/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Forms/SuperToolTipControl.cs#9 $
 * $DateTime: 2007/12/28 19:23:38 $
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Diagnostics;

namespace Bellagio.Forms {
    public class SuperToolTipControl : UserControl {
        //ʎ̃ACRƂ݂݂ŊǗ邱Ƒ̂
        public interface IImageProvider {
            Image GetCrossImage(bool hovering);
            Image GetDropDownImage(bool hovering);
        }

        public enum Mode {
            ToolTipMode, FormMode
        }

        public static IImageProvider _imageProvider;

        private Mode _mode;

        //`
        private const int CORNER_RADIUS = 11;
        private const int ARROW_HEIGHT = 12;
        private const int ARROW_TOP_X = 3;
        private const int ARROW_ROOT_X1 = CORNER_RADIUS;
        private const int ARROW_ROOT_X2 = CORNER_RADIUS + 12;
        private const int ICON_SIZE = 20;

        //e[hp[W
        private Region _toolTipRegion;
        private Region _formRegion;
        
        private bool _hoveringOnButton; //}EX{^̂ɏtrue

        //gCxg
        public event EventHandler ExpandToForm;
        public event EventHandler FormClose;

        //͂ق
        private Button _acceptButtonEx;

        public SuperToolTipControl() {
            this.SetStyle(ControlStyles.OptimizedDoubleBuffer, true);

            //CreateRegion();
            this.BorderStyle = BorderStyle.None;
            this.BackColor = SystemColors.Info;
            _mode = Mode.ToolTipMode;
        }

        public void SetMode(Mode mode) {
            if(_mode==mode) return;

            bool v = mode==Mode.FormMode;
            foreach(Control c in this.Controls) c.Visible = v;
            _mode = mode;

            if(this.Visible) //ĂȂƂRegionĂȂƂ
                this.Region = _mode==Mode.ToolTipMode? _toolTipRegion : _formRegion;
        }
        public Mode CurrentMode {
            get {
                return _mode;
            }
        }
        public Button AcceptButtonEx {
            get {
                return _acceptButtonEx;
            }
            set {
                _acceptButtonEx = value;
            }
        }

        protected override void Dispose(bool disposing) {
            base.Dispose(disposing);
            ClearRegion(); 
        }

        protected override void OnPaint(PaintEventArgs e) {

            Graphics g = e.Graphics;
            if(_mode==Mode.ToolTipMode) {
                g.FillRegion(SystemBrushes.Info, _toolTipRegion);
                DrawToolTipBorder(g);
            }
            else {
                g.FillRegion(SystemBrushes.Info, _formRegion);
                DrawFormBorder(g);
            }

            base.OnPaint(e);

            Brush br = new SolidBrush(this.ForeColor);
            g.DrawString(this.Text, this.Font, br, TextLocation(g));
            br.Dispose();

            Debug.Assert(_imageProvider!=null);
            g.DrawImage(_mode==Mode.ToolTipMode? _imageProvider.GetDropDownImage(_hoveringOnButton) : _imageProvider.GetCrossImage(_hoveringOnButton) , ButtonRectangle().Location); 
        }
        

        protected override void OnResize(EventArgs e) {
            base.OnResize(e);
            CreateRegion();
        }
        protected override void OnVisibleChanged(EventArgs e) {
            base.OnVisibleChanged(e);
            if(this.Visible)
                CreateRegion();
        }

        protected override void OnClick(EventArgs e) {
            base.OnClick(e);

            MouseEventArgs me = e as MouseEventArgs;
            if(me!=null && me.Button==MouseButtons.Left) {
                if(_hoveringOnButton) {
                    if(_mode==Mode.ToolTipMode) {
                        if(ExpandToForm!=null) ExpandToForm(this, e);
                        SetMode(Mode.FormMode);
                    }
                    else {
                        if(FormClose!=null) FormClose(this, e);
                    }
                }
            }
        }
        protected override bool ProcessDialogKey(Keys keyData) {
            if(keyData==Keys.Escape && _mode==Mode.FormMode) {
                if(FormClose!=null) FormClose(this, new EventArgs());
            }
            else if(keyData==Keys.Space && _mode==Mode.ToolTipMode) {
                if(ExpandToForm!=null) ExpandToForm(this, null);
                SetMode(Mode.FormMode);
            }
            else if(keyData==Keys.Enter && _mode==Mode.FormMode && _acceptButtonEx!=null) {
                _acceptButtonEx.PerformClick();
            }
            return base.ProcessDialogKey(keyData);
        }

        protected override void OnMouseMove(MouseEventArgs e) {
            base.OnMouseMove(e);
            bool h = ButtonRectangle().Contains(e.X, e.Y);
            AdjustHoverState(h);
        }
        protected override void OnMouseLeave(EventArgs e) {
            base.OnMouseLeave(e);
            AdjustHoverState(false);
        }

        private void CreateRegion() {
            ClearRegion();

            GraphicsPath toolTipPath = new GraphicsPath();
            toolTipPath.FillMode = FillMode.Winding;
            toolTipPath.StartFigure();
            
            int right =  this.Width-1;
            int r2 = CORNER_RADIUS*2; //a
            int rb = CORNER_RADIUS*2; //rectangle bottom
            
            //GraphicsPath̉~ʂƒ̌܂Ȃ̂ŁA̕`͕ʂɍsBȂp[cƂɃyg|OK
            //c[`bv̌`@~ӂƍ
            toolTipPath.AddArc(new Rectangle(0, 0, r2, r2), 270, -180); //
            //`𐮂炱͕̒svɂȂ
            //toolTipPath.AddLine(CORNER_RADIUS-1, rb, ARROW_ROOT_X1, rb);
            toolTipPath.AddLine(ARROW_ROOT_X1, rb, ARROW_TOP_X, rb+ARROW_HEIGHT);
            toolTipPath.AddLine(ARROW_TOP_X, rb+ARROW_HEIGHT, ARROW_ROOT_X2, rb);
            toolTipPath.AddLine(ARROW_ROOT_X2, rb, right-CORNER_RADIUS, rb);
            toolTipPath.AddArc(new Rectangle(right-r2, 0, r2, r2), 90, -180); //E
            toolTipPath.AddLine(right-CORNER_RADIUS, 0, CORNER_RADIUS-1, 0);
            toolTipPath.CloseFigure();
            
            _toolTipRegion = new Region(toolTipPath);
            toolTipPath.Dispose();

            //tH[̌`@RoundRect
            GraphicsPath formPath = new GraphicsPath();
            formPath.FillMode = FillMode.Winding;
            formPath.AddArc(new Rectangle(0, 0, r2, r2), 270, -90);
            formPath.AddArc(new Rectangle(0, this.Height-r2-1, r2, r2), 180, -90);
            formPath.AddArc(new Rectangle(this.Width-r2-1, this.Height-r2-1, r2, r2), 90, -90);
            formPath.AddArc(new Rectangle(this.Width-r2-1, 0, r2, r2), 0, -90);
            formPath.CloseFigure();

            _formRegion = new Region(formPath);
            formPath.Dispose();

            this.Region = _mode==Mode.ToolTipMode? _toolTipRegion : _formRegion;
        }
        private void DrawToolTipBorder(Graphics g) {
            //̃pX쐬ɋ߂
            Pen p = CreateBorderPen();
            g.SmoothingMode = SmoothingMode.HighQuality;
            int right =  this.Width;
            int r2 = CORNER_RADIUS*2; //a
            int rb = CORNER_RADIUS*2-1; //rectangle bottom
            float w = p.Width;

            g.DrawArc(p, new Rectangle(0, 0, r2, r2), 270, -180); //
            g.DrawLine(p, ARROW_ROOT_X1, rb, ARROW_TOP_X, rb+ARROW_HEIGHT);
            g.DrawLine(p, ARROW_TOP_X, rb+ARROW_HEIGHT-w/2, ARROW_ROOT_X2, rb);
            g.DrawLine(p, ARROW_ROOT_X2, rb, right-CORNER_RADIUS, rb);
            g.DrawArc(p, new RectangleF(right-r2-w, 0, r2, r2), 90, -180); //E
            g.DrawLine(p, right-CORNER_RADIUS, 0, CORNER_RADIUS-1, 0);

            g.SmoothingMode = SmoothingMode.Default;
            p.Dispose();
        }
        private void DrawFormBorder(Graphics g) {
            Pen p = CreateBorderPen();
            g.SmoothingMode = SmoothingMode.HighQuality;
            int right =  this.Width-1;
            int r = CORNER_RADIUS;
            int r2 = CORNER_RADIUS*2; //a
            float w = p.Width;

            g.DrawArc(p, new Rectangle(0, 0, r2, r2), 270, -90);
            g.DrawLine(p, 0, r, 0, this.Height-r);
            g.DrawArc(p, new RectangleF(0, this.Height-r2-w, r2, r2), 180, -90);
            g.DrawLine(p, r, this.Height-w, this.Width-r, this.Height-w);
            g.DrawArc(p, new RectangleF(this.Width-r2-w, this.Height-r2-w, r2, r2), 90, -90);
            g.DrawLine(p, this.Width-w, r, this.Width-w, this.Height-r);
            g.DrawArc(p, new RectangleF(this.Width-r2-w, 0, r2, r2), 0, -90);
            g.DrawLine(p, r, 0, this.Width-r, 0);
            g.SmoothingMode = SmoothingMode.Default;
            p.Dispose();
        }

        //zo[Ԃ̍XV
        private void AdjustHoverState(bool state) {
            if(_hoveringOnButton!=state) { //ω
                _hoveringOnButton = state;
                this.Cursor = state? Cursors.Hand : Cursors.Default;
                Invalidate();
            }
        }

        //{^\ꏊ
        public Rectangle ButtonRectangle() {
            return new Rectangle(this.Width - CORNER_RADIUS - ICON_SIZE + 4, (CORNER_RADIUS*2-ICON_SIZE)/2, ICON_SIZE, ICON_SIZE);
        }
        //ToolTip[hɂ̒[
        public Point ArrowPosition() {
            return new Point(ARROW_TOP_X, CORNER_RADIUS*2+ARROW_HEIGHT-2);
        }
        private PointF TextLocation(Graphics g) {
            SizeF sz = g.MeasureString(this.Text, this.Font);
            return new PointF(CORNER_RADIUS-2, (CORNER_RADIUS*2-sz.Height)/2);
        }
        public void AdjustSizeByTipTextSize(SizeF sz) {
            this.Size = new Size((int)sz.Width + CORNER_RADIUS + ICON_SIZE + 4, Math.Max(CORNER_RADIUS*2, (int)sz.Height+4) + ARROW_HEIGHT);
        }

        private void ClearRegion() {
            if(_toolTipRegion!=null) _toolTipRegion.Dispose();
            if(_formRegion!=null) _formRegion.Dispose();
            _toolTipRegion = null;
            _formRegion = null;
        }

        private Pen CreateBorderPen() {
            return new Pen(Color.LightGray, 2);
        }

    }
}
