/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Forms/BellagioViewContent.cs#11 $
 * $DateTime: 2008/02/22 14:38:32 $
 * 
 */

using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Windows.Forms;
using System.Resources;
using System.Drawing.Imaging;
using System.Diagnostics;

using Poderosa.Sessions;
using Poderosa.UI;
using Poderosa;
using Poderosa.Commands;

using Sansa.Runtime;
using Bellagio.Environment;
using Bellagio.Drawing;

namespace Bellagio.Forms {
    //ViewContent̊{
    public abstract class BellagioViewContent : IBellagioDefaultControlContent, IDisposable, ICommandTarget, ITickListener {

        protected static WaitingMark _waitingMark = new WaitingMark(); //Ŝŋ

        public abstract IPoderosaDocument IPoderosaDocument { get; }
        public abstract void Attach(BellagioDefaultControl parent);
        public abstract void Detach();
        public abstract void OnPaint(PaintEventArgs args);
        public abstract void NotifySplitMarkStateChanged();
        public abstract void ManualResize();
        public virtual void DoLayout() {
        }
        public virtual void OnMouseMove(MouseEventArgs args) {
        }
        public virtual void OnMouseDown(MouseEventArgs args) {
        }
        public virtual void OnMouseUp(MouseEventArgs args) {
        }
        public virtual void OnMouseLeave() {
        }
        public virtual void OnMouseWheel(MouseEventArgs args) {
        }
        public virtual void OnDoubleClick() {
        }
        public virtual void OnResize() {
        }
        public virtual void OnGotFocus() {
        }
        public virtual void OnKeyDown(KeyEventArgs args) {
        }
        public virtual void OnBeforeSansaTick() { //Tickł̋Rg[ɂ͂override
            _invalidateRequired = false;
        }
        public virtual Rectangle SplitMarkDisplayRect {
            get {
                return _container.ClientRectangle;
            }
        }
        public virtual void AdjustActiveDocumentStatus(bool active) {}


        protected BellagioDefaultControl _container;
        protected DTimerHandler.D _invalidateMark; //^C}[ɂTickRg[̍ĕ`𑣂
        private bool _invalidateRequired;

        public BellagioDefaultControl ContainerControl {
            get {
                return _container;
            }
        }

        public DoubleTimer CreateDoubleTimer(double initial, double final_, double length_sec) {
            return CreateDoubleTimer(initial, final_, length_sec, null);
        }
        public DoubleTimer CreateDoubleTimer(double initial, double final_, double length_sec, DTimerHandler.D tick) {
            IPlatformBridge p = BellagioPlugin.Instance.SansaPlatform;
            DoubleTimer t = null;
            DTimerHandler.D h = tick==null? _invalidateMark : new DTimerHandler.DList().Add(tick).Add(_invalidateMark).D;
            t = new DoubleTimer(p, new DTimerHandler(delegate() { t.reset(initial, final_, p.getRootTimer().secondToTick(length_sec)); }, h));
            return t;
        }



        public BellagioViewContent() {
            BellagioPlugin.Instance.SansaPlatform.getRootTimer().addTickListener(this);
            _invalidateMark = delegate() { _invalidateRequired = true; };
        }
        void ITickListener.beforeTick() {
            OnBeforeSansaTick();
        }
        void ITickListener.afterTick() {
            if(_invalidateRequired && _container!=null)
                _container.Invalidate();
        }
        public virtual void Dispose() {
            BellagioPlugin.Instance.SansaPlatform.getRootTimer().removeTickListener(this);
        }

        public virtual IAdaptable GetAdapter(Type adapter) {
            return BUtil.DefaultGetAdapter(this, adapter);
        }
    }

    //Xgr[zXeBOX^CViewContent Ranking, AlertŎgp
    //Xgr[͊{IDockStyle.FillŁASplitMark̊荞݂̂ȃ^XN
    public abstract class ViewContentHostingListView : BellagioViewContent, BellagioListView.IBellagioListViewClient {
        protected BellagioListView _listView;

        public override void Dispose() {
            if(_listView!=null) _listView.Dispose();
            base.Dispose();
        }

        public override void Attach(BellagioDefaultControl parent) {
            _container = parent;
            if(_listView==null) CreateListControl();
            parent.Controls.Add(_listView);
        }
        public override void Detach() {
            _container.Controls.Clear();
            _container = null;
        }

        protected abstract void InitializeListView();

        private void CreateListControl() {
            _listView = new BellagioListView(this);
            _listView.Dock = DockStyle.Fill;
            _listView.BackColor = _container.BackColor;
            InitializeListView();
        }

        /*
        //XbhΉInvalidate
        public void Invlalidate() {
            if(_listView.InvokeRequired)
                _listView.Invoke(_updateNotifyDelegate);
            else
                _listView.Invalidate(true);
        }
        */

        //Xgr[Ă̂ŋOK
        public override void OnPaint(PaintEventArgs args) {
        }
        public override void OnResize() {
        }
        public override void ManualResize() {
            
        }

        #region IBellagioListViewClient
        public virtual void DrawColumnHeader(Graphics g, Rectangle r, ColumnHeader header) {
        }

        public virtual void DrawItemBackground(Graphics g, Rectangle r, ListViewItem item) {
        }

        public virtual void DrawItemBody(Graphics g, Rectangle r, int[] lefts, ListViewItem item) {
        }

        private static int traceCount;

        //Xgr[R[obN}EXړCxgBŋɕ}[N荞܂
        public virtual void OnMouseMoveInListView(MouseEventArgs e) {
            SplitMarkSupport sp = _container.SplitMark;
            _container.MouseHandlerManager.BypassMouseMove(e); //Os
            if(sp.IsSplitMarkVisible) { //}[N悤ɂȂ烊Xgr[̈ʒu
                Debug.WriteLineIf(BDebugOpts.TRACE_RANKINGVIEW_SPLIT, "Splitmark On " + (traceCount++));
                _container.SuspendLayout();
                SplitMarkSupport.AssureMarkSizeChecked(_container);
                bool topbottom = sp.CurrentMarkState==SplitMarkSupport.MarkState.TopBottom;
                _listView.Dock = DockStyle.None;
                _listView.Location = topbottom? new Point(0, SplitMarkSupport.MarkSizeTopBottom.Height) : new Point(SplitMarkSupport.MarkSizeLeftRight.Width, 0);
                Size sz = _container.ClientSize;
                if(topbottom) sz.Height -= SplitMarkSupport.MarkSizeTopBottom.Height*2;
                else sz.Width -= SplitMarkSupport.MarkSizeLeftRight.Width*2;
                _listView.Size = sz;
                _container.ResumeLayout();
            }
        }

        public virtual void OnMouseEnterToListView(EventArgs e) {
            //ɃRg[܂܂ȂX^Cł́AMouseMove,Leave߂ĂOKAɃXgr[܂ގ̓Xgr[Ƀ}EXƂʓrnhȂ΂ȂȂ
            if(_container.SplitMark.IsSplitMarkVisible)
                _container.SplitMark.ClearMark();
        }
        #endregion
        //荞܂̉
        public override void NotifySplitMarkStateChanged() {
            SplitMarkSupport sp = _container.SplitMark;
            if(!sp.IsSplitMarkVisible && _listView.Dock==DockStyle.None) ClearSplitMark();
        }
        private void ClearSplitMark() {
            Debug.WriteLineIf(BDebugOpts.TRACE_RANKINGVIEW_SPLIT, "Ranking Splitmark Off" + (traceCount++));
            _container.SuspendLayout();
            _listView.Location = new Point(0, 0);
            _listView.Size = _container.ClientSize;
            _listView.Dock = DockStyle.Fill;
            _container.ResumeLayout();

        }

    }
}
