/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/FigureBoard/FigureBoardSchema.cs#9 $
 * $DateTime: 2007/12/28 19:23:38 $
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using Poderosa;
using Poderosa.Preferences;

using Travis.ORT;
using Bellagio.Values;
using Bellagio.Environment;

namespace Bellagio.FigureBoard {
    public class FigureBoardItemSchema : OriginReportableObject {
        public ORText name;
        public ORText expression;
        public ORText subExpression;

        private void AvoidWarning() {
            expression = new ORText();
        }
    }
    public class FigureBoardSchema : ExtensionKitItemWithParameter {
        public ORCollectionMember<FigureBoardItemSchema> item;
        public ORText interval; //XVԊu

        public FigureBoardSchema() {
            item = new ORCollectionMember<FigureBoardItemSchema>();
        }

    }
    public class FigureBoardSchemaCollection : ViewSchemaCollection<FigureBoardSchema> {
        private List<FigureBoardSchema> _data;

        public FigureBoardSchemaCollection() {
            _data = new List<FigureBoardSchema>();
        }
        public FigureBoardSchema Find(string name) {
            foreach(FigureBoardSchema ss in _data)
                if(!ss.id.IsOmitted && ss.id.Value==name) return ss;

            return null;
        }

        public override void Clear() {
            _data.Clear();
        }
        public override int Count {
            get {
                return _data.Count;
            }
        }
        public override void Add(FigureBoardSchema item) {
            _data.Add(item);
        }
        public override FigureBoardSchema this[int index] {
            get {
                return _data[index];
            }
        }
        public override IEnumerator GetEnumerator() {
            return _data.GetEnumerator();
        }


    }

}
