/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id$
 * $DateTime$
 * 
 * Eݒ̃IvVpl
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Diagnostics;
using System.Windows.Forms;

using Bellagio.Forms;
using Bellagio.Drawing;
using Bellagio.Environment;
using Bellagio.Data;

using Travis.LocationOperation;
using Poderosa.Usability;
using Poderosa.Preferences;
using Poderosa.UI;

namespace Bellagio.Chart {
    public class ItaPriceOptionPanelExtension : IOptionPanelExtension {
        private ItaPriceOptionPanel _panel;

        public string Caption {
            get {
                return "/";
            }
        }

        public System.Drawing.Image Icon {
            get {
                return BellagioRoot.CommonIcons.OptionDialogButtons.GetBitmap(1);
            }
        }

        public string[] PreferenceFolderIDsToEdit {
            get {
                return new string[] { "tactico.chart", "tactico.itaDrawing", "tactico.currentPriceInfoDrawing" };
            }
        }

        public Panel ContentPanel {
            get {
                return _panel;
            }
        }

        public void InitiUI(IPreferenceFolder[] values) {
            if(_panel==null) _panel = new ItaPriceOptionPanel();
            _panel.InitUI(values[0], values[1], values[2]);
        }

        public bool Commit(IPreferenceFolder[] values) {
            return _panel.Commit(values[0], values[1], values[2]);
        }

        public void Dispose() {
            if(_panel!=null) {
                _panel.Dispose();
                _panel = null;
            }
        }
    }


    public class ItaPriceOptionPanel : Panel {
        private GroupBox _itaGroup;
        private FontConfig _itaFont;
        private ColorConfig _itaPriceColor;
        private ColorConfig _itaActivePriceColor;
        private ColorConfig _itaAskColor;
        private ColorConfig _itaBidColor;

        private GroupBox _currentPriceGroup;
        private FontConfig _currentPriceFont;
        private FontConfig _currentPriceLargeFont;
        private ColorConfig _currentPriceLabelColor;
        private ColorConfig _currentPriceValueColor;
        private ColorConfig _currentPriceTimeColor;
        private ColorConfig _currentPriceCPColor;

        private GroupBox _dataGroup;
        private CheckBox _enableCurrentPriceAnimation;
        private CheckBox _enableFigureBoardAnimation;
        private CheckBox _enableItaDiff;

        public ItaPriceOptionPanel() {
            _itaGroup = new GroupBox();
            _itaGroup.FlatStyle = FlatStyle.System;
            _itaGroup.Text = "̃tHgƐF̐ݒ";
            _itaGroup.Location = new Point(8, 8);
            _itaGroup.Width = 440;
            _itaGroup.Height = 88;

            _currentPriceGroup = new GroupBox();
            _currentPriceGroup.FlatStyle = FlatStyle.System;
            _currentPriceGroup.Text = "̃tHgƐF̐ݒ";
            _currentPriceGroup.Location = new Point(8, _itaGroup.Bottom + 8);
            _currentPriceGroup.Width = 440;
            _currentPriceGroup.Height = 112;

            _dataGroup = new GroupBox();
            _dataGroup.FlatStyle = FlatStyle.System;
            _dataGroup.Text = "\̐ݒ";
            _dataGroup.Location = new Point(8, _currentPriceGroup.Bottom + 8);
            _dataGroup.Width = 440;
            _dataGroup.Height = 108;

            int y = 12;
            int x1 = 8;
            int x2 = 220;

            _itaFont = new FontConfig(_itaGroup, "tHg", x1, ref y);
            _itaPriceColor = new ColorConfig(_itaGroup, "iF", x1, y);
            _itaActivePriceColor = new ColorConfig(_itaGroup, "ߒlwiF", x2, ref y);
            _itaAskColor = new ColorConfig(_itaGroup, "ʐF", x1, y);
            _itaBidColor = new ColorConfig(_itaGroup, "ʐF", x2, ref y);

            y = 12;
            _currentPriceFont = new FontConfig(_currentPriceGroup, "WtHg", x1, ref y);
            _currentPriceLargeFont = new FontConfig(_currentPriceGroup, "ݒltHg", x1, ref y);
            _currentPriceLabelColor = new ColorConfig(_currentPriceGroup, "xF", x1, y);
            _currentPriceValueColor = new ColorConfig(_currentPriceGroup, "ʂ̒l̐F", x2, ref y);
            _currentPriceTimeColor = new ColorConfig(_currentPriceGroup, "̐F", x1, y);
            _currentPriceCPColor = new ColorConfig(_currentPriceGroup, "ݒlF", x2, ref y);

            _enableCurrentPriceAnimation = new CheckBox();
            _enableCurrentPriceAnimation.Text = "ݒlω̃Aj[VL(&A)";
            _enableCurrentPriceAnimation.Location = new Point(8, 12);
            _enableCurrentPriceAnimation.Size = new Size(400, 19);
            _enableFigureBoardAnimation = new CheckBox();
            _enableFigureBoardAnimation.Text = "EHb`Xg̃Aj[VL(&W)";
            _enableFigureBoardAnimation.Location = new Point(8, 36);
            _enableFigureBoardAnimation.Size = new Size(400, 19);
            _enableItaDiff = new CheckBox();
            _enableItaDiff.Text = "Őʂ̕ω\(&D)";
            _enableItaDiff.Location = new Point(8, 60);
            _enableItaDiff.Size = new Size(200, 19);

            _dataGroup.Controls.Add(_enableCurrentPriceAnimation);
            _dataGroup.Controls.Add(_enableFigureBoardAnimation);
            _dataGroup.Controls.Add(_enableItaDiff);

            this.Controls.Add(_itaGroup);
            this.Controls.Add(_currentPriceGroup);
            this.Controls.Add(_dataGroup);
        }

        public void InitUI(IPreferenceFolder chart, IPreferenceFolder ita_dr, IPreferenceFolder cp_dr) {
            ChartPreferences p = BellagioRoot.FixedPreferences.Chart;
            ItaGraphicsSettings ig = p.ItaGraphicsSettings;
            CurrentPriceInfoGraphicsSettings pg = p.CurrentPriceInfoGraphicsSettings;

            _itaFont.SetFont(ig.priceFont);
            _itaPriceColor.SelectedColor = DrawingUtil.ParseColor(ita_dr.ChildAt(ig.priceColor.PreferenceItem.Index).AsItem().AsString().Value);
            _itaActivePriceColor.SelectedColor = DrawingUtil.ParseColor(ita_dr.ChildAt(ig.activePriceBackColor.PreferenceItem.Index).AsItem().AsString().Value);
            _itaAskColor.SelectedColor = DrawingUtil.ParseColor(ita_dr.ChildAt(ig.askVolumeColor.PreferenceItem.Index).AsItem().AsString().Value);
            _itaBidColor.SelectedColor = DrawingUtil.ParseColor(ita_dr.ChildAt(ig.bidVolumeColor.PreferenceItem.Index).AsItem().AsString().Value);
            _currentPriceFont.SetFont(pg.labelFont);
            _currentPriceLargeFont.SetFont(pg.largeValueFont);
            _currentPriceLabelColor.SelectedColor = DrawingUtil.ParseColor(cp_dr.ChildAt(pg.labelColor.PreferenceItem.Index).AsItem().AsString().Value);
            _currentPriceValueColor.SelectedColor = DrawingUtil.ParseColor(cp_dr.ChildAt(pg.valueColor.PreferenceItem.Index).AsItem().AsString().Value);
            _currentPriceTimeColor.SelectedColor = DrawingUtil.ParseColor(cp_dr.ChildAt(pg.timeColor.PreferenceItem.Index).AsItem().AsString().Value);
            _currentPriceCPColor.SelectedColor = DrawingUtil.ParseColor(cp_dr.ChildAt(pg.priceColor.PreferenceItem.Index).AsItem().AsString().Value);

            _enableCurrentPriceAnimation.Checked = chart.ChildAt(p.EnablePriceInfoAnimationItem.Index).AsItem().AsBool().Value;
            _enableFigureBoardAnimation.Checked = chart.ChildAt(p.EnableFigureBoardAnimationItem.Index).AsItem().AsBool().Value;
            _enableItaDiff.Checked = chart.ChildAt(p.EnableItaDiffItem.Index).AsItem().AsBool().Value;
        }
        public bool Commit(IPreferenceFolder chart, IPreferenceFolder ita_dr, IPreferenceFolder cp_dr) {
            ChartPreferences p = BellagioRoot.FixedPreferences.Chart;
            ItaGraphicsSettings ig = p.ItaGraphicsSettings;
            CurrentPriceInfoGraphicsSettings pg = p.CurrentPriceInfoGraphicsSettings;

            string itaFont = _itaFont.Value.ToString();
            //͘Aē
            ita_dr.ChildAt(ig.priceFont.PreferenceItem.Index).AsItem().AsString().Value = itaFont;
            ita_dr.ChildAt(ig.bidVolumeFont.PreferenceItem.Index).AsItem().AsString().Value = itaFont;
            ita_dr.ChildAt(ig.askVolumeFont.PreferenceItem.Index).AsItem().AsString().Value = itaFont;
            ita_dr.ChildAt(ig.bidVolumeDiffFont.PreferenceItem.Index).AsItem().AsString().Value = itaFont;
            ita_dr.ChildAt(ig.askVolumeDiffFont.PreferenceItem.Index).AsItem().AsString().Value = itaFont;

            ita_dr.ChildAt(ig.priceColor.PreferenceItem.Index).AsItem().AsString().Value = DrawingUtil.ColorToString(_itaPriceColor.SelectedColor);
            ita_dr.ChildAt(ig.activePriceBackColor.PreferenceItem.Index).AsItem().AsString().Value = DrawingUtil.ColorToString(_itaActivePriceColor.SelectedColor);
            ita_dr.ChildAt(ig.askVolumeColor.PreferenceItem.Index).AsItem().AsString().Value = DrawingUtil.ColorToString(_itaAskColor.SelectedColor);
            ita_dr.ChildAt(ig.bidVolumeColor.PreferenceItem.Index).AsItem().AsString().Value = DrawingUtil.ColorToString(_itaBidColor.SelectedColor);


            string price_font = _currentPriceFont.Value.ToString();
            string price_large_font = _currentPriceLargeFont.Value.ToString();
            cp_dr.ChildAt(pg.labelFont.PreferenceItem.Index).AsItem().AsString().Value = price_font;
            cp_dr.ChildAt(pg.largeValueFont.PreferenceItem.Index).AsItem().AsString().Value = price_large_font;
            cp_dr.ChildAt(pg.labelColor.PreferenceItem.Index).AsItem().AsString().Value = DrawingUtil.ColorToString(_currentPriceLabelColor.SelectedColor);
            cp_dr.ChildAt(pg.valueColor.PreferenceItem.Index).AsItem().AsString().Value = DrawingUtil.ColorToString(_currentPriceValueColor.SelectedColor);
            cp_dr.ChildAt(pg.timeColor.PreferenceItem.Index).AsItem().AsString().Value = DrawingUtil.ColorToString(_currentPriceTimeColor.SelectedColor);
            cp_dr.ChildAt(pg.priceColor.PreferenceItem.Index).AsItem().AsString().Value = DrawingUtil.ColorToString(_currentPriceCPColor.SelectedColor);

            chart.ChildAt(p.EnableItaDiffItem.Index).AsItem().AsBool().Value = _enableItaDiff.Checked;
            chart.ChildAt(p.EnablePriceInfoAnimationItem.Index).AsItem().AsBool().Value = _enableCurrentPriceAnimation.Checked;
            chart.ChildAt(p.EnableFigureBoardAnimationItem.Index).AsItem().AsBool().Value = _enableFigureBoardAnimation.Checked;

            return true;
        }
    }
}
