using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;
using System.Drawing;
using System.IO;
using System.Net;

using Bellagio.Forms;

using Travis.LocationOperation;

namespace Bellagio.Personal {
    internal class InitDataDialog : Form {
        private Label _explanation;
        private RadioButton _defaultData;
        private RadioButton _externalData;
        private TextBox _fileNameBox;
        private Button _openFileDialogButton;
        private Button _okButton;
        private Button _cancelButton;

        public InitDataDialog() {
            FormUtil.AdjustStyleForModalDialog(this);
            this.Text = "f[^̏";

            _explanation = new Label();
            _explanation.Text = "f[^̏ƁAf[^ׂ͂ăZbg܂BڍׂTacticoWebTCgB\n̑͏N̂ݕKvłAx̎Ԃ܂B";
            _defaultData = new RadioButton();
            _defaultData.Text = "Wzz̃f[^_E[hĎ荞";
            _externalData = new RadioButton();
            _externalData.Text = "ʓr肵̃t@Cgp";
            _fileNameBox = new TextBox();
            _openFileDialogButton = new Button();
            _openFileDialogButton.Text = "...";
            _openFileDialogButton.Click += new EventHandler(OnOpenFileDialog);
            _okButton = new Button();
            _okButton.Text = "OK";
            _okButton.DialogResult = DialogResult.OK;
            _okButton.Click += new EventHandler(OnOK);
            this.AcceptButton = _okButton;
            _cancelButton = new Button();
            _cancelButton.Text = "LZ";
            _cancelButton.DialogResult = DialogResult.Cancel;
            this.CancelButton = _cancelButton;

            _defaultData.CheckedChanged += new EventHandler(OnRadioCheckedChanged);
            _defaultData.Checked = true;

            RectOp rop = new RectangleOperatorBuilder()
                .Shrink(4)
                .SplitFixed(SplitDir.Top, 64).ProbeControl(_explanation).CloseBranch()
                .SplitFixed(SplitDir.Top, 24).ProbeControl(_defaultData).CloseBranch()
                .SplitFixed(SplitDir.Top, 24).ProbeControl(_externalData).CloseBranch()
                .SplitFixed(SplitDir.Top, 24)
                    .PlaceControl(ContentAlignment.TopLeft, _fileNameBox, 240, 19).RightControl(_openFileDialogButton, 24, 19)
                    .CloseBranch()
                .PlaceControl(ContentAlignment.BottomRight, _cancelButton, 64, 24).LeftControl(_okButton, 64, 24)
                .Finish();

            this.Size = new Size(320, 200);
            rop.Rect(this.ClientRectangle);

            this.Controls.AddRange(new Control[] {
                _explanation, _defaultData, _externalData, _fileNameBox, _openFileDialogButton, _okButton, _cancelButton });
        }

        private void OnRadioCheckedChanged(object sender, EventArgs argS) {
            bool d = _defaultData.Checked;
            _fileNameBox.Enabled = !d;
            _openFileDialogButton.Enabled = !d;
        }

        private void OnOpenFileDialog(object sender, EventArgs args) {
            OpenFileDialog dlg = new OpenFileDialog();
            dlg.CheckFileExists = true;
            dlg.DefaultExt = "zip";
            dlg.Filter = "zipt@C|*.zip";
            dlg.Title = "f[^t@C";
            if(dlg.ShowDialog(this)==DialogResult.OK)
                _fileNameBox.Text = dlg.FileName;
            dlg.Dispose();
        }

        private void OnOK(object sender, EventArgs args) {
            this.DialogResult = DialogResult.None;
            try {
                if(_defaultData.Checked) {
                    string title = this.Text;
                    this.Text = title + "  _E[h...";
                    string filename = DownloadShortInitialDataToTempFile();
                    this.Text = title;
                    ImportFile(filename);
                    this.DialogResult = DialogResult.OK;
                }
                else {
                    string fn = _fileNameBox.Text;
                    if(fn.Length==0)
                        PUtil.ShowWarningMessageBox(this, "t@Cw肳Ă܂");
                    else if(!System.IO.File.Exists(fn))
                        PUtil.ShowWarningMessageBox(this, "t@C܂");
                    else {
                        ImportFile(fn);
                        this.DialogResult = DialogResult.OK;
                    }
                }
            }
            catch(Exception ex) {
                Debug.WriteLine(ex.StackTrace);
            }
        }

        private void ImportFile(string filename) {
            this.Enabled = false;
            try {
                string dest_dir = PersonalPlugin.Instance.BellagioEnvironment.DataHomeDir;
                //string daily = dest_dir + "daily";
                //if(!Directory.Exists(daily)) Directory.CreateDirectory(daily);
                Debug.WriteLine("StartDecompress");
                PUtil.Unzip(filename, dest_dir, true);
                Debug.WriteLine("EndDecompress");
                PersonalPlugin.Instance.ExecReloadDailyDataCommand();
            }
            finally {
                this.Enabled = true;
            }
        }

        private string DownloadShortInitialDataToTempFile() {
            string temp_dir = PersonalPlugin.Instance.BellagioEnvironment.DataHomeDir + "temp";
            if(!Directory.Exists(temp_dir)) Directory.CreateDirectory(temp_dir);

            string temp_file = temp_dir + "\\SD.zip";

            HttpWebRequest req = (HttpWebRequest)WebRequest.Create("http://www.lagarto.co.jp/tactico/startup/SD.zip");
            HttpWebResponse response = (HttpWebResponse)req.GetResponse();
            FileStream fs = new FileStream(temp_file, FileMode.Create, FileAccess.Write);
            PUtil.CopyStream(response.GetResponseStream(), fs, 0x4000);
            fs.Close();
            response.Close();

            return temp_file;
        }

    }
}
