/*
 * Copyright 2004,2006 The Poderosa Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * $Id: UIEventHandler.cs,v 1.4 2006/07/16 03:21:52 osawa Exp $
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;

//}EX̃CxgDx̊Ǘ@\
//@.NETOnMouseMoveRg[̌p֌WŎ󂯂Ă\IɃLrVĈ
namespace Poderosa.View {
    /// <summary>
    /// 
    /// </summary>
    /// <exclude/>
    public enum UIHandleResult {
        Pass,         //̗Dx̃nhɓn
        Stop,         //I
        Capture,      //D挠l
        EndCapture    //D挠
    }

    /// <summary>
    /// 
    /// </summary>
    /// <exclude/>
    public interface IUIHandler {
        string Name { get; }
    }

    /// <summary>
    /// 
    /// </summary>
    /// <exclude/>
    public interface IMouseHandler : IUIHandler {
        UIHandleResult OnMouseDown(MouseEventArgs args);
        UIHandleResult OnMouseMove(MouseEventArgs args);
        UIHandleResult OnMouseUp(MouseEventArgs args);
    }

    //ProcessCmdKey/ProcessDialogKey̎ӂɊւĂ̏s
    /// <summary>
    /// 
    /// </summary>
    /// <exclude/>
    public interface IKeyHandler : IUIHandler {
        UIHandleResult OnKeyProcess(Keys key);
    }

    //
    /// <summary>
    /// 
    /// </summary>
    /// <exclude/>
    public abstract class DefaultMouseHandler : IMouseHandler {
        private string _name;
        public DefaultMouseHandler(string name) {
            _name = name;
        }
        public string Name {
            get {
                return _name;
            }
        }

        public virtual UIHandleResult OnMouseDown(MouseEventArgs args) {
            return UIHandleResult.Pass;            
        }

        public virtual UIHandleResult OnMouseMove(MouseEventArgs args) {
            return UIHandleResult.Pass;
        }

        public virtual UIHandleResult OnMouseUp(MouseEventArgs args) {
            return UIHandleResult.Pass;
        }
    }

    /// <summary>
    /// 
    /// </summary>
    /// <typeparam name="HANDLER"></typeparam>
    /// <typeparam name="ARG"></typeparam>
    /// <exclude/>
    public abstract class UIHandlerManager<HANDLER, ARG> where HANDLER:class,IUIHandler {
        /// <summary>
        /// 
        /// </summary>
        /// <param name="handler"></param>
        /// <param name="args"></param>
        /// <returns></returns>
        /// <exclude/>
        public delegate UIHandleResult HandlerDelegate(HANDLER handler, ARG args);

        private List<HANDLER> _handlers; //擪ōDx
        private HANDLER _capturingHandler; //CxgLv`ĂnhB݂ȂƂnull
        private bool _UIEventGuard;

        public UIHandlerManager() {
            _handlers = new List<HANDLER>();
        }
        public void AddLastHandler(HANDLER handler) {
            _handlers.Add(handler);
        }
        public void AddFirstHandler(HANDLER handler) {
            _handlers.Insert(0, handler);
        }
        //O̗vŃLv`ƂB
        public void EndCapture() {
            _capturingHandler = null;
        }
        public HANDLER CapturingHandler {
            get {
                return _capturingHandler;
            }
        }
        public bool IsGuardingUIEvent {
            get {
                return _UIEventGuard;
            }
        }

        //WinForms̃CxgnhƂ̊֘At OnXXXoverrideȂ̂ŃCxgnhōs
        public abstract void AttachControl(Control c);

        //_v
        public string DumpHandlerList() {
            StringBuilder bld = new StringBuilder();
            foreach(IUIHandler h in _handlers) {
                if(bld.Length>0) bld.Append(',');
                bld.Append(h.Name);
            }
            return bld.ToString();
        }

        //̖{
        protected UIHandleResult Process(HandlerDelegate action, ARG args) {
            try {
                _UIEventGuard = true;
                if(_capturingHandler!=null) {
                    UIHandleResult r = action(_capturingHandler, args);
                    if(r==UIHandleResult.EndCapture) _capturingHandler = null; //Lv`̏I
                    return r;
                }
                else {
                    //̏ɂ܂킵Ă
                    foreach(HANDLER h in _handlers) {
                        UIHandleResult r = action(h, args);
                        Debug.Assert(r!=UIHandleResult.EndCapture);
                        if(r==UIHandleResult.Stop) return r;
                        if(r==UIHandleResult.Capture) {
                            Debug.Assert(_capturingHandler==null);
                            _capturingHandler = h;
                            return r;
                        }
                    }

                }
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
            finally {
                _UIEventGuard = false;
            }

            return UIHandleResult.Pass;
        }
    }

    //nh̃}l[W
    /// <summary>
    /// 
    /// </summary>
    /// <exclude/>
    public class MouseHandlerManager : UIHandlerManager<IMouseHandler, MouseEventArgs> {

        //gp̃fQ[g
        private static HandlerDelegate _mouseDownDelegate = 
            delegate(IMouseHandler handler, MouseEventArgs args) { return handler.OnMouseDown(args); };
        private static HandlerDelegate _mouseUpDelegate = 
            delegate(IMouseHandler handler, MouseEventArgs args) { return handler.OnMouseUp(args); };
        private static HandlerDelegate _mouseMoveDelegate = 
            delegate(IMouseHandler handler, MouseEventArgs args) { return handler.OnMouseMove(args); };

        public override void AttachControl(Control c) {
            c.MouseDown += new MouseEventHandler(RootMouseDown);
            c.MouseUp += new MouseEventHandler(RootMouseUp);
            c.MouseMove += new MouseEventHandler(RootMouseMove);
        }

        //WinForms̃Cxgnh
        private void RootMouseDown(object sender, MouseEventArgs args) {
            Process(_mouseDownDelegate, args);
        }
        private void RootMouseUp(object sender, MouseEventArgs args) {
            Process(_mouseUpDelegate, args);
        }
        private void RootMouseMove(object sender, MouseEventArgs args) {
            Process(_mouseMoveDelegate, args);
        }

        //{NĂȂMouseMovezIɔBLOłSplitMark\ɂĕKv
        public void BypassMouseMove(MouseEventArgs e) {
            Process(_mouseMoveDelegate, e);
        }

    }

    /// <summary>
    /// 
    /// </summary>
    /// <exclude/>
    public class KeyboardHandlerManager : UIHandlerManager<IKeyHandler, Keys> {

        private static HandlerDelegate _keyDelegate =
            delegate(IKeyHandler handler, Keys key) { return handler.OnKeyProcess(key); };

        public override void AttachControl(Control c) {
            //ProcessDialogKeyCxgŎƂ񂾂A͂łȂ̂ŋ
        }

        //OĂяo
        public UIHandleResult Process(Keys key) {
            return base.Process(_keyDelegate, key);
        }
    }

}
