/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Screening/ScreeningSchema.cs#3 $
 * $DateTime: 2008/05/14 13:05:12 $
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using Poderosa;
using Poderosa.Preferences;
using Poderosa.Util;

using Travis.ORT;
using Bellagio.Values;
using Bellagio.Environment;

namespace Bellagio.Screening {

    public enum ScreeningSortType {
        None, Ascending, Descending
    }
    [EnumDesc(typeof(ScreeningResultCountType))]
    public enum ScreeningResultCountType {
        [EnumValue(Description="100")]
        Top100,
        [EnumValue(Description="100")]
        Bottom100,
        [EnumValue(Description="㉺50")]
        Both50,
        [EnumValue(Description="Ȃ")]
        All
    }
    [EnumDesc(typeof(ScreeningFilterType))]
    public enum ScreeningFilterType {
        [EnumValue(Description="ׂĂ̖")]
        None,
        [EnumValue(Description="oύ̗p")]
        Nikkei225,
        //[EnumValue(Description="ϔ500")]
        //Active500,
        [EnumValue(Description="؁E؂P")]
        Div1,
        [EnumValue(Description="}U[YEwNXEJASDAQ̂")]
        MO_HE_JQ,
        [EnumValue(Description="ʉ")]
        Currencies,
    }


    //LO̗`
    public class ScreeningSchemaColumn : OriginReportableObject {
        public ORText label;
        public ORText expression;
        public ORText order;
        public ORText format;

        public static ScreeningSortType ParseOrderType(IORText text, ScreeningSortType defaultvalue) {
            if(text.IsOmitted) return defaultvalue;
            string value = text.Value;

            if(value=="ascending")
                return ScreeningSortType.Ascending;
            else if(value=="descending")
                return ScreeningSortType.Descending;
            else if(value=="none")
                return ScreeningSortType.None;
            else
                throw new BellagioException(ORText.FormatMulformedElementMessage(text, "\[g"));
        }
        private void AvoidWarning() {
            label = expression = order = format = new ORText();
        }
    }


    public class ScreeningSchema : ExtensionKitItemWithParameter {
        public ORText title;
        public ORText filter; //boolԂExpressionĖOłBoptional.
        public ORText parameterDescription; //̏Ńp[^𖄂߂邽߂UI
        public ORCollectionMember<ScreeningSchemaColumn> column;

        public ScreeningSchema() {
            column = new ORCollectionMember<ScreeningSchemaColumn>();
        }
        internal override void Load(ExtensionKit owner) {
            base.Load(owner);
        }

        private void AvoidWarning() { //gptB[ȟx
            title = new ORText();
        }
    }

    public class ScreeningSchemaCollection : ViewSchemaCollection<ScreeningSchema> {
        private List<ScreeningSchema> _data;

        public ScreeningSchemaCollection() {
            _data = new List<ScreeningSchema>();
        }
        public ScreeningSchema Find(string name) {
            foreach(ScreeningSchema ss in _data)
                if(!ss.id.IsOmitted && ss.id.Value==name) return ss;

            return null;
        }

        public override void Clear() {
            _data.Clear();
        }
        public override int Count {
            get {
                return _data.Count;
            }
        }
        public override void Add(ScreeningSchema item) {
            _data.Add(item);
        }
        public override ScreeningSchema this[int index] {
            get {
                return _data[index];
            }
        }
        public override IEnumerator GetEnumerator() {
            return _data.GetEnumerator();
        }


    }


}
