#if false
//C# / Java̕pwb_
//R|[lg`p
using System;
using System.Windows.Forms;
using System.Drawing;
using Sansa.Runtime;
using Bellagio.Data;
namespace Bellagio.Drawing {



public class SashineGraphic {
 private IPlatformBridge _bridge;

 private IItaGDI _itaGDI;
 private SashineMotion _motion;


 public SashineGraphic(IPlatformBridge bridge) {
  _bridge = bridge;

  _itaGDI = (IItaGDI)bridge.getAdapter(typeof(IItaGDI));

 }

 public int x;
 public int y;
 public int height;

 public int stringTop; //\ʒuYW(this.y̑Βl)
 public int priceWidth;
 public int volumeWidth;
 public int diffWidth;
 public int width;

 public AutoBrush priceColor;
 public AutoBrush volumeColor;
 public AutoBrush diffPlusColor;
 public AutoBrush diffMinusColor;

 public bool visible;
 public bool showDiff;
 public bool fadingIn;
 public bool fadingOut;
 public int diffOffset;


 public void invalidate() {
  _bridge.invalidate(x, y, width, height);
 }






 public void paint(PaintEventArgs a) {
  if(_motion==null || !visible) return;
  Graphics g = a.Graphics;
  Rectangle clip = _itaGDI.ItaBoundsRect;
  DrawingUtil.DrawClippedString(g, _motion.Sashine.Price.ToString(), _itaGDI.ItaPriceFont, priceColor.asBrush(), clip, x, y+stringTop);
  DrawingUtil.DrawClippedString(g, _motion.Sashine.Volume.ToString(), _itaGDI.ItaVolumeFont, volumeColor.asBrush(), clip, x+priceWidth, y+stringTop);
  if(showDiff)
   DrawingUtil.DrawClippedString(g, DiffString(_motion.Diff), _itaGDI.ItaVolumeDiffFont, _motion.Diff>0? diffPlusColor.asBrush() : diffMinusColor.asBrush(), clip, x+priceWidth+volumeWidth+diffOffset, y+stringTop);
 }
 public void Dispose() {
  priceColor.dispose();
  volumeColor.dispose();
  diffPlusColor.dispose();
  diffMinusColor.dispose();
 }
 //삳ȂƂnull
 public void SetMotion(SashineMotion m) {
  _motion = m;
  visible = m!=null;
  showDiff = m!=null && m.Diff!=0;
  fadingIn = m!=null && m.Action==SashineAction.FadeIn;
  fadingOut = m!=null && m.Action==SashineAction.FadeOut;
 }
 private string DiffString(int value) {
  return value>0? "+" + value.ToString() : value.ToString();
 }

}

} //ns
#endif