/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Ordering/OrderingUtil.cs#8 $
 * $DateTime: 2008/05/14 13:05:12 $
 * 
 * 
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;

using Bellagio.Data;
using Bellagio.Values;
using Poderosa.Util;

namespace Bellagio.Ordering {
    [EnumDesc(typeof(OrderDealType))]
    public enum OrderDealType {
        [EnumValue(Description="")]
        Genbutsu,
        [EnumValue(Description="x")]
        CreditSeido,
        [EnumValue(Description="")]
        CreditIppan,
        [EnumValue(Description="敨EIvV")]
        Derivatives
    }
    [EnumDesc(typeof(LongShort))]
    public enum LongShort {
        [EnumValue(Description="")]
        Long,
        [EnumValue(Description="")]
        Short
    }

    [EnumDesc(typeof(OrderNewClose))]
    public enum OrderNewClose {
        [EnumValue(Description="VK")]
        New,
        [EnumValue(Description="")]
        Close
    }
    [EnumDesc(typeof(OrderNewClose))]
    public enum SpecialOrderClose {
        [EnumValue(Description="")]
        None,
        [EnumValue(Description="")]
        Genhiki,   //
        [EnumValue(Description="n")]
        Genwatashi,
        [EnumValue(Description="SQ")]
        SQ,
        [EnumValue(Description="P")]
        Hakabu
        
    }
    //ڍׂȏԂ́AOrderTransactionStatusƂ̑gŌ܂B
    //OrderStatusOrdered, Cancelled, Changed̂ƂTransactionStatusɂĂɋʂB
    //ȊO͋ʂȂ
    [EnumDesc(typeof(OrderStatus))]
    public enum OrderStatus {
        [EnumValue(Description="")]
        Preparing, //茳œ͂Ŕ̂͂ĂȂ
        [EnumValue(Description="")]
        Ordered,  //󗝂
        [EnumValue(Description="ύX")]
        Changed,
        [EnumValue(Description="")]
        Complete,
        [EnumValue(Description="")]
        Cancelled,     //(Ŏcς݁A܂)
        [EnumValue(Description="")]
        Expired //󗝂Ȃꍇ܂
    }
    public enum OrderTransactionStatus {
        Stable, //󂯕t
        Lock,   //،Ђ̒ʒm҂Ă
        Rejected, //󂯕tȂ
        Waiting, //،Ђ󂯕tɂ͍sĂȂԁBɏꂪJĂȂԑт̒͂ɂȂB
    }

    [EnumDesc(typeof(OrderCondition))]
    public enum OrderCondition {
        [EnumValue(Description="wl")]
        Sashine,
        [EnumValue(Description="s")]
        Nariyuki,
        [EnumValue(Description="w")]
        Yorisashi,
        [EnumValue(Description="")]
        Yorinari,
        [EnumValue(Description="w")]
        Hikesashi,
        [EnumValue(Description="")]
        Hikenari,
        [EnumValue(Description="w")]
        Sashinari,
    }
    [EnumDesc(typeof(OrderLimitDate))]
    public enum OrderLimitDate {
        [EnumValue(Description="")]
        Today,
        [EnumValue(Description="T")]
        Week
    }
    [EnumDesc(typeof(OrderKouza))]
    public enum OrderKouza {
        [EnumValue(Description="ʌ")]
        Ippan,
        [EnumValue(Description="")]
        Tokutei,
        [EnumValue(Description="敨EIvV")]
        Derivatives,
    }

    //PTSƂ̊֌W@ƉɗpBdlȂ̂ŕs邪B
    [EnumDesc(typeof(PTSOrder))]
    public enum PTSOrder {
        [EnumValue(Description="")] //PTSƖ֌W̒ʏ풍
        None,
        [EnumValue(Description="Ԏs")] //PTSɂ̂ݔĂ钍
        PTSOnly,
        [EnumValue(Description="Ԃ֌Jz")] //肵ȂPTS֌Jz
        CarryOverIfExpire,
        [EnumValue(Description="ԂJz")] //OԂŖ肵Ȃ̂ŌJzꂽ
        CarriedOverByExpire
    }

    //،Ђ̎wŁAԍϒEύXE̐tOB
    //ԂƂǂ̂炢ǐ邩͓ȂłȂƂ悭킩Ȃ
    public enum OrderRestriction {
        None, //ȂB
        Locked, //os\
        CancelOnly //̂݉\
    }

    //twl
    public enum OrderTriggerType {
        Unsupported,
        None,
        UpperBreak,
        LowerBreak
    }

    //񉻂͊g\Ȃ悤ɊOC^tF[X
    public interface IOrderItemFormatter {
        string FormatOrderCondition(OrderCondition condition);
        //string FormatOrderType(OrderDealType type, LongShort ls);
        //void FormatOrderType2(OrderDealType type, LongShort ls, out string s1, out string s2); //Qs^CvBPsōςނƂs2==nullԂ
        string FormatOrderStatus(OrderStatus status, OrderTransactionStatus transaction);
        string FormatOrderKouza(OrderKouza kouza);
        string FormatStockExchange(StockExchange exchange);
        string FormatTradeDescription(OrderDealType type, LongShort ls, OrderNewClose newOrClose);
        string FormatPosition(OrderDealType type, LongShort ls);
        string FormatOrderDealType(OrderDealType type);
        string FormatShinnyoKigen(OrderDealType type);
        string FormatShinnyoKubun(OrderDealType type);
        string FormatOrderDealTypeCategory(OrderDealType type);
    }
    public class DefaultOrderItemFormatter : IOrderItemFormatter {
        public virtual string FormatOrderCondition(OrderCondition condition) {
            return EnumDescAttribute.For(typeof(OrderCondition)).GetDescription(condition);
        }
        public virtual string FormatOrderDealType(OrderDealType type) {
            if(type==OrderDealType.Genbutsu)
                return "";
            else if(type==OrderDealType.CreditSeido)
                return "x";
            else if(type==OrderDealType.CreditIppan)
                return "";
            else
                return "敨";
        }
        public virtual string FormatOrderDealTypeCategory(OrderDealType type) {
            if(type==OrderDealType.Genbutsu)
                return "";
            else if(type==OrderDealType.Derivatives)
                return "敨";
            else
                return "Mp";
        }
        public virtual string FormatShinnyoKigen(OrderDealType type) {
            Debug.Assert(type==OrderDealType.CreditSeido || type==OrderDealType.CreditIppan);
            return type==OrderDealType.CreditSeido? "U" : "";
        }
        public virtual string FormatShinnyoKubun(OrderDealType type) {
            Debug.Assert(type==OrderDealType.CreditSeido || type==OrderDealType.CreditIppan);
            return type==OrderDealType.CreditSeido? "x" : "";
        }

        public virtual string FormatPosition(OrderDealType type, LongShort ls) {
            if(type==OrderDealType.Genbutsu)
                return "";
            else
                return ls==LongShort.Long? "" : "";
        }
        /*
        public virtual string FormatOrderType(OrderDealType type, LongShort ls) {
            if(type==OrderDealType.Derivatives) {
                return ls==LongShort.Long? "" : "";
            }
            else {
                if(type==OrderDealType.Genbutsu) {
                    Debug.Assert(ls==LongShort.Long);
                    return "";
                }
                else
                    return ls==LongShort.Long? "Mp" : "Mp";
            }
        }
        public virtual void FormatOrderType2(OrderDealType type, LongShort ls, out string s1, out string s2) {
            s1 = FormatOrderType(type, ls);
            s2 = null;
            if(OrderingUtil.IsShinnyo(type)) {
                s2 = EnumDescAttribute.For(typeof(OrderDealType)).GetDescription(type);
            }
        }
        */
        public virtual string FormatOrderStatus(OrderStatus status, OrderTransactionStatus transaction) {
            if(status==OrderStatus.Complete) return "";
            else if(status==OrderStatus.Expired) return "";
            else if(status==OrderStatus.Preparing) return "\";
            
            //cR̓gUNVԂ֌W
            string tr = "";
            if(transaction==OrderTransactionStatus.Stable) tr = "";
            else if(transaction==OrderTransactionStatus.Lock) tr = "";
            else if(transaction==OrderTransactionStatus.Rejected) tr = "s";
            else if(transaction==OrderTransactionStatus.Waiting) tr = "t";

            string st = "";
            if(status==OrderStatus.Ordered) st = "";
            else if(status==OrderStatus.Changed) st = "ύX";
            else if(status==OrderStatus.Cancelled) st = "";

            Debug.Assert(tr.Length>0 && st.Length>0);

            return st + tr;
        }
        public virtual string FormatStockExchange(StockExchange exchange) {
            return EnumDescAttribute.For(typeof(StockExchange)).GetDescription(exchange);
        }
        public virtual string FormatTradeDescription(OrderDealType type, LongShort ls, OrderNewClose newOrClose) {
            bool n = newOrClose==OrderNewClose.New;
            if(type==OrderDealType.Derivatives) {
                if(ls==LongShort.Long)
                    return n? "VK" : "ԍϔ";
                else
                    return n? "VK" : "ԍϔ";
            }
            else if(type==OrderDealType.Genbutsu)
                return n? "" : "";
            else { //Mp
                if(ls==LongShort.Long)
                    return n? "VK" : "ԍϔ";
                else
                    return n? "VK" : "ԍϔ";
            }
        }
        public virtual string FormatOrderKouza(OrderKouza kouza) {
            return kouza==OrderKouza.Ippan? "" : kouza==OrderKouza.Tokutei? "" : "OP";
        }
    }


    public static class OrderingUtil {
        public static bool CanCancellableStatus(OrderStatus status, OrderTransactionStatus transaction) {
            if(status==OrderStatus.Complete || status==OrderStatus.Expired)
                return false;
            else if(status==OrderStatus.Preparing) //ۗȂǂƂłOK
                return true;
            else if(status==OrderStatus.Ordered)
                return transaction==OrderTransactionStatus.Stable || transaction==OrderTransactionStatus.Waiting; //sÂƂ͂̌̎͂ȂB
            else if(status==OrderStatus.Changed)
                return transaction!=OrderTransactionStatus.Lock; //ύXs͕ʂ̕ύXȂOKȂ̂ŋ֎~Ȃ
            else if(status==OrderStatus.Cancelled)
                return transaction==OrderTransactionStatus.Waiting || transaction==OrderTransactionStatus.Rejected; //s͕ύXOKȂ̂ňSɐUUIB͂ȍ~̑s

            Debug.Assert(false); //ȏőSP[Xԗ̂͂
            return false;
        }
        public static bool IsFinalStatus(OrderStatus status, OrderTransactionStatus transaction) {
            return status==OrderStatus.Complete || status==OrderStatus.Expired || (status==OrderStatus.Cancelled && transaction==OrderTransactionStatus.Stable);
        }
        public static bool IsShinnyo(OrderDealType type) {
            return type==OrderDealType.CreditIppan || type==OrderDealType.CreditSeido;
        }
        public static bool IsLong(LongShort ls) {
            return ls==LongShort.Long; //󔄂ȊO̓O|WV
        }
        public static bool IsSashineRequired(OrderCondition cond) {
            return cond==OrderCondition.Sashine || cond==OrderCondition.Yorisashi || cond==OrderCondition.Hikesashi || cond==OrderCondition.Sashinari;
        }
        public static bool IsCarryingPTS(PTSOrder ptsOrder) {
            return ptsOrder==PTSOrder.CarryOverIfExpire || ptsOrder==PTSOrder.CarriedOverByExpire;
        }
        public static bool IsFutureOrOption(StockProfileFlags f) {
            return (f & (StockProfileFlags.Future | StockProfileFlags.Option))!=StockProfileFlags.None;
        }

        public static void AssertCorrectDataResponseCode(DataResponseCode code) {
            DataResponseCode r = code & DataResponseCode.ResultMask;
            Debug.Assert(r==DataResponseCode.Failed || r==DataResponseCode.Succeeded);
            DataResponseCode s = code & DataResponseCode.SyncTypeMask;
            Debug.Assert(s==DataResponseCode.SyncResponse || s==DataResponseCode.AsyncResponse || s==DataResponseCode.DataSourceRequiresRefresh);
        }

        //formatterɂ镶ϊzɑ΂ēKp
        public delegate string ElemFormatter<T>(T value);
        public static string[] FormatArray<T>(ElemFormatter<T> f, T[] values) {
            string[] t = new string[values.Length];
            for(int i=0; i<t.Length; i++)
                t[i] = f(values[i]);
            return t;
        }

        public static bool IsTriggerAvailable(OrderTriggerType type) {
            return type==OrderTriggerType.UpperBreak || type==OrderTriggerType.LowerBreak;
        }
    }


}
