/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Ordering/OrderingCommand.cs#21 $
 * $DateTime: 2008/05/14 13:05:12 $
 * 
 * c[o[{́B
 * Office2007Ƃ܂˂đ傫ACRɂĂ݂BȂAڂhbv_E{^̓̂߂Poderosaɋ@\ǉĂ
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Windows.Forms;
using System.Diagnostics;

using Travis.ORT;

using Poderosa;
using Poderosa.Commands;
using Poderosa.Forms;

using Bellagio.Environment;
using Bellagio.Forms;

//Ɋւc[o[AR}h

namespace Bellagio.Ordering {
    public class OrderingCommands {

        private IGeneralCommand _openOrderForm;
        private IGeneralCommand _openPositionListForm;
        private IGeneralCommand _openOrderListForm;
        private IGeneralCommand _openYoryokuForm;

        //private OrderForm _orderForm;
        private PositionListForm _positionListForm;
        private OrderListForm _orderListForm;
        private PowerInfoDialog _powerInfoDialog;

        public OrderingCommands(ICommandManager cm) {
            ICommandCategory cc = cm.CommandCategories.Dialogs;
            CanExecuteDelegate enabler = new CanExecuteDelegate(delegate(ICommandTarget target) {
                if(BDebugOpts.UITEST_ALLOW_ORDER_IN_OFFLINE)
                    return true;
                else
                    return BellagioRoot.DataSourceHost.IsConnected;
            });
            _openOrderForm = new GeneralCommandImpl("jp.co.lagarto.tactico.ordering.openOrderForm", "", cc, new ExecuteDelegate(OpenOrderFormCommand), enabler).SetDefaultShortcutKey(Keys.Control|Keys.O);
            cm.Register(_openOrderForm);
            _openPositionListForm = new GeneralCommandImpl("jp.co.lagarto.tactico.ordering.openPositionListForm", "|WVƉ", cc, new ExecuteDelegate(OpenPositionListFormCommand), enabler).SetDefaultShortcutKey(Keys.Control|Keys.P);
            cm.Register(_openPositionListForm);
            _openOrderListForm = new GeneralCommandImpl("jp.co.lagarto.tactico.ordering.openOrderListForm", "Ɖ", cc, new ExecuteDelegate(OpenOrderListFormCommand), enabler).SetDefaultShortcutKey(Keys.Control|Keys.R);
            cm.Register(_openOrderListForm);
            _openYoryokuForm = new GeneralCommandImpl("jp.co.lagarto.tactico.ordering.openYoryokuForm", "]͏", cc, new ExecuteDelegate(OpenYoryokuFormCommand), enabler);
            cm.Register(_openYoryokuForm);
        }
        public IGeneralCommand OpenOrderForm {
            get {
                return _openOrderForm;
            }
        }
        public IGeneralCommand OpenPositionListForm {
            get {
                return _openPositionListForm;
            }
        }
        public IGeneralCommand OpenOrderListForm {
            get {
                return _openOrderListForm;
            }
        }
        public IGeneralCommand OpenYoryokuForm {
            get {
                return _openYoryokuForm;
            }
        }

        //tH[쐬ς݂Ȃ炻AłȂnullԂ
        public PositionListForm PositionListForm {
            get {
                return _positionListForm;
            }
        }
        public OrderListForm OrderListForm {
            get {
                return _orderListForm;
            }
        }
        /*
        public OrderForm OrderForm {
            get {
                return _orderForm;
            }
        }
        */
        private CommandResult OpenOrderFormCommand(ICommandTarget target) {
            return OpenOrderFormCommand(target, null);
        }

        private CommandResult CheckDataSource() {
            //ItCłnUI𓮂Ȃf[^\[X`FbN͂ȂBtH[̓mFȂǂ̂ƂɎgp
            if(BDebugOpts.UITEST_ALLOW_ORDER_IN_OFFLINE || BellagioRoot.DataSourceHost.IsConnected) {
                return CommandResult.Succeeded;
            }
            else {
                return CommandResult.Failed;
            }
        }

        //܂Ԃŕ\ łɌĂOrderForm㏑邱Ƃ̂Œ
        public CommandResult OpenOrderFormCommand(ICommandTarget target, OrderFormParameter parameter) {
            Form f = BellagioCommandUtil.AsPoderosaForm(target).AsForm();
            CommandResult r = CheckDataSource();
            if(r!=CommandResult.Succeeded) return r;

            if(parameter==null) parameter = OrderFormParameter.ForNewPosition();
#if true
            TabStyleOrderForm tof = new TabStyleOrderForm(parameter);
            FormUtil.AdjustStyleForModelessSizableDialog(tof, f);
            FormUtil.SetLocationToCenter(tof, f);
            switch(BellagioRoot.FixedPreferences.Ordering.OrderFormStyle) {
                case OrderFormStyle.Owned:
                    tof.Owner = f;
                    break;
                case OrderFormStyle.StandAlone:
                    tof.Owner = null;
                    tof.ShowInTaskbar = true;
                    break;
                /*
                case OrderFormStyle.TopMost:
                    tof.Owner = null;
                    tof.TopMost = true;
                    break;
                */
            }            
            tof.Show();
#else
            if(_orderForm==null || _orderForm.IsDisposed) {
                _orderForm = new OrderForm();
                FormUtil.SetLocationToCenter(_orderForm, f);
            }

            _orderForm.Owner = f;
            _orderForm.Hide();
            r = _orderForm.InitContent(parameter); //Ŗ\
            _orderForm.Show();
#endif
            return CommandResult.Succeeded;
        }

        public CommandResult OpenPositionListFormCommand(ICommandTarget target) {
            Form f = ((IPoderosaForm)target.GetAdapter(typeof(IPoderosaForm))).AsForm();
            CommandResult r = CheckDataSource();
            if(r!=CommandResult.Succeeded) return r;

            if(_positionListForm==null || _positionListForm.IsDisposed) {
                _positionListForm = new PositionListForm();
                FormUtil.SetLocationToCenter(_positionListForm, f);
                _positionListForm.Owner = f;
                _positionListForm.Show();
            }
            else 
                ReshowForm(_positionListForm, f);

            return CommandResult.Succeeded;
        }

        public CommandResult OpenOrderListFormCommand(ICommandTarget target) {
            Form f = ((IPoderosaForm)target.GetAdapter(typeof(IPoderosaForm))).AsForm();
            CommandResult r = CheckDataSource();
            if(r!=CommandResult.Succeeded) return r;

            if(_orderListForm==null || _orderListForm.IsDisposed) {
                _orderListForm = new OrderListForm();
                FormUtil.SetLocationToCenter(_orderListForm, f);
                _orderListForm.Owner = f;
                _orderListForm.Show();
            }
            else 
                ReshowForm(_orderListForm, f);

            return CommandResult.Succeeded;
        }
        private void ReshowForm(Form form, Form owner) {
            form.Owner = owner;
            if(form.WindowState==FormWindowState.Minimized) form.WindowState = FormWindowState.Normal;
            form.Show();
            form.Activate();
        }

        public CommandResult OpenYoryokuFormCommand(ICommandTarget target) {
            Form f = ((IPoderosaForm)target.GetAdapter(typeof(IPoderosaForm))).AsForm();
            CommandResult r = CheckDataSource();
            if(r!=CommandResult.Succeeded) return r;

            if(!BellagioRoot.DataSourceHost.IsConnected) {
                BUtil.ShowWarningMessageBox("OCԂł͂Ȃߏ̎擾ł܂B");
                return CommandResult.Succeeded;
            }

            if(_powerInfoDialog==null || _powerInfoDialog.IsDisposed) {
                _powerInfoDialog = new PowerInfoDialog(f);
                _powerInfoDialog.Show();
            }
            else
                ReshowForm(_powerInfoDialog, f);

            return CommandResult.Succeeded;
        }

        //ʒm\ ͒ʏ̃R}hł͂Ȃ
        public CommandResult OpenTradeNotification(ICommandTarget target, TradeOrderItem item, TradeOrderItem.Element elem) {
            Form f = ((IPoderosaForm)target.GetAdapter(typeof(IPoderosaForm))).AsForm();
            TradeNotificationDialog d = new TradeNotificationDialog(item, elem);
            Debug.WriteLine("OTN " + d.DesktopBounds.ToString());
            d.Show();
            return CommandResult.Succeeded;
        }
    }

    public class OrderingToolBar : IToolBarComponent {

        private IToolBarElement[] _elements;

        public OrderingToolBar() {
        }
        private void CreateElements() {
            OrderingCommands cmds = OrderingPlugin.Instance.Commands;
            _elements = new IToolBarElement[4];
            _elements[0] = new DialogToolBarElement("|WVƉ", 7, cmds.OpenPositionListForm);
            _elements[1] = new DialogToolBarElement("", 4, cmds.OpenOrderForm);
            _elements[2] = new DialogToolBarElement("Ɖ", 8, cmds.OpenOrderListForm);
            _elements[3] = new DialogToolBarElement("]͏", 11, cmds.OpenYoryokuForm);
        }

        public IToolBarElement[] ToolBarElements {
            get {
                if(_elements==null) CreateElements();
                return _elements;
            }
        }

        public Size BarImageSize {
            get {
                return new Size(24, 24);
            }
        }

        public IAdaptable GetAdapter(Type adapter) {
            return BUtil.DefaultGetAdapter(this, adapter);
        }

    }

}
