/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Ordering/DetailedTradeList.cs#1 $
 * $DateTime: 2007/12/28 19:23:38 $
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;

using Bellagio.Values;

namespace Bellagio.Ordering {
    //̏ڍו\̂AToolTipł͕\ɂȂꍇɂg
    public class DetailedTradeList : ToolStripDropDown {
        private PrivateListBox _listBox;

        public DetailedTradeList() {

            _listBox = new PrivateListBox(this);

            ToolStripControlHost tch = new ToolStripControlHost(_listBox);
            this.Items.Add(tch);
            tch.Padding = Padding.Empty;
            this.Padding = Padding.Empty;
        }

        public bool Popup(OrderListControl parent, TradeOrderItem item, Point pt_screen) {
            this.BackColor = Color.Black;
            _listBox.BackColor = this.BackColor;
            this.ForeColor = Color.White;
            _listBox.ForeColor = this.ForeColor;

            InitListBox(item);
            this.Show(pt_screen);
            _listBox.Focus();
            return true;
        }

        private void InitListBox(TradeOrderItem item) {
            this.SuspendLayout();

            _listBox.HorizontalExtent = 140;
            _listBox.MaximumSize = new Size(140, 200); //ĂƗ]Ă܂Ƃ͂ȂȂ

            _listBox.BeginUpdate();
            _listBox.Items.Clear();
            string vu = item.Stock.Profile.VolumeUnitString;
            foreach(TradeOrderItem.Element e in item.Trades) {
                _listBox.Items.Add(String.Format("{0} {1:N0}~ {2:N0}{3}", BTime.FormatHHMM(e.Time), item.AdjustPriceI(e.Price), e.Volume, vu));
            }

            _listBox.EndUpdate();

            this.ResumeLayout(true);
        }

        //ListBox̃R[obNn

        public void Exit() {
            this.Close();
        }

        public class PrivateListBox : ListBox {
            private DetailedTradeList _parent;
            public PrivateListBox(DetailedTradeList parent) {
                _parent = parent;
                this.IntegralHeight = false;
            }

            protected override bool ProcessCmdKey(ref Message msg, Keys keyData) {
                Keys key = keyData & Keys.KeyCode;

                switch(key) {
                    case Keys.Escape:
                    case Keys.Enter:
                    case Keys.Space:
                        _parent.Exit();
                        return base.ProcessCmdKey(ref msg, keyData);
                    default:
                        return base.ProcessCmdKey(ref msg, keyData);
                }
            }


            protected override void OnLostFocus(EventArgs e) {
                base.OnLostFocus(e);
                _parent.Exit();
            }
        }
    }
}
