/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Forms/ViewContentGraphics.cs#9 $
 * $DateTime: 2008/02/22 14:38:32 $
 * `{̂ƃAj[V̊{
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using System.Diagnostics;

using Sansa.Runtime;
using Travis.LocationOperation;

namespace Bellagio.Forms {

    //GraphicViewerĂԂƂ̂߂̂
    public interface IBellagioLightWeightControl {
        void Paint(Graphics g, Rectangle clip);
        RectOp RectOp { get; }
        void Dispose();
    }

    [Flags]
    public enum GraphUpdateReason {
        None=0, Data=1, Direct=2
    }

    public abstract class ViewContentGraphics : IBellagioLightWeightControl {
        protected Control _container;
        protected RectOp _rectangleOperator; //_container̃NCAgWɂ`ʒu
        protected GraphUpdateReason _updateReason;
        protected DoubleTimer _dataAnimationTimer;
        protected double _animationTimeSec; //bPʂł̃Aj[V

        private GraphScaleInfoBase _scaleInfoBase;

        private bool _duringDataUpdate;

        public ViewContentGraphics(IPlatformBridge platform, Control container) {
            _container = container;
            _updateReason = GraphUpdateReason.Direct;
            _animationTimeSec = 0.5;

            DTimerHandler h = new DTimerHandler(delegate() { _dataAnimationTimer.reset(0, 1, platform.getRootTimer().secondToTick(_animationTimeSec)); }, new DTimerHandler.D(OnDataAnimationTick));
            h.SetEnd(new DTimerHandler.D(OnEndAnimation));
            _dataAnimationTimer = new DoubleTimer(platform, h);
        }
        protected void Init(GraphScaleInfoBase scale) {
            //RXgN^Ƃ͓ƗɌĂׂقs悢
            _scaleInfoBase = scale;
        }
        public DoubleTimer DataAnimationTimer {
            get {
                return _dataAnimationTimer;
            }
        }
        public double AnimationTimeSec {
            get {
                return _animationTimeSec;
            }
            set {
                _animationTimeSec = value;
            }
        }
        public RectOp RectOp {
            get {
                return _rectangleOperator;
            }
        }
        public void SetParent(Control c) {
            _container = c;
            if(_dataAnimationTimer.IsActive()) _dataAnimationTimer.Abort();
        }

        public abstract void Dispose();

        //Ot̃C̎d͂Ƃɂ`悾
        public abstract void Paint(Graphics g, Rectangle clip);

        //Aj[VIʒm
        protected virtual void OnEndAnimation() {
        }

        //f[^XVƂ́ABeginDataUpdate , Datȁ, EndDataUpdatȅ
        public void BeginDataUpdate() {
            Debug.Assert(!_duringDataUpdate);
            Debug.Assert(!_container.InvokeRequired); //CXbhŎsł邱
            _scaleInfoBase.BeginDataUpdate();
            _duringDataUpdate = true;
        }
        public void EndDataUpdate() {
            Debug.Assert(_duringDataUpdate);
            Debug.Assert(!_container.InvokeRequired); //CXbhŎsł邱
            _updateReason |= GraphUpdateReason.Data;
            BuildScaleInfo();

            if(!_dataAnimationTimer.IsActive()) _dataAnimationTimer.Initialize();
            _scaleInfoBase.EndDataUpdate();

            _container.Invalidate();
            _duringDataUpdate = false;
        }
        
        public void DataUpdateDirect() {
            if(_container==null) return;

            Debug.Assert(!_container.InvokeRequired); //CXbhŎsł邱
            _updateReason |= GraphUpdateReason.Direct;
            if(_dataAnimationTimer.IsActive()) _dataAnimationTimer.Abort(); //Aj[V͑~
            BuildScaleInfo();
            _container.Invalidate();
        }
        protected abstract void BuildScaleInfo();

        private void OnDataAnimationTick() {
            try {
                InvalidateForDataAnimationTick();
            }
            catch(Exception ex) {
                Poderosa.RuntimeUtil.ReportException(ex);
            }
        }

        protected abstract void InvalidateForDataAnimationTick();

        //Invalidatey
        protected void InvalidateRect(BRect rect) {
            if(_container!=null)
                _container.Invalidate(rect.Value);
        }
    }

    //Aj[VWϊ
    public class LinearTranslatorAnimation {
        private LinearTranslator _translator;
        private LinearTranslator _prev;
        private GraphScaleInfoBase _scale;
        public LinearTranslatorAnimation(GraphScaleInfoBase s) {
            _scale = s;
        }
        public void Update(LinearTranslator t) {
            if(_prev==null) _prev = t;
            _translator = t;
        }
        public void BeginDataUpdate() {
            _prev = _translator;
        }
        public LinearTranslator CurrentTranslator {
            get {
                if(_scale.IsScaleMoving) {
                    double p = GetDataTimer();
                    return new LinearTranslator(
                        _translator.A*p + _prev.A*(1-p),
                        _translator.B*p + _prev.B*(1-p));
                }
                else
                    return _translator;
            }
        }
        private double GetDataTimer() {
            return _scale.Graph.DataAnimationTimer.value();
        }
    }

    public abstract class GraphScaleInfoBase {
        private ViewContentGraphics _ownerGraph;
        protected bool _translatorChanging;

        public GraphScaleInfoBase(ViewContentGraphics g) {
            _ownerGraph = g;
        }
        public ViewContentGraphics Graph {
            get {
                return _ownerGraph;
            }
        }
        public bool IsScaleMoving {
            get {
                return _translatorChanging && _ownerGraph.DataAnimationTimer.IsActive();
            }
        }

        public virtual void BeginDataUpdate() {
        }
        public virtual void EndDataUpdate() {
        }
    }

    public abstract class GraphDataBase {
        public virtual void BeginDataUpdate() {
        }
        public virtual void EndDataUpdate() {
        }
    }
}
