/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Data/WebUtil.cs#8 $
 * $DateTime: 2007/12/28 19:23:38 $
 * 
 * Web܂̃[eBeB
 * ƂʁF
 *  404G[EndGetResponse_ŗOɂȂB
 *  _CNg͏ĂnĂBRequestɓK؂ɐݒ肷΃Rg[\ȂA܂̕Kv͓ʂȂB
 *  ^CAEg͎Oi񓯊ʐMȂ̂œRj
 *  HTTPSȂgBAT[oؖɖ肪ꍇɌx@sB
 *  WebResponse.DisposeIɌĂׂȂ̂͋CB\[XHC邪B
 *  ContentLengthwb_ȂƂ́AvpeBĂԂ-1ԂB
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Net;
using System.Diagnostics;
using System.IO;

#if UNITTEST
using NUnit.Framework;
using System.Threading;
#endif

namespace Bellagio.Data {
    //񓯊HTTPANZX̃[eBeB

    public interface IWebResponseReceiver {
        void OnResponse(WebResponse response);

    }

    public class WebUtil {
        private static AsyncCallback _callback = new AsyncCallback(CallBackRoot);
        private class Tag {
            public IWebResponseReceiver _receiver;
            public WebRequest _request;
            public Tag(WebRequest req, IWebResponseReceiver rec) {
                _request = req;
                _receiver = rec;
            }
        }

        public static IAsyncResult AsyncRequest(WebRequest req, IWebResponseReceiver receiver) {
            return req.BeginGetResponse(_callback, new Tag(req, receiver));
        }

        private static void CallBackRoot(IAsyncResult result) {
            Tag tag = (Tag)result.AsyncState;
            try {
                WebResponse response = tag._request.EndGetResponse(result);
                tag._receiver.OnResponse(response);
            }
            catch(Exception ex) {
                WebException wex = ex as WebException;
                if(wex!=null) {
                    tag._receiver.OnResponse(wex.Response); //HTTPx̃G[݂͂ȒʒmBXe[^XR[h͕ԂȂƁB
                    return;
                }
                Debug.WriteLine(ex.Message);
                Debug.WriteLine(ex.StackTrace);
            }
        }
    }

#if UNITTEST
    [TestFixture]
    public class WebTests {
        private class Client : IWebResponseReceiver {
            public WebResponse _response;
            public void OnResponse(WebResponse response) {
                _response = response;
            }
        }
        [Test]
        public void Normal() {
            WebRequest req = WebRequest.Create("http://www.google.com/");
            Client cl = new Client();
            WebUtil.AsyncRequest(req, cl).AsyncWaitHandle.WaitOne();
            while(cl._response==null) Thread.Sleep(100);

            Assert.IsTrue(cl._response is HttpWebResponse);
            Assert.AreEqual(HttpStatusCode.OK, ((HttpWebResponse)cl._response).StatusCode);
        }
        [Test]
        public void NotFound() {
            WebRequest req = WebRequest.Create("http://www.google.com/maybe_404/");
            Client cl = new Client();
            WebUtil.AsyncRequest(req, cl).AsyncWaitHandle.WaitOne();
            while(cl._response==null) Thread.Sleep(100);

            Assert.IsTrue(cl._response is HttpWebResponse);
            Assert.AreEqual(HttpStatusCode.NotFound, ((HttpWebResponse)cl._response).StatusCode);
            //Debug.WriteLine(((HttpWebResponse)cl._response).StatusDescription);
        }
        [Test]
        public void Redirect() {
            WebRequest req = WebRequest.Create("https://www.google.com/");
            Client cl = new Client();
            WebUtil.AsyncRequest(req, cl).AsyncWaitHandle.WaitOne();
            while(cl._response==null) Thread.Sleep(100);

            Assert.IsTrue(cl._response is HttpWebResponse);
            //Assert.AreEqual(HttpStatusCode., ((HttpWebResponse)cl._response).StatusCode);
            Debug.WriteLine(((HttpWebResponse)cl._response).StatusCode);
            Debug.WriteLine(((HttpWebResponse)cl._response).StatusDescription);
            Debug.WriteLine(((HttpWebResponse)cl._response).ResponseUri.ToString());
        }
        [Test]
        public void Https() {
            WebRequest req = WebRequest.Create("https://www.amazon.co.jp/");
            Client cl = new Client();
            WebUtil.AsyncRequest(req, cl).AsyncWaitHandle.WaitOne();
            while(cl._response==null) Thread.Sleep(100);

            Assert.IsTrue(cl._response is HttpWebResponse);
            //Assert.AreEqual(HttpStatusCode., ((HttpWebResponse)cl._response).StatusCode);
            Debug.WriteLine(((HttpWebResponse)cl._response).StatusCode);
            Debug.WriteLine(((HttpWebResponse)cl._response).StatusDescription);
            Debug.WriteLine(((HttpWebResponse)cl._response).ResponseUri.ToString());
        }
        /*
        [Test]
        public void InvalidPort() {
            WebRequest req = WebRequest.Create("http://www.google.com:8002/"); //ۍg|[g
            Client cl = new Client();
            WebUtil.AsyncRequest(req, cl).AsyncWaitHandle.WaitOne();
        }
        */
    }
#endif

}
