/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Data/Ita.cs#14 $
 * $DateTime: 2008/04/17 18:20:55 $
 * 
 * ̃f[^\BQ̔̍Ƃ̂|Cg
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;

using Bellagio.Values;
#if UNITTEST
using NUnit.Framework;
#endif

namespace Bellagio.Data {
    //TESTINFO ̃t@C

    //Ǝwl̃f[^Bf[^tB[h獷Ƃ낪]c[Ƃ̍̃~\

    //wl̃ANV
    public enum SashineAction {
        Move, //p\
        ScrollIn, //O猩ĂANV
        ScrollOut, //O֏ĂANV
        FadeIn, //̏ŌĂANV
        FadeOut, //̏ŏĂANV
    }
    public enum SashinePriceEffect {
        None,
        Active,  //ŐVl
        FadeIn,  //ꂩlɂȂ
        FadeOut  //lłȂȂ
    }
    public enum SashinePriceMotion {
        None,
        Tick
    }
    public enum AskBid {
        Ask, Bid
    }
    //wlɂL
    public enum SashineRemark {
        None,
        Yorimae,
        TokuKehai, //ʋCz
        Hike,
        Chuu  //
    }

    public class Sashine {
        private int _price;
        private int _volume;
        private int _orderCount; //@gȂƂ
        private int _index; //O0
        private SashineRemark _remark;
        private bool _visible;

        public Sashine() {
        }

        public Sashine(int price, int volume, int index) {
            _price = price;
            _volume = volume;
            _index = index;
            _orderCount = 0;
            _remark = SashineRemark.None;
            _visible = false;
        }

        public int Index {
            get {
                return _index;
            }
        }
        public int Price {
            get {
                return _price;
            }
            set {
                _price = value;
            }
        }
        public int Volume {
            get {
                return _volume;
            }
            set {
                _volume = value;
            }
        }
        public bool Visible {
            get {
                return _visible;
            }
            set {
                _visible = value;
            }
        }
        public int OrderCount {
            get {
                return _orderCount;
            }
            set {
                _orderCount = value;
            }
        }
        public SashineRemark Remark {
            get {
                return _remark;
            }
            set {
                _remark = value;
            }
        }

        public void Import(Sashine src) {
            _price = src._price;
            _volume = src._volume;
            _orderCount = src._orderCount;
            _remark = src._remark;
            _index = src._index;
            _visible = src._visible;
        }
        public Sashine Clone() {
            Sashine s = new Sashine();
            s.Import(this);
            return s;
        }
    }

    //Ask/Bid̕Е̔ł邱Ƃɒ
    //̍XVCxg󂯂ƁAXibvVbgƔrĔ̓肷Ƃ菇ɂȂ
    public class Ita {
        private Sashine[] _sashine;
        private AskBid _askbid;

        public Ita(int size, AskBid askbid) {
            _askbid = askbid;
            _sashine = new Sashine[size];
            for(int i=0; i<size; i++) _sashine[i] = new Sashine(0, 0, i);
        }

        public int Size {
            get {
                return _sashine.Length;
            }
        }
        public AskBid AskBid {
            get {
                return _askbid;
            }
        }
        public int VisibleSashineCount {
            get {
                for(int i=_sashine.Length-1; i>=0; i--) {
                    if(_sashine[i].Visible) return i+1;
                }
                return 0;
            }
        }

        //ȂǂŃ_CNgɃZbg volume==0ŏɂȂ
        public void SetDirect(int index, int price, int volume) {
            SetDirect(index, price, volume, 0, SashineRemark.None, true);
        }
        public void SetDirect(int index, int price, int volume, bool visible) {
            SetDirect(index, price, volume, 0, SashineRemark.None , visible);
        }
        public void SetDirect(int index, int price, int volume, int ordercount, SashineRemark rem, bool visible) {
            Sashine s = _sashine[index];
            s.Price = price;
            s.Volume = volume;
            s.Visible = visible;
            s.OrderCount = ordercount;
            s.Remark = rem;
        }

        //wlԂB
        public Sashine SashineAt(int index) {
            return _sashine[index];
        }
        //InVisiblêƂnull
        public Sashine VisibleSashineAt(int index) {
            Sashine s = _sashine[index];
            return s.Visible? s : null;
        }

        //liɕł邩𒲂ׂ
        public bool IsOrdered() {
            for(int i=0; i<_sashine.Length-1; i++) {
                Sashine x = _sashine[i];
                Sashine y = _sashine[i+1];
                if(x.Visible) {
                    if(y.Visible) {
                        //PriceĈvƂAsk/BidǂłfalseԂBȂ̂XOR͎gȂ
                        if(_askbid==AskBid.Ask) {
                            if(x.Price >= y.Price) return false;
                        }
                        else {
                            if(x.Price <= y.Price) return false;
                        }
                    }
                }
                else
                    if(y.Visible) return false; //xVisiblełȂwl炻̌Visible炾
            }
            return true;
        }

        public void Import(Ita src) {
            Debug.Assert(_sashine.Length==src._sashine.Length);
            for(int i=0; i<_sashine.Length; i++)
                _sashine[i].Import(src._sashine[i]);
        }
        public void Import(Ita src, int length) {
            for(int i=0; i<length; i++)
                _sashine[i].Import(src._sashine[i]);
        }
    }

    //wl̓
    public class SashineMotion {
        private Sashine _sashine;
        private int _srcIndex;
        private int _destIndex;
        private int _diff;
        private SashineAction _action;
        private SashinePriceEffect _priceEffect;
        private SashinePriceMotion _priceMotion;

        public SashineMotion() {
            _sashine = new Sashine();
        }
        public Sashine Sashine {
            get {
                return _sashine;
            }
        }
        //ANVł͖
        public int SrcIndex {
            get {
                return _srcIndex;
            }
        }
        //ŃANVł͖
        public int DestIndex {
            get {
                return _destIndex;
            }
        }
        //Sustainł̂ݗL
        public int Diff {
            get {
                return _diff;
            }
        }
        public SashineAction Action {
            get {
                return _action;
            }
        }

        //ItaMotion̍쐬Ƃ͓ƗɃZbg
        public SashinePriceEffect PriceEffect {
            get {
                return _priceEffect;
            }
            set {
                _priceEffect = value;
            }
        }
        public SashinePriceMotion PriceMotion {
            get {
                return _priceMotion;
            }
            set {
                _priceMotion = value;
            }
        }

        //ݒnBItaMotionĂ
        // 1 ̂܂ܕێAKvɉʒu▇ς
        public void Move(Sashine sashine, int srcIndex, int destIndex, int diff) {
            _sashine.Import(sashine);
            _srcIndex = srcIndex;
            _destIndex = destIndex;
            _diff = diff;
            _action = SashineAction.Move;
            _priceEffect = SashinePriceEffect.None;
            _priceMotion = SashinePriceMotion.None;
        }
        public void ScrollIn(Sashine sashine, int destIndex) {
            _sashine.Import(sashine);
            _srcIndex = -1;
            _destIndex = destIndex;
            _action = SashineAction.ScrollIn;
            _priceEffect = SashinePriceEffect.None;
            _priceMotion = SashinePriceMotion.None;
        }
        public void ScrollOut(Sashine sashine, int srcIndex) {
            _sashine.Import(sashine);
            _srcIndex = srcIndex;
            _destIndex = -1;
            _action = SashineAction.ScrollOut;
            _priceEffect = SashinePriceEffect.None;
            _priceMotion = SashinePriceMotion.None;
        }
        public void FadeIn(Sashine sashine, int destIndex) {
            _sashine.Import(sashine);
            _srcIndex = destIndex; //h~BtF[hł͈ʒu͕s
            _destIndex = destIndex;
            _action = SashineAction.FadeIn;
            _priceEffect = SashinePriceEffect.None;
            _priceMotion = SashinePriceMotion.None;
        }
        public void FadeOut(Sashine sashine, int srcIndex) {
            _sashine.Import(sashine);
            _srcIndex = srcIndex;
            _destIndex = srcIndex; //h~BtF[hł͈ʒu͕s
            _action = SashineAction.FadeOut;
            _priceEffect = SashinePriceEffect.None;
            _priceMotion = SashinePriceMotion.None;
        }
    }

    //r̓BőŖ{Q̃ANV
    public class ItaMotion {
        private SashineMotion[] _motions;
        private AskBid _askbid;
        private int _size; //[V͔rʎ
        private int _itaSize;

        //̃TCY^
        public ItaMotion(int size) {
            _itaSize = size;
            _motions = new SashineMotion[size*2];
            for(int i=0; i<_motions.Length; i++) _motions[i] = new SashineMotion();
        }

        public int Size {
            get {
                return _size;
            }
        }
        public int ItaSize {
            get {
                return _itaSize;
            }
        }
        public AskBid AskBid {
            get {
                return _askbid;
            }
        }
        public SashineMotion MotionAt(int index) {
            return _motions[index];
        }
        public void ClearPriceEffect() {
            for(int i=0; i<_size; i++)
                _motions[i].PriceEffect = SashinePriceEffect.None;
        }
        public void ClearPriceMotion() {
            for(int i=0; i<_size; i++)
                _motions[i].PriceMotion = SashinePriceMotion.None;
        }
        public SashineMotion FindByPrice(int price) {
            for(int i=0; i<_size; i++)
                if(_motions[i].Sashine.Price == price) return _motions[i];
            return null;
        }
        public SashineMotion FindByPriceMotion(SashinePriceMotion motion) {
            for(int i=0; i<_size; i++)
                if(_motions[i].PriceMotion==motion) return _motions[i];
            return null;
        }

        //rB̃t@C̃R[hŃASY炵̂͂ꂾ
        public void Create(Ita snapshot, Ita current) {
            Debug.Assert(snapshot.Size==current.Size);
            Debug.Assert(snapshot.Size*2 == _motions.Length);
            Debug.Assert(snapshot.AskBid==current.AskBid);
            Debug.Assert(snapshot.IsOrdered());
            Debug.Assert(current.IsOrdered());
            _askbid = snapshot.AskBid;

            int snap_index = 0;
            int curr_index = 0;
            int motion_index = 0;
            int snap_count = snapshot.VisibleSashineCount;
            int curr_count = current.VisibleSashineCount;
            //O珇rĂ
            while(snap_index < snap_count || curr_index < curr_count) {
                Sashine s = snap_index==snap_count? null : snapshot.VisibleSashineAt(snap_index);
                Sashine c = curr_index==curr_count? null : current.VisibleSashineAt(curr_index);

                if(s==null)
                    _motions[motion_index++].ScrollIn(c, curr_index++);
                else if(c==null)
                    _motions[motion_index++].ScrollOut(s, snap_index++);
                else { //Ƃɑ݂Ƃ
                    if(s.Price==c.Price) //ړ
                        _motions[motion_index++].Move(c, snap_index++, curr_index++, c.Volume-s.Volume);
                    else {
                        bool fadeout = snapshot.AskBid==AskBid.Bid ^ s.Price<c.Price;
                        if(fadeout)
                            _motions[motion_index++].FadeOut(s, snap_index++);
                        else
                            _motions[motion_index++].FadeIn(c, curr_index++);
                    }
                }
            }
            _size = motion_index;
        }
    }



#if UNITTEST
    [TestFixture]
    public class ItaTests {
        private Ita _snapshot;
        private Ita _current;
        private ItaMotion _motion;
        
        public ItaTests() {
            _snapshot = new Ita(3, AskBid.Ask);
            _current = new Ita(3, AskBid.Ask);
            _motion = new ItaMotion(_snapshot.Size);
        }

        private void Prepare() {
            //̔ɉHeXgɂȂ
            _snapshot.SetDirect(2, 110, 1000);
            _snapshot.SetDirect(1, 105, 1000);
            _snapshot.SetDirect(0, 100, 1000);
            _current.Import(_snapshot);
        }

        [Test]
        public void DontMove() {
            Prepare();
            _current.SetDirect(2, 110, 3000);
            _current.SetDirect(1, 105, 2000);
            _current.SetDirect(0, 100, 1000);
            _motion.Create(_snapshot, _current);

            Assert.AreEqual(3, _motion.Size);
            for(int i=0; i<_motion.Size; i++) {
                SashineMotion m = _motion.MotionAt(i);
                Assert.IsTrue(m.Action==SashineAction.Move);
                Assert.AreEqual(100 + i*5, m.Sashine.Price);
                Assert.AreEqual(i, m.SrcIndex);
                Assert.AreEqual(i, m.DestIndex);
                Assert.AreEqual(i*1000, m.Diff);
            }
        }

        [Test]
        public void NormalUp() { //ʏ̏H
            Prepare();
            _current.SetDirect(2, 115, 1000);
            _current.SetDirect(1, 110, 3000);
            _current.SetDirect(0, 105, 2000);
            _motion.Create(_snapshot, _current);
            Assert.AreEqual(4, _motion.Size);

            //100~̔̓tF[hAEg
            SashineMotion m = _motion.MotionAt(0);
            Assert.AreEqual(100, m.Sashine.Price);
            Assert.AreEqual(1000, m.Sashine.Volume);
            Assert.AreEqual(0, m.SrcIndex);
            Assert.IsTrue(m.Action==SashineAction.FadeOut);
            
            //105~͈ړ
            m = _motion.MotionAt(1);
            Assert.IsTrue(m.Action==SashineAction.Move);
            Assert.AreEqual(105, m.Sashine.Price);
            Assert.AreEqual(2000, m.Sashine.Volume);
            Assert.AreEqual(1, m.SrcIndex);
            Assert.AreEqual(0, m.DestIndex);

            //110~ړ
            m = _motion.MotionAt(2);
            Assert.IsTrue(m.Action==SashineAction.Move);
            Assert.AreEqual(110, m.Sashine.Price);
            Assert.AreEqual(3000, m.Sashine.Volume);
            Assert.AreEqual(2, m.SrcIndex);
            Assert.AreEqual(1, m.DestIndex);

            //115~͍~Ă
            m = _motion.MotionAt(3);
            Assert.IsTrue(m.Action==SashineAction.ScrollIn);
            Assert.AreEqual(115, m.Sashine.Price);
            Assert.AreEqual(1000, m.Sashine.Volume);
            Assert.AreEqual(2, m.DestIndex);
        }

        [Test]
        public void NormalDown() { //ʏ̉~
            Prepare();
            _current.SetDirect(2, 105, 1000);
            _current.SetDirect(1, 100, 1000);
            _current.SetDirect(0,  95, 1000);
            _motion.Create(_snapshot, _current);
            Assert.AreEqual(4, _motion.Size);

            //95~̔̓tF[hC
            SashineMotion m = _motion.MotionAt(0);
            Assert.AreEqual(95, m.Sashine.Price);
            Assert.AreEqual(0, m.DestIndex);
            Assert.IsTrue(m.Action==SashineAction.FadeIn);

            //100~͈ړ
            m = _motion.MotionAt(1);
            Assert.IsTrue(m.Action==SashineAction.Move);
            Assert.AreEqual(100, m.Sashine.Price);
            Assert.AreEqual(0, m.SrcIndex);
            Assert.AreEqual(1, m.DestIndex);

            //105~ړ
            m = _motion.MotionAt(2);
            Assert.IsTrue(m.Action==SashineAction.Move);
            Assert.AreEqual(105, m.Sashine.Price);
            Assert.AreEqual(1, m.SrcIndex);
            Assert.AreEqual(2, m.DestIndex);

            //110~̓XN[AEg
            m = _motion.MotionAt(3);
            Assert.IsTrue(m.Action==SashineAction.ScrollOut);
            Assert.AreEqual(110, m.Sashine.Price);
            Assert.AreEqual(2, m.SrcIndex);
        }

        [Test]
        public void TwoUp() { //QԂʂ
            Prepare();
            _current.SetDirect(2, 120, 1000);
            _current.SetDirect(1, 115, 3000);
            _current.SetDirect(0, 110, 2000);
            _motion.Create(_snapshot, _current);
            Assert.AreEqual(5, _motion.Size);

            //100,105~̔̓tF[hAEg
            SashineMotion m = _motion.MotionAt(0);
            Assert.AreEqual(100, m.Sashine.Price);
            Assert.AreEqual(0, m.SrcIndex);
            Assert.IsTrue(m.Action==SashineAction.FadeOut);
            m = _motion.MotionAt(1);
            Assert.AreEqual(105, m.Sashine.Price);
            Assert.AreEqual(1, m.SrcIndex);
            Assert.IsTrue(m.Action==SashineAction.FadeOut);

            //110~͈ړ
            m = _motion.MotionAt(2);
            Assert.IsTrue(m.Action==SashineAction.Move);
            Assert.AreEqual(110, m.Sashine.Price);
            Assert.AreEqual(2000, m.Sashine.Volume);
            Assert.AreEqual(1000, m.Diff);
            Assert.AreEqual(2, m.SrcIndex);
            Assert.AreEqual(0, m.DestIndex);

            //115,120~͍~Ă
            m = _motion.MotionAt(3);
            Assert.IsTrue(m.Action==SashineAction.ScrollIn);
            Assert.AreEqual(115, m.Sashine.Price);
            Assert.AreEqual(3000, m.Sashine.Volume);
            Assert.AreEqual(1, m.DestIndex);
            m = _motion.MotionAt(4);
            Assert.IsTrue(m.Action==SashineAction.ScrollIn);
            Assert.AreEqual(120, m.Sashine.Price);
            Assert.AreEqual(1000, m.Sashine.Volume);
            Assert.AreEqual(2, m.DestIndex);
        }

        [Test]
        public void Insert() { //r}
            Prepare();
            _current.SetDirect(2, 105, 1000);
            _current.SetDirect(1, 102, 3000);
            _current.SetDirect(0, 100, 1000);
            _motion.Create(_snapshot, _current);
            Assert.AreEqual(4, _motion.Size);

            //100~͓
            SashineMotion m = _motion.MotionAt(0);
            Assert.AreEqual(100, m.Sashine.Price);
            Assert.AreEqual(0, m.SrcIndex);
            Assert.IsTrue(m.Action==SashineAction.Move);

            //102~VK
            m = _motion.MotionAt(1);
            Assert.AreEqual(102, m.Sashine.Price);
            Assert.AreEqual(1, m.DestIndex);
            Assert.IsTrue(m.Action==SashineAction.FadeIn);

            //105~͈ړ
            m = _motion.MotionAt(2);
            Assert.AreEqual(105, m.Sashine.Price);
            Assert.AreEqual(1, m.SrcIndex);
            Assert.AreEqual(2, m.DestIndex);
            Assert.IsTrue(m.Action==SashineAction.Move);

            //110~̓XN[AEg
            m = _motion.MotionAt(3);
            Assert.AreEqual(110, m.Sashine.Price);
            Assert.AreEqual(2, m.SrcIndex);
            Assert.IsTrue(m.Action==SashineAction.ScrollOut);
        }

        [Test]
        public void Cancel() { //
            Prepare();
            _current.SetDirect(2, 115, 1000);
            _current.SetDirect(1, 110, 1000);
            _current.SetDirect(0, 100, 1000);
            _motion.Create(_snapshot, _current);
            Assert.AreEqual(4, _motion.Size);

            //100~͓
            SashineMotion m = _motion.MotionAt(0);
            Assert.AreEqual(100, m.Sashine.Price);
            Assert.AreEqual(0, m.SrcIndex);
            Assert.AreEqual(0, m.DestIndex);
            Assert.IsTrue(m.Action==SashineAction.Move);

            //105~
            m = _motion.MotionAt(1);
            Assert.AreEqual(105, m.Sashine.Price);
            Assert.AreEqual(1, m.SrcIndex);
            Assert.IsTrue(m.Action==SashineAction.FadeOut);

            //110~͈ړ
            m = _motion.MotionAt(2);
            Assert.AreEqual(110, m.Sashine.Price);
            Assert.AreEqual(2, m.SrcIndex);
            Assert.AreEqual(1, m.DestIndex);
            Assert.IsTrue(m.Action==SashineAction.Move);

            //115~
            m = _motion.MotionAt(3);
            Assert.AreEqual(115, m.Sashine.Price);
            Assert.AreEqual(2, m.DestIndex);
            Assert.IsTrue(m.Action==SashineAction.ScrollIn);
        }

        [Test]
        public void ChangeAll() { //SƂ
            Prepare();
            _current.SetDirect(2, 210, 1000);
            _current.SetDirect(1, 205, 1000);
            _current.SetDirect(0, 200, 1000);
            _motion.Create(_snapshot, _current);
            Assert.AreEqual(6, _motion.Size);
            for(int i=0; i<3; i++) {
                SashineMotion m = _motion.MotionAt(i);
                Assert.AreEqual(100+i*5, m.Sashine.Price);
                Assert.AreEqual(i, m.SrcIndex);
                Assert.IsTrue(m.Action==SashineAction.FadeOut);
            }
            for(int i=0; i<3; i++) {
                SashineMotion m = _motion.MotionAt(i+3);
                Assert.AreEqual(200+i*5, m.Sashine.Price);
                Assert.AreEqual(i, m.DestIndex);
                Assert.IsTrue(m.Action==SashineAction.ScrollIn);
            }
        }

        [Test]
        public void MovingToStop() { //Xgbv֋߂Â
            Prepare();
            _current.SetDirect(2, 0, 0, false);
            _current.SetDirect(1, 0, 0, false);
            _current.SetDirect(0, 110, 1000);
            _motion.Create(_snapshot, _current);
            Assert.AreEqual(3, _motion.Size);
            
            SashineMotion m = _motion.MotionAt(0);
            Assert.AreEqual(100, m.Sashine.Price);
            Assert.AreEqual(0, m.SrcIndex);
            Assert.IsTrue(m.Action==SashineAction.FadeOut);

            m = _motion.MotionAt(1);
            Assert.AreEqual(105, m.Sashine.Price);
            Assert.AreEqual(1, m.SrcIndex);
            Assert.IsTrue(m.Action==SashineAction.FadeOut);

            m = _motion.MotionAt(2);
            Assert.AreEqual(110, m.Sashine.Price);
            Assert.AreEqual(2, m.SrcIndex);
            Assert.AreEqual(0, m.DestIndex);
            Assert.IsTrue(m.Action==SashineAction.Move);
        }

        [Test]
        public void MovingFromStop() { //Xgbvt߂ʏ
            _snapshot.SetDirect(2, 0, 0, false);
            _snapshot.SetDirect(1, 0, 0, false);
            _snapshot.SetDirect(0, 110, 1000);
            
            _current.SetDirect(2, 110, 1000);
            _current.SetDirect(1, 105, 1000);
            _current.SetDirect(0, 100, 1000);

            _motion.Create(_snapshot, _current);
            Assert.AreEqual(3, _motion.Size);

            SashineMotion m = _motion.MotionAt(0);
            Assert.AreEqual(100, m.Sashine.Price);
            Assert.AreEqual(0, m.DestIndex);
            Assert.IsTrue(m.Action==SashineAction.FadeIn);

            m = _motion.MotionAt(1);
            Assert.AreEqual(105, m.Sashine.Price);
            Assert.AreEqual(1, m.DestIndex);
            Assert.IsTrue(m.Action==SashineAction.FadeIn);

            m = _motion.MotionAt(2);
            Assert.AreEqual(110, m.Sashine.Price);
            Assert.AreEqual(0, m.SrcIndex);
            Assert.AreEqual(2, m.DestIndex);
            Assert.IsTrue(m.Action==SashineAction.Move);

        }

    }
#endif
}
