/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Chart/RealTimeChartSession.cs#21 $
 * $DateTime: 2008/05/14 13:05:12 $
 * 
 * ʖ̃`[gƔA^C\ZbVEhLgEr[
 * 
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Drawing;
using System.Threading;
using System.Windows.Forms;

using Bellagio.Data;
using Bellagio.Values;
using Bellagio.Drawing;
using Bellagio.Forms;
using Bellagio.Environment;

using Travis.LocationOperation;

using Poderosa;
using Poderosa.Forms;
using Poderosa.Preferences;
using Poderosa.Commands;
using Poderosa.Plugins;
using Poderosa.Sessions;

namespace Bellagio.Chart {
    public class RealTimeChartDocument : IntraDayTradeBasedChartDocument, IRealTimeDataSubscriber {
        private SubscribeDataKind _subscribeDataKind;

        public RealTimeChartDocument(int scale) : base(scale) {
            Init(null);
            _subscribeDataKind = SubscribeDataKind.Ticks|SubscribeDataKind.Ita; //Ȃ葽̃P[Xł͔KvɂȂBtH[łTick݂̂ł悢Ƃ̂ŕύX
        }
        public SubscribeDataKind SubscribeDataKind {
            get {
                return _subscribeDataKind;
            }
            set {
                _subscribeDataKind = value;
            }
        }

        public override void SetCurrentStock(Stock stock) {
            if(_stock!=null) BellagioRoot.DataSubscriberManager.RemoveRealTimeSubscriber(this);

            base.SetCurrentStock(stock);
            Init(stock);
        }
        private void Init(Stock stock) {
            _sectionInfo = ChartSectionInfo.Empty;
            if(stock==null) {
                _intraDayTrade = null;
                _realtimeIta = null;
                _documentStatus = BellagioDocumentStatus.Empty;
            } else {
                _documentStatus = BellagioDocumentStatus.Loading;
                //SubscribeRequest̃RXgN^ItaʂŐɂĂ͈̂ӖB
                //̂قɃTuXNCuł鐔Ȃ̂ŁAsȂ瑁߂ɔf悤ɁB
                Debug.Assert(_subscribeDataKind==(SubscribeDataKind.Ticks|SubscribeDataKind.Ita) || _subscribeDataKind==SubscribeDataKind.Ticks);
                BellagioRoot.DataSubscriberManager.AddRealtimeSubscriber(this,
                    _subscribeDataKind==SubscribeDataKind.Ticks? new SubscribeRequest(stock, SubscribeDataKind.Ticks) :
                    new SubscribeRequest(stock, SubscribeDataKind.Ita, SubscribeDataKind.Ticks));
            }
        }
        public override void Dispose() {
            base.Dispose();
            if(_stock!=null) BellagioRoot.DataSubscriberManager.RemoveRealTimeSubscriber(this);
            _documentStatus = BellagioDocumentStatus.Empty;
        }

        void IStockBasedDataSubscriber.SubscribeComplete() {
            Debug.WriteLineIf(BDebugOpts.TRACE_DATA_SUBSCRIBER, "SubscribeComplete");
            _intraDayTrade = BellagioRoot.IntraDayTradeProvider.Lookup(_stock);
            Debug.Assert(_intraDayTrade!=null);
            _realtimeIta = BellagioRoot.ItaProvider.Lookup(_stock);
            _priceRecord = _scale==1? _intraDayTrade.Minutely : QuoteConverter.Shrink(_intraDayTrade.Minutely, _scale);
            _documentStatus = BellagioDocumentStatus.Complete;
            _sectionInfo = ChartSectionInfo.Empty;
        }
        void IStockBasedDataSubscriber.SubscribeFailed(string reason) {
            base.DefaultSubscribeFailed(reason);
        }

        public override void ReloadQuote() {
            if(_stock!=null) {
                IntraDayTrade dt = BellagioRoot.IntraDayTradeProvider.Lookup(_stock);
                if(dt!=null) { //ؒf̓f[^ȂƂ
                    _intraDayTrade = dt;
                    _realtimeIta = BellagioRoot.ItaProvider.Lookup(_stock);
                    _priceRecord = _scale==1? _intraDayTrade.Minutely : QuoteConverter.Shrink(_intraDayTrade.Minutely, _scale);
                }
            }
            _sectionInfo = ChartSectionInfo.Empty;
            base.ReloadQuote();
        }

        #region IDataSubscriber
        public int ThinningTime {
            get {
                return 0;
            }
        }

        public void RealTimeProcess(DataProcessArg arg) {

            //Kvɉđ𑝂₷
            if(_scale > 1) {
                lock(_intraDayTrade) {
                    Quote min = _intraDayTrade.Minutely;
                    while(min.Count >= ((_priceRecord.Count+1)*_scale)) {
                        int i = _priceRecord.Count * _scale;
                        Candle y = new Candle(min.CandleAt(i++));
                        while(i < min.Count)
                            y.Update(min.CandleAt(i++));
                        _priceRecord.Add(y);
                    }
                }
            }

        }
        #endregion

    }

    public class RealTimeChartSessionCreateParam : ChartSessionCreateParamBase {
        private int _scale; //

        public RealTimeChartSessionCreateParam(ChartSchema schema, Stock stock)
            : base(schema, stock) {
        }

        public int Scale {
            get {
                return _scale;
            }
            set {
                _scale = value;
            }
        }

    }

    //`[gƔ̂قAwb_⌻ݒl̂ŕʓr̃CAEg񂪕Kv
    public class RealTimeChartViewSettings : DrawingSettingsBase {
        public DSInt headerHeight; //㕔̃}[W
        public DSInt stockNameLeft; //\ʒu(ύXs)
        public DSFont headerFont; //\tHgʒu(ύXs)
        public DSInt itaWidth; //̕\
        public DSInt priceAreaHeight; //ݒl\
        public DSInt tickHeight; //eBbN̈捂

        public RealTimeChartViewSettings(string id)
            : base(id) {
        }

        protected override void CreateElements() {
            headerFont = DefineFont("headerFont", DSFont.GenericFontName, 11);

            headerHeight = DefinePositiveInt("headerHeight", 28);
            stockNameLeft = DefinePositiveInt("stockNameLeft", 64);
            itaWidth = DefinePositiveInt("itaWidth", 280);
            priceAreaHeight = DefinePositiveInt("priceAreaHeight", 152);
            tickHeight = DefinePositiveInt("tickHeight", 176);
        }

    }


    public class RealTimeChartViewContent : ChartViewContentBase {
        private RealTimeChartSession _session;
        private RealTimeChartViewSettings _viewSettings;

        private ItaGraphics _itaGraphics;
        private CurrentPriceInfoGraphics _priceInfoGraphics;
        private TickGraphics _tickGraphics;
       
        private BRect _chartAreaRect;

        private const int FRAME_MARGIN = 3;
        private int _lastTimeAndSalesCount; //f[^XV邲ƂTimeAndSales̐LBłȂƖGtFNgȂȂ
        private int _lastChartLength;
        private DataChangeTag _itaMotionCount;
        private int _lastTickMotionCount;
        private int _lastOHLMotionCount;
        private int _lastBestBidAskMotionCount;

        //ݒl̕\X^C
        //ZbVŗL̐ݒ肪\Al̓vt@XŌ܂
        private CurrentPriceInfoGraphicsSettings.LayoutStyle _currentPriceLayout;
        private ChartDrawingSettings.LayoutStyle _chartLayout;
        private ItaLayoutParam _itaLayout;
        private TickLayoutParam _tickLayout;

        public RealTimeChartViewContent(RealTimeChartSession session, RealTimeChartDocument doc)
            : base(session, doc) {
            _session = session;
            ChartPreferences cp = BellagioRoot.FixedPreferences.Chart;
            _viewSettings = cp.RealTimeChartViewSettings;

            _priceInfoGraphics = new CurrentPriceInfoGraphics(_container, BellagioPlugin.Instance.SansaPlatform, cp.CurrentPriceInfoGraphicsSettings, CurrentPriceInfoGraphics.LayoutT.Default);
            _chartLayout = cp.ChartDrawingSettings.layoutStyle;
            _currentPriceLayout = cp.CurrentPriceInfoGraphicsSettings.layoutStyle;
            _itaLayout = new ItaLayoutParam(cp.ItaGraphicsSettings);
            _tickLayout = new TickLayoutParam(cp.TickGraphicsSettings);

            _itaGraphics = new ItaGraphics(_container, BellagioPlugin.Instance.SansaPlatform, cp.ItaGraphicsSettings, _itaLayout);
            _tickGraphics = new TickGraphics(_container, BellagioPlugin.Instance.SansaPlatform, cp.TickGraphicsSettings, _tickLayout);

            _chartAreaRect = new BRect();
            BuildRectangleOperator();

            _itaMotionCount = new DataChangeTag();
        }
        public override void Attach(BellagioDefaultControl parent) {
            _rectangleOperator.Rect(parent.ClientRectangle);
            base.Attach(parent);
            _itaGraphics.SetParent(_container);
            _priceInfoGraphics.SetParent(_container);
            _tickGraphics.SetParent(_container);
            if(_session.ChartDocument.DocumentStatus==BellagioDocumentStatus.Complete)
                _chartDrawing.DataUpdateDirect();
        }
        public override void PrepareStockChange() {
            base.PrepareStockChange();
            _lastTimeAndSalesCount = 0;
            _itaMotionCount = new DataChangeTag();
            _lastTickMotionCount = 0;
            _lastOHLMotionCount = 0;
            _lastBestBidAskMotionCount = 0;
            _lastChartLength = 0;
        }
        public override IPoderosaMenuGroup[] CreateContextMenuContent() {
            return new IPoderosaMenuGroup[] {
                new ChartMenuGroups.RealtimeChartSettingsMenuGroup(),
                new ChartMenuGroups.ChartOrderMenuGroup(),
                new ChartMenuGroups.DataSettingMenuGroup(new SetStockCommand(this), false),
                new ChartMenuGroups.ChartUIMenuGroup()
            };
        }
        public override void DocumentEvent() {
            RealTimeChartDocument d = _session.Document;
            if(d.DocumentStatus==BellagioDocumentStatus.Loading) {
                if(d.DocumentStatus==BellagioDocumentStatus.Complete) { //
                    bool future = d.Stock.Profile.IsDerivative;
                    if(_container!=null)
                        _itaGraphics.StartItaMotion(d.RealtimeIta);
                    _itaGraphics.EnableOrderCount = d.Stock.Market==StockExchange.J;
                    _priceInfoGraphics.AnimationTimeSec = future? 0.25 : 0.5; //Pref̂ق̂H
                    if(_container!=null)
                        _priceInfoGraphics.StartMotion(d.IntraDayTrade.CurrentPriceInfo);
                    _priceInfoGraphics.Mode = future? CurrentPriceInfoGraphics.ModeT.Future : CurrentPriceInfoGraphics.ModeT.Stock;
                    if(_container!=null)
                        _tickGraphics.StartMotion(d.IntraDayTrade.TimeAndSales, d.Stock, false);
                }
            }
            base.DocumentEvent();
            if(d.DocumentStatus==BellagioDocumentStatus.Complete) DocumentEventBody();
        }

        protected override void OnStockChanged(object sender, EventArgs args) {

            base.OnStockChanged(sender, args);
        }

        private void DocumentEventBody() {
            try {
                RealTimeChartDocument d = _session.Document;
                if(d.IntraDayTrade==null || _container==null) return; //܂łĂȂ

                TimeAndSales ts = d.IntraDayTrade.TimeAndSales;
                if(ts.Count==0 && ts.Count < _lastTimeAndSalesCount) { //DynamicResetƂɑΉ
                    d.ReloadQuote();
                    _scrollBar.SetValueToMaximum();
                    _chartDrawing.DataUpdateDirect();
                    _lastTimeAndSalesCount = ts.Count;
                    _tickGraphics.StartMotion(d.IntraDayTrade.TimeAndSales, d.Stock, false);

                }

                //`[g̓
                
                if(ts.Count > _lastTimeAndSalesCount) {
                    //TODO TICKƎʒm̕svɂAŐV̈ʒu̒lςindicator̍ČvZKvɂȂP[XB
                    //AIntraDayTrade->ChartDocumentւ̒ʒm@\DataSubscriberoRĂAʒm̊Ԉ@\W}Đmɂǂ̈ʒũLbVNAׂ
                    //킩ȂBȂ̂œʂ͍ŐVP{̒l̂݃NA邱Ƃł̂A
                    //ʂɍXVʒmAPIDataSubscriberŎׂł낤B
                    //͂Ƃ̓hLgłĂARNV铯̖̂߂̃CXbhɈړ
                    d.ClearLastIndicatorValueCache();

                    if(_itaGraphics.DataAnimationTimer.IsActive()) { //^C}[ĂȂ犄荞݂ŃGtFNg
                        RealtimeIta ita = BellagioRoot.ItaProvider.Lookup(d.Stock);
                        ita.SetupPriceEffect(ts.LastPrice);
                        //IuWFNgƂĈvĂ邱
                        Debug.Assert(Object.ReferenceEquals(ita.AskMotion, _itaGraphics.AskMotion));
                    }

                    _chartDrawing.BeginDataUpdate();
                    ChartScaleInfo.PriceMoveEffectT me = _chartDrawing.ChartScaleInfo.PriceMoveEffect;
                    if(BellagioRoot.FixedPreferences.Chart.EnableChartAnimation) {
                        me.available = true;
                        TickData ltd = ts.LastTick; //NOTE ̊֌WCount>0łLastTick==null̃P[X݂
                        me.lastPrice = ltd!=null? ltd.Price : 0;
                        me.semiLastPrice = ts.Count>=2? ts.TickAt(ts.Count-2).Price : me.lastPrice; //PȂΓ̒lg
                        me.isUptick = ts.PreDifferentPrice < ts.LastPrice;
                    }
                    else
                        me.available = false;

                    _lastTimeAndSalesCount = ts.Count;
              
                    _chartDrawing.EndDataUpdate();

                    _tickGraphics.StartMotion(d.IntraDayTrade.TimeAndSales, d.Stock, true);
                }

                int chart_len = d.SectionInfo.GetDisplayLength();
                if(_lastChartLength != chart_len) {
                    //int di = _chartDrawing.DisplayPosition.IsEmpty? -1 : _chartDrawing.DisplayPosition.ToDisplayIndex();
                    _scrollBar.SetRange(_chartDrawing.GetMaxCandleCount(), chart_len);
                    _lastChartLength = chart_len;
                }

                //̓
                RealtimeIta ri = d.RealtimeIta;
                if(!_itaMotionCount.Equals(ri.DataChangeTag)) {
                    _itaGraphics.StartItaMotion(ri);
                    _itaMotionCount.Let(ri.DataChangeTag);
                }

                //ݒl̓
                //TODO Aj[V^C}[Tick/OHL/BestBidAskŋʂȂ̂ŁA_priceInfoGraphics.StartMotionSɌĂԂƑ̃Aj[VLZĂ܂B
                //TICK݂̂ŃAj[VAȊOInvalidateōς܂BƎɃ^C}[悤ɂł΂Ȃ悵
                CurrentPriceInfo pi = d.IntraDayTrade.CurrentPriceInfo;
                if(_lastTickMotionCount!=pi.TickMotionCount) {
                    //Debug.WriteLine(String.Format("CurrentPrice STARTMOTION pr={0}", pi.CurrentPrice.Move.ToString()));
                    _priceInfoGraphics.StartMotion(pi);
                    _lastTickMotionCount = pi.TickMotionCount;
                }
                //OHL
                if(_lastOHLMotionCount!=pi.OHLMotionCount) {
                    _lastOHLMotionCount = pi.OHLMotionCount;
                }
                //BestBidAsk
                if(_lastBestBidAskMotionCount!=pi.BestBidAskMotionCount) {
                    _lastBestBidAskMotionCount = pi.BestBidAskMotionCount;
                }

                _container.Invalidate();
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }
        public override void OnPaint(PaintEventArgs args) {
            try {
                if(base.PaintIncompleteCases(args)) return;
                Graphics g = args.Graphics;
                
                //eg
                Pen p = new Pen(BellagioRoot.FixedPreferences.Chart.CurrentPriceInfoGraphicsSettings.borderColor.col, 2);
                g.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.HighQuality;
                Rectangle r = _priceInfoGraphics.Bound.Value;
                if(!r.IsEmpty)
                    RoundRectUtil.Draw(g, p, r, 5);
                r = _itaGraphics.Bound.Value;
                if(!r.IsEmpty)
                    RoundRectUtil.Draw(g, p, r, 5);
                r = _tickGraphics.Bound.Value;
                if(!r.IsEmpty)
                    RoundRectUtil.Draw(g, p, r, 5);
                g.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.Default;
                p.Dispose();

                Rectangle clip = args.ClipRectangle;
                _priceInfoGraphics.Paint(g, clip);
                _itaGraphics.Paint(g, clip);
                _tickGraphics.Paint(g, clip);

                if(_chartLayout!=ChartDrawingSettings.LayoutStyle.None) {
                    _chartDrawing.Paint(g, clip);
                    base.PaintFreeLines(g, clip);
                }

                float additional_text_y = _codeInputBox.Bottom+2;
                if(_omittedItemInfoText!=null) {
                    g.DrawString(_omittedItemInfoText, _chartDrawing.ChartDrawingSettings.stockInfoFont.F, _chartDrawing.ChartDrawingSettings.warningColor.B, _codeInputBox.Left, additional_text_y);
                    additional_text_y += 10;
                }
                IntraDayTradeWarnings dtw = _session.Document.IntraDayTrade.WarningStatus;
                if(dtw!=IntraDayTradeWarnings.None) {
                    if(dtw==IntraDayTradeWarnings.TickSpilled)
                        g.DrawString("TICK̈ꕔ擾ł܂łBʂׂĕĂĕ\ĂB", _chartDrawing.ChartDrawingSettings.stockInfoFont.F, _chartDrawing.ChartDrawingSettings.warningColor.B, _codeInputBox.Left, additional_text_y);
                }
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }
        public override void Dispose() {
            base.Dispose();
            _itaGraphics.Dispose();
            _priceInfoGraphics.Dispose();
            _tickGraphics.Dispose();
        }
        public override void DoLayout() {
            BuildRectangleOperator();
            AdjustToLatest();
        }
        public override void ManualResize() {
            base.ManualResize();

            RealTimeChartDocument d = _session.Document;

            if(d.IntraDayTrade!=null && _container!=null) {
                IntraDayTrade dt = d.IntraDayTrade;
                if(!_tickGraphics.Bound.IsEmpty)
                    _tickGraphics.StartMotion(dt.TimeAndSales, dt.Stock, false); //TCYɌĉScaleςȂƂȂB͂ƉPƂ
                //if(!_itaGraphics.Bound.IsEmpty)
                //    _itaGraphics.StartItaMotion(BellagioRoot.ItaProvider.GetActive(dt.Stock));
                if(_currentPriceLayout!=CurrentPriceInfoGraphicsSettings.LayoutStyle.None)
                    _priceInfoGraphics.StartMotion(dt.CurrentPriceInfo);
            }

        }

        private void BuildRectangleOperator() {

            ItaGraphicsSettings ig = BellagioRoot.FixedPreferences.Chart.ItaGraphicsSettings;
            int ita_height = ig.pitch.V * 11 + ig.margin.V * 2; //㉺T{10{ƃwb_pP{ő̍

            bool chart_visible = _chartLayout!=ChartDrawingSettings.LayoutStyle.None;
            bool infozone_visible = _currentPriceLayout!=CurrentPriceInfoGraphicsSettings.LayoutStyle.None ||
                _itaLayout.LayoutStyle!=ItaGraphicsSettings.LayoutStyle.None ||
                _tickLayout.LayoutStyle!=TickGraphicsSettings.LayoutStyle.None;
            RectOp.RuntimeInt info = delegate() { return infozone_visible? _viewSettings.itaWidth.V : 0; };
            RectOp.RuntimeInt info_min = delegate() { return infozone_visible? _viewSettings.itaWidth.V*2 : 0; };

            RectangleOperatorBuilder bld = new RectangleOperatorBuilder()
                .Cut(SplitDir.Bottom, _scrollBar.AsControl.Height)
                .Cut(SplitDir.Top, _viewSettings.headerHeight.V)
                .SplitFixed(chart_visible? SplitDir.Right : SplitDir.Left, info, chart_visible? info_min : info)
                    .SplitFixed(SplitDir.Top, delegate() { return _currentPriceLayout!=CurrentPriceInfoGraphicsSettings.LayoutStyle.None? _viewSettings.priceAreaHeight.V+10 : 0; })
                        .Shrink(5).Append(_priceInfoGraphics.RectOp)
                    .CloseBranch()
                    .SplitFixed(SplitDir.Top, delegate() { return _itaLayout.LayoutStyle!=ItaGraphicsSettings.LayoutStyle.None? ita_height+10 : 0; })
                        .Shrink(5).Append(_itaGraphics.RectOp)
                    .CloseBranch()
                    .SplitFixed(SplitDir.Top, delegate() { return _tickLayout.LayoutStyle!=TickGraphicsSettings.LayoutStyle.None? _viewSettings.tickHeight.V+10 : 0; })
                        .Shrink(5).Append(_tickGraphics.RectOp)
                    .CloseBranch()
                .CloseBranch();

            if(chart_visible)
                bld.Append(_chartDrawing.RectOp);
            else
                bld.CornerOffset(RectCorner.TopLeft, 0, 0, 0, 0).Append(_chartDrawing.RectOp);

            _rectangleOperator = bld.Finish();

            //Debug.WriteLine("BROp Ita="+ (_itaLayout.LayoutStyle!=ItaGraphicsSettings.LayoutStyle.None));
        }

        public override void GetOmittedScreenItemList(ref List<string> list) {
            if(_chartLayout!=ChartDrawingSettings.LayoutStyle.None)
                base.GetOmittedScreenItemList(ref list); //܂X}[głȂANXł̓`[g̗vfĂȂƂŒmĂ

            if(_currentPriceLayout!=CurrentPriceInfoGraphicsSettings.LayoutStyle.None && _priceInfoGraphics.Bound.IsEmpty) {
                if(list==null) list = new List<string>();
                list.Add("ݒl");
            }
            if(_itaLayout.LayoutStyle!=ItaGraphicsSettings.LayoutStyle.None && _itaGraphics.Bound.IsEmpty) {
                if(list==null) list = new List<string>();
                list.Add("");
            }
            if(_tickLayout.LayoutStyle!=TickGraphicsSettings.LayoutStyle.None && _tickGraphics.Bound.IsEmpty) {
                if(list==null) list = new List<string>();
                list.Add("TICK");
            }
        }

        public CurrentPriceInfoGraphicsSettings.LayoutStyle CurrentPriceLayout {
            get {
                return _currentPriceLayout;
            }
            set {
                _currentPriceLayout = value;
            }
        }
        public ChartDrawingSettings.LayoutStyle ChartLayout {
            get {
                return _chartLayout;
            }
            set {
                _chartLayout = value;
            }
        }
        public ItaLayoutParam ItaLayout {
            get {
                return _itaLayout;
            }
        }
        public TickLayoutParam TickLayout {
            get {
                return _tickLayout;
            }
        }

    }

    public class RealTimeChartSession : ChartSessionBase {
        private RealTimeChartViewContent _content;
        private RealTimeChartDocument _document;
        private int _minuteScale; //
        
        public RealTimeChartSession(RealTimeChartSessionCreateParam p) {
            _minuteScale = p.Scale;

            Stock s = p.Stock;
            
            _document = new RealTimeChartDocument(p.Scale);
            
            ChartSchema schema = p.Schema;
            CreateDocument(_document, schema);
            AdjustCaption(s);

            _content = new RealTimeChartViewContent(this, _document);

            base.Init(_document, _content, p.Schema.FullID);

            SetCurrentStock(s);
        }
        public override void SetCurrentStock(Stock stock) {
            if(!BellagioRoot.DataSourceHost.IsConnected) {
                BUtil.ShowWarningMessageBox("zMɐڑĂȂߖ̎w肪ł܂");
                SubscribeFailed();
                return;
            }

            AdjustCaption(stock);
            base.SetCurrentStock(stock);
        }
        protected override void SubscribeFailed() {
            AdjustCaption(null);
            _content.ResetCodeInputBox(_document.Stock);
            base.SubscribeFailed();
        }
        public override ChartSchema GetSourceSchema() {
            return BellagioRoot.SchemaRoot.FindRealTimeChartSchema(_sourceSchemaName);
        }
        public override void ReloadSchema(string schema_name, Stock stock) {
            //A^C`[g͓ZbVɉeô͕s
            //܂SubscriberS[hXe[^Xւ̈ڍsAf[^\[Xł̐ؒfmFAēxSubscribeJnAƂ
            List<IStockBasedDataSubscriber> subscribers = new List<IStockBasedDataSubscriber>();
            foreach(ISession sess in BellagioPlugin.Instance.SessionManager.AllSessions) {
                RealTimeChartSession rs = sess as RealTimeChartSession;
                if(rs!=null && rs.CurrentStock==stock) {
                    rs.SuspendStock();
                    IStockBasedDataSubscriber subscr = rs.Document;
                    subscribers.Add(subscr);
                    BellagioRoot.DataSubscriberManager.RemoveRealTimeSubscriber((IRealTimeDataSubscriber)subscr);
                }
            }

            if(_sourceSchemaName!=schema_name) {
                ChartSchema sc = BellagioRoot.SchemaRoot.FindStaticChartSchema(schema_name);
                if(sc==null) return; //ȂȂĂ̂܂܃^[
                _document = new RealTimeChartDocument(sc.ChartScale);
                CreateDocument(_document, sc);
                _content.ReplaceDocument(_document);
                ReplaceDocument(_document);
            }

            if(stock!=null) {
                foreach(IStockBasedDataSubscriber subscr in subscribers)
                    BellagioRoot.DataSubscriberManager.AddRealtimeSubscriber((IRealTimeDataSubscriber)subscr, new SubscribeRequest(stock, SubscribeDataKind.Ticks, SubscribeDataKind.Ita));
            }
        }


        private void AdjustCaption(Stock stock) {

            if(stock==null)
                _caption = _document.SourceSchema.description.ParseMandatoryString();
            else
                _caption = String.Format("{0} - {1}", _document.SourceSchema.description.ParseMandatoryString(), stock.Profile.Name);
        }


        public RealTimeChartDocument Document {
            get {
                return _document;
            }
        }
        public RealTimeChartViewContent ViewContent {
            get {
                return _content;
            }
        }
        #region ISession

        public override void InternalStart(ISessionHost host) {
            base.InternalStart(host);

            //f[^\[Xڑ
            //BellagioRoot.DataSubscriberManager.AddSubscriber(_document);
            //BellagioRoot.PrimaryDataSource.Connect(_document.CurrentStock);
        }

        public override void InternalTerminate() {
            //f[^\[Xؒf
            //BellagioRoot.PrimaryDataSource.Close(_document.CurrentStock);
            //BellagioRoot.DataSubscriberManager.RemoveSubscriber(_document);

            base.InternalTerminate();
        }


        #endregion

    }

}
