/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Chart/ChartPreference.cs#4 $
 * $DateTime: 2008/02/19 10:04:20 $
 * 
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Diagnostics;

using Poderosa;
using Poderosa.Plugins;
using Poderosa.Preferences;

using Bellagio.Environment;
using Bellagio.Data;

namespace Bellagio.Chart {
    //}EXzC[ŉ邩  EnumScreeningIvVɂ
    public enum MouseWheelAction {
        SwitchStock, //ړ
        Scroll,   //ʃXN[
    }
    public enum UpDownKeyAction {
        SwitchTab,
        SwitchStock
    }

    //{̓}i[ᔽAFixedPreferences璼ڎQƂ`ɂȂ
    public class ChartPreferences : PreferenceSupplierImpl, IPreferenceChangeListener {
        private IBoolPreferenceItem _reflectSplit; //𔽉f邩ǂ
        private IIntPreferenceItem _concatinateFutureCount; //̐敨}[WĘAł邩
        private IIntPreferenceItem _candleCountBetweenSections; //x݂ɃE\N{̃Xy[X󂯂邩
        private IBoolPreferenceItem _enableChartAnimation; //`[g̃Aj[VL
        private IBoolPreferenceItem _enableItaDiff; //̍\L
        private IBoolPreferenceItem _enablePriceInfoAnimation; //ݒl\̃Aj[VL
        private IBoolPreferenceItem _enableFigureBoardAnimation; //EHb`Xg̃Aj[VL

        private EnumPreferenceItem<EveningSessionAware> _eveningSessionAware;
        private EnumPreferenceItem<MouseWheelAction> _mouseWheelOnChart;
        private EnumPreferenceItem<UpDownKeyAction> _upDownKeyAction;

        //FreeLine
        private DynamicPreference _userOperation;

        //GraphicSettings
        private ItaGraphicsSettings _itaGraphicsSettings;
        private ChartDrawingSettings _chartDrawingSettings;
        private IndicatorFigureDrawingSettings _indicatorFigureDrawingSettings;
        private MultipleIndicatorEditorSettings _multipleIndicatorEditorSettings;
        private RealTimeChartViewSettings _realtimeChartViewSettings;
        private StaticChartViewSettings _staticChartViewSettings;
        private CurrentPriceInfoGraphicsSettings _currentPriceInfoGraphicsSettings;
        private TickGraphicsSettings _tickGraphicsSettings;

        public ChartPreferences()
            : base("tactico.chart") {
        }

        public void RegisterExtension(IExtensionPoint pt) {
            pt.RegisterExtension(this);

            _userOperation = new DynamicPreference("tactico.userOperation");
            pt.RegisterExtension(_userOperation);

            _chartDrawingSettings = new ChartDrawingSettings("tactico.chartDrawing");
            _itaGraphicsSettings = new ItaGraphicsSettings("tactico.itaDrawing");
            _indicatorFigureDrawingSettings = new IndicatorFigureDrawingSettings("tactico.indicatorFigure");
            _multipleIndicatorEditorSettings = new MultipleIndicatorEditorSettings("tactico.multiIndicatorEditor");
            _realtimeChartViewSettings = new RealTimeChartViewSettings("tactico.realtimeChartView");
            _staticChartViewSettings = new StaticChartViewSettings("tactico.staticChartView");
            _currentPriceInfoGraphicsSettings = new CurrentPriceInfoGraphicsSettings("tactico.currentPriceInfoDrawing");
            _tickGraphicsSettings = new TickGraphicsSettings("tactico.tickDrawing");

            pt.RegisterExtension(_chartDrawingSettings);
            pt.RegisterExtension(_itaGraphicsSettings);
            pt.RegisterExtension(_indicatorFigureDrawingSettings);
            pt.RegisterExtension(_multipleIndicatorEditorSettings);
            pt.RegisterExtension(_realtimeChartViewSettings);
            pt.RegisterExtension(_staticChartViewSettings);
            pt.RegisterExtension(_currentPriceInfoGraphicsSettings);
            pt.RegisterExtension(_tickGraphicsSettings);
        }

        public override void InitializePreference(IPreferenceBuilder builder, IPreferenceFolder folder) {
            folder.AddChangeListener(this); //ɂChartDrawing, ItaDrawingɂAddChangeListenerĂ

            _reflectSplit = builder.DefineBoolValue(folder, "reflectSplit", true, null);
            _concatinateFutureCount = builder.DefineIntValue(folder, "concatinateFutureCount", 4, null);
            _candleCountBetweenSections = builder.DefineIntValue(folder, "candleCountBetweenSections", 5, null);
            _eveningSessionAware = new EnumPreferenceItem<EveningSessionAware>(builder.DefineStringValue(folder, "eveningSessionAware", "Default", null), EveningSessionAware.Default);
            _enableChartAnimation = builder.DefineBoolValue(folder, "enableChartAnimation", true, null);
            _enableItaDiff = builder.DefineBoolValue(folder, "enableItaDiff", true, null);
            _enablePriceInfoAnimation = builder.DefineBoolValue(folder, "enablePriceInfoAnimation", true, null);
            _enableFigureBoardAnimation = builder.DefineBoolValue(folder, "enableFigureBoardAnimation", true, null);
            _mouseWheelOnChart = new EnumPreferenceItem<MouseWheelAction>(builder.DefineStringValue(folder, "mouseWheelOnChart", "SwitchStock", null), MouseWheelAction.SwitchStock);
            _upDownKeyAction = new EnumPreferenceItem<UpDownKeyAction>(builder.DefineStringValue(folder, "upDownKeyAction", "SwitchTab", null), UpDownKeyAction.SwitchTab);
        }
        public void OnPreferenceImport(IPreferenceFolder oldvalues, IPreferenceFolder newvalues) {
        }

        //KKvȍڂύXꂽƂ͌ȂAxReloadPreferenceŝ邽ߑ\FixedPreferenceʒm󂯂
        public void OnPreferenceImportFinish() {
           ReloadPreference();
        }

        public DynamicPreference UserOperation {
            get {
                return _userOperation;
            }
        }

        public SplitReflection ReflectSplit {
            get {
                return _reflectSplit.Value? SplitReflection.Reflected : SplitReflection.NotRefrected;
            }
            set {
                _reflectSplit.Value = value==SplitReflection.Reflected;
            }
        }

        public int ConcatinateFutureCount {
            get {
                return _concatinateFutureCount.Value;
            }
            set {
                _concatinateFutureCount.Value = value;
            }
        }

        public int CandleCountBetweenSections {
            get {
                return _candleCountBetweenSections.Value;
            }
            set {
                _candleCountBetweenSections.Value = value;
            }
        }

        public EveningSessionAware EveningSessionAware {
            get {
                return _eveningSessionAware.Value;
            }
            set {
                _eveningSessionAware.Value = value;
            }
        }
        public IStringPreferenceItem EveningSessionAwareItem {
            get {
                return _eveningSessionAware.PreferenceItem;
            }
        }
        public MouseWheelAction MouseWheelOnChart {
            get {
                return _mouseWheelOnChart.Value;
            }
        }
        public IStringPreferenceItem MouseWheelOnChartItem {
            get {
                return _mouseWheelOnChart.PreferenceItem;
            }
        }
        public UpDownKeyAction UpDownKeyAction {
            get {
                return _upDownKeyAction.Value;
            }
        }
        public IStringPreferenceItem UpDownKeyActionItem {
            get {
                return _upDownKeyAction.PreferenceItem;
            }
        }
        public bool EnableChartAnimation {
            get {
                return _enableChartAnimation.Value;
            }
            set {
                _enableChartAnimation.Value = value;
            }
        }
        public IBoolPreferenceItem EnableChartAnimationItem {
            get {
                return _enableChartAnimation;
            }
        }
        public bool EnableItaDiff {
            get {
                return _enableItaDiff.Value;
            }
            set {
                _enableItaDiff.Value = value;
            }
        }
        public IBoolPreferenceItem EnableItaDiffItem {
            get {
                return _enableItaDiff;
            }
        }
        public bool EnablePriceInfoAnimation {
            get {
                return _enablePriceInfoAnimation.Value;
            }
            set {
                _enablePriceInfoAnimation.Value = value;
            }
        }
        public IBoolPreferenceItem EnablePriceInfoAnimationItem {
            get {
                return _enablePriceInfoAnimation;
            }
        }
        public bool EnableFigureBoardAnimation {
            get {
                return _enableFigureBoardAnimation.Value;
            }
            set {
                _enableFigureBoardAnimation.Value = value;
            }
        }
        public IBoolPreferenceItem EnableFigureBoardAnimationItem {
            get {
                return _enableFigureBoardAnimation;
            }
        }

        public ItaGraphicsSettings ItaGraphicsSettings {
            get {
                return _itaGraphicsSettings;
            }
        }
        public ChartDrawingSettings ChartDrawingSettings {
            get {
                return _chartDrawingSettings;
            }
        }
        public IndicatorFigureDrawingSettings IndicatorFigureDrawingSettings {
            get {
                return _indicatorFigureDrawingSettings;
            }
        }
        public MultipleIndicatorEditorSettings MultipleIndicatorEditorSettings {
            get {
                return _multipleIndicatorEditorSettings;
            }
        }
        public RealTimeChartViewSettings RealTimeChartViewSettings {
            get {
                return _realtimeChartViewSettings;
            }
        }
        public StaticChartViewSettings StaticChartViewSettings {
            get {
                return _staticChartViewSettings;
            }
        }
        public CurrentPriceInfoGraphicsSettings CurrentPriceInfoGraphicsSettings {
            get {
                return _currentPriceInfoGraphicsSettings;
            }
        }
        public TickGraphicsSettings TickGraphicsSettings {
            get {
                return _tickGraphicsSettings;
            }
        }


        public void Dispose() {
            _itaGraphicsSettings.Dispose();
            _chartDrawingSettings.Dispose();
            _indicatorFigureDrawingSettings.Dispose();
            _multipleIndicatorEditorSettings.Dispose();
            _realtimeChartViewSettings.Dispose();
            _staticChartViewSettings.Dispose();
            _currentPriceInfoGraphicsSettings.Dispose();
        }


        public void ReloadPreference() {
            ChartPreferenceUpdateInfo info = new ChartPreferenceUpdateInfo();
            info.UpdatedAllSchema = true;
            info.UpdatedAllIndicators = true;

            BellagioPlugin.Instance.Commands.ReloadPreference.InternalExecute(null, info);
        }

    }
}
