/*
 * Copyright 2004,2006 The Poderosa Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * $Id: PluginEx.cs,v 1.12 2006/08/23 06:45:16 dan-iwasaki Exp $
 */
using System;
using System.Collections.Generic;

namespace Poderosa.Plugins {

    /// <summary>
    /// <ja>
    /// vOC̑ݒ肵܂B
    /// </ja>
    /// <en>
    /// Set the attribute of the plug-in
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// ׂẴvOĆAPluginInfoAttributeȂ΂Ȃ܂B
    /// </ja>
    /// <en>
    /// All plug-ins must have the PluginInfoAttribute attribute.
    /// </en>
    /// </remarks>
	[AttributeUsage(AttributeTargets.Class, Inherited=false, AllowMultiple=false)]
	public class PluginInfoAttribute : Attribute {
        /// <summary>
        /// <ja>vOC̎ʎqƂȂuvOCIDvłBK{łB</ja>
        /// <en>REQUIRED:Plug-in that identifies the plug-in.</en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// ׂẴvOCŗBꖳ̂̂w肷Kv܂B
        /// ʎq́AJavãpbP[WWɏŎʂ܂B
        /// J҂ۗLhCȂ΁AɊÂăvOCID߂ĂiƂ΁Aujp.co.example.CӖvȂǁj B
        /// PoderosaW̃vOCIDł́Auorg.poderosavgĂ܂BJ҂Ǝ̃vOC쐬ۂɂ́Auorg.poderosavȉIDltĂ͂܂Buorg.poderosavȉIDltꍇɂ́APoderosaJ҃R~jeBł̏Fv܂B 
        /// </ja>
        /// <en>
        /// It is necessary to specify the unique one by all plug-ins. 
        /// The identifier is identified by the method based on the package standard of Java. 
        /// Please provide plug-in ID based on it if there is a domain name that the developer has (for instance, "jp.co.example.foo" etc.). 
        ///In the ID attribute of the plug-in of the Poderosa standard, "org.poderosa" is used.
        /// Do not set ID following "org.poderosa" when the developer makes an original plug-in. "org.poderosa"
        /// When ID is set, approval in the Poderosa developer community is required. 
        /// </en>
        /// </remarks>
		public string ID;
        /// <summary>
        /// <ja>vOĈ̖ł</ja>
        /// <en>Name of the plug-in.</en>
        /// </summary>
		public string Name;
        /// <summary>
        /// <ja>ˑ鑼̃vOC̃vOCIDłB</ja>
        /// <en>The plug-in ID that depends other plug-ins. </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// ˑ鑼̃vOCꍇɂ́ÃvOCIDZ~Ri;jŋ؂ė񋓂܂B
        /// ŗ񋓂vOCɓǂݍ܂邱Ƃۏ؂܂B
        /// </ja>
        /// <en>
        /// When other depending plug-ins exist, the plug-in ID is delimited by semicolon (;) and enumerated. 
        /// It is guaranteed to be read from the plug-in enumerated here back. 
        /// </en>
        /// </remarks>
		public string Dependencies;
        /// <summary>
        /// <ja>vOC̃o[WԍłB</ja>
        /// <en>Version number of the plug-in.</en>
        /// </summary>
		public string Version;
        /// <summary>
        /// <ja>vOC̒ҏł</ja>
        /// <en>Copyright information of the plug-in.</en>
        /// </summary>
        public string Author;
	}

    /// <summary>
    /// <ja>
    /// vOC\AZuׂłB
    /// </ja>
    /// <en>
    /// It is an attribute that the assembly that composes the plug-in should have. 
    /// </en>
    /// </summary>
    [AttributeUsage(AttributeTargets.Assembly, AllowMultiple=true)]
    public class PluginDeclarationAttribute : Attribute {
        /// <summary>
        /// <ja>̃AZuɊ܂܂vOC̃NX`܂B</ja>
        /// <en>
        /// Define the class of the plug-in included in this assembly.
        /// </en>
        /// </summary>
        /// <param name="type"><ja>vOC̃NXł</ja>
        /// <en>
        /// Class of plug-in.
        /// </en>
        /// </param>
        /// <remarks>
        /// <ja>
        /// Poderosa<var>type</var>Ɏw肳ꂽNX̃CX^XAInitializePlugin\bhĂяoƂŃvOCA\ȏԂɂ܂B
        /// </ja>
        /// <en>
        /// The plug-in is initialized by making the instance of the class specified for type, 
        /// and calling the InitializePlugin method, and Poderosa is put into the state that can be operated. 
        /// </en>
        /// </remarks>
        public PluginDeclarationAttribute(Type type) {
            Target = type;
        }
        /// <summary>
        /// <ja>vOC\NXłB</ja>
        /// <en>Class that composes plug-in</en>
        /// </summary>
        public Type Target;
    }

    /// <summary>
    /// <ja>
    /// ׂẴvOCȂ΂ȂȂC^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface that all plug-ins should implement
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// J҂́AIPluginC^[tFCXɁA<seealso cref="PluginBase">PluginBaseNX</seealso>
    /// pNXƂč쐬邱Ƃł܂B
    /// </ja>
    /// <en>
    /// The developer can make it as a class that inheritances to from the 
    /// <seealso cref="PluginBase">PluginBase class</seealso> instead of implementing the IPlugin interface. 
    /// </en>
    /// </remarks>
	public interface IPlugin : IAdaptable {
        /// <summary>
        /// <ja>
        /// vOCۂɌĂяo郁\bhłB
        /// </ja>
        /// <en>
        /// Method of call when plug-in is initialized
        /// </en>
        /// </summary>
        /// <param name="poderosa">
        /// <ja>
        /// Poderosa{̂ƒʐM邽߂IPoderosaWorldC^[tFCXłB
        /// </ja>
        /// <en>
        /// IPoderosaWorld interface to communicate with Poderosa
        /// </en>
        /// </param>
        /// <remarks>
        /// <ja>
        /// ̃\bh́APoderosa{̂ɂăvOCǂݍ܂ꂽɌĂяo܂B<br/>
        /// nIPoderosaWorldC^[tFCX̓vOC܂ŕsςłB<br/>
        /// vOCJ҂́Ã\bhŃvOC̏邱ƂɂȂ܂B
        /// </ja>
        /// <en>
        /// This method is called immediately after the plug-in was read by Poderosa. 
        /// The IPoderosaWorld interface handed over is invariable until the plug-in is relesed.
        /// The developer will do the initialization of the plug-in in this method. 
        /// </en>
        /// </remarks>
		void InitializePlugin(IPoderosaWorld poderosa);
        /// <summary>
        /// <ja>
        /// vOC钼OɌĂяo郁\bhłB
        /// </ja>
        /// <en>
        /// Method of call immediately before plug-in is released.
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// vOCJ҂́Ã\bhŃvOČ㏈ĂB
        /// </ja>
        /// <en>
        /// The developer must postprocess the plug-in in this method. 
        /// </en>
        /// </remarks>
		void TerminatePlugin();
	}

    /// <summary>
    /// <ja>
    /// vOC𓝊ǗuvOC}l[WṽC^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface of "Plug-in manager" that manages generalization as for the plug-in. 
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// IPluginManageŕA<seealso cref="IPoderosaWorld">IPoderosaWorld</seealso><see cref="IPoderosaWorld.PluginManager">PluginManagervpeB</see>擾ł܂B
    /// </ja>
    /// <en>
    /// IPluginManager can be acquired from the <see cref="IPoderosaWorld.PluginManager">PluginManager property</see> of 
    /// <seealso cref="IPoderosaWorld">IPoderosaWorld</seealso>. 
    /// </en>
    /// </remarks>
    public interface IPluginManager : IAdaptable {
        //Plugins
        /// <summary>
        /// <ja>vOC܂B</ja>
        /// <en>Retrieval of the plug-in.</en>
        /// </summary>
        /// <param name="id">
        /// <ja>vOCIDłB
        /// </ja>
        /// <en>Retrieved plug-in ID
        /// </en>
        /// </param>
        /// <param name="adapter">
        /// <ja>
        /// 擾vOC̃C^[tFCX̌^łB
        /// </ja>
        /// <en>
        /// Type in interface of acquired plug-in.
        /// </en>
        /// </param>
        /// <returns>
        /// <ja>
        /// vOC̃C^[tFCXԂ܂BỸvOCȂꍇɂ́Anull߂܂B
        /// </ja>
        /// <en>
        /// The interface of the found plug-in is returned. Null returns when the plug-in of the correspondence is not found. 
        /// </en>
        /// </returns>
        object FindPlugin(string id, Type adapter);
        //Extension Points
        /// <summary>
        /// <ja>
        /// g|Cg쐬܂B
        /// </ja>
        /// <en>
        /// Making of the extension point.
        /// </en>
        /// </summary>
        /// <param name="id">
        /// <ja>
        /// 쐬g|Cǵug|CgIDvłB
        /// </ja>
        /// <en>
        /// Extension point ID of made extension point
        /// </en>
        /// </param>
        /// <param name="requiredInterface">
        /// <ja>
        /// g|CgvC^[tFCXłB
        /// </ja>
        /// <en>
        /// Interface that extension point demands.
        /// </en>
        /// </param>
        /// <param name="owner">
        /// <ja>
        /// g|Cg̏L҂ƂȂvOC̃IuWFNgłB̏ꍇAuthisvn܂B
        /// </ja>
        /// <en>
        /// It is an object of the plug-in that becomes the owner of the extension point.
        /// In many cases, "this" is passed. 
        /// </en>
        /// </param>
        /// <returns>
        /// <ja>
        /// Ɋg|Cg쐬ꂽꍇA쐬ꂽg|CgIExtensionPointC^[tFCX߂܂B
        /// g|Cg̍쐬Ɏsꍇɂ́Anull߂܂B
        /// </ja>
        /// <en>
        /// The IExtensionPoint interface of the made extension point returns when the extension point is normally made. 
        /// Null returns when failing in making the extension point. 
        /// </en>
        /// </returns>
        IExtensionPoint CreateExtensionPoint(string id, Type requiredInterface, IPlugin owner);
        /// <summary>
        /// <ja>
        /// g|Cg܂B
        /// </ja>
        /// <en>
        /// Retrieval of the extension point.
        /// </en>
        /// </summary>
        /// <param name="id">
        /// <ja>
        /// g|CgIDłB
        /// </ja>
        /// <en>
        /// Retrieved extension point ID
        /// </en>
        /// </param>
        /// <returns>
        /// <ja>
        /// Y̊g|Cgꍇɂ́AIExtensionPointC^[tFCX߂܂B
        /// g|CgȂꍇɂ́Anull߂܂B
        /// </ja>
        /// <en>
        /// The IExtensionPoint interface returns when the extension point of the correspondence is found. 
        /// Null returns when the enhancing point is not found. 
        /// </en>
        /// </returns>
        IExtensionPoint FindExtensionPoint(string id);

        //Nߒɂē̃vOC𖳌
        void DisablePlugin(string[] id);
    }

    /// <summary>
    /// <ja>
    /// g|CgC^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface that shows extension point.
    /// </en>
    /// </summary>
	public interface IExtensionPoint {
        /// <summary>
        /// <ja>
        /// g|CgLvOCIPluginC^[tFCXłB
        /// </ja>
        /// <en>
        /// IPlugin interface of plug-in to own extension point.
        /// </en>
        /// </summary>
        IPlugin OwnerPlugin { get; }
        /// <summary>
        /// <ja>
        /// g|CgIDłB
        /// </ja>
        /// <en>
        /// Extension point ID.
        /// </en>
        /// </summary>
		string ID { get; }
        /// <summary>
        /// <ja>
        /// g|CgvC^[tFCXłB
        /// </ja>
        /// <en>
        /// Interface that entension point demands
        /// </en>
        /// </summary>
		Type ExtensionInterface { get; }
        /// <summary>
        /// <ja>
        /// g|CgɃIuWFNgo^܂B
        /// </ja>
        /// <en>
        /// The object is registered in the extension point. 
        /// </en>
        /// </summary>
        /// <param name="extension">
        /// <ja>
        /// o^IuWFNgłB̃IuWFNgExtensionInterfacevpeBŎw肳
        /// C^[tFCXĂȂ΂Ȃ܂B
        /// </ja>
        /// <en>
        /// It is a registered object. This object should have the interface specified in the ExtensionInterface property. 
        /// </en>
        /// </param>
        /// <exception cref="ArgumentException">
        /// <ja>
        /// extensionɎw肳ꂽIuWFNgExtensionInterfacevpeBŎw肳C^[tFCXĂ܂B
        /// </ja>
        /// <en>
        /// The interface for which the object specified for extension is specified in the ExtensionInterface property is not provided with. 
        /// </en>
        /// </exception>
		void RegisterExtension(object extension);
        /// <summary>
        /// <ja>
        /// ̊g|Cgɓo^ĂIuWFNg̔z擾܂B
        /// </ja>
        /// <en>
        /// Get the array of the object registered in this extension point.
        /// </en>
        /// </summary>
        /// <returns>
        /// <ja>
        /// ̊g|Cgɓo^ĂIuWFNg̔z񂪕Ԃ܂B
        /// </ja>
        /// <en>
        /// The array of the object registered in this extension point is returned. 
        /// </en>
        /// </returns>
		Array GetExtensions();
	}

    //ŏExtensionPointp̃C^tF[X
    /// <summary>
    /// 
    /// </summary>
    /// <exclude/>
    public interface IRootExtension {
        void InitializeExtension();
    }

    /// <summary>
    /// 
    /// </summary>
    /// <exclude/>
    public interface IGUIMessageLoop : IRootExtension {
        void RunExtension();
    }

    //Plugin Inspectorp
    /// <summary>
    /// 
    /// </summary>
    /// <exclude/>
    public interface IPluginInspector : IAdaptable {
        IEnumerable<IPluginInfo> Plugins { get; }
        IEnumerable<IExtensionPoint> ExtensionPoints { get; }
        IPluginInfo GetPluginInfo(IPlugin plugin);
    }

    /// <summary>
    /// 
    /// </summary>
    /// <exclude/>
    public interface IPluginInfo : IAdaptable {
        IPlugin Body { get; }
        PluginInfoAttribute PluginInfoAttribute { get; }
        PluginStatus Status { get; }
    }

    /// <summary>
    /// <ja>
    /// vOCJ҂ɁAIPluginC^[tFCXIAdaptableC^[tFCX̕W񋟂܂B
    /// </ja>
    /// <en>
    /// A default implementation in the IPlugin interface and the IAdaptable interface is offered to the developer. 
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// vOCJ҂́ÃNXp邱ƂŏȂR[hŃvOCƂł܂B
    /// L̎ɂȂĂ܂B
    /// <code>
    /// public abstract class PluginBase : MarshalByRefObject, IPlugin
    /// {
    ///    protected IPoderosaWorld _poderosaWorld;
    ///    public virtual void InitializePlugin(IPoderosaWorld poderosa)
    ///    {
    ///        poderosaWorld = poderosa;
    ///    }
    ///    public IPoderosaWorld PoderosaWorld
    ///    {
    ///        get
    ///        {
    ///            return _poderosaWorld;
    ///        }
    ///    }
    ///    public virtual void TerminatePlugin()
    ///    {
    ///    }
    ///    public virtual IAdaptable GetAdapter(Type adapter)
    ///    {
    ///        return _poderosaWorld.AdapterManager.GetAdapter(this, adapter);
    ///    }
    /// }
    /// </code>
    /// </ja>
    /// <en>
    /// The plug-in developer can write the plug-in by a little code by making it inheritances to from this class. 
    /// It is the following implementation. 
    /// <code>
    /// public abstract class PluginBase : MarshalByRefObject, IPlugin
    /// {
    ///    protected IPoderosaWorld _poderosaWorld;
    ///    public virtual void InitializePlugin(IPoderosaWorld poderosa)
    ///    {
    ///        poderosaWorld = poderosa;
    ///    }
    ///    public IPoderosaWorld PoderosaWorld
    ///    {
    ///        get
    ///        {
    ///            return _poderosaWorld;
    ///        }
    ///    }
    ///    public virtual void TerminatePlugin()
    ///    {
    ///    }
    ///    public virtual IAdaptable GetAdapter(Type adapter)
    ///    {
    ///        return _poderosaWorld.AdapterManager.GetAdapter(this, adapter);
    ///    }
    /// }
    /// </code>
    /// </en>
    /// </remarks>
    public abstract class PluginBase : MarshalByRefObject, IPlugin {
        /// <summary>
        /// <ja>
        /// ̂ƂɎ󂯎IPoderosaWorldC^[tFCXێ܂B
        /// </ja>
        /// <en>
        /// The IPoderosaWorld interface received when initializing it is maintained. 
        /// </en>
        /// </summary>
        protected IPoderosaWorld _poderosaWorld;
        /// <summary>
        /// <ja>
        /// vOC̏̍ۂɌĂяo܂BftHg̎ł́A_poderosaWorldɎ󂯎IPoderosaWorldC^[tFCXۑ܂B
        /// </ja>
        /// <en>
        /// When the plug-in is initialized, it is called.
        /// In default implementation, the IPoderosaWorld interface received in _poderosaWorld is preserved. 
        /// </en>
        /// </summary>
        /// <param name="poderosa">
        /// <ja>Poderosa{̂nIPoderosaWorldC^[tFCX</ja>
        /// <en>IPoderosaWorld interface to which Poderosa is passed</en>
        /// </param>
        public virtual void InitializePlugin(IPoderosaWorld poderosa) {
            _poderosaWorld = poderosa;
        }

        /// <summary>
        /// <ja>
        /// Poderosa{̂ƒʐM邽߂IPoderosaWorldC^[tFCXԂ܂B
        /// </ja>
        /// <en>
        /// The IPoderosaWorld interface to communicate with Poderosa is returned. 
        /// </en>
        /// </summary>
        public IPoderosaWorld PoderosaWorld {
            get {
                return _poderosaWorld;
            }
        }

        /// <summary>
        /// <ja>
        /// vOCOɌĂяo܂B
        /// </ja>
        /// <en>
        /// It is called before the plug-in is released. 
        /// </en>
        /// </summary>
        public virtual void TerminatePlugin() {
        }

        public virtual IAdaptable GetAdapter(Type adapter) {
            return _poderosaWorld.AdapterManager.GetAdapter(this, adapter);
        }
    }

}
