/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Values/Evaluator.cs#7 $
 * $DateTime: 2007/12/28 19:35:14 $
 * 
 * IEvaluatorEvalĂԂƁAlԂB
 * ̂ƂA^͎Oɂ킩ĂKvB܂AEval̎ɂẮAEvalĂԂтɃĂԂ悤ɂ͂ȂĂȂX^Cł邱Ƃ]܂B
 * āAEvalĂ񂾂炻̖߂lBV.LetȂǂŃRs[ĂƁB
 * Ȃŏ ref BV n悤ɂ΂̂ł͂Ȃ̂HƂ^͂ƂAřʂ̃X^Cł
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;

using Bellagio.Evaluators;
using Bellagio.Script;
using Travis.ORT;

namespace Bellagio.Values {
    /* OmegaChartExpressionTree𒼐ڕ]ĂAxEvaluatorc[܂邱ƂŌ^̃`FbNAp[^QƂȂǂłB
     * 
     * ֐́AOƈ\猟ĉʂIBVFunction̎ĂԁBIuWFNgɊ֘Atꂽ́AO[ô̗̂肤B
     * ނArraynɓKpł֐QȂǁAۂɓKpł̂̂EvaluatorBuildContext̎̒ōsB
     * 
     * Evalł́AʂǂԂŎ̂Rp^[B
     *  1. ŃIuWFNgnAl𒼐ڃZbg@@qEvaluatoř^ĐeBV炩ߍ쐬̂ʓ|ALet̉񐔂ANil͌^ɂP̌Ȃ
     *  2. refnAlZbg@@qEvaluatoř^ĐeBV炩ߍ쐬̂ʓ|ALet̉񐔂
     *  3. fɖ߂l@@EvaluatorĂԑLetKvȂƂɒӂKv
     * Ƃ킯łRԁB
     * 
     *  Agݍ݊֐̎TChł͌ʂrefŎ󂯂B󋵎ł́APȂōς܂邩łBQuotes,TimeAndSalesł͑p
     */
    public interface IEvaluator {
        BT BT { get; }
        BV Eval(EvalContext context);
    }

    //gݍ݊֐p[^QƂƂɎg
    public interface INamedValue {
        BT BT { get; }
        BV GetValue(EvalContext ctx);
        string Name { get; }
    }
    //OQƂƂ̌₪ꂽꍇl^Cv  Ă1Ȃ̂ł̂Ƃ̓X[Yɂ悤
    public class NamedValueCollection {
        public INamedValue single; //single,multipleǂ炩݂̂Zbg
        public INamedValue[] multiple;
        public NamedValueCollection(INamedValue v) {
            single = v;
        }
        public NamedValueCollection(INamedValue[] v) {
            multiple = v;
        }
    }

    //p[^ێ
    public interface IParameterProvider {
        INamedValue FindParameter(string name);
    }


    public class EvalContext {
        private BV _context;
        private BTime _currentTime;
        private BDate _currentDate;
        private BStackFrame _stack;
        private StockRef _currentStock;
        private Dictionary<BMethod, BStackFrame> _stackCache;

        private EvalSpecial_CodeCollector _codeCollector;

        public EvalContext() {
            Set(null);
            _stackCache = new Dictionary<BMethod, BStackFrame>();
        }
        public EvalContext(BV context) {
            Set(context);
            _stackCache = new Dictionary<BMethod, BStackFrame>();
        }
        public void Set(BV context) {
            _context = context;
        }
        public void InitializeStack(BStackFrame stack) {
            _stack = stack;
        }


        public BV ContextValue {
            get {
                return _context;
            }
            set {
                _context =value;
            }
        }

        public BTime CurrentTime {
            get {
                return _currentTime;
            }
            set {
                _currentTime = value;
            }
        }
        public BDate CurrentDate {
            get {
                return _currentDate;
            }
            set {
                _currentDate = value;
            }
        }
        public BStackFrame Stack {
            get {
                return _stack;
            }
        }
        public StockRef CurrentStock {
            get {
                return _currentStock;
            }
            set {
                _currentStock = value;
            }
        }

        public BStackFrame AllocateStack(BMethod method, BV[] args) {
            BStackFrame result;
            //BMethodɑ΂ĂЂƂX^bN邪ACX^X͍ėpł
            if(_stackCache.TryGetValue(method, out result) && !result.Using) {
                result.Reuse(_stack, args);
            }

            result = new BStackFrame(method, _stack, args);
            _stackCache[method] = result;
            _stack = result;
            return result;
        }
        public void ReleaseStack(BStackFrame stack) {
            stack.Using = false;
            _stack = stack.ParentFrame;
        }


        public EvalSpecial_CodeCollector EvalSpecial_CodeCollector {
            get {
                return _codeCollector;
            }
            set {
                _codeCollector = value;
            }
        }



    }

    //EvalɎQƂR[hW߂
    public class EvalSpecial_CodeCollector {
        private List<string> _stocks;
        private List<string> _indices;

        public EvalSpecial_CodeCollector() {
            _stocks = new List<string>();
            _indices = new List<string>();
        }
        public void AddStock(string code) {
            if(!_stocks.Contains(code))
                _stocks.Add(code);
        }
        public void AddIndex(string code) {
            if(!_indices.Contains(code))
                _indices.Add(code);
        }
        public List<string> ResultStocks {
            get {
                return _stocks;
            }
        }
        public List<string> ResultIndex {
            get {
                return _indices;
            }
        }
    }

    //ʏEvaluatorBuildContextɈB̍ĕ]ł
    public class EvaluatorBuildContextWithArgs {
        private EvaluatorBuildContext _context;
        private List<LocalVariable> _arguments;
        private List<StandAloneEvaluator> _argumentValues;

        public EvaluatorBuildContextWithArgs(EvaluatorBuildContext plain) {
            _context = plain;
            _arguments = new List<LocalVariable>();
            _argumentValues = new List<StandAloneEvaluator>();
        }
        public EvaluatorBuildContext ResultContext {
            get {
                return _context;
            }
        }
        public int ArgCount {
            get {
                return _arguments.Count;
            }
        }
        public StandAloneEvaluator GetArgumentEvaluatorAt(int index) {
            return _argumentValues[index];
        }
        public LocalVariable GetLocalVariableAt(int index) {
            return _arguments[index];
        }
        public int IndexFromName(string name) {
            for(int i=0; i<_arguments.Count; i++) {
                LocalVariable lv = _arguments[i];
                if(name==lv.Name) {
                    return i;
                }
            }
            return -1;
        }

        public void DefineArgument(LocalVariable var, StandAloneEvaluator content) {
            _arguments.Add(var);
            _argumentValues.Add(content);
            _context.DefineLocal(var.Name, var.BT);
        }
        public LocalVariable[] Arguments() {
            return _arguments.ToArray();
        }
        public BV[] EvalArguments() {
            Debug.Assert(_arguments.Count==_argumentValues.Count);
            EvalContext ec = new EvalContext();
            BV[] result = new BV[_arguments.Count];
            for(int i=0; i<_arguments.Count; i++) {
                BV v = null;
                BV.Let(ref v, _argumentValues[i].Eval(ec));
                Debug.Assert(v.BT==_arguments[i].BT);
                result[i] = v;
            }
            return result;
        }

    }


    public static class EvaluatorBuilderFromText {
        public static IEvaluator Build(IORText text, EvaluatorBuildContext ctx) {
            Expression expr = Expression.ParseExpression(text);
            return Build(expr, text.LocationString, ctx);
        }
        public static IEvaluator Build(string text, EvaluatorBuildContext ctx) {
            Expression expr = Expression.ParseExpression(text);
            return Build(expr, text, ctx); //dȂExprʒuɎg
        }
        private static IEvaluator Build(Expression expr, string location_info, EvaluatorBuildContext ctx) {
            try {
                EvaluatorBuilder bld = new EvaluatorBuilder(ctx);
                IEvaluator ev = bld.Build(expr);
                return ev;
            }
            catch(Exception ex) {
                Debug.WriteLine(ex.StackTrace);
                throw new ScriptException(String.Format("{0} \n{1}", location_info==null? "" : location_info, ex.Message));
            }
        }
        public static StandAloneEvaluator BuildStandAlone(IORText text, IParameterProvider pp, BT context, LocalVariable[] args, BV[] arg_values) {
            EvaluatorBuildContext ctx = new EvaluatorBuildContext(pp);
            ctx.Initialize(context, args);
            IEvaluator e = Build(text, ctx);
            return new StandAloneEvaluator(e, ctx, arg_values);
        }
        public static StandAloneEvaluator BuildStandAlone(string text, IParameterProvider pp, BT context, LocalVariable[] args, BV[] arg_values) {
            EvaluatorBuildContext ctx = new EvaluatorBuildContext(pp);
            ctx.Initialize(context, args);
            IEvaluator e = Build(text, ctx);
            return new StandAloneEvaluator(e, ctx, arg_values);
        }

        //Xg\
        //referredɂargumentsŎw肳Ăp[^
        public static EvaluatorBuildContextWithArgs CreateContextWithArgs(IParameterProvider param_prov, ParameterListDefinition prm, Expression[] args, string args_location) {
            Debug.Assert(prm.Count==args.Length);
            EvaluatorBuildContext ctx = new EvaluatorBuildContext(param_prov);
            EvaluatorBuildContextWithArgs result = new EvaluatorBuildContextWithArgs(ctx);
            for(int i=0; i<args.Length; i++) {
                EvaluatorBuildContext arg_context = new EvaluatorBuildContext(param_prov);
                ctx.Initialize(null, LocalVariable.EmptyArray);
                LocalVariable var = new LocalVariable(prm.NameAt(i), ctx.TypeDescToBT(prm.TypeDescAt(i)), i);
                IEvaluator ev = Build(args[i], args_location, arg_context);
                //^ϊ
                if(var.BT==BT.Double && ev.BT==BT.Int)
                    ev = EvaluatorUtil.CreateI2D(ctx, (Evaluator)ev);

                Debug.Assert(ev.BT==var.BT);
                result.DefineArgument(var, new StandAloneEvaluator(ev, arg_context, BV.EmptyArray));
            }
            return result;
        }

    }

    //ExpressionɑΉX^bNt[쐬̔\͂
    public class StandAloneEvaluator {
        private IEvaluator _evaluator;
        private EvaluatorBuildContext _buildContext;
        private BV[] _args;
        private BStackFrame _rootStack;
        public StandAloneEvaluator(IEvaluator ev, EvaluatorBuildContext ctx, BV[] args) {
            _evaluator = ev;
            _buildContext = ctx;
            _args = args;
            _rootStack = new BStackFrame(ctx, args);
        }

        public IEvaluator Content {
            get {
                return _evaluator;
            }
        }

        public BT BT {
            get { return _evaluator.BT; }
        }
        public BV[] Args {
            get {
                return _args;
            }
        }
        internal EvaluatorBuildContext BuildContext {
            get {
                return _buildContext;
            }
        }

        public BV Eval(EvalContext ctx) {
            _rootStack.Reuse(null, _args);
            ctx.InitializeStack(_rootStack);
            return _evaluator.Eval(ctx);
        }

    }
}
