options {
    language  = "CSharp";
    namespace = "Bellagio.Script.Parser";

}
{
}
class ExpressionParser extends Parser;

options {
  buildAST = false;
  k=1;
  classHeaderPrefix = "internal";
  defaultErrorHandler = false;
}
{
}

//comma-separated expression list
top_expr_list returns [Expression[] l]
: { System.Collections.ArrayList a = new System.Collections.ArrayList(); Expression e; }
  ( e=expr { a.Add(e); } ("," e=expr { a.Add(e); })* )? EOF { l=(Expression[])a.ToArray(typeof(Expression)); };

top_expr returns [Expression e]
: e = expr EOF ;

expr returns [Expression e]
: { Expression r1 = null, r2 = null; }
  e=cond_expr
  ("?" r1 = cond_expr ":" r2 = expr { e = new ConditionalExpression(e, r1, r2); })?
;

cond_expr returns [Expression e]
: { Expression r=null; IToken op=null; }
  e=logical_expr 
  (op=logical_ops r=logical_expr { e = new BinaryOpExpression(op, e, r); })*
;

logical_expr returns [Expression e]
: { Expression r=null; IToken op=null; }
  e=arith_expr
  (op=comp_ops r=arith_expr { e = new BinaryOpExpression(op, e, r); })*
;

arith_expr returns [Expression e]
: { Expression r=null; IToken op=null; }
  e=term_expr
  (op=arith_addsub_ops r=term_expr { e=new BinaryOpExpression(op, e, r); })*
;

term_expr returns [Expression e]
: { Expression r=null; IToken op=null; }
  e=unary_expr
  (op=arith_muldiv_ops r=unary_expr { e=new BinaryOpExpression(op,e,r); })*
;

unary_expr returns [Expression e]
:
  e=value_expr
| { IToken op; } 
  op=unary_ops e=value_expr { e = new UnaryOpExpression(op, e); }
;

value_expr returns [Expression e]
: { Expression r = null; }
  e=reference_expr ("." r=reference_expr { e = new ReferenceExpression(e, r); } )*
;

reference_expr returns [Expression e]
: { Expression a = null; InvokeExpression ie=null; }
  e=leaf_expr (
    ( "(" { ie=new InvokeExpression(e); } (a=expr { ie.AddArg(a); } ("," a=expr { ie.AddArg(a); } )*)? ")" { e=ie; } )
  | ( "[" a=expr "]" { e=new ArrayExpression(e, a); } )
  )*
;

leaf_expr returns [Expression e]
:
  "(" e=expr ")"
| e=literal_expr
| e=parameter_expr
| e=special_function
;

literal_expr returns [Expression e]
: 
   BOOLEAN_TRUE { e = new LiteralBooleanExpression(true); }
|  BOOLEAN_FALSE { e = new LiteralBooleanExpression(false); }
|  num:NUMBER { e = new LiteralNumberExpression(num.getText()); }
|  ( "@t" t:NUMBER { e = new LiteralTimeExpression(t.getText()); } )
|  ( "@d" d:NUMBER { e = new LiteralDateExpression(d.getText()); } )
|  ( s:LITERAL_STRING { e = new LiteralStringExpression(s.getText()); } )
|  id:IDENTIFIER { e = new SymbolExpression(id.getText()); }
;

parameter_expr returns [Expression e]
:
"$" (
  name:IDENTIFIER { e = new ParameterExpression(name.getText()); }
| "{" name2:IDENTIFIER { e = new ParameterExpression(name2.getText()); } "}"
)
;

special_function returns [Expression e]
: { ParameterListDefinition al = null; }
   ( "lambda" "(" "(" al=parameter_list_def ")" e=expr ")" { e = new LambdaExpression(al, e); } )
|  { Expression df = null; LetExpression l; }
   ( "let" "(" "(" n1:IDENTIFIER "=" df=expr { l = new LetExpression(); l.DefLocal(n1.getText(), df); } ("," n2:IDENTIFIER "=" df=expr { l.DefLocal(n2.getText(), df); } )* ")" df=expr { l.SetBody(df); e = l; } ")" )
;

parameter_list_def returns [ParameterListDefinition al]
: { TypeDesc t = null; al = new ParameterListDefinition(); }
  (t=type_desc n1:IDENTIFIER { al.Add(t, n1.getText()); } ("," t=type_desc n2:IDENTIFIER { al.Add(t, n2.getText()); } )*)?
;
top_parameter_list_def returns [ParameterListDefinition al]
: al=parameter_list_def EOF;

top_type_desc returns [TypeDesc t]
:
t = type_desc EOF;

type_desc returns [TypeDesc t]
:
t = not_array_type_desc (ARRAY_TYPE { t = new ArrayTypeDesc(t); } )*
;

not_array_type_desc returns [TypeDesc t]
: 
(
  s:IDENTIFIER { t = TypeDesc.FromName(s.getText()); }
| { TypeDesc a = null; LambdaTypeDesc l = null; }
  "(" a=type_desc { l = new LambdaTypeDesc(); l.AddArg(a); } ("," a=type_desc { l.AddArg(a); } )*  TYPE_ARROW a=type_desc { l.Fix(a); t=l; } ")"
)
;

//function definition list
top_function_definition_list returns [FunctionDefinitionList fl]
: { fl = new FunctionDefinitionList(); FunctionDefinition f = null; }
( f = function_definition { fl.Add(f); } )* EOF;

function_definition returns [FunctionDefinition fd]
: { TypeDesc rt; ParameterListDefinition pl; Expression body; }
rt=type_desc n:IDENTIFIER "(" pl=parameter_list_def ")" "{" body=expr "}" { fd=new FunctionDefinition(n.getText(), rt, pl, body, n.getLine()); }
;

logical_ops returns [IToken t = null]
:  t1:LOGICAL_AND   { t=t1; }
|  t2:LOGICAL_OR    { t=t2; }
;

comp_ops returns [IToken t = null]
:  t1:COMP_OP_GT  { t=t1; }
| t2:COMP_OP_GTE { t=t2; }
| t3:COMP_OP_LT  { t=t3; }
| t4:COMP_OP_LTE { t=t4; }
| t5:COMP_OP_EQ  { t=t5; }
| t6:COMP_OP_NEQ { t=t6; }
;

arith_addsub_ops returns [IToken t = null]
: t1:ARITH_OP_ADD { t=t1; }
| t2:ARITH_OP_SUB { t=t2; }
;

arith_muldiv_ops returns [IToken t = null]
:  t1:ARITH_OP_MUL { t=t1; }
|  t2:ARITH_OP_DIV { t=t2; }
|  t3:ARITH_OP_MOD { t=t3; }
;

unary_ops returns [IToken t = null]
: t1:ARITH_OP_SUB { t=t1; }
| t2:LOGICAL_NOT { t=t2; }
;

dummy_for_lex
: DUMMY_FOR_LEX
;


//// Lexical

class ExpressionLexer extends Lexer;
options {
  testLiterals = true;
  //charVocabulary='\u0001'..'\uFFFE';
  k=3;
}
tokens {
  BOOLEAN_TRUE = "true";
  BOOLEAN_FALSE = "false";
}
{
//avoid warnings
#pragma warning disable 618, 219 //old-fashioned Hashtable constructor(618), unused local variable(219)
private static void neverCalled() {
}
}

protected
NL : ( '\n' );

protected
WS :
    ( ' '
    | '\r'
    | '\t'
    | '\f'
    | NL {newline();}
    );

IGNORE :
 ( (WS)+ { $setType(Token.SKIP); } );

NUMBER
options {
  paraphrase = "a number";
}
: ('0'..'9')+('.'('0'..'9')+)?;

LITERAL_STRING :
    ( '"'!  ( options{greedy=false;} : ~('"') )* '"'!);

LOGICAL_NOT: "!";
LOGICAL_AND: "&&";
LOGICAL_OR:  "||";
COMP_OP_GT:  ">";
COMP_OP_GTE: ">=";
COMP_OP_LT:  "<";
COMP_OP_LTE: "<=";
COMP_OP_EQ:  "==";
COMP_OP_NEQ: "!=";
ARITH_OP_ADD: "+";
ARITH_OP_SUB: "-";
ARITH_OP_MUL: "*";
ARITH_OP_DIV: "/";
ARITH_OP_MOD: "%";
TYPE_ARROW: "->";
ARRAY_TYPE: "[]";

DUMMY_FOR_LEX
options {
  testLiterals = true;
}
: ( '('|')'|'['|']'|'{'|'}'|','|':'|';'|'?'|'='|'|'|'.'|'$'|"@t"|"@d" );

IDENTIFIER
options {
  paraphrase = "an identifier";
  testLiterals = false;
}
: ID_CHAR (ID_CHAR | '0'..'9')* ;

protected
  ID_CHAR: 'a'..'z'|'A'..'Z'|'_';
//  ID_CHAR: 'a'..'z'|'A'..'Z'|'_'|'\u0100'..'\uFFFD';

