﻿/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id$
 * $DateTime$
 */
using System;
using System.Collections.Generic;
using System.Text;

using Bellagio.Environment;
using Bellagio.Forms;
using Bellagio.Chart;

using Poderosa.Plugins;
using Poderosa.Preferences;


namespace Bellagio.Screening {

    //自動売買検証で、表示する結果は条件成立時か取引日か
    public enum AutoTradingDateDisplay {
        Condition,
        Trade
    }

    public class ScreeningPreferences : PreferenceSupplierImpl, IPreferenceChangeListener {
        private IIntPreferenceItem _maximumDailyDataLength;
        private EnumPreferenceItem<AutoTradingDateDisplay> _autotradingDateDisplay;
        private EnumPreferenceItem<MouseWheelAction> _mouseWheelOnResultPane;
        private IStringPreferenceItem _lastExecutedScreening;
        private IStringPreferenceItem _lastExecutedAutoTrading;

        public ScreeningPreferences()
            : base("tactico.screening") {
        }

        public void RegisterExtension(IExtensionPoint pt) {

            pt.RegisterExtension(this);
        }

        public override void InitializePreference(IPreferenceBuilder builder, IPreferenceFolder folder) {
            //_tradeSoundFile = builder.DefineStringValue(folder, "tradeSoundFile", "Execution.wav", null);
            _maximumDailyDataLength = builder.DefineIntValue(folder, "maximumDailyDataLength", 2000, null);
            _autotradingDateDisplay = new EnumPreferenceItem<AutoTradingDateDisplay>(builder.DefineStringValue(folder, "autotradingDateDisplay", "Condition", null), AutoTradingDateDisplay.Condition);
            _mouseWheelOnResultPane = new EnumPreferenceItem<MouseWheelAction>(builder.DefineStringValue(folder, "mouseWheelOnResultPane", "Scroll", null), MouseWheelAction.Scroll);

            _lastExecutedScreening = builder.DefineStringValue(folder, "lastExecutedScreening", "", null);
            _lastExecutedAutoTrading = builder.DefineStringValue(folder, "lastExecutedAutoTrading", "", null);
        }

        public void OnPreferenceImport(IPreferenceFolder oldvalues, IPreferenceFolder newvalues) {
        }

        //必ずしも必要な項目が変更されたとは限らないが、何度もReloadPreferenceを実行するのを避けるため代表してFixedPreferenceが通知を受ける
        public void OnPreferenceImportFinish() {
        }


        public void ReloadPreference() {
        }

        public void Dispose() {
        }

        public int MaximumDailyDataLength {
            get {
                return _maximumDailyDataLength.Value;
            }
        }
        public IIntPreferenceItem MaximumDailyDataLengthItem {
            get {
                return _maximumDailyDataLength;
            }
        }
        public AutoTradingDateDisplay AutoTradingDateDisplay {
            get {
                return _autotradingDateDisplay.Value;
            }
        }
        public EnumPreferenceItem<AutoTradingDateDisplay> AutoTradingDateDisplayItem {
            get {
                return _autotradingDateDisplay;
            }
        }
        public MouseWheelAction MouseWheelOnResultPane {
            get {
                return _mouseWheelOnResultPane.Value;
            }
        }
        public IStringPreferenceItem MouseWheelOnResultPaneItem {
            get {
                return _mouseWheelOnResultPane.PreferenceItem;
            }
        }

        public string LastExecutedScreening {
            get {
                return _lastExecutedScreening.Value;
            }
            set {
                _lastExecutedScreening.Value = value;
            }
        }
        public string LastExecutedAutoTrading {
            get {
                return _lastExecutedAutoTrading.Value;
            }
            set {
                _lastExecutedAutoTrading.Value = value;
            }
        }

    }
}
