/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Screening/AutoTradingSummaryDialog.cs#3 $
 * $DateTime: 2008/05/14 13:05:12 $
 */
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using Bellagio.Forms;
using Bellagio.Values;

namespace Bellagio.Screening {
    /// <summary>
    /// AutoTradingSummaryDialog ̊Tv̐łB
    /// </summary>
    internal class AutoTradingSummaryDialog : System.Windows.Forms.Form {
        private System.Windows.Forms.Button _copyButton;
        private System.Windows.Forms.Button _okButton;
        private System.Windows.Forms.ListView _listView;
        private System.Windows.Forms.ColumnHeader _nameColumn;
        private System.Windows.Forms.ColumnHeader _valueColumn;
        /// <summary>
        /// KvȃfUCiϐłB
        /// </summary>
        private System.ComponentModel.Container components = null;

        public AutoTradingSummaryDialog(AutoTradingResult sr) {
            //
            // Windows tH[ fUCi T|[gɕKvłB
            //
            InitializeComponent();

            //
            // TODO: InitializeComponent ĂяǒɁARXgN^ R[hǉĂB
            //
            InitUI(sr);
        }

        /// <summary>
        /// gpĂ郊\[XɌ㏈s܂B
        /// </summary>
        protected override void Dispose(bool disposing) {
            if(disposing) {
                if(components != null) {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #region Windows tH[ fUCiŐꂽR[h
        /// <summary>
        /// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
        /// R[h GfB^ŕύXȂłB
        /// </summary>
        private void InitializeComponent() {
            this._copyButton = new System.Windows.Forms.Button();
            this._okButton = new System.Windows.Forms.Button();
            this._listView = new System.Windows.Forms.ListView();
            this._nameColumn = new System.Windows.Forms.ColumnHeader();
            this._valueColumn = new System.Windows.Forms.ColumnHeader();
            this.SuspendLayout();
            // 
            // _copyButton
            // 
            this._copyButton.Location = new System.Drawing.Point(24, 352);
            this._copyButton.Name = "_copyButton";
            this._copyButton.TabIndex = 2;
            this._copyButton.Text = "Rs[";
            this._copyButton.Click += new System.EventHandler(this.OnCopyButton);
            this._copyButton.FlatStyle = FlatStyle.System;
            // 
            // _okButton
            // 
            this._okButton.DialogResult = System.Windows.Forms.DialogResult.OK;
            this._okButton.Location = new System.Drawing.Point(288, 352);
            this._okButton.Name = "_okButton";
            this._okButton.TabIndex = 0;
            this._okButton.Text = "OK";
            this._okButton.FlatStyle = FlatStyle.System;
            // 
            // _listView
            // 
            this._listView.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						this._nameColumn,
																						this._valueColumn});
            this._listView.GridLines = true;
            this._listView.Location = new System.Drawing.Point(0, 0);
            this._listView.MultiSelect = false;
            this._listView.Name = "_listView";
            this._listView.Size = new System.Drawing.Size(376, 344);
            this._listView.TabIndex = 1;
            this._listView.View = System.Windows.Forms.View.Details;
            // 
            // _nameColumn
            // 
            this._nameColumn.Text = "";
            this._nameColumn.Width = 160;
            // 
            // _valueColumn
            // 
            this._valueColumn.Text = "l";
            this._valueColumn.Width = 208;
            // 
            // AutoTradingSummaryDialog
            // 
            this.AcceptButton = this._okButton;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
            this.CancelButton = this._okButton;
            this.ClientSize = new System.Drawing.Size(376, 383);
            this.ControlBox = false;
            this.Controls.Add(this._listView);
            this.Controls.Add(this._okButton);
            this.Controls.Add(this._copyButton);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "AutoTradingSummaryDialog";
            this.ShowInTaskbar = false;
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
            this.Text = "̏Wv";
            this.ResumeLayout(false);

        }
        #endregion

        private void InitUI(AutoTradingResult sr) {
            double perf = 0;
            string msg = "";
            //AddItem("ؑΏۖ", sr.BrandDescription);
            AddItem("؊Jn", BDate.FormatYYMMDD(new BDate(sr.Query.OriginDate)));
            AddItem("؏I", BDate.FormatYYMMDD(new BDate(sr.Query.LastDate)));
            AddItem("ؓ", String.Format("{0}", sr.TotalCount));
            AddItem("VOi", String.Format("{0}", sr.Count));
            AddItem("PVOił̕σg[h", String.Format("{0:F2}", sr._avgTradeLength));
            AddItem("Pg[h̕σptH[}X", String.Format("{0:F2}%", sr._avgPerformance * 100));

            AddItem("", String.Format("{0} ({1:F2}%)", sr._exitCount, (double)sr._exitCount / sr._totalCount * 100));
            AddItem("̕ϗv", String.Format("{0:F2}%", sr._avgExit * 100));
            AddItem("̕W΍", String.Format("{0:F2}%", sr._sdevExit * 100));
            AddItem("̕σg[h", String.Format("{0:F2}", sr._avgExitTradeLength));
            SignalResult t = sr._maxExit;
            if(t!=null) {
                t.CheckResult(ref perf, ref msg);
                AddItem("ő嗘v", String.Format("{0:F2}% ({1}{2} {3})", perf*100, t.StockProfile.Code, t.StockProfile.Name, BDate.FormatYYMMDD(new BDate(t.SignalDate))));
            }
            else
                AddItem("ő嗘v", "-");

            AddItem("s", String.Format("{0} ({1:F2}%)", sr._losscutCount, (double)sr._losscutCount / sr._totalCount * 100));
            AddItem("s̕ϑ", String.Format("{0:F2}%", sr._avgLosscut * 100));
            AddItem("s̕W΍", String.Format("{0:F2}%", sr._sdevLosscut * 100));
            AddItem("s̕σg[h", String.Format("{0:F2}", sr._avgLosscutTradeLength));
            t = sr._maxLosscut;
            if(t!=null) {
                t.CheckResult(ref perf, ref msg);
                AddItem("ő呹", String.Format("{0:F2}% ({1}{2} {3})", perf*100, t.StockProfile.Code, t.StockProfile.Name, BDate.FormatYYMMDD(new BDate(t.SignalDate))));
            }
            else
                AddItem("ő呹", "-");

            AddItem("ʔs\ȃVOi", (sr.Count - sr._exitCount - sr._losscutCount).ToString());
        }

        private void AddItem(string name, string value) {
            ListViewItem li = new ListViewItem(new string[] { name, value });
            _listView.Items.Add(li);
        }

        // Copy{^
        // ListViewUtil𗬗pAꉞ삵Ă̂̎M͂Ȃ by Yakutainashi
        private void OnCopyButton(object sender, EventArgs e) {
            ListViewUtil.CopyListViewContentToClipboard(_listView, true, new ListViewUtil.ItemChecker(ListViewItemChecker));
        }
        private static bool ListViewItemChecker(ListViewItem li) {
            return true;
        }
    }
}
