/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Forms/ScaleUnit.cs#8 $
 * $DateTime: 2007/12/28 19:23:38 $
 * Ot̃̐lB1, 2.5, 5 ̂ꂩƁA10̐̐
 */
using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.Text;
#if UNITTEST
using NUnit.Framework;
#endif
namespace Bellagio.Forms {
    //1.0,2.5,5.0̂ǂꂩ
    public enum ScaleType {
        _1,
        _25,
        _5
    }
    
    // type * (10^power) 킷
    public struct GraphScaleUnit {
        public ScaleType type;
        public int power;

        public GraphScaleUnit(ScaleType t, int p) {
            type = t;
            power = p;
        }

        public double ToValue() {
            double t = ScaleTypeToDouble(type);
            if(power >= 0) {
                for(int i=0; i<power; i++)
                    t *= 10.0;
            }
            else {
                for(int i=0; i<-power; i++)
                    t /= 10.0;
            }

            return t;
        }

        //K, M, BgĒZɂB1001MBق̃XP[(~A}CNȂǂ̓T|[gȂ)
        public string ToShortString() {
            int p = power;
            char s = '\0';

            if(p >= 9) {
                p -= 9;
                s = 'B';
            }
            else if(p >= 6) {
                p -= 6;
                s = 'M';
            }
            else if(p >= 4) { //10000ȏォKp
                p -= 3;
                s = 'K';
            }

            if(s!='\0')
                return new GraphScaleUnit(type, p).ToValue().ToString() + s;
            else
                return new GraphScaleUnit(type, p).ToValue().ToString();
        }

        //value𒴂ŏScaleInfoԂ
        public static GraphScaleUnit FromFloor(double value) {
            Debug.Assert(value>0); //̐ΐƂȂ
            double l = Math.Log10(value);
            //sRȒl̂Ƃ肠assertŎ~߂
            Debug.Assert(l>-10 && l<10);

            GraphScaleUnit ret = new GraphScaleUnit();
            ret.power = (int)Math.Floor(l);
            l -= ret.power;
            if(l < 0.397) //log(2.5)
                ret.type = ScaleType._25;
            else if(l < 0.699) //log(5)
                ret.type = ScaleType._5;
            else {
                ret.type = ScaleType._1;
                ret.power++;
            }

            return ret;
        }

        //rBEqualsI[o[Ch̓^
        public bool Eq(GraphScaleUnit s) {
            return power==s.power && type==s.type;
        }

        //1̒PʂԂ
        public GraphScaleUnit Increment() {
            switch(type) {
                case ScaleType._1:
                    return new GraphScaleUnit(ScaleType._25, power);
                case ScaleType._25:
                    return new GraphScaleUnit(ScaleType._5, power);
                default: //case ScaleType._5:
                    return new GraphScaleUnit(ScaleType._1, power+1);
            }
        }
        //1̒PʂԂ
        public GraphScaleUnit Decrement() {
            switch(type) {
                case ScaleType._1:
                    return new GraphScaleUnit(ScaleType._5, power-1);
                case ScaleType._25:
                    return new GraphScaleUnit(ScaleType._1, power);
                default: //case ScaleType._5:
                    return new GraphScaleUnit(ScaleType._25, power);
            }
        }

        public static double ScaleTypeToDouble(ScaleType type) {
            switch(type) {
                case ScaleType._1:
                    return 1.0;
                case ScaleType._25:
                    return 2.5;
                case ScaleType._5:
                    return 5.0;
            }
            Debug.Assert(false);
            return 0;
        }
        //ToShortStringƓl
        public static string GetShortString(double value) {
            char s = '\0';

            if(value >= 1000000000) {
                value /= 1000000000;
                s = 'B';
            }
            else if(value >= 1000000) {
                value /= 1000000;
                s = 'M';
            }
            else if(value >= 10000) { //10000ȏォKp
                value /= 1000;
                s = 'K';
            }

            if(s!='\0')
                return String.Format("{0:F0}{1}", value, s);
            else
                return value.ToString();
        }
    }

#if UNITTEST
    [TestFixture]
    public class GraphUtilTests {
        [Test]
        public void ScaleInfoTest() {
            GraphScaleUnit i1 = GraphScaleUnit.FromFloor(9.9);
            Assert.AreEqual(ScaleType._1, i1.type);
            Assert.AreEqual(1, i1.power);
            Assert.AreEqual(10.0, i1.ToValue());

            GraphScaleUnit i2 = GraphScaleUnit.FromFloor(10.1);
            Assert.AreEqual(ScaleType._25, i2.type);
            Assert.AreEqual(1, i2.power);
            Assert.AreEqual(25.0, i2.ToValue());

            GraphScaleUnit i3 = GraphScaleUnit.FromFloor(0.3);
            Assert.AreEqual(ScaleType._5, i3.type);
            Assert.AreEqual(-1, i3.power);
            Assert.AreEqual(0.5, i3.ToValue());

            Assert.AreEqual("10K", new GraphScaleUnit(ScaleType._1, 4).ToShortString());
            Assert.AreEqual("2.5M", new GraphScaleUnit(ScaleType._25, 6).ToShortString());
            Assert.AreEqual("25M", new GraphScaleUnit(ScaleType._25, 7).ToShortString());
            Assert.AreEqual("5B", new GraphScaleUnit(ScaleType._5, 9).ToShortString());
        }
    }
#endif
}
