//
// ̃R[h́AJuan Pablo G.C. ̃R[h
// http://www.codeproject.com/cs/miscctrl/The_New_RibbonMenuButton.asp
// ƂɁAB"Checked"Xe[g̒ǉAtH[JX̘g`Ȃǂ傾Ȃ񂾂񂾂Ŕ͏
// ܂ȂĂȂƂ͂B

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Drawing.Imaging;
using System.Windows.Forms;
using System.Drawing.Drawing2D;

//using System.Diagnostics;

namespace Bellagio.Forms
{
    public class RibbonMenuButton : Button
    {
        #region About Constructor
        public RibbonMenuButton()
        {
            this.SetStyle(ControlStyles.SupportsTransparentBackColor |
                          ControlStyles.AllPaintingInWmPaint |
                          ControlStyles.OptimizedDoubleBuffer, true);
            this.SetStyle(ControlStyles.Opaque, false);
            this.FlatAppearance.BorderSize = 0;
            this.FlatStyle = FlatStyle.Flat;
            this.BackColor = Color.Transparent;
            this.TextAlign = ContentAlignment.BottomCenter;

            _mouseState = MouseState.Leave;
            _timer.Interval = 5;
            _timer.Tick += new EventHandler(OnTimerTick);
            
        }
        protected override void Dispose(bool disposing) {
            base.Dispose(disposing);
            if(disposing) {
                _timer.Dispose();
            }
        }

        protected override void OnCreateControl()
        {
            base.OnCreateControl();
            if(_checked) {
                _curA = ColorChecked.A;
                _curR = ColorChecked.R;
                _curG = ColorChecked.G;
                _curB = ColorChecked.B;
            }
            else {
                _curA = ColorBase.A;
                _curR = ColorBase.R;
                _curG = ColorBase.G;
                _curB = ColorBase.B;
            }
            _colorStroke = _baseStroke;

            Rectangle r = new Rectangle(new Point(-1, -1), new Size(this.Width + _radius, this.Height + _radius));
            #region Transform to SmoothRectangle Region
            if (this.Size != null)
            {
                GraphicsPath pathregion = new GraphicsPath();
                DrawArc(r, pathregion);
                this.Region = new Region(pathregion);
            }
            #endregion
        }
        #endregion

        #region About Image Settings
        private imagelocation _imagelocation = imagelocation.Top;
        public enum imagelocation
        {
            Top,Bottom,Left,Right,None
        }
        public imagelocation ImageLocation
        {
            get { return _imagelocation; }
            //TODO topȊOT|[g
        }

        #endregion

        #region About Button Settings
        private showbase _showbase;
        public enum showbase
        {
            Yes,No
        }
        public showbase ShowBase
        {
            get { return _showbase; }
            set { _showbase = value; this.Invalidate(); }
        }
        private int _radius = 6;
        public int Radius
        {
            get { return _radius; }
            set { if (_radius > 0) _radius = value; this.Invalidate(); }
        }
        private groupPos _grouppos;
        public enum groupPos
        {
            None,Left,Center,Right,Top,Bottom
        }
        public groupPos GroupPos
        {
            get { return _grouppos; }
            set { _grouppos = value; this.Invalidate(); }
        }

        private arrow _arrow;
        public enum arrow
        {
            None, ToRight, ToDown
        }
        public arrow Arrow
        {
            get { return _arrow; }
            set { _arrow = value; this.Invalidate(); }
        }
        private splitbutton _splitbutton;
        public enum splitbutton
        {
            No, Yes
        }
        public splitbutton SplitButton
        {
            get { return _splitbutton; }
            set { _splitbutton = value; this.Invalidate(); }
        }
        private int _splitdistance = 0;
        public int SplitDistance
        {
            get { return _splitdistance; }
            set { _splitdistance = value; this.Invalidate(); }
        }
        private string _title = "";
        public string Title
        {
            get { return _title; }
            set { _title = value; this.Invalidate(); }
        }

        private bool _checked;
        public bool Checked {
            get {
                return _checked;
            }
            set {
                if(_checked!=value && _mouseState==MouseState.Leave) { //O̒ڎw
                    Color target_col = value? _checkedColor : _baseColor;
                    _curR = target_col.R; _curG = target_col.G; _curB = target_col.B;
                    Invalidate();
                }
                _checked = value;
            }
        }

        #endregion

        #region Colors
        private Color _baseColor;
        private Color _onColor;
        private Color _pressColor;
        private Color _checkedColor;
        private Color _checkedOnColor;

        private Color _baseStroke;
        private Color _onStroke;
        private Color _pressStroke;
        private Color _colorStroke;
        private int _curA;
        private int _curR;
        private int _curG;
        private int _curB;

        private Color ToStrokeColor(Color col) {
            RibbonColor hsb = new RibbonColor(col);
            if(hsb.BC<50) {
                hsb.SetBrightness(60);
            }
            else {
                hsb.SetBrightness(30);
            }
            //if(_baseStroke.A >0)
                return Color.FromArgb(100, hsb.GetColor());
            //else
            //    return Color.FromArgb(0, hsb.GetColor());
        }

        public Color ColorBase
        {
            get { return _baseColor; }
            set
            {
                _baseColor = value;
                _curR = _baseColor.R;
                _curB = _baseColor.B;
                _curG = _baseColor.G;
                _curA = _baseColor.A;
                _baseStroke = ToStrokeColor(_baseColor);

            }
        }
        public Color ColorOn
        {
            get { return _onColor; }
            set { _onColor = value;
            _onStroke = ToStrokeColor(_onColor);
            }
        }
        public Color ColorPress
        {
            get { return _pressColor; }
            set { _pressColor = value;
            _pressStroke = ToStrokeColor(_pressColor);            
            }
        }
        public Color ColorChecked {
            get {
                return _checkedColor;
            }
            set {
                _checkedColor = value;
            }
        }
        public Color ColorCheckedOn {
            get {
                return _checkedOnColor;
            }
            set {
                _checkedOnColor = value;
            }
        }
        public Color ColorBaseStroke
        {
            get { return _baseStroke; }
            set { _baseStroke = value; }
        }
        public Color ColorOnStroke
        {
            get { return _onStroke; }
            set { _onStroke = value; }
        }
        public Color ColorPressStroke
        {
            get { return _pressStroke; }
            set { _pressStroke = value; }
        }
        private Color GetColorIncreased(Color color,int h,int s,int b)
        {
            RibbonColor _color = new RibbonColor(color);
            int ss = _color.GetSaturation();
            float vc = b + _color.GetBrightness();
            float hc = h+ _color.GetHue();
            float sc = s + ss;

            
            _color.VC = vc;
            _color.HC = hc;
            _color.SC = sc;
            
            return _color.GetColor();

            
        }

        private Color GetColor(int A,int R, int G, int B)
        {
            if (A + _curA > 255) { A = 255; } else { A = A + _curA; }
            if (R + _curR > 255) { R = 255; } else { R = R + _curR; }
            if (G + _curG > 255) { G = 255; } else { G = G + _curG; }
            if (B + _curB > 255) { B = 255; } else { B = B + _curB; }

            return Color.FromArgb(A,R, G, B);
        }
        #endregion

        protected override void OnPaint(PaintEventArgs pevent)
        {
            #region Variables & Conf
            Graphics g = pevent.Graphics;
            g.SmoothingMode = SmoothingMode.HighQuality;
            g.InterpolationMode = InterpolationMode.High;
            Rectangle r = new Rectangle(new Point(-1,-1), new Size(this.Width+_radius, this.Height+_radius));
            #endregion

            #region Paint
            GraphicsPath path = new GraphicsPath();
            Rectangle rp = new Rectangle(new Point(0, 0), new Size(this.Width-1, this.Height-1)); DrawArc(rp,path);
            FillGradients(g,path);
            DrawImage(g);
            DrawString(g);
            DrawArrow(g);
            #endregion
        }

        #region Paint Methods
        public void FillGradients(Graphics gr,GraphicsPath pa)
        {
            int origin = this.Height/3; int end = this.Height; int oe = (end - origin) / 2;
            LinearGradientBrush lgbrush = null; Rectangle rect;
            if (_showbase == showbase.Yes)
            {
                Pen pen = null;
                rect = new Rectangle(new Point(0, 0), new Size(this.Width - 1, this.Height - 1));
                pa = new GraphicsPath(); 
                DrawArc(rect, pa);
                if(_mouseState==MouseState.Press || _checked || !this.Enabled) {
                    SolidBrush br = new SolidBrush(Color.FromArgb(_curA, _curR, _curG, _curB));
                    gr.FillPath(br, pa);
                    br.Dispose();
                }
                else {
                    lgbrush = new LinearGradientBrush(rect, Color.Transparent, Color.Transparent, LinearGradientMode.Vertical);

                    #region Main Gradient
                    float[] pos = new float[4];
                    pos[0] = 0.0F; pos[1] = 0.3F; pos[2] = 0.35F; pos[3] = 1.0F;
                    Color[] colors = new Color[4];
                    if(_mouseState == MouseState.Leave) {
                        colors[0] = GetColor(0, 35, 24, 9);
                        colors[1] = GetColor(0, 13, 8, 3);
                        colors[2] = Color.FromArgb(_curA, _curR, _curG, _curB);
                        colors[3] = GetColor(0, 28, 29, 14);
                    }
                    else {
                        colors[0] = GetColor(0, 0, 50, 100);
                        colors[1] = GetColor(0, 0, 0, 30);
                        colors[2] = Color.FromArgb(_curA, _curR, _curG, _curB);
                        colors[3] = GetColor(0, 0, 50, 100);
                    }
                    ColorBlend mix = new ColorBlend();
                    mix.Colors = colors;
                    mix.Positions = pos;
                    lgbrush.InterpolationColors = mix;
                    gr.FillPath(lgbrush, pa);
                }
                #endregion

#if false
                #region Fill Band
                rect = new Rectangle(new Point(0, 0), new Size(this.Width, this.Height/3));
                pa = new GraphicsPath(); int _rtemp = _radius; _radius = _rtemp - 1;
                DrawArc(rect, pa);
                if (_curA > 80)
                {
                    SolidBrush br = new SolidBrush(Color.FromArgb(60, 255, 255, 255));
                    gr.FillPath(br, pa);
                    br.Dispose();
                }
                _radius = _rtemp;
                #endregion
#endif
                #region SplitFill
                if (_splitbutton == splitbutton.Yes & _mouseState!=MouseState.Leave)
                {
                    FillSplit(gr);
                }
                #endregion

                #region Shadow
                pen = null;
                if (_mouseState == MouseState.Press || _checked)
                {
                    rect = new Rectangle(1, 1, this.Width-2, this.Height-2);
                    pa = new GraphicsPath();
                    DrawShadow(rect, pa);
                    pen = new Pen(Color.FromArgb(50, 20, 20, 20),2.0F);
                    gr.DrawPath(pen, pa);
                }
                else
                {
                    rect = new Rectangle(1, 1, this.Width - 2, this.Height-1);
                    pa = new GraphicsPath();
                    DrawShadow(rect, pa);
                    if (_curA > 80)
                    {
                        pen = new Pen(Color.FromArgb(100, 250, 250, 250), 3.0F);
                        gr.DrawPath(pen, pa);
                    }
                }
                if(pen!=null) { pen.Dispose(); pen = null; }
                #endregion

                //Focus
                if(this.Focused) {
                    pen = new Pen(Color.FromArgb(50, 20, 20, 20), 1.0F);
                    pen.DashStyle = DashStyle.Dot;
                    rect = new Rectangle(4, 4, this.Width-8, this.Height-8);
                    gr.DrawRectangle(pen, rect);
                    pen.Dispose();
                }


                #region SplitLine

                pen = null;
                if (_splitbutton == splitbutton.Yes)
                {
                    if (_imagelocation == imagelocation.Top)
                    {
                        switch (_mouseState)
                        {
                            case MouseState.Enter:
                                pen = new Pen(_onStroke);
                                gr.DrawLine(pen, new Point(1, this.Height - _splitdistance), new Point(this.Width-1, this.Height - _splitdistance));
                                break;
                            case MouseState.Press:
                                pen = new Pen(_pressStroke);
                                gr.DrawLine(pen, new Point(1, this.Height - _splitdistance), new Point(this.Width - 1, this.Height -_splitdistance));
                                break;
                            default:
                                break;
                        }
                    }
                    else if (_imagelocation == imagelocation.Left)
                    {
                        switch (_mouseState)
                        {
                            case MouseState.Enter:
                                pen = new Pen(_onStroke);
                                gr.DrawLine(pen, new Point(this.Width - _splitdistance, 0), new Point(this.Width - _splitdistance, this.Height));
                                break;
                            case MouseState.Press:
                                pen = new Pen(_pressStroke);
                                gr.DrawLine(pen, new Point(this.Width - _splitdistance, 0), new Point(this.Width - _splitdistance, this.Height));
                                break;
                            default:
                                break;
                        }     
                    }

                }
                if(pen!=null) { pen.Dispose(); pen=null; }
                #endregion

                rect = new Rectangle(new Point(0, 0), new Size(this.Width - 1, this.Height - 1));
                pa = new GraphicsPath();
                DrawArc(rect, pa);
                pen = new Pen(_colorStroke, 0.9F);
                gr.DrawPath(pen, pa);
                pen.Dispose();

                pa.Dispose();
                if(lgbrush!=null) lgbrush.Dispose(); 

            }
        }

        public void DrawImage(Graphics gr)
        {
            if (this.Image != null)
            {
                if(this.Enabled)
                    gr.DrawImage(this.Image, new Point((this.Width-this.Image.Width)/2, 1));
                else
                    ControlPaint.DrawImageDisabled(gr, this.Image, (this.Width-this.Image.Width)/2, 1, Color.Gray);
#if false 
                offsety = _imageoffset; offsetx = _imageoffset;
                if (_imagelocation == imagelocation.Left | _imagelocation == imagelocation.Right)
                {
                    imageheight = this.Height - offsety * 2;
                    if (imageheight > maximagesize.Y & maximagesize.Y!=0)
                    { imageheight = maximagesize.Y; }
                    imagewidth = (int)((Convert.ToDouble(imageheight) / this.Image.Height) * this.Image.Width);
                }
                else if (_imagelocation == imagelocation.Top | _imagelocation == imagelocation.Bottom)
                {
                    imagewidth = this.Width - offsetx * 2;
                    if (imagewidth > maximagesize.X & maximagesize.X != 0)
                    { imagewidth = maximagesize.X; }
                    imageheight = (int)((Convert.ToDouble(imagewidth) / this.Image.Width) * this.Image.Height);
                    
                }
                switch (_imagelocation)
                {
                    case imagelocation.Left:
                        gr.DrawImage(this.Image, new Rectangle(offsetx, offsety, imagewidth, imageheight));
                        break;
                    case imagelocation.Right:
                        gr.DrawImage(this.Image, new Rectangle(this.Width - imagewidth - offsetx, offsety, imagewidth, imageheight));
                        break;
                    case imagelocation.Top:
                        offsetx = this.Width / 2 - imagewidth / 2;
                        gr.DrawImage(this.Image, new Rectangle(offsetx, offsety, imagewidth, imageheight));
                        break;
                    case imagelocation.Bottom:
                        gr.DrawImage(this.Image, new Rectangle(offsetx, this.Height - imageheight - offsety, imagewidth, imageheight));
                        break;
                    default:
                        break;
                }
#endif
            }
        }

        public void DrawString(Graphics gr)
        {
            if (this.Text != "")
            {
                SizeF szf = gr.MeasureString(this.Text,this.Font);
                int textwidth = (int) szf.Width;
                int textheight = (int) szf.Height;


                #region Calc Color Brightness
                RibbonColor __color = new RibbonColor(Color.FromArgb(_curR, _curG, _curB));
                RibbonColor forecolor = new RibbonColor(this.ForeColor);
                Color _forecolor;
                
                if (__color.GetBrightness() > 50)
                {
                    forecolor.BC = 1;
                    forecolor.SC = 80;
                }
                else
                {
                    forecolor.BC = 99;
                    forecolor.SC = 20;
                }
                _forecolor = forecolor.GetColor();
                #endregion

                Brush fore_brush = new SolidBrush(this.Enabled? _forecolor : Color.Gray);
                int offsety; 
                
                if(this.Image!=null)
                    offsety = this.Image.Height;
                else
                    offsety = ContentAlignmentToY(this.TextAlign, textheight);

                if(_checked || _mouseState==MouseState.Press) offsety++;
                gr.DrawString(this.Text, this.Font, fore_brush, new PointF((this.Width - textwidth) / 2 , offsety));
#if false
                switch (_imagelocation)
                {
                    case imagelocation.Left:
                        if (this.Title != "")
                        {
                            gr.DrawString(this.Title, fontb, fore_brush, new PointF(offsetx + imagewidth + 4, this.Font.Size / 2));
                            gr.DrawString(this.Text, this.Font, fore_brush, new PointF(offsetx + imagewidth + 4, 2 * this.Font.Size + 1));
                        }
                        else
                        {
                            gr.DrawString(this.Text, this.Font, fore_brush, new PointF(offsetx + imagewidth + 4, this.Height / 2 - this.Font.Size + 1));
                        }

                        break;
                    case imagelocation.Right:
                        gr.DrawString(this.Title, fontb, fore_brush, new PointF(offsetx, this.Height / 2 - this.Font.Size + 1 - extraoffset));
                        gr.DrawString(this.Text, this.Font, fore_brush, new PointF(offsetx, extraoffset + this.Height / 2 - this.Font.Size + 1));
                        break;
                    case imagelocation.Top:
                        break;
                    case imagelocation.Bottom:
                        gr.DrawString(this.Text, this.Font, fore_brush, new PointF(this.Width / 2 - textwidth / 2 - 1, this.Height - imageheight - textheight - 1));
                        break;
                    default:
                        break;
                }
#endif
                fore_brush.Dispose();
                
            }
        }
        private int ContentAlignmentToY(ContentAlignment a, int textheight) {
            if(a==ContentAlignment.MiddleCenter || a==ContentAlignment.MiddleLeft || a==ContentAlignment.MiddleRight)
                return (this.Height-textheight)/2;
            else if(a==ContentAlignment.BottomCenter || a==ContentAlignment.BottomLeft || a==ContentAlignment.BottomRight)
                return this.Height-2-textheight;
            else //top
                return 2;
        }

        public void DrawArc(Rectangle re,GraphicsPath pa)
        {
            int _radiusX0Y0 = _radius, _radiusXFY0 = _radius, _radiusX0YF = _radius, _radiusXFYF = _radius;
            switch (_grouppos)
            {
                case groupPos.Left:
                    _radiusXFY0 = 1; _radiusXFYF = 1;
                break;
                case groupPos.Center:
                _radiusX0Y0 = 1; _radiusX0YF = 1; _radiusXFY0 = 1; _radiusXFYF = 1;
                break;
                case groupPos.Right:
                _radiusX0Y0 = 1; _radiusX0YF = 1;
                break;
                case groupPos.Top:
                _radiusX0YF = 1; _radiusXFYF = 1;
                break;
                case groupPos.Bottom:
                _radiusX0Y0 = 1; _radiusXFY0 = 1;
                break;
            }
            pa.AddArc(re.X, re.Y, _radiusX0Y0, _radiusX0Y0, 180, 90);
            pa.AddArc(re.Width - _radiusXFY0, re.Y, _radiusXFY0, _radiusXFY0, 270, 90);
            pa.AddArc(re.Width - _radiusXFYF, re.Height - _radiusXFYF, _radiusXFYF, _radiusXFYF, 0, 90);
            pa.AddArc(re.X, re.Height - _radiusX0YF, _radiusX0YF, _radiusX0YF, 90, 90);
            pa.CloseFigure();

        }

        public void DrawShadow(Rectangle re, GraphicsPath pa)
        {
            int _radiusX0Y0 = _radius, _radiusXFY0 = _radius, _radiusX0YF = _radius, _radiusXFYF = _radius;
            switch (_grouppos)
            {
                case groupPos.Left:
                    _radiusXFY0 = 1; _radiusXFYF = 1;
                    break;
                case groupPos.Center:
                    _radiusX0Y0 = 1; _radiusX0YF = 1; _radiusXFY0 = 1; _radiusXFYF = 1;
                    break;
                case groupPos.Right:
                    _radiusX0Y0 = 1; _radiusX0YF = 1;
                    break;
                case groupPos.Top:
                    _radiusX0YF = 1; _radiusXFYF = 1;
                    break;
                case groupPos.Bottom:
                    _radiusX0Y0 = 1; _radiusXFY0 = 1;
                    break;
            }
            pa.AddArc(re.X, re.Y, _radiusX0Y0, _radiusX0Y0, 180, 90);
            pa.AddArc(re.Width - _radiusXFY0, re.Y, _radiusXFY0, _radiusXFY0, 270, 90);
            pa.AddArc(re.Width - _radiusXFYF, re.Height - _radiusXFYF, _radiusXFYF, _radiusXFYF, 0, 90);
            pa.AddArc(re.X, re.Height - _radiusX0YF, _radiusX0YF, _radiusX0YF, 90, 90);
            pa.CloseFigure();

        }

        public void DrawArrow(Graphics gr)
        {
#if false
            int _size = 1;

            RibbonColor __color = new RibbonColor(Color.FromArgb(R0, G0, B0));
            RibbonColor forecolor = new RibbonColor(this.ForeColor);
            Color _forecolor;

            if (__color.GetBrightness() > 50)
            {
                forecolor.BC = 1;
                forecolor.SC = 80;
            }
            else
            {
                forecolor.BC = 99;
                forecolor.SC = 20;
            }
            _forecolor = forecolor.GetColor();
            
            switch (_arrow)
            {
                case arrow.ToDown:
                    if (_imagelocation == imagelocation.Left)
                    {
                        Point[] points = new Point[3];
                        points[0] = new Point(this.Width - 8 * _size - _imageoffset, this.Height / 2 - _size / 2);
                        points[1] = new Point(this.Width - 2 * _size - _imageoffset, this.Height / 2 - _size / 2);
                        points[2] = new Point(this.Width - 5 * _size - _imageoffset, this.Height / 2 + _size * 2);
                        gr.FillPolygon(new SolidBrush(_forecolor), points);
                    }
                    else if (_imagelocation == imagelocation.Top)
                    {
                        Point[] points = new Point[3];
                        points[0] = new Point(this.Width/2 + 8 * _size - _imageoffset, this.Height - _imageoffset - 5*_size );
                        points[1] = new Point(this.Width/2 + 2 * _size - _imageoffset, this.Height - _imageoffset - 5* _size );
                        points[2] = new Point(this.Width/2 + 5 * _size - _imageoffset, this.Height - _imageoffset - 2*_size);
                        gr.FillPolygon(new SolidBrush(_forecolor), points);
                    }
                    break;
                case arrow.ToRight:
                    if (_imagelocation == imagelocation.Left)
                    {
                        int arrowxpos = this.Width - _splitdistance + 2*_imageoffset;
                        Point[] points = new Point[3];
                        points[0] = new Point(arrowxpos + 4, this.Height / 2 - 4 * _size);
                        points[1] = new Point(arrowxpos + 8, this.Height / 2);
                        points[2] = new Point(arrowxpos + 4, this.Height / 2 + 4 * _size);
                        gr.FillPolygon(new SolidBrush(_forecolor), points);
                    }
                    break;
                default:
                    break;
            }
#endif
        }

        public void FillSplit(Graphics gr)
        {
            Color _tranp = Color.FromArgb(200, 255, 255, 255);
            int x1 = this.Width - _splitdistance; int x2 = 0;
            int y1 = this.Height - _splitdistance; int y2=0;
            SolidBrush btransp = new SolidBrush(_tranp);
            #region Horizontal
            if (_imagelocation == imagelocation.Left && _mouseState!=MouseState.Leave)
            {
                    if (xmouse < this.Width - _splitdistance) //Small button
                    {
                        Rectangle _r = new Rectangle(x1 + 1, 1, this.Width - 2, this.Height - 1);
                        GraphicsPath p = new GraphicsPath();
                        int _rtemp = _radius; _radius = 4;
                        DrawArc(_r, p);
                        _radius = _rtemp;
                        gr.FillPath(btransp, p);
                        
                    }
                    else //Big Button
                    {
                        Rectangle _r = new Rectangle(x2 + 1, 1, this.Width - _splitdistance-1, this.Height - 1);
                        GraphicsPath p = new GraphicsPath();
                        int _rtemp = _radius; _radius = 4; 
                        DrawArc(_r, p);
                        _radius = _rtemp;
                        gr.FillPath(btransp, p);
                    }
               
            }
            #endregion

            #region Vertical
            else if (_imagelocation == imagelocation.Top && _mouseState!=MouseState.Leave)
            {
                    if (ymouse < this.Height - _splitdistance) //Small button
                    {
                        Rectangle _r = new Rectangle(1, y1 + 1, this.Width - 1, this.Height - 1);
                        GraphicsPath p = new GraphicsPath();
                        int _rtemp = _radius; _radius = 4;
                        DrawArc(_r, p);
                        _radius = _rtemp;
                        gr.FillPath(btransp, p);
                    }
                    else //Big Button
                    {
                        Rectangle _r = new Rectangle(1, y2 + 1, this.Width - 1, this.Height - _splitdistance - 1);
                        GraphicsPath p = new GraphicsPath();
                        int _rtemp = _radius; _radius = 4;
                        DrawArc(_r, p);
                        _radius = _rtemp;
                        gr.FillPath(btransp, p);
                    }
                }
            #endregion
            btransp.Dispose();

        }
        #endregion

        #region About Fading
        private Timer _timer = new Timer();
        int i_factor = 35;
        public int FadingSpeed
        {
            get { return i_factor; }
            set
            {
                if (value > -1)
                {
                    i_factor = value;
                }
            }
        }

        int i_fR = 1; int i_fG = 1; int i_fB = 1; int i_fA = 1;
        void OnTimerTick(object sender, EventArgs e) {
            AdjustColor();
            this.Invalidate();
        }
        #endregion        
        private void AdjustColor() {
            #region Entering
            if(_mouseState == MouseState.Enter) {
                Color target_col = _checked? _checkedOnColor : _onColor;
                if(Math.Abs(target_col.R - _curR) > i_factor) { i_fR = i_factor; }
                else { i_fR = 1; }
                if(Math.Abs(target_col.G - _curG) > i_factor) { i_fG = i_factor; }
                else { i_fG = 1; }
                if(Math.Abs(target_col.B - _curB) > i_factor) { i_fB = i_factor; }
                else { i_fB = 1; }

                if(target_col.R < _curR) {
                    _curR -= i_fR;
                }
                else if(target_col.R > _curR) {
                    _curR += i_fR;
                }

                if(target_col.G < _curG) {
                    _curG -= i_fG;
                }
                else if(target_col.G > _curG) {
                    _curG += i_fG;
                }

                if(target_col.B < _curB) {
                    _curB -= i_fB;
                }
                else if(target_col.B > _curB) {
                    _curB += i_fB;
                }

                if(target_col == Color.FromArgb(_curR, _curG, _curB)) {
                    _timer.Stop();
                }
                else {
                    this.Invalidate();
                }
            }
            #endregion

            #region Leaving
            if(_mouseState == MouseState.Leave) {
                Color target_col = _checked? _checkedColor : _baseColor;
                if(Math.Abs(target_col.R - _curR) < i_factor) { i_fR = 1; }
                else { i_fR = i_factor; }
                if(Math.Abs(target_col.G - _curG) < i_factor) { i_fG = 1; }
                else { i_fG = i_factor; }
                if(Math.Abs(target_col.B - _curB) < i_factor) { i_fB = 1; }
                else { i_fB = i_factor; }
                if(Math.Abs(target_col.A - _curA) < i_factor) { i_fA = 1; }
                else { i_fA = i_factor; }

                if(target_col.R < _curR) {
                    _curR -= i_fR;
                }
                else if(target_col.R > _curR) {
                    _curR += i_fR;
                }
                if(target_col.G < _curG) {
                    _curG -= i_fG;
                }
                else if(target_col.G > _curG) {
                    _curG += i_fG;
                }
                if(target_col.B < _curB) {
                    _curB -= i_fB;
                }
                else if(target_col.B > _curB) {
                    _curB += i_fB;
                }
                if(target_col.A < _curA) {
                    _curA -= i_fA;
                }
                else if(target_col.A > _curA) {
                    _curA += i_fA;
                }

                if(target_col == Color.FromArgb(_curA, _curR, _curG, _curB)) {
                    _timer.Stop();

                }
                else {

                    this.Invalidate();
                }

            }
            #endregion
        }


        #region Mouse Events
        private enum MouseState {
            Enter, Leave, Press
        }
        private MouseState _mouseState;
        int xmouse = 0, ymouse = 0;
        protected override void OnMouseEnter(EventArgs e)
        {
            base.OnMouseEnter(e);
            _colorStroke = ColorOnStroke;
            _mouseState = MouseState.Enter;
            _curA = 200;
            if(i_factor == 0)
            {
                Color target_col = _checked? _checkedOnColor : _onColor;
                _curR = target_col.R; _curG = target_col.G; _curB = target_col.B;
            }
            _timer.Start();
        }

        protected override void OnMouseLeave(EventArgs e)
        {
            base.OnMouseLeave(e);
            OnMouseLeaveMain();
        }
        private void OnMouseLeaveMain() {
            _colorStroke = ColorBaseStroke;
            _mouseState = MouseState.Leave;
            if(i_factor == 0) {
                Color target_col = _checked? _checkedColor : _baseColor;
                _curR = target_col.R; _curG = target_col.G; _curB = target_col.B;
            }
            _timer.Stop();
            _timer.Start();
            Invalidate();
        }

        protected override void OnMouseDown(MouseEventArgs mevent)
        {
            base.OnMouseDown(mevent);
            _curR = ColorPress.R; _curG = ColorPress.G; _curB = ColorPress.B;
            _colorStroke = ColorPressStroke;
            _mouseState = MouseState.Press;
            xmouse = PointToClient(Cursor.Position).X;
            ymouse = PointToClient(Cursor.Position).Y;
            this.Invalidate();
        }

        protected override void OnMouseUp(MouseEventArgs mevent)
        {
            base.OnMouseUp(mevent);
            if(_mouseState==MouseState.Press) {
                Color target_col = _checked? _checkedColor : _onColor;
                _curR = target_col.R; _curG = target_col.G; _curB = target_col.B;
                _colorStroke = ColorOnStroke;
                _mouseState = MouseState.Enter;
                this.Invalidate();
            }
            #region ClickSplit
            if (_imagelocation == imagelocation.Left & xmouse > this.Width - _splitdistance & _splitbutton == splitbutton.Yes)
            {
                if (_arrow == arrow.ToDown)
                {
                    if (this.ContextMenuStrip != null)
                        this.ContextMenuStrip.Opacity = 1.0;
                        this.ContextMenuStrip.Show(this,0,this.Height);

                }
                else if (_arrow == arrow.ToRight)
                {
                     if (this.ContextMenuStrip != null)
                     {
                         ContextMenuStrip menu = this.ContextMenuStrip;
                         this.ContextMenuStrip.Opacity = 1.0;
                         //!!
                         //RibbonMenuShadow shadow = new RibbonMenuShadow();
                         //shadow.Show();
                         //menu.Show(this, this.Width, -this.Height);
                     }

                }
            }
            else if (_imagelocation == imagelocation.Top & ymouse > this.Height - _splitdistance & _splitbutton == splitbutton.Yes)
            {
                if (_arrow == arrow.ToDown)
                {
                    if (this.ContextMenuStrip != null) 
                    this.ContextMenuStrip.Show(this, 0, this.Height);
                }
            }
            #endregion
           
            
        }


        protected override void OnMouseMove(MouseEventArgs mevent)
        {
            xmouse = PointToClient(Cursor.Position).X;
            ymouse = PointToClient(Cursor.Position).Y;
            this.Invalidate();
            base.OnMouseMove(mevent);
        }

        
        #endregion

        protected override void OnLostFocus(EventArgs e) {
            base.OnLostFocus(e);
            if(_mouseState==MouseState.Enter)
                OnMouseLeaveMain();
        }
        //NbNCxgɔăbZ[W{bNXoƂȂǁAԃNAKvȂƂ
        public void ClearMouseEnterState() {
            if(_mouseState==MouseState.Enter)
                OnMouseLeaveMain();
        }
    }
    public class RibbonColor
    {

        #region Constructors
        public RibbonColor(Color color)
        {
            rc = color.R;
            gc = color.G;
            bc = color.B;
            ac = color.A;

            HSV();

        }

        public RibbonColor(uint alpha,int hue, int saturation, int brightness)
        {
            hc = hue;
            sc = saturation;
            vc = brightness;
            ac = alpha;

            GetColor();
        }
        #endregion

        #region Alpha
        private uint ac=0; //Alpha > -1
        public uint AC { get { return ac;} set { System.Math.Min(value,255);}}
        #endregion

        #region RGB
        private int rc=0, gc=0, bc=0; //RGB Components > -1 

        public int RC { get { return rc; } set { rc= System.Math.Min(value, 255); } }
        public int GC { get { return gc; } set { gc =System.Math.Min(value, 255); } }
        public int BC { get { return bc; } set { bc = System.Math.Min(value, 255); } }

        
        public Color GetColor()
        {

            int conv;
	        double hue, sat, val;
	        int basis;

	        hue = (float)hc / 100.0f;
	        sat = (float)sc / 100.0f;
	        val = (float)vc / 100.0f;

	        if ((float)sc == 0) // Gray Colors
		    {
		        conv = (int) (255.0f * val);
                rc = gc = bc = conv;
                return Color.FromArgb((int)rc, (int)gc, (int)bc);
		    }

            basis = (int)(255.0f * (1.0 - sat) * val);

            switch ((int)((float)hc/60.0f))
		{
		case 0:
			rc = (int)(255.0f * val);
			gc = (int)((255.0f * val - basis) * (hc/60.0f) + basis);
            bc = (int)basis;
		break;

		case 1:
			rc = (int)((255.0f * val - basis) * (1.0f - ((hc%60)/ 60.0f)) + basis);
			gc = (int)(255.0f * val);
            bc = (int)basis;
		break;

		case 2:
            rc = (int)basis;
			gc = (int)(255.0f * val);
			bc = (int)((255.0f * val - basis) * ((hc%60)/60.0f) + basis);
		break;
		
		case 3:
            rc = (int)basis;
			gc = (int)((255.0f * val - basis) * (1.0f - ((hc%60) / 60.0f)) + basis);
			bc = (int)(255.0f * val);
		break;
		
		case 4:
			rc = (int)((255.0f * val - basis) * ((hc%60) / 60.0f) + basis);
            gc = (int)basis;
			bc = (int)(255.0f * val);
		break;
		
		case 5:
			rc = (int)(255.0f * val);
            gc = (int)basis;
			bc = (int)((255.0f * val - basis) * (1.0f - ((hc%60) / 60.0f)) + basis);
		break;
		}
        return Color.FromArgb((int)ac,(int)rc, (int)gc, (int)bc);
	
        }

        public uint GetRed()
        {
            return GetColor().R;
        }

        public uint GetGreen()
        {
            return GetColor().G;
        }

        public uint GetBlue()
        {
            return GetColor().B;
        }

        #endregion

        #region HSV

        private int hc = 0, sc = 0, vc = 0;

        public float HC { get { return hc; } set { hc = (int)System.Math.Min(value, 359); hc = (int)System.Math.Max(hc, 0); } }
        public float SC { get { return sc; } set { sc = (int)System.Math.Min(value, 100); sc = (int)System.Math.Max(sc, 0); } }
        public float VC { get { return vc; } set { vc = (int)System.Math.Min(value, 100); vc = (int)System.Math.Max(vc, 0); } }

        public enum C{ Red, Green, Blue,None }
        private int maxval = 0, minval = 0;
        private C CompMax, CompMin;

        private void HSV()
        {
            hc = this.GetHue();
            sc = this.GetSaturation();
            vc = this.GetBrightness();
        }
        
        public void CMax()
        {
            if (rc > gc)
            {
                if (rc < bc) { maxval = bc; CompMax = C.Blue; }
                else { maxval = rc; CompMax = C.Red; }
            }
            else
            {
                if (gc < bc) { maxval = bc; CompMax = C.Blue; }
                else { maxval = gc; CompMax = C.Green; }
            }
        }
        
        public void CMin()
        {
            bool z = CompMin==C.None; //avoid warning

            if(rc < gc)
            {
                if (rc > bc) { minval = bc; CompMin = C.Blue; }
                else { minval = rc; CompMin = C.Red; }
            }
            else
            {
                if (gc > bc) { minval = bc; CompMin = C.Blue; }
                else { minval = gc; CompMin = C.Green; }
            }
            
        }

        public int GetBrightness()  //Brightness is from 0 to 100
        {
            CMax(); return 100 * maxval/255;
        }

        public int GetSaturation() //Saturation from 0 to 100
        {
            CMax(); CMin();
            if (CompMax == C.None)
                return 0;
            else if (maxval != minval)
            {
                Decimal d_sat = Decimal.Divide(minval, maxval);
                d_sat = Decimal.Subtract(1, d_sat);
                d_sat = Decimal.Multiply(d_sat, 100);
                return Convert.ToUInt16(d_sat);
            }
            else
            {
                return 0;
            }
            
        }

        public int GetHue()
        {
            CMax(); CMin();

            if (maxval == minval)
            {
                return 0;
            }
            else if (CompMax == C.Red)
            {
                if (gc >= bc)
                {
                    Decimal d1 = Decimal.Divide((gc - bc), (maxval - minval));
                    return Convert.ToUInt16(60 * d1);
                }
                else
                {
                    Decimal d1 = Decimal.Divide((bc - gc), (maxval - minval));
                    d1 = 60 * d1;
                    return Convert.ToUInt16(360 - d1); 
                }
            }
            else if(CompMax == C.Green)
            {
                if (bc >= rc)
                {
                    Decimal d1 = Decimal.Divide((bc - rc), (maxval - minval));
                    d1 = 60 * d1;
                    return Convert.ToUInt16(120 + d1);
                }
                else
                {
                    Decimal d1 = Decimal.Divide((rc - bc), (maxval - minval));
                    d1 = 60 * d1;
                    return Convert.ToUInt16(120 - d1);
                }
                
                
            }
            else if (CompMax == C.Blue)
            {
                if (rc >= gc)
                {
                    Decimal d1 = Decimal.Divide((rc - gc), (maxval - minval));
                    d1 = 60 * d1;
                    return Convert.ToUInt16(240 + d1);
                }
                else
                {
                    Decimal d1 = Decimal.Divide((gc - rc), (maxval - minval));
                    d1 = 60 * d1;
                    return Convert.ToUInt16(240 - d1);
                }
            }
            else
            {
                return 0;
            }
        }  //Hue from 0 to 100
        
        #endregion

        #region Methods

        public bool IsDark()
        {
            if (BC > 50)
            {
                return false;
            }
            else
            {
                return true;
            }
        }

        public void IncreaseBrightness(int val)
        {
            this.VC = this.VC + val;
        
        }

        public void SetBrightness(int val)
        {
            this.VC = val;
            
        }

        public void IncreaseHue(int val)
        {
            this.HC = this.HC + val;
          
        }

        public void SetHue(int val)
        {
            this.HC = val;
        
        }

        public void IncreaseSaturation(int val)
        {
            this.SC = this.SC + val;
     
        }

        public void SetSaturation(int val)
        {
            this.SC = val;
        
        }

        public Color IncreaseHSV(int h, int s, int b)
        {
            this.HC = this.HC + h;
            this.SC = this.SC + s;
            this.VC = this.VC + b;
            return GetColor();
        }
       
        #endregion

    }
}
