/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Drawing/Fading.cs#8 $
 * $DateTime: 2007/12/28 19:23:38 $
 * 
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Diagnostics;
using System.Drawing.Imaging;

namespace Bellagio.Drawing {
    /// <summary>
    /// ̕\GtFNgŁAEBʒuĂ^CvBE[t߂̐Fς邱ƂŌ͋CoB
    /// \ƂẮȂ傫̃rbg}bvpӂĂAuVpɐ؂ʒuς邱ƂŎ
    /// 
    /// e][̕ƐF
    /// 
    /// (textColor) [_bodyWidth] (textColor) [_middleWidth] (brightColor) [_headWidth] (backColor) [_bodyWidth] (backColor)
    /// y                                                                x                        xx
    /// 
    /// [_bodyWidth̕Ƃ͒PFA͋E̐Fɍ킹ăOf[VB
    /// _bodyWidth́A\悤ƂeLXg̕\ɎełTCYłȂ΂ȂȂB
    /// 
    /// uV̊Jn_́A x 獶 y ܂ŐiނƂtF[hCAt y  x ܂ŐiނƂtF[hAEgBDrawTextprogressŎw肷B
    /// x ̂ xx gƂł邾낤B
    /// 
    /// eLXg̕\ʒu킹ĕς邱ƂłЂƑÂƂłB
    /// </summary>

    public class Fading : IDisposable {
        private int _bodyWidth;
        private int _middleWidth;
        private int _headWidth;
        private int _height;
        private Bitmap _back; //؂̈uVƂĎgp

        public Fading(int bodyWidth, int middleWidth, int height, Color backColor, Color textColor, Color brightColor) {
            _bodyWidth = bodyWidth;
            _middleWidth = middleWidth;
            _headWidth = middleWidth / 2; //oケꂭ炢
            _height = height;
            CreateBack(backColor, textColor, brightColor);
        }
        public int LimitProgress {
            get {
                return _bodyWidth + _middleWidth;
            }
        }
        public void DrawText(Graphics g, string text, float progress, Font f, float x, float y) {
            //NOTE progressɂ킹uVLbV͈̂肾
            Brush b = new TextureBrush(_back, new Rectangle(this.LimitProgress-(int)progress, 0, _bodyWidth, _height));
            g.DrawString(text, f, b, x, y);
            b.Dispose();
        }

        private void CreateBack(Color backColor, Color textColor, Color brightColor) {
            _back = new Bitmap(_bodyWidth+_middleWidth+_headWidth+_bodyWidth, _height, PixelFormat.Format24bppRgb);
            Graphics g = Graphics.FromImage(_back);
            using(Brush b = new SolidBrush(textColor)) {
                g.FillRectangle(b, 0, 0, _bodyWidth, _height);
            }
            for(int x = _bodyWidth; x < _bodyWidth + _middleWidth; x++) {
                Pen p = new Pen(DrawingUtil.ProportionalColor(textColor, brightColor, x-_bodyWidth, _middleWidth));
                g.DrawLine(p, x, 0, x, _height);
                p.Dispose();
            }
            for(int x = _bodyWidth+_middleWidth; x < _bodyWidth + _middleWidth + _headWidth; x++) {
                Pen p = new Pen(DrawingUtil.ProportionalColor(brightColor, backColor, (x - _bodyWidth - _middleWidth), _headWidth));
                g.DrawLine(p, x, 0, x, _height);
                p.Dispose();
            }
            using(Brush b = new SolidBrush(backColor)) {
                g.FillRectangle(b, _bodyWidth + _middleWidth + _headWidth, 0, _bodyWidth, _height);
            }
        }

        public void Dispose() {
            _back.Dispose();
        }
    }

    //tF[hȂłƌ^Cv
    /// e][̕ƐF
    /// 
    /// (textColor) [_bodyWidth] (textColor) [_brightWidth/2] (brightColor) [_brightWidth/2] (textColor) [_bodyWidth] (textColor)
    /// y                                                                                               x
    ///镔΂߂ɂ̂A
    public class Flicker : IDisposable {
        private int _bodyWidth;
        private int _brightWidth;
        private int _height;
        private Bitmap _back;

        public Flicker(int bodyWidth, int brightWidth, int height, Color textColor, Color brightColor) {
            _bodyWidth = bodyWidth;
            _brightWidth = brightWidth;
            _height = height;
            CreateBack(textColor, brightColor);
        }
        public int LimitProgress {
            get {
                return _bodyWidth + _brightWidth;
            }
        }
        public void DrawText(Graphics g, string text, int progress, Font f, int x, int y) {
            //NOTE progressɂ킹uVLbV͈̂肾
            Brush b = new TextureBrush(_back, new Rectangle(_bodyWidth+_brightWidth-progress, 0, _bodyWidth, _height));
            g.DrawString(text, f, b, x, y);
            b.Dispose();
        }

        private void CreateBack(Color textColor, Color brightColor) {
            _back = new Bitmap(_bodyWidth+_brightWidth+_bodyWidth, _height, PixelFormat.Format24bppRgb);
            Graphics g = Graphics.FromImage(_back);
            int skew = 5;
            using(Brush b = new SolidBrush(textColor)) {
                g.FillRectangle(b, 0, 0, _bodyWidth, _height);
                g.FillRectangle(b, _bodyWidth+_brightWidth, 0, _bodyWidth, _height);
            }
            for(int x = 0; x < _brightWidth/2; x++) {
                Pen p = new Pen(DrawingUtil.ProportionalColor(textColor, brightColor, x, _brightWidth/2-1));
                g.DrawLine(p, _bodyWidth+x+skew, 0, _bodyWidth+x-skew, _height);
                g.DrawLine(p, _bodyWidth+_brightWidth-x+skew, 0, _bodyWidth+_brightWidth-1-x-skew, _height);
                p.Dispose();
            }
        }

        public void Dispose() {
            _back.Dispose();
        }
    }
}
