/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Data/DataSubscriberHost.cs#9 $
 * $DateTime: 2008/04/17 18:20:55 $
 * 
 * 񓯊Ƀf[^󂯁Af[^pXbhP{点
 * IDataSubscriberɂ́ÃA^CĎƁAsƂBReserveExecnQ̃\bhŎsׂSubscriber肵A[NXbhsB
 * 
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Diagnostics;
using System.Windows.Forms;

using Poderosa.Util.Collections;

using Travis.Collections;
using Poderosa;

using Timer=System.Windows.Forms.Timer;
using BTime=Bellagio.Values.BTime;

namespace Bellagio.Data {
    //Subscribe̎w
    public enum SubscribeDataKind {
        None=0,
        Ticks=1,   //()
        Ita=2,     //
        Daily=4,   //
    }

    //TuXNCu邩̎wIuWFNg
    //̃NX̏͏ȂƂǂ߁AׂSubscriberHosts
    public class SubscribeRequest {
        private Stock[] _stocks;
        private SubscribeDataKind[] _kinds;

        public int Length {
            get {
                return _stocks.Length;
            }
        }

        public bool IsInterestedIn(Stock stock, SubscribeDataKind kind) {
            for(int i=0; i<_stocks.Length; i++)
                if(_stocks[i]==stock && _kinds[i]==kind) return true;

            return false;
        }
        public void GetTarget(int index, out Stock stock, out SubscribeDataKind kind) {
            stock = _stocks[index];
            kind = _kinds[index];
        }

        //PP(TICK݂̂Ȃ)
        public SubscribeRequest(Stock stock, SubscribeDataKind kind) {
            _stocks = new Stock[1] { stock };
            _kinds = new SubscribeDataKind[1] { kind };
        }
        //PQ(TICK+Ȃ)
        public SubscribeRequest(Stock stock, SubscribeDataKind kind1, SubscribeDataKind kind2) {
            _stocks = new Stock[2] { stock, stock };
            _kinds = new SubscribeDataKind[2] { kind1, kind2 };
        }
        //
        public SubscribeRequest(Stock[] stocks, SubscribeDataKind kind) {
            _stocks = stocks;
            _kinds = new SubscribeDataKind[stocks.Length];
            for(int i=0; i<_kinds.Length; i++) _kinds[i] = kind;
        }
    }

    public interface IDataSubscriber {
        //XVɃCXbhŎsׂfQ[gBSubscribeCompletěłĂ΂B
        //͍ĕ`𑣂̂ړIȂ̂ŁACEBhE쐬Oł͌Ă΂Ȃ
        DataThreadToMainThread NotifyDelegate { get; }
    }
    public interface IPeriodicalDataSubscriber : IDataSubscriber {
        //XVԊu(bP)
        int IntervalSec { get; }
        //f[^XV{́BBTime͎Ŕj󂵂ĂOK
        void PeriodicalProcess(DataProcessArg arg);
    }
    public interface IStockBasedDataSubscriber : IDataSubscriber {
        //f[^MnƂ̒ʒmBAddSubscriber̎_Ńf[^̏łĂΓɌĂ΂BłȂΌɃf[^_Ńf[^XbhɂČĂ΂B
        void SubscribeComplete();
        //TuXNCus̒ʒm
        void SubscribeFailed(string reason);
    }
    public interface IRealTimeDataSubscriber : IStockBasedDataSubscriber {
        //XṼbV邽߂̑ҋ@ԁi~bPʁAҋ@ȂƂ͂Oj
        int ThinningTime { get; }
        //̍XVɔXV
        void RealTimeProcess(DataProcessArg arg);
    }

    public delegate void DataThreadToMainThread();


    //Processn̈
    public abstract class DataProcessArg {
        public abstract BTime LocalTime { get; }
        public abstract int ProcessCount { get; }
    }

    public abstract class SubscriberHost : DataProcessArg { //p֌WɂȂĂ̂͂ƕς
        private IDataSubscriber _subscriber;
        
        //sɊւ
        protected BTime _lastProcessed;
        protected BTime _localTime;
        protected int _processCount;
        protected int _reserveTime; //~bPʂł̗\񎞍
        protected Exception _lastException; //ExecuteŋNOۑ
        protected string _errorMessage;

        public SubscriberHost(IDataSubscriber ds) {
            _subscriber = ds;
            _lastProcessed = new BTime(0);
            _localTime = new BTime(0);
            _processCount = 0;
        }
        public IDataSubscriber Subscriber {
            get {
                return _subscriber;
            }
        }
        public Exception LastException {
            get {
                return _lastException;
            }
        }
        public override int ProcessCount {
            get { return _processCount; }
        }
        public override BTime LocalTime {
            get { return _localTime; }
        }
        public int ReserveTime {
            get {
                return _reserveTime;
            }
            set {
                _reserveTime = value;
            }
        }
        public string ErrorMessage {
            get {
                return _errorMessage;
            }
            set {
                _errorMessage = value;
            }
        }

        public abstract bool ExecuteInDataThread(BTime localTime);
    }
    public abstract class StockBasedSubscriberHost : SubscriberHost {
        private IStockBasedDataSubscriber _stockBasedSubscriber;
        protected PrimaryDataStatus _status; //PrimaryDataStatusł͂Ȃenum͗pł
        private SubscribeRequest _request;
        private PrimaryDataStatus[] _dataStatus; //request̃CfbNXƘA
        protected bool _subscribeResultCalled; //{_statusƂPŊǗׂ蔲
        private int _nextSubscribeIndex; //ɃTuXNCuׂCfNXB_request.Length܂ł犮

        public StockBasedSubscriberHost(IStockBasedDataSubscriber su, SubscribeRequest req)
            : base(su) {
            _stockBasedSubscriber = su;
            _request = req;
            _dataStatus = new PrimaryDataStatus[req.Length];
            for(int i=0; i<_dataStatus.Length; i++) _dataStatus[i] = PrimaryDataStatus.Initial;
            Reset();
        }

        public IStockBasedDataSubscriber StockBasedSubscriber {
            get {
                return _stockBasedSubscriber;
            }
        }

        public bool IsReadyToExecute {
            get {
                return _request.Length==_nextSubscribeIndex;
            }
        }

        public PrimaryDataStatus Status {
            get {
                return _status;
            }
        }

        public void Reset() {
            _nextSubscribeIndex = 0;
            _status = PrimaryDataStatus.Initial;
        }
        
        public void CallSubscribeResult() {
            Debug.Assert(!_subscribeResultCalled);
            if(_errorMessage==null) {
                _stockBasedSubscriber.SubscribeComplete();
                _status = PrimaryDataStatus.OK;
            }
            else {
                _stockBasedSubscriber.SubscribeFailed(_errorMessage);
                _status = PrimaryDataStatus.Error;
            }
            _subscribeResultCalled = true;
        }
        public bool ProcessRequired(Stock stock, SubscribeDataKind datakind) {
            return _request.IsInterestedIn(stock, datakind);
        }

        public AsyncOpResult CheckCondition() {
            Debug.Assert(!this.IsReadyToExecute);

            while(!this.IsReadyToExecute) {
                Stock stock;
                SubscribeDataKind kind;
                _request.GetTarget(_nextSubscribeIndex, out stock, out kind);
                PrimaryDataStatus pds = _dataStatus[_nextSubscribeIndex];
                Debug.Assert(pds==PrimaryDataStatus.Initial || pds==PrimaryDataStatus.Preparing);
                AsyncOpResult result = CheckStockCondition(stock, kind, pds==PrimaryDataStatus.Initial, ref _errorMessage);
                //Debug.WriteLine(String.Format("{0} status={1} pds={2}", stock.Profile.Code, result.ToString(), pds.ToString()));
                if(result==AsyncOpResult.Succeeded) {
                    _dataStatus[_nextSubscribeIndex] = PrimaryDataStatus.OK;
                    _nextSubscribeIndex++; //Ȃ玟
                }
                else if(result==AsyncOpResult.Async) {
                    _dataStatus[_nextSubscribeIndex] = PrimaryDataStatus.Preparing;
                    _status = PrimaryDataStatus.Preparing;
                    return result;
                }
                else {
                    _status = PrimaryDataStatus.Error;
                    CleanupConnection();
                    return result; //񓯊s܂͎sm SubscribeKvȎA1łԎ΂Ń^[
                }
            }

            _status = PrimaryDataStatus.OK;
            return AsyncOpResult.Succeeded;
        }

        private AsyncOpResult CheckStockCondition(Stock stock, SubscribeDataKind datakind, bool open_required, ref string message) {
            Debug.Assert(datakind!=SubscribeDataKind.None);
            //DataSubscriber܂̃eXgłIntraDayTradeProviderȂǂɐڑȂƂ̂ŉς
            //TODO ̒ŗONAddRef̎csɂȂBʋN邱Ƃł͂ȂB

            //refn̂߂̃_~[
            DateBasedQuoteSet qs = null;
            IntraDayTrade dt = null;
            LightIntraDayTrade lt = null;
            RealtimeIta ita = null;

            if(open_required) {
                switch(datakind) {
                    case SubscribeDataKind.Daily:
                        return BellagioRoot.DateBasedQuoteProvider.Open(stock, ref qs, ref message);
                    case SubscribeDataKind.Ita:
                        return BellagioRoot.ItaProvider.Open(stock, ref ita, ref message);
                    case SubscribeDataKind.Ticks:
                        if(stock.Profile is MarketIndex)
                            return BellagioRoot.LightIntraDayTradeProvider.Open(stock, ref lt, ref message);
                        else
                            return BellagioRoot.IntraDayTradeProvider.Open(stock, ref dt, ref message);
                    default:
                        Debug.Assert(false);
                        return AsyncOpResult.Failed;
                }
            }
            else {
                switch(datakind) {
                    case SubscribeDataKind.Daily:
                        return SPD2AsyncOp(BellagioRoot.DateBasedQuoteProvider.Lookup(stock));
                    case SubscribeDataKind.Ita:
                        return SPD2AsyncOp(BellagioRoot.ItaProvider.Lookup(stock));
                    case SubscribeDataKind.Ticks:
                        if(stock.Profile is MarketIndex)
                            return SPD2AsyncOp(BellagioRoot.LightIntraDayTradeProvider.Lookup(stock));
                        else
                            return SPD2AsyncOp(BellagioRoot.IntraDayTradeProvider.Lookup(stock));
                    default:
                        Debug.Assert(false);
                        return AsyncOpResult.Failed;
                }
            }
        }
        private static AsyncOpResult SPD2AsyncOp(StockPrimaryData pd) {
            return pd==null? AsyncOpResult.Async : AsyncOpResult.Succeeded;
        }

        //ڑĂ̂ΏۂɁAڑ؂ɂ
        public void CleanupConnection() {
            for(int i=0; i<_nextSubscribeIndex; i++) {
                Stock stock;
                SubscribeDataKind kind;
                _request.GetTarget(i, out stock, out kind);
                CleanupStockConnection(stock, kind);
            }

            _nextSubscribeIndex = 0; //ĂCleanupConnectionԂĂv
            for(int i=0; i<_dataStatus.Length; i++) _dataStatus[i] = PrimaryDataStatus.Initial;
        }
        private void CleanupStockConnection(Stock stock, SubscribeDataKind datakind) {
            Debug.Assert(datakind!=SubscribeDataKind.None);

            switch(datakind) {
                case SubscribeDataKind.Daily:
                    BellagioRoot.DateBasedQuoteProvider.Release(stock);
                    break;
                case SubscribeDataKind.Ita:
                    BellagioRoot.ItaProvider.Release(stock);
                    break;
                case SubscribeDataKind.Ticks:
                    if(stock.Profile is MarketIndex)
                        BellagioRoot.LightIntraDayTradeProvider.Release(stock);
                    else
                        BellagioRoot.IntraDayTradeProvider.Release(stock);
                    break;
                default:
                    Debug.Assert(false);
                    break;
            }

        }

    }
    public class RealTimeSubscriberHost : StockBasedSubscriberHost {
        private IRealTimeDataSubscriber _realTimeSubscriber;

        public RealTimeSubscriberHost(IRealTimeDataSubscriber su, SubscribeRequest req)
            : base(su, req) {
            _realTimeSubscriber = su;
        }

        public void SetErrorStatus(string msg) {
            _errorMessage = msg;
            _status = PrimaryDataStatus.Error;
        }


        public override bool ExecuteInDataThread(BTime localTime) {
            _localTime.LetInt(localTime.AsInt());

            if(!_subscribeResultCalled) {
                CallSubscribeResult();
            }
            if(_status!=PrimaryDataStatus.OK) return true;

            try {
                if(_errorMessage==null)
                    _realTimeSubscriber.RealTimeProcess(this);
            }
            catch(Exception ex) {
                Debug.WriteLine(ex.Message);
                Debug.WriteLine(ex.StackTrace);
                _lastException = ex;
                throw ex;
            }
            finally {
                _lastProcessed.LetInt(localTime.AsInt());
                _processCount++;
            }
            return false;
        }
    }
    public class PeriodicalSubscriberHost : SubscriberHost {
        private IPeriodicalDataSubscriber _periodicalSubscriber;
        private BTime _nextPreferableTime; //sɓK؂Ȏ

        public PeriodicalSubscriberHost(IPeriodicalDataSubscriber su)
            : base(su) {
            _periodicalSubscriber = su;
            _nextPreferableTime = new BTime(0);
        }
        public override bool ExecuteInDataThread(BTime localTime) {
            _localTime.LetInt(localTime.AsInt());
            try {
                _periodicalSubscriber.PeriodicalProcess(this);
            }
            catch(Exception ex) {
                //RuntimeUtil.ReportException(ex);
                _lastException = ex;
                throw ex;
            }
            finally {
                _lastProcessed.LetInt(localTime.AsInt());
                _processCount++;

                //s̎
                int interval = _periodicalSubscriber.IntervalSec;
                Debug.Assert(interval!=0);
                int t = localTime.AsInt() + interval;
                t -= t % interval; //Ƃ΂PƂɍXVƂāA9:00:30ɋN̎sȂΎ9:01:00B܂ԊuŊ]̂ĂB

                _nextPreferableTime.LetInt(t);
            }

            return false;
        }

        public bool ProcessRequired(BTime current) {
            if(_lastException!=null) return false;

            if(_processCount==0) return true; //͕K

            int lt = _nextPreferableTime.AsInt();
            return lt <= current.AsInt();

        }
    }
}
