/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Common/TimerTests.cs#6 $
 * $DateTime: 2007/10/25 12:56:12 $
 * 
 */
#if UNITTEST
using System;
using System.Collections.Generic;
using System.Text;

using NUnit.Framework;

namespace Sansa.Runtime {

    //^C}[̃eXgB{̂Hermesɂ邪ANUniteXgDemeterɏWĂ̂

    [TestFixture]
    public class TimerTests : IPlatformBridge {


        private RootTimer _rootTimer;
        private bool _started;
        private bool _finished;
        private StringBuilder _bld;

        [TestFixtureSetUp]
        public void SetUp() {
            _rootTimer = new RootTimer(0);
        }

        private void tick() {
            _rootTimer.tickForTest();
        }
        private void RecordTick(int value) {
            if(_bld.Length > 0) _bld.Append(',');
            _bld.Append(value.ToString());
        }
        private void Reset() {
            _bld = new StringBuilder();
            _started = false;
            _finished = false;
        }

        public RootTimer getRootTimer() {
            return _rootTimer;
        }

        public Object getAdapter(Type klass) {
            return null; //not used
        }
        public void invalidate(int x, int y, int width, int height) {

        }


        //^C}[̈ sleep, interval, initial, final, length̏
        [Test]
        public void IntTest1() {
            Reset();
            //ł悤ȉ
            IntTimer t = null;
            t = new IntTimer(this, new DTimerHandler(
                delegate() { t.reset(0, 1, 0, 3, 3, false); },
                delegate() { RecordTick(t.value()); })
                .SetEnd(delegate() { _finished = true; }));

            Assert.AreEqual(0, _rootTimer.getTimerCount());
            t.Initialize();
            Assert.AreEqual(1, _rootTimer.getTimerCount());
            int count = 0;
		    while(!_finished) {
			    tick();
			    count++;
		    }
    		
		    Assert.AreEqual(3, count);
		    Assert.AreEqual("0,1,2,3", _bld.ToString());
            Assert.AreEqual(0, _rootTimer.getTimerCount());
            //TimerCount͈ȉȂ̂ŃXLbv
        }
	
	    [Test]
        public void IntTest2() {
            Reset();
            IntTimer t = null;
            t = new IntTimer(this, new DTimerHandler(
                 delegate() { t.reset(3, 2, 1, 2, 1, false); },
                 delegate() { RecordTick(t.value()); })
                 .SetStart(delegate() { _started = true; })
                 .SetEnd(delegate() { _finished = true; }));

            t.Initialize();
            int count = 0;
            while(!_finished) {
                tick();
			    count++;
			    if(count<3)
				    Assert.IsFalse(_started);
			    else
				    Assert.IsTrue(_started);
		    }
    		
		    Assert.AreEqual(5, count); //ŏ3x, C^[o21,2Ȃ̂
		    Assert.AreEqual("1,2", _bld.ToString());
	    }

    	[Test]
        public void IntTest3() {
            Reset();
            IntTimer t = null;
            t = new IntTimer(this, new DTimerHandler(
                 delegate() { t.reset(5, 4, -2, 2, 4, false); },
                 delegate() { RecordTick(t.value()); })
                 .SetEnd(delegate() { _finished = true; }));

            t.Initialize();
            int count = 0;
            while(!_finished) {
                tick();
			    count++;
		    }
    		
		    Assert.AreEqual(21, count); //ŏ5x, C^[o4-22Ȃ̂
		    Assert.AreEqual("-2,-1,0,1,2", _bld.ToString());
	    }

    	[Test]
        public void IntTest4() {
            Reset();
            IntTimer t = null;
            t = new IntTimer(this, new DTimerHandler(
                 delegate() { t.reset(0, 1, -2, 2, 2, false); },
                 delegate() { RecordTick(t.value()); })
                 .SetEnd(delegate() { _finished = true; }));

            t.Initialize();
            int count = 0;
            while(!_finished) {
                tick();
                count++;
            }
    		
		    Assert.AreEqual(2, count); 
		    Assert.AreEqual("-2,0,2", _bld.ToString());
	    }

    	[Test]
        public void IntTest5() {
            Reset();
            IntTimer t = null;
            t = new IntTimer(this, new DTimerHandler(
                 delegate() { t.reset(0, 1, 0, 100, 6, false); },
                 delegate() { RecordTick(t.value()); })
                 .SetEnd(delegate() { _finished = true; }));

            t.Initialize();
            int count = 0;
            while(!_finished) {
                tick();
                count++;
            }
    		
		    Assert.AreEqual(6, count); 
		    Assert.AreEqual("0,17,33,50,67,83,100", _bld.ToString()); //ľܓ
	    }

	    [Test]
        public void IntTest6() {
            Reset();
            IntTimer t = null;
            t = new IntTimer(this, new DTimerHandler(
                 delegate() { t.reset(0, 1, 0, -100, 6, false); },
                 delegate() { RecordTick(t.value()); })
                 .SetEnd(delegate() { _finished = true; }));

            t.Initialize();
            int count = 0;
            while(!_finished) {
                tick();
                count++;
            }
    		
		    Assert.AreEqual(6, count); 
		    Assert.AreEqual("0,-17,-33,-50,-67,-83,-100", _bld.ToString());
	    }
	
    	//
	    [Test]
        public void IntTest7() {
            Reset();
            IntTimer t = null;
            t = new IntTimer(this, new DTimerHandler(
                 delegate() { t.reset(1, 1, 5, 8, 3, false); },
                 delegate() { RecordTick(t.value()); }));

            t.Initialize();
		    Assert.IsTrue(t.IsSleeping());
		    Assert.IsTrue(t.IsAlive());
		    Assert.IsFalse(t.IsActive());
		    Assert.AreEqual(5, t.value()); //^l̂܂
    		
		    tick();
		    Assert.IsFalse(t.IsSleeping());
		    Assert.IsTrue(t.IsAlive());
		    Assert.IsTrue(t.IsActive());
		    Assert.AreEqual(5, t.value());
    		
		    tick();
		    Assert.AreEqual(6, t.value());
		    tick();
		    Assert.AreEqual(7, t.value());
    		
		    tick(); //ŏÎ͂
		    Assert.IsFalse(t.IsSleeping());
		    Assert.IsTrue(t.IsDead());
		    Assert.IsFalse(t.IsActive());
		    Assert.AreEqual(8, t.value());
    		
		    tick(); //NȂ
		    Assert.IsFalse(t.IsSleeping());
		    Assert.IsTrue(t.IsDead());
		    Assert.IsFalse(t.IsActive());
		    Assert.AreEqual(8, t.value());
	    }

        [Test]
        public void IntTest8() {
            //[v
            Reset();
            IntTimer t = null;
            t = new IntTimer(this, new DTimerHandler(
                 delegate() { t.reset(0, 1, -1, 1, 2, true); },
                 delegate() { RecordTick(t.value()); }));

            t.Initialize();
            Assert.AreEqual(-1, t.value());
            tick();
            Assert.AreEqual(0, t.value());
            tick();
            Assert.AreEqual(-1, t.value());
            tick();
            Assert.AreEqual(0, t.value());
            tick();
            Assert.AreEqual(-1, t.value());
        }
	
	
    }
}
#endif
