/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Common/IconList.cs#8 $
 * $DateTime: 2007/12/28 19:33:36 $
 */

using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Diagnostics;
using System.Resources;

namespace Bellagio.Common {
    //Bellagioł́AACR͊֘Âɕׂgift@Cx[XŊǗBKɐ؂Ē񋟂@\NXB
    public class IconList {
        private Bitmap _image;
        private Bitmap[,] _icons; //א؂(x])
        private Size _size; //PACR̃TCY
        private int _countX; //(X)
        private int _countY; //(Y)
        
        public IconList(string resourceName, string imageName, int width, int height) {
            _size = new Size(width, height);

            ResourceManager rm = new ResourceManager(resourceName, typeof(IconList).Assembly);
            _image = (Bitmap)rm.GetObject(imageName);

            //ȉTsPNGT|[gɂ
            Bitmap result = new Bitmap(_image.Width, _image.Height, System.Drawing.Imaging.PixelFormat.Format32bppArgb);
            Graphics g = Graphics.FromImage(result);
            g.DrawImage(_image, 0, 0, result.Width, result.Height);
            g.Dispose();
            _image = result;


            _countX = _image.Width / width;
            _countY = _image.Height / height;
            Debug.Assert(_countX>0);
            Debug.Assert(_countY>0);
            _icons = new Bitmap[_countX, _countY];
        }

        public Bitmap GetBitmap(int x, int y) {
            Debug.Assert(x>=0 && x<_countX);
            Debug.Assert(y>=0 && y<_countY);

            Bitmap t = _icons[x, y];
            if(t==null) {
                t = new Bitmap(_size.Width, _size.Height, System.Drawing.Imaging.PixelFormat.Format32bppArgb);
                Graphics g = Graphics.FromImage(t);
                float hr = 1.0F;//
                float vr = 1.0F;// _image.VerticalResolution;
                g.DrawImage(_image, 0F, 0F, new RectangleF(x * _size.Width / hr, y * _size.Height / vr, _size.Width / hr, _size.Height / vr), GraphicsUnit.Pixel);
                g.Dispose();

                _icons[x, y] = t;
            }

            return t;
        }

        //ɕ񂾂擾
        public Bitmap GetBitmap(int index) {
            return GetBitmap(index, 0);
        }

        public Size IconSize {
            get {
                return _size;
            }
        }
    }
}
