/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Chart/StaticChartSession.cs#18 $
 * $DateTime: 2008/05/14 13:05:12 $
 * A^CXVł͂Ȃ`[gBȂǁB͂ȂB
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;

using Bellagio.Data;
using Bellagio.Values;
using Bellagio.Drawing;
using Bellagio.Forms;
using Bellagio.Environment;
using Travis.ORT;
using Travis.LocationOperation;

using Poderosa;
using Poderosa.Forms;
using Poderosa.Preferences;
using Poderosa.Commands;
using Poderosa.Plugins;
using Poderosa.Sessions;

namespace Bellagio.Chart {
    //ÓIf[^ɂ`[g\


    //staticf[^pZbV
    public class StaticChartDocument : ChartDocumentBase, IRealTimeDataSubscriber {
        private Quote _quote;
        private Quote.QuoteUnit _unit; //ETÊǂꂩ
        private ChartSectionInfo _sectionInfo;
        private BDate _for_label_cond; //x

        public StaticChartDocument(Quote.QuoteUnit unit)
            : base() {
            _unit = unit;
            //DailyłĂĂƂ͘AP{B̈̂IndicatorSet̂Ƃ͂̌ł͂Ȃ
            _for_label_cond = new BDate(0);
            Init(null);
        }
        public override void SetCurrentStock(Stock stock) {
            if(_stock!=null) BellagioRoot.DataSubscriberManager.RemoveSubscriber(this);
            base.SetCurrentStock(stock);
            Init(stock);
        }
        public override void Dispose() {
            if(_stock!=null) BellagioRoot.DataSubscriberManager.RemoveSubscriber(this);
            base.Dispose();
        }
        private void Init(Stock stock) {
            _sectionInfo = ChartSectionInfo.Empty;
            if(stock==null) {
                _quote = null;
                _documentStatus = BellagioDocumentStatus.Empty;
            }
            else {
                _documentStatus = BellagioDocumentStatus.Loading;
                BellagioRoot.DataSubscriberManager.AddRealtimeSubscriber(this, new SubscribeRequest(stock, SubscribeDataKind.Daily));
            }
        }

        void IStockBasedDataSubscriber.SubscribeComplete() {
            if(_stock==null) return; //TODOʂ邢

            _quote = BellagioRoot.DateBasedQuoteProvider.GetActive(_stock, _unit, BellagioRoot.FixedPreferences.Chart.ReflectSplit); //TODO fǂς
            Debug.Assert(_quote!=null); //Quote͎擾\ɂȂĂȂƂȂ
            _documentStatus = BellagioDocumentStatus.Complete;
        }
        void IStockBasedDataSubscriber.SubscribeFailed(string reason) {
            base.DefaultSubscribeFailed(reason);
        }
        int IRealTimeDataSubscriber.ThinningTime {
            get {
                return 0;
            }
        }
        void IRealTimeDataSubscriber.RealTimeProcess(DataProcessArg arg) {
            
        }
        public override int LastClosePrice {
            get {
                return _documentStatus==BellagioDocumentStatus.Complete? _quote.LastCandle.Close : 10000;
            }
        }

        public Quote Quote {
            get {
                return _quote;
            }
        }

        public override void ReloadQuote() {
            if(_stock!=null)
                _quote = BellagioRoot.DateBasedQuoteProvider.GetActive(_stock, _unit, BellagioRoot.FixedPreferences.Chart.ReflectSplit);
        }

        protected override Quote SourceQuote {
            get { return _quote; }
        }

        public override ChartSectionInfo SectionInfo {
            get {
                if(_documentStatus!=BellagioDocumentStatus.Complete) {
                    Debug.Assert(_sectionInfo.IsEmpty);
                    return _sectionInfo;
                }

                if(_sectionInfo.IsEmpty) { //쐬
                    int fl = _indicators.FutureLength;
                    if(fl==0) //̈sv
                        _sectionInfo = new ChartSectionInfo(ChartSectionType.Data, _quote.Count);
                    else
                        _sectionInfo = new ChartSectionInfo(new ChartSectionType[] { ChartSectionType.Data, ChartSectionType.Forward }, new int[] { _quote.Count, fl });
                }
                else if(_sectionInfo.FirstData.length!=_quote.Count) { //쐬ς݂f[^ς
                    _sectionInfo.UpdateLength(_sectionInfo.FirstData.index, _quote.Count);
                }
                return _sectionInfo;
            }
        }
        public override void ResetSectionInfo() {
            _sectionInfo = ChartSectionInfo.Empty;
        }

        public override Candle GetCandleAt(CHARTPOSITION position) {
            int i = position.ToDataIndexSoft();
            if(i==-1)
                return null;
            else
                return _quote.CandleAt(i);
        }
        private Candle GetCandleAtOrNull(int data_index) {
            if(data_index < 0 || data_index >= _quote.Count)
                return null;
            else
                return _quote.CandleAt(data_index);
        }
        public override int GetDateOrTimeAt(CHARTPOSITION position) {
            int i = position.ToDataIndexSoft();
            if(i==-1)
                return -1;
            else
                return _quote.CandleAt(i).Time;
        }
        public override bool GetChartPositionAt(int raw_time, out CHARTPOSITION pos) {
            int index = _quote.FindExactly(raw_time); //TODO ExactlyƓłLłȂB͈͎wŌł@\QuoteɂȂ
            if(index==-1) {
                pos = CHARTPOSITION.Empty(_sectionInfo);
                return false;
            }
            else {
                pos = _sectionInfo.GetChartPositionByData(index);
                return true;
            }
        }

        public override int GetNextDateOrTimeAt(CHARTPOSITION position) {
            int i = position.ToDataIndexSoft();
            if(i==-1)
                return -1;
            else {
                DateTime dt = BDate.ToDateTime(_quote.CandleAt(i).Time);
                if(_unit==Quote.QuoteUnit.Monthly)
                    dt = dt.AddMonths(1);
                else
                    dt = dt.AddDays(_unit==Quote.QuoteUnit.Daily? 1 : 7);
                return BDate.DateTimeToInt(dt);
            }
        }
        protected override bool AdjustEvalContext(EvalContext context, int data_index) {
            Candle y = GetCandleAtOrNull(data_index);
            context.CurrentDate = y!=null? BDate.LetRaw(context.CurrentDate, y.Time) : null;
            _contextQuote.Set(_quote, 0, data_index+1);
            context.ContextValue = _contextQuote;
            return true;
        }
        public override SplitInfo FindSplitInfo(int raw_time) {
            AbstractStockProfile sp = _stock.Profile;
            switch(_unit) {
                case Quote.QuoteUnit.Daily:
                    return sp.FindSplitInfo(raw_time);
                case Quote.QuoteUnit.Weekly: {
                        WeeklyDateIndex di = WeeklyDateMap.FindByDate(raw_time);
                        return sp.FindSplitInfo(di.FirstDate, di.LastDate);
                    }
                case Quote.QuoteUnit.Monthly:
                    return sp.FindSplitInfo(raw_time, raw_time+31); //Ȃ肢
                default:
                    Debug.Assert(false); //̂ǂꂩ
                    return null;
            }
        }
        public override bool IsTimeLabelRequired(int raw_time, out string str) {
            str = null;
            _for_label_cond.LetInt(raw_time);
            switch(_unit) {
                case Quote.QuoteUnit.Daily:
                    if(MarketUtil.IsFirstMarketOpenDateOfMonth(_for_label_cond)) //
                        str = String.Format("{0}N{1}", _for_label_cond.Year, _for_label_cond.Month);
                    break;
                case Quote.QuoteUnit.Weekly:
                    if(WeeklyDateMap.FindByDate(raw_time).StartOfQuarter)
                        str = String.Format("{0}N{1}Q", _for_label_cond.Year, (_for_label_cond.Month+2)/3);
                    break;
                case Quote.QuoteUnit.Monthly:
                    if(_for_label_cond.Month==1)
                        str = String.Format("{0}N", _for_label_cond.Year);
                    break;
                default:
                    Debug.Assert(false); //̂ǂꂩ
                    break;
            }
            return str!=null;
        }
        public override string GetTimeLabel(int raw_time) {
            _for_label_cond.LetInt(raw_time);
            switch(_unit) {
                case Quote.QuoteUnit.Daily:
                    return String.Format("{0}N{1}{2}({3})", _for_label_cond.Year, _for_label_cond.Month, _for_label_cond.Day, _for_label_cond.DayOfWeekString);
                case Quote.QuoteUnit.Weekly:
                    return String.Format("{0}N{1}{2}`", _for_label_cond.Year, _for_label_cond.Month, _for_label_cond.Day);
                case Quote.QuoteUnit.Monthly:
                    return String.Format("{0}N{1}", _for_label_cond.Year, _for_label_cond.Month);
                default:
                    Debug.Assert(false); //̂ǂꂩ
                    return "";
            }
        }

    }

    public class StaticChartViewSettings : DrawingSettingsBase {
        public DSInt headerHeight; //㕔}[W
        public DSInt stockNameLeft; //
        public DSFont headerFont; //ttHg
        public DSBrush headerTextColor; //tF

        public StaticChartViewSettings(string id)
            : base(id) {
        }

        protected override void CreateElements() {
            headerFont = DefineFont("headerFont", DSFont.GenericFontName, 11);
            headerHeight = DefinePositiveInt("headerHeight", 20);
            stockNameLeft = DefinePositiveInt("stockNameLeft", 64);
            headerTextColor = DefineBrush("headerTextColor", Color.Ivory);
        }
    }

    public class StaticChartViewContent : ChartViewContentBase {
        private StaticChartSession _session;
        private StaticChartViewSettings _viewSettings;
        private const int FRAME_MARGIN = 3;
        
        public StaticChartViewContent(StaticChartSession session, StaticChartDocument doc)
            : base(session, doc) {
            _session = session;
            _viewSettings = BellagioRoot.FixedPreferences.Chart.StaticChartViewSettings;
            _rectangleOperator = new RectangleOperatorBuilder()
                .Cut(SplitDir.Bottom, _scrollBar.AsControl.Height)
                .Cut(SplitDir.Top, _viewSettings.headerHeight.V)
                .Append(_chartDrawing.RectOp)
                .Finish();
        }
        public override void Attach(BellagioDefaultControl parent) {
            _rectangleOperator.Rect(parent.ClientRectangle); //ɃTCYĂȂbase.InitializeŃXN[o[sɏI
            base.Attach(parent);
            if(_session.Document.DocumentStatus==BellagioDocumentStatus.Complete)
                _chartDrawing.DataUpdateDirect();
        }
        public override IPoderosaMenuGroup[] CreateContextMenuContent() {
            if(Ordering.OrderingPlugin.Instance==null) {
                return new IPoderosaMenuGroup[] {
                new ChartMenuGroups.ChartSettingsMenuGroup(),
                new ChartMenuGroups.DataSettingMenuGroup(new SetStockCommand(this), true),
                new ChartMenuGroups.ChartUIMenuGroup()
            };
            }
            else {
                return new IPoderosaMenuGroup[] {
                new ChartMenuGroups.ChartSettingsMenuGroup(),
                new ChartMenuGroups.ChartOrderMenuGroup(),
                new ChartMenuGroups.DataSettingMenuGroup(new SetStockCommand(this), true),
                new ChartMenuGroups.ChartUIMenuGroup()
            };
            }
        }
        

        public override void OnPaint(PaintEventArgs args) {
            try {
                if(base.PaintIncompleteCases(args)) return;

                Graphics g = args.Graphics;

                //eg
                /*
                g.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.HighQuality;
                RoundRectUtil.Draw(g, p, _chartGraphics.Location, 5);
                RoundRectUtil.Draw(g, p, _itaGraphics.Location, 5);
                g.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.Default;
                */
                //PaintHeader(g);

                _chartDrawing.Paint(g, args.ClipRectangle);
                if(_omittedItemInfoText!=null)
                    g.DrawString(_omittedItemInfoText, _chartDrawing.ChartDrawingSettings.stockInfoFont.F, _chartDrawing.ChartDrawingSettings.warningColor.B, _codeInputBox.Left, _codeInputBox.Bottom+2);

                base.PaintFreeLines(g, args.ClipRectangle);
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }
        private void PaintHeader(Graphics g) {
            Brush br = _viewSettings.headerTextColor.B;
            AbstractStockProfile st = _session.Document.CurrentStock.Profile;
            g.DrawString(String.Format("{0} {1}", st.Code, st.Name), _viewSettings.headerFont.F, br, _viewSettings.stockNameLeft.V, 2);
        }
        public override void Dispose() {
            base.Dispose();
        }
    }

    public class StaticChartSessionCreateParam : ChartSessionCreateParamBase {
        private Quote.QuoteUnit _unit;

        public StaticChartSessionCreateParam(ChartSchema schema, Stock stock)
            : base(schema, stock) {
        }

        public Quote.QuoteUnit Unit {
            get {
                return _unit;
            }
            set {
                _unit = value;
            }
        }
    }

    public class StaticChartSession : ChartSessionBase {
        private StaticChartViewContent _content;
        private StaticChartDocument _document;
        private Quote.QuoteUnit _unit;

        public StaticChartSession(StaticChartSessionCreateParam p) {
            ChartSchema schema = p.Schema;

            //{͈Ɏ󂯂R}hl擾ׂƂ
            Stock s = p.Stock!=null? p.Stock : BellagioRoot.GlobalStockCollection.FindExact("NK225").Primary; //Jʏ܂oς
            _unit = p.Unit; //̓RXgN^Ō߂瓮Ȃ
            _document = new StaticChartDocument(_unit);

            CreateDocument(_document, schema);
            _content = new StaticChartViewContent(this, _document);
            AdjustCaption(s);
            base.Init(_document, _content, schema.FullID);

            SetCurrentStock(s);
        }
        public override void SetCurrentStock(Stock stock) {
            AdjustCaption(stock);
            base.SetCurrentStock(stock);
        }
        protected override void SubscribeFailed() {
            AdjustCaption(null);
            _content.ResetCodeInputBox(null);
            base.SubscribeFailed();
        }

        //LbVNAĂǂݍ
        public override void ReloadSchema(string schema_name, Stock stock) {
            //Y[hȂ疳
            if(_document.DocumentStatus==BellagioDocumentStatus.Loading) {
                Debug.WriteLineIf(BDebugOpts.TRACE_DATE_BASED_QUOTE, "Ignore DateRequest");
                return;
            }

            SetCurrentStock(null);
            BellagioRoot.DateBasedQuoteProvider.Clear(stock);

            if(schema_name!=_sourceSchemaName) {
                ChartSchema sc = BellagioRoot.SchemaRoot.FindStaticChartSchema(schema_name);
                if(sc==null) return; //ȂȂĂ̂܂܃^[
                _sourceSchemaName = schema_name;
                _unit = sc.ChartUnit;
                _document = new StaticChartDocument(sc.ChartUnit);
                CreateDocument(_document, sc);
                _content.ReplaceDocument(_document);
                ReplaceDocument(_document);
            }

            SetCurrentStock(stock);
        }
        private void AdjustCaption(Stock stock) {
            _caption = String.Format("{0} - {1}", _document.SourceSchema.description.ParseMandatoryString(), stock==null? "" : stock.Profile.Name);
        }
        public override ChartSchema GetSourceSchema() {
            return BellagioRoot.SchemaRoot.FindStaticChartSchema(_sourceSchemaName);
        }

        public StaticChartDocument Document {
            get {
                return _document;
            }
        }
        public StaticChartViewContent ViewContent {
            get {
                return _content;
            }
        }

    }
}
