/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Chart/ItaDocument.cs#8 $
 * $DateTime: 2008/03/13 13:20:43 $
 * 
 * ̃hLg
 * 
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;

using Bellagio.Data;
using Bellagio.Values;
using Bellagio.Drawing;
using Bellagio.Forms;
using Bellagio.Environment;

using Travis.LocationOperation;

using Poderosa;
using Poderosa.Forms;
using Poderosa.Preferences;
using Poderosa.Commands;
using Poderosa.Plugins;
using Poderosa.Sessions;

namespace Bellagio.Chart {
    public class ItaDocument : BellagioDocumentBase, IRealTimeDataSubscriber {
        private Stock _stock;
        private RealtimeIta _realtimeIta;

        public ItaDocument(Stock stock) {
            Init(stock);   
        }
        public void SetCurrentStock(Stock stock) {
            if(_stock!=null) BellagioRoot.DataSubscriberManager.RemoveSubscriber(this);

            Init(stock);
        }
        public Stock Stock {
            get {
                return _stock;
            }
        }
        
        private void Init(Stock stock) {
            _stock = stock;

            if(stock==null) {
                _realtimeIta = null;
                _documentStatus = BellagioDocumentStatus.Empty;
            }
            else {
                _documentStatus = BellagioDocumentStatus.Loading;
                BellagioRoot.DataSubscriberManager.AddRealtimeSubscriber(this, new SubscribeRequest(stock, SubscribeDataKind.Ita));
            }
        }

        public void Dispose() {
            if(_stock!=null) BellagioRoot.DataSubscriberManager.RemoveSubscriber(this);
        }

        public void SuspendStock() {
            _documentStatus = BellagioDocumentStatus.Loading;
        }

        public RealtimeIta RealTimeIta {
            get {
                return _realtimeIta;
            }
        }

        int IRealTimeDataSubscriber.ThinningTime {
            get {
                return 0;
            }
        }

        void IRealTimeDataSubscriber.RealTimeProcess(DataProcessArg arg) {
            //͂邱ƂȂ
        }



        void IStockBasedDataSubscriber.SubscribeComplete() {
            _realtimeIta = BellagioRoot.ItaProvider.Lookup(_stock);
            _documentStatus = BellagioDocumentStatus.Complete;
        }

        void IStockBasedDataSubscriber.SubscribeFailed(string reason) {
            base.DefaultSubscribeFailed(reason);
        }


        DataThreadToMainThread IDataSubscriber.NotifyDelegate {
            get {
                return _notifyDelegate;
            }
        }

    }
}
