/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006-2008  Lagarto Technology, Inc.
 * 
 * $Id$
 * $DateTime$
 * 
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.Drawing;

using Bellagio.Forms;
using Bellagio.Drawing;
using Bellagio.Data;
using Bellagio.Environment;

using Poderosa;

namespace Bellagio.Chart {

    //قIntraDayTrade邾ړIDocument
    public class CurrentPriceInfoDocument : BellagioDocumentBase, IRealTimeDataSubscriber {
        private Stock _stock;
        private IntraDayTrade _intraDayTrade;

        public IntraDayTrade IntraDayTrade {
            get {
                return _intraDayTrade;
            }
        }


        public void SetCurrentStock(Stock stock) {
            if(_stock!=null) BellagioRoot.DataSubscriberManager.RemoveSubscriber(this);

            Init(stock);
        }
        private void Init(Stock stock) {
            _stock = stock;
            if(stock==null) {
                _intraDayTrade = null;
                _documentStatus = BellagioDocumentStatus.Empty;
            }
            else {
                _documentStatus = BellagioDocumentStatus.Loading;
                //SubscribeRequest̃RXgN^ItaʂŐɂĂ͈̂ӖB
                //̂قɃTuXNCuł鐔Ȃ̂ŁAsȂ瑁߂ɔf悤ɁB
                BellagioRoot.DataSubscriberManager.AddRealtimeSubscriber(this, new SubscribeRequest(stock, SubscribeDataKind.Ticks));
            }
        }
        public  void Dispose() {
            if(_stock!=null) BellagioRoot.DataSubscriberManager.RemoveSubscriber(this);
            _documentStatus = BellagioDocumentStatus.Empty;
        }

        void IStockBasedDataSubscriber.SubscribeComplete() {
            Debug.WriteLineIf(BDebugOpts.TRACE_DATA_SUBSCRIBER, "SubscribeComplete");
            _intraDayTrade = BellagioRoot.IntraDayTradeProvider.Lookup(_stock);
            Debug.Assert(_intraDayTrade!=null);
            _documentStatus = BellagioDocumentStatus.Complete;
        }
        void IStockBasedDataSubscriber.SubscribeFailed(string reason) {
            base.DefaultSubscribeFailed(reason);
        }
        int IRealTimeDataSubscriber.ThinningTime {
            get {
                return 0;
            }
        }
        void IRealTimeDataSubscriber.RealTimeProcess(DataProcessArg arg) {
        }

    }


    public class CurrentPriceInfoControl : StockInfoViewerControl {

        private CurrentPriceInfoGraphics _drawing;
        private CurrentPriceInfoDocument _document;

        public CurrentPriceInfoControl(CurrentPriceInfoDocument doc, CurrentPriceInfoGraphics.LayoutT layout) : base(doc) {
            _document = doc;
            _drawing = new CurrentPriceInfoGraphics(this, BellagioPlugin.Instance.SansaPlatform,
                BellagioRoot.FixedPreferences.Chart.CurrentPriceInfoGraphicsSettings,
                layout);
            
            this.BackColor = Color.Black;
            this.ForeColor = Color.White;

            base.SetStyle(ControlStyles.Selectable, false);
            base.SetStyle(ControlStyles.AllPaintingInWmPaint|ControlStyles.OptimizedDoubleBuffer, true);
        }

        public CurrentPriceInfoGraphics Drawing {
            get {
                return _drawing;
            }
        }

        protected override void OnResize(EventArgs e) {
            base.OnResize(e);
            _drawing.RectOp.Rect(this.ClientRectangle);
            this.Invalidate();
        }


        protected override void OnPaint(PaintEventArgs e) {
            base.OnPaint(e);
            try {
                Graphics g = e.Graphics;
                if(base.PaintIncompleteCases(e))
                    return;
                else {
                    _drawing.Paint(g, e.ClipRectangle);
                }
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }

        }

        protected override void OnMouseDown(MouseEventArgs e) {
            base.OnMouseDown(e);
            if(e.Button==MouseButtons.Left && _document.DocumentStatus==BellagioDocumentStatus.Complete) {
                CurrentPriceInfo cp = _document.IntraDayTrade.CurrentPriceInfo;
                if(!cp.CurrentPrice.IsEmpty) {
                    _draggingPrice = cp.CurrentPrice.Value;
                    _dragStartPoint = e.Location;
                }
            }
        }
        protected override void OnMouseUp(MouseEventArgs e) {
            base.OnMouseUp(e);
            if(e.Button==MouseButtons.Left)
                _draggingPrice = -1; //Zbg
        }

        protected override void OnMouseMove(MouseEventArgs e) {
            base.OnMouseMove(e);
            if(e.Button==MouseButtons.Left && _draggingPrice!=-1 &&
                Math.Abs(e.X-_dragStartPoint.X)+Math.Abs(e.Y-_dragStartPoint.Y) < 6)
                FireStartDragPrice(_draggingPrice);
        }

    }
}
