/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Alert/AlertPlugin.cs#13 $
 * $DateTime: 2008/05/14 13:05:12 $
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.Drawing;

using Poderosa;
using Poderosa.Plugins;
using Poderosa.Commands;
using Poderosa.Forms;
using Poderosa.Sessions;
using Poderosa.View;
using Poderosa.Preferences;

using Sansa.Runtime;
using Bellagio.Forms;
using Bellagio.Data;
using Bellagio.Values;
using Bellagio.Environment;

[assembly: PluginDeclaration(typeof(Bellagio.Alert.AlertPlugin))]

namespace Bellagio.Alert {
    using RealTimeChartSession=Bellagio.Chart.RealTimeChartSession;

    [PluginInfo(ID=AlertPlugin.PLUGIN_ID, Version=BellagioVersionInfo.PLUGIN_VERSION, Author=BellagioVersionInfo.AUTHOR_NAME, Dependencies=BellagioPlugin.PLUGIN_ID)]
    public class AlertPlugin : PluginBase, IBellagioBootProcedure {
        public const string PLUGIN_ID = "jp.co.lagarto.tactico.alert";
        private static AlertPlugin _instance;

        //A[gł͓ŁAr[EhLg͑ŜłP̃CX^XBvOC̏Ɠɍ
        private AlertDocument _document;
        private AlertContent _content;
        private AlertPreference _preference;
        
        public override void InitializePlugin(IPoderosaWorld poderosa) {
            base.InitializePlugin(poderosa);

            _document = new AlertDocument();
            _instance = this;
            IPluginManager pm = poderosa.PluginManager;
            pm.FindExtensionPoint(BellagioConstants.BOOT_PROCEDURE_EXTENSION).RegisterExtension(this);

            ICoreServices cs = (ICoreServices)poderosa.GetAdapter(typeof(ICoreServices));
            _preference = new AlertPreference();
            cs.PreferenceExtensionPoint.RegisterExtension(_preference);
        }
        public static AlertPlugin Instance {
            get {
                return _instance;
            }
        }

        public override void TerminatePlugin() {
            base.TerminatePlugin();
            BellagioRoot.DataSubscriberManager.RemoveSubscriber(_document);
        }

        public AlertContent AlertContent {
            get {
                return _content;
            }
        }
        public AlertDocument Document {
            get {
                return _document;
            }
        }
        public AlertPreference Preference {
            get {
                return _preference;
            }
        }

        private void InitDocument() {
            List<AlertConditionSchema> c = new List<AlertConditionSchema>();
            BellagioRoot.SchemaRoot.CollectAlertSchema(c);

            foreach(AlertConditionSchema cond in c) {
                RuntimeAlertCondition r = new RuntimeAlertCondition(cond);
                _document.AddConditon(r);
            }

            _document.CompleteCreation();

            BellagioRoot.DataSubscriberManager.AddPeriodicalSubscriber(_document);
        }

        internal CommandResult OpenAlertList(ICommandTarget target) {
            //fƂāACtrlL[ĂƃeXgf[^ŃA[g
            if(BRuntimeOpts.ENABLE_ALERT_DEMO && Control.ModifierKeys==Keys.Control) {
                return OpenAlertCommandWithCurrentStock(target);
            }
            IPoderosaForm f = BellagioCommandUtil.AsPoderosaForm(target);

            if(_content==null || _content.IsDisposed) 
                _content = new AlertContent(f.AsForm());
            else
                _content.Owner = f.AsForm();


            _content.Show();

            return CommandResult.Succeeded;
        }

        internal CommandResult OpenAlertCommandWithCurrentStock(ICommandTarget target) {
            //ĂKȖŃVOis
            foreach(ISession s in BellagioPlugin.Instance.SessionManager.AllSessions) {
                RealTimeChartSession rs = s as RealTimeChartSession;
                if(rs!=null) {
                    IntraDayTrade q = null;
                    string message = null;
                    BellagioRoot.IntraDayTradeProvider.Open(rs.CurrentStock, ref q, ref message);

                    _document.ForceRaiseAlert(q, BellagioRoot.TimeManager.Current, _document.GetConditionAt(0));
                    return CommandResult.Succeeded;
                }
            }

            return CommandResult.Ignored;
        }
        internal CommandResult OpenAlertCommand(ICommandTarget target, AlertData ad) {
            if(!AlertPlugin.Instance.Preference.Enabled) return CommandResult.Ignored;

            AlertDetectedForm form = new AlertDetectedForm(ad);
            AdjustDetectedFormLocation(form);
            form.Show();

            return CommandResult.Succeeded;
        }

        private static int _detectedFormCount; //͑Bɕ\ĂʒuɂȂȂ悤ɂ邽߂
        private static void AdjustDetectedFormLocation(AlertDetectedForm f) {
            Form owner = BellagioPlugin.Instance.ActivePoderosaWindow.AsForm();
            f.Owner = owner;

            Rectangle r = owner.RestoreBounds;

            Point pt  = new Point(r.X+r.Width/2-f.Width/2, r.Y+r.Height/2-f.Height/2);
            int adj = (_detectedFormCount++ % 5) * 8;
            pt.X += adj;
            pt.Y += adj;

            f.Location = pt;
        }

        //Nߒ̏IɃA[g̃hLgBłȂBellagioRootoR̊e@\gȂ
        void IBellagioBootProcedure.RunBootProcedure(IAdaptable server, IBellagioLoadingLog log) {
        }

        void IBellagioBootProcedure.Join() {
            InitDocument();
        }

    }
}
