using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Windows.Forms;

using Bellagio.Data;
using Poderosa;

namespace Bellagio.Personal {
    internal class PUtil {
        public static int DateTimeToInt(DateTime dt) {
            return dt.Year*10000 + dt.Month*100 + dt.Day;
        }
        public static DateTime IntToDateTime(int date) {
            return new DateTime(date / 10000, (date / 100) % 100, date % 100); ;
        }

        public static bool SneakDailyDataLastDate(string code, out int last_date) {
            return SneakDailyDataDate(code, false, out last_date);
        }
        public static bool SneakDailyDataFirstDate(string code, out int first_date) {
            return SneakDailyDataDate(code, true, out first_date);
        }
        private static bool SneakDailyDataDate(string code, bool first, out int result_date) {
            result_date = 0;
            string filename = PersonalPlugin.Instance.BellagioEnvironment.DataHomeDir + "daily\\" + code;
            if(File.Exists(filename)) {
                FileStream fs = null;
                try {
                    fs = new FileStream(filename, FileMode.Open, FileAccess.Read);
                    if(!first) //I[̂Ƃ
                        fs.Seek(-32, SeekOrigin.End);
                    byte[] b = new byte[32];
                    fs.Read(b, 0, b.Length);
                    unsafe {
                        fixed(byte* p = b) {
                            result_date = *(int*)p;
                        }
                    }
                    return true;
                }
                catch(Exception) {
                    return false;
                }
                finally {
                    if(fs!=null) fs.Close();
                }
            }
            else
                return false;
        }

        public static int NextMarketOpenDate(int date) {
            DateTime dt = IntToDateTime(date);
            dt = dt.AddDays(1);
            while(!PublicMarketUtil.IsMarketOpenDate(dt)) dt = dt.AddDays(1);
            return DateTimeToInt(dt);
        }
        public static int PrevMarketOpenDate(int date) {
            DateTime dt = IntToDateTime(date);
            dt = dt.AddDays(-1);
            while(!PublicMarketUtil.IsMarketOpenDate(dt)) dt = dt.AddDays(-1);
            return DateTimeToInt(dt);
        }

        private delegate void MBDelegate(Form form, string message);
        public static void ShowWarningMessageBox(Form parent, string message) {
            if(parent.InvokeRequired)
                parent.Invoke(new MBDelegate(ShowWarningMessageBox), parent, message);
            else
                MessageBox.Show(parent, message, BellagioVersionInfo.APPLICATION_CAPTION, MessageBoxButtons.OK, MessageBoxIcon.Warning);
        }


        public static void CopyStream(Stream input, Stream output, int buffer_size) {
            byte[] buffer = new byte[buffer_size];
            int n = input.Read(buffer, 0, buffer.Length);
            while(n > 0) {
                output.Write(buffer, 0, n);
                n = input.Read(buffer, 0, buffer.Length);
            }
        }

        public static Shell32.Folder Unzip(string zip_file, string dest_dir, bool show_dialog) {
            //zip
            Shell32.ShellClass sc = new Shell32.ShellClass();
            Shell32.Folder dest = sc.NameSpace(dest_dir);
            Shell32.Folder src = sc.NameSpace(zip_file);
            dest.CopyHere(src.Items(), show_dialog? 0x10 : 0x14); //̒萔̈ӖMSDNSHFILEOPSSTRUCT𒲂ׂ
            return src;
        }

        public static IAdaptable DefaultGetAdapter(IAdaptable obj, Type adapter) {
            return PersonalPlugin.Instance.PoderosaWorld.AdapterManager.GetAdapter(obj, adapter);
        }
    }
}
