/*
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Travis/BinarySearch.cs#8 $
 * $DateTime: 2007/12/28 19:23:38 $
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

#if UNITTEST
using NUnit.Framework;
#endif

namespace Travis.Collections {
    //\[gς݂IListɑ΂oCiT[`
    public static class BinarySearch<E, K> {
        public delegate int Comparator(E elem, K value);

        public static int FindExact(IList<E> coll, K value, Comparator comparator) {
            if(coll.Count==0)
                return -1;
            else {
                Finder f = new Finder(coll, comparator, value);
                return f.FindExact(0, coll.Count);
            }
        }

        //valueȏオoꂷŏCfbNXԂ
        public static int FindLowerBound(IList<E> coll, K value, Comparator comparator) {
            if(coll.Count==0 || comparator(coll[coll.Count-1], value) < 0)
                return -1;
            else {
                Finder f = new Finder(coll, comparator, value);
                return f.FindLowerBound(0, coll.Count);
            }
        }
        //valueȉoꂷőCfbNXԂ
        public static int FindUpperBound(IList<E> coll, K value, Comparator comparator) {
            if(coll.Count==0 || comparator(coll[0], value) > 0)
                return -1;
            else {
                Finder f = new Finder(coll, comparator, value);
                return f.FindUpperBound(0, coll.Count);
            }
        }

        private struct Finder {
            private IList<E> _coll;
            private Comparator _comp;
            private K _key;
            public Finder(IList<E> coll, Comparator comp, K key) {
                _coll = coll;
                _comp = comp;
                _key = key;
            }
            public int FindExact(int begin, int end) {
                if(end-begin<=1) {
                    if(_comp(_coll[begin], _key)==0)
                        return begin;
                    else
                        return -1;
                }

                int mid = (begin + end)/2;
                if(_comp(_coll[mid], _key) > 0)
                    return FindExact(begin, mid);
                else
                    return FindExact(mid, end);
            }

            //[begin,end)͈̔͂ŁAkeyȏɂȂŏԂB
            public int FindLowerBound(int begin, int end) {
                if(end-begin<=1) {
                    if(_comp(_coll[begin], _key)>=0)
                        return begin;
                    else
                        return end;
                }

                int mid = (begin + end - 1)/2;
                if(_comp(_coll[mid], _key) >= 0)
                    return FindLowerBound(begin, mid+1);
                else
                    return FindLowerBound(mid+1, end);
            }

            //[begin,end)͈̔͂ŁAkeyȉɂȂőԂB
            public int FindUpperBound(int begin, int end) {
                if(end-begin<=1) {
                    if(_comp(_coll[begin], _key)<=0)
                        return begin;
                    else
                        return end;
                }

                int mid = (begin + end)/2;
                if(_comp(_coll[mid], _key) <= 0)
                    return FindUpperBound(mid, end);
                else
                    return FindUpperBound(begin, mid);
            }
        }
    }
    
#if UNITTEST
    [TestFixture]
    public class BinarySearchTests {
        private static BinarySearch<int, int>.Comparator _compInt = delegate(int v, int k) { return v-k; };

        [Test]
        public void Find() {
            List<int> coll = new List<int>();
            for(int i=0; i<100; i++)
                coll.Add(i*10);

            int r = BinarySearch<int, int>.FindExact(coll, 500, _compInt);
            Assert.AreEqual(50, r);
            r = BinarySearch<int, int>.FindExact(coll, 501, _compInt);
            Assert.AreEqual(-1, r);
            r = BinarySearch<int, int>.FindExact(coll, 0, _compInt);
            Assert.AreEqual(0, r);
            r = BinarySearch<int, int>.FindExact(coll, 990, _compInt);
            Assert.AreEqual(99, r);
        }

        [Test]
        public void LowerBound() {
            List<int> coll = new List<int>();
            for(int i=0; i<100; i++)
                coll.Add(i*10);

            int r = BinarySearch<int, int>.FindLowerBound(coll, 500, _compInt);
            Assert.AreEqual(50, r);
            r = BinarySearch<int, int>.FindLowerBound(coll, 501, _compInt);
            Assert.AreEqual(51, r);
            r = BinarySearch<int, int>.FindLowerBound(coll, -100, _compInt);
            Assert.AreEqual(0, r);
            r = BinarySearch<int, int>.FindLowerBound(coll, 990, _compInt);
            Assert.AreEqual(99, r);
            r = BinarySearch<int, int>.FindLowerBound(coll, 1000, _compInt);
            Assert.AreEqual(-1, r);
        }
        [Test]
        public void UpperBound() {
            List<int> coll = new List<int>();
            for(int i=0; i<100; i++)
                coll.Add(i*10);

            int r = BinarySearch<int, int>.FindUpperBound(coll, 500, _compInt);
            Assert.AreEqual(50, r);
            r = BinarySearch<int, int>.FindUpperBound(coll, 499, _compInt);
            Assert.AreEqual(49, r);
            r = BinarySearch<int, int>.FindUpperBound(coll, 1000, _compInt);
            Assert.AreEqual(99, r);
            r = BinarySearch<int, int>.FindUpperBound(coll, 0, _compInt);
            Assert.AreEqual(0, r);
            r = BinarySearch<int, int>.FindUpperBound(coll, -100, _compInt);
            Assert.AreEqual(-1, r);
        }
    }
#endif
}
