/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id$
 * $DateTime$
 * 
 * EnptH[
 * ̌σtH[̂Aʓ͕ĂiD
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.Drawing;

using Bellagio.Values;
using Bellagio.Chart;
using Bellagio.Data;
using Bellagio.Forms;
using Bellagio.Common;
using Bellagio.Drawing;
using Poderosa;

using Travis;
using Travis.LocationOperation;

namespace Bellagio.Ordering {
    public class GenhikiGenwatasiForm : Form {
        private OrderFormParameter _parameter;
        private AbstractStockProfile _stockProfile;

        private Color _backColor;
        private Color _foreColor;

        private Label _codeLabel;
        private CodeInputBox _codeBox;
        private Control _currentPositionOrOrder;

        //`c[
        private Font _figureFont;    //|WV̕\ŐɎgptHg
        private int _figureFontYOffset; //ʒu킹
        private Brush _figureBrush;
        private Brush _buyMarkBrush;  //Ẽ|WV/ɂ킹ĕ\
        private Brush _sellMarkBrush;


        //
        private Label _volumeLabel;
        private VolumeInputBox _volumeBox;
        private HoveringLabel _volumeDec10;
        private HoveringLabel _volumeDec;
        private HoveringLabel _volumeInc;
        private HoveringLabel _volumeInc10;

        //Ïؔԍ
        private Label _pinCodeLabel;
        private TextBox _pinCodeBox;
        private Label _separator1;

        //LZE
        private RibbonMenuButton _cancelButton;
        private RibbonMenuButton _orderButton;

        //zu
        private RectOp _rectOperator;

        public GenhikiGenwatasiForm() {
            this.SuspendLayout();
            FormUtil.AdjustStyleForModalDialog(this);

            _backColor = Color.Black;
            _foreColor = Color.White;
            _figureFont = new Font("Arial Black", 10.5F);
            _figureBrush = new SolidBrush(Color.DarkGoldenrod);
            _figureFontYOffset = -2;
            _buyMarkBrush = new SolidBrush(Color.Red);
            _sellMarkBrush = new SolidBrush(Color.DarkBlue);
            
            _codeLabel = CreateLabel("");
            _codeBox = new CodeInputBox();
            ChartDrawingSettings ds = BellagioRoot.FixedPreferences.Chart.ChartDrawingSettings;
            _codeBox.Font = ds.stockBoxFont.F;
            _codeBox.CodeColor = ds.stockCodeColor.col;
            _codeBox.NameColor = ds.stockNameColor.col;
            _currentPositionOrOrder = FormUtil.CreateCustomPaintControl(new PaintEventHandler(OnPaintCurrentPositionOrOrder));
            
            _volumeLabel = CreateLabel("(&V)");
            _volumeBox = new VolumeInputBox();
            _volumeBox.Font = new Font("lr SVbN", 10.5F); 
            _volumeDec10 = CreateVolumeChangeLabel(9);
            _volumeDec = CreateVolumeChangeLabel(6);
            _volumeInc = CreateVolumeChangeLabel(5);
            _volumeInc10 = CreateVolumeChangeLabel(10);
            
            _pinCodeLabel = CreateLabel("Ï(&N)");
            _pinCodeBox = new TextBox();
            _pinCodeBox.PasswordChar = '*';
            _separator1 = FormUtil.CreateSeparatorAsLabel();

            _cancelButton = FormUtil.CreateRibbonCommandButton("", LargeBitmap(10), new MouseEventHandler(OnCancelButtonClick));
            _cancelButton.DialogResult = DialogResult.Cancel;
            _orderButton = FormUtil.CreateRibbonCommandButton("", LargeBitmap(6), new MouseEventHandler(OnOrderButtonClick));
            _orderButton.DialogResult = DialogResult.OK;

            this.Controls.AddRange(new Control[] {
                _codeLabel, _codeBox,
                _currentPositionOrOrder,
                _volumeLabel, _volumeBox, _volumeDec10, _volumeDec, _volumeInc, _volumeInc10, 
                _pinCodeLabel, _pinCodeBox, _separator1,
                _cancelButton, _orderButton
            });


            int row_s = 24; //P̍()
            int row_m = 30; //P̍()
            
            int m = 8; //W̃Rg[ԃ}[W
            int lw = 92; //̃xp[g̕
            int cw = 100; //iEʂȂǂ̃Rg[
            int sb = 20; //ACRRg[̈
            int cmd_w = 52; //R}h{^TCY
            int cmd_h = 52;
            _codeBox.Height = row_m-4; //ProbeControlVerCenterg͎̍
            _volumeBox.Height = row_m-4;

            _rectOperator = new RectangleOperatorBuilder()
                .SplitTop(row_m)
                    .SplitLeft(lw).ProbeControl(_codeLabel).CloseBranch()
                    .PlaceControl(ContentAlignment.MiddleLeft, _codeBox)
                    .CloseBranch()
                .SplitTop(64)
                    .ProbeControl(_currentPositionOrOrder)
                    .CloseBranch()
                .SplitTop(row_s)
                    .SplitFixed(SplitDir.Left, lw).ProbeControl(_volumeLabel).CloseBranch()
                    .PlaceControl(ContentAlignment.MiddleLeft, _volumeBox, cw, row_s)
                    .VCenter(sb).SetMargin(2)
                    .RightControl(_volumeDec10)
                    .RightControl(_volumeDec)
                    .RightControl(_volumeInc)
                    .RightControl(_volumeInc10)
                    .CloseBranch()
                .SplitTop(row_s)
                    .SplitFixed(SplitDir.Left, lw).ProbeControl(_pinCodeLabel).CloseBranch()
                    .PlaceControl(ContentAlignment.TopLeft, _pinCodeBox, cw, row_s)
                    .CloseBranch()
                .SplitTop(8)
                    .Shrink(3).ProbeControl(_separator1)
                    .CloseBranch()
                .SplitFixed(SplitDir.Bottom, cmd_h+m)
                    .SetMargin(m)
                    .PlaceControl(ContentAlignment.TopRight, _cancelButton, cmd_w, cmd_h)
                    .LeftControl(_orderButton, cmd_w, cmd_h)
                    .CloseBranch()

                .Finish();

            _volumeBox.BackColor = _backColor; _volumeBox.ForeColor = _foreColor;
            _volumeBox.MouseWheel += new MouseEventHandler(OnMouseWheelVolume);
            _pinCodeBox.BackColor = _backColor; _pinCodeBox.ForeColor = _foreColor;
            _pinCodeBox.MaxLength = BRuntimeOpts.MAX_PASSWORD_LENGTH;

            this.ClientSize = new Size(352, 208);

            this.CancelButton = _cancelButton;
            this.AcceptButton = _orderButton;

            _codeBox.Font = new Font("lr SVbN", 10.5F);

            _rectOperator.Rect(this.ClientRectangle);

            this.ResumeLayout();
        }

        //ʕύX
        private void OnVolumeChangeButtonClick(object sender, MouseEventArgs args) {
            if(args.Button!=MouseButtons.Left) return;

            if(sender==_volumeDec10) ChangeVolume(false, true);
            else if(sender==_volumeDec) ChangeVolume(false, false);
            else if(sender==_volumeInc) ChangeVolume(true, false);
            else if(sender==_volumeInc10) ChangeVolume(true, true);
        }
        private void OnMouseWheelVolume(object sender, MouseEventArgs args) {
            ChangeVolume(args.Delta>0, false);
        }
        private void ChangeVolume(bool increment, bool ten_times) {
            if(!_volumeBox.Enabled) return;

            int volume = _volumeBox.GetTextAsInt();
            int u = _stockProfile==null? 1 : _stockProfile.Primary.VolumeUnit;
            int add = u;
            if(ten_times) add *= 10;
            if(!increment) add *= -1;

            volume += add;

            if(volume < u) volume = u;
            if(volume > _volumeBox.MaximumValue) volume = _volumeBox.MaximumValue;
            _volumeBox.SetTextByInt(volume);
        }

        private void OnCancelButtonClick(object sender, MouseEventArgs args) {
            Close();
        }

        private void OnOrderButtonClick(object sender, MouseEventArgs args) {
            try {
                this.DialogResult = DialogResult.None;

                TradeOrderItem item = CreateTradeOrderItemUI();
                //En̓|WVwłAPIłĂׂȂ悤ɂȂĂ
                PositionAndVolumeList l = new PositionAndVolumeList();
                l.Add(_parameter.PositionElement.UniqueID, item.Volume);
                item.ClosePositionDetail = l;
                BellagioRoot.OrderDataProvider.SendSpecifiedElementCloseOrder(item, _pinCodeBox.Text);

                this.DialogResult = DialogResult.OK;
                this.Close();
            }
            catch(Exception ex) {
                Debug.WriteLine(ex.StackTrace);
                BUtil.ShowWarningMessageBox(ex.Message);
            }
        }

        public void InitContent(OrderFormParameter info) {
            try {
                _parameter = info;
                Debug.Assert(info.OrderCategory==OrderFormParameter.Category.ClosePosition);
                
                TradePositionItem item = info.CurrentPosition;
                _stockProfile = item.Stock.Profile;

                this.Text = String.Format("{0}", item.LongShort==LongShort.Long? "" : "n");
                
                _codeBox.SetTextExternal(CodeDropDownDataProvider.DefaultFormat(item.Stock.Profile));
                _codeBox.LastCorrectText = _codeBox.Text;
                _codeBox.EnabledEx = false;
                _pinCodeBox.Text = ""; //TODO lZbg

                int volume = _parameter.MaximumVolume;
                _volumeBox.MaximumValue = volume;
                _volumeBox.SetTextByInt(volume);
                _volumeBox.ZeroFixedDigits = GetZeroDigitsCountFromVolumeUnit(item.Stock.VolumeUnit);


                this.Invalidate();
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }

        }

        //TradeOrderItem̍쐬Bݒ肪܂΃bZ[W{bNXonullԂ
        private TradeOrderItem CreateTradeOrderItemUI() {

            TradeOrderItem item = new TradeOrderItem(_parameter.CurrentPosition.Stock);
            DateTime now = DateTime.Now;
            item.OrderDate = new BDate(BDate.DateTimeToInt(now));
            item.OrderTime = new BTime(now.Hour, now.Minute, 0);
            item.TransactionStatus = OrderTransactionStatus.Stable;

            item.OrderStatus = OrderStatus.Ordered;
            item.NewOrClose = OrderNewClose.Close;
            item.LongShort = _parameter.CurrentPosition.LongShort;
            item.SpecialClose = item.LongShort==LongShort.Long? SpecialOrderClose.Genhiki : SpecialOrderClose.Genwatashi;
            item.DealType = _parameter.CurrentPosition.DealType;
            item.Kouza = _parameter.CurrentPosition.OrderKouza;
            item.LimitDate = OrderLimitDate.Today;
            item.Volume = _volumeBox.GetTextAsInt();

            item.Condition = OrderCondition.Nariyuki;

            return item;
        }

        private void OnPaintCurrentPositionOrOrder(object sender, PaintEventArgs args) {
            IOrderItemFormatter fmt = BellagioRoot.OrderDataProvider.OrderItemFormatter;
            Font f = _currentPositionOrOrder.Font; //ftHgtHg, uV
            Brush b = SystemBrushes.WindowText;
            Graphics g = args.Graphics;

            TradePositionItem pos = _parameter.CurrentPosition;
            int volume = _parameter.CloseType==OrderFormParameter.ClosePositionType.MultiplePosition? pos.TotalVolume : _parameter.PositionElement.Volume;

            int x = 0;
            int y = _currentPositionOrOrder.Height/2 - DrawStringUtil.GetFontHeightAsInt(f, g);
            DrawStringUtil.MiddleRight(g, fmt.FormatPosition(pos.DealType, pos.LongShort), f, OrderingUtil.IsLong(pos.LongShort)? _buyMarkBrush : _sellMarkBrush, ref x, y);
            DrawStringUtil.MiddleRight(g, pos.DealType==OrderDealType.Genbutsu? " ۗL " : " ʐ ", f, b, ref x, y);
            DrawStringUtil.MiddleRight(g, volume.ToString(), _figureFont, _figureBrush, ref x, y + _figureFontYOffset);
            DrawStringUtil.MiddleRight(g, pos.Stock.Profile.VolumeUnitString, f, b, ref x, y);
            x = 0;
            y = _currentPositionOrOrder.Height/2;
            DrawStringUtil.MiddleRight(g, pos.DealType==OrderDealType.Genbutsu? "擾P " : "ʒP ", f, b, ref x, y);
            double price = _parameter.CloseType==OrderFormParameter.ClosePositionType.MultiplePosition? pos.AveragePrice : (_parameter.PositionElement.Price100/100);
            DrawStringUtil.MiddleRight(g, FormatPrice(price), _figureFont, _figureBrush, ref x, y + _figureFontYOffset);
            DrawStringUtil.MiddleRight(g, "~", f, b, ref x, y);

        }

        protected override void Dispose(bool disposing) {
            base.Dispose(disposing);
            if(disposing) {
                _figureFont.Dispose();
                _figureBrush.Dispose();
                _buyMarkBrush.Dispose();
                _sellMarkBrush.Dispose();
            }
        }

        private Label CreateLabel(string text) {
            Label l = FormUtil.CreateLabel(text);
            l.Font = this.Font;
            l.ForeColor = this.ForeColor;
            l.BackColor = this.BackColor;
            return l;
        }

        private HoveringLabel CreateVolumeChangeLabel(int image_index) {
            IconList il = BellagioRoot.CommonIcons.ControlBoxes;
            HoveringLabel l = new HoveringLabel(il.GetBitmap(0, image_index), il.GetBitmap(1, image_index));
            l.MouseDown += new MouseEventHandler(OnVolumeChangeButtonClick);
            return l;
        }
        private static int GetZeroDigitsCountFromVolumeUnit(int unit) { //TODO OrderFormɂBǂɂ܂Ƃ߂
            Debug.Assert(unit > 0);
            int zero = 0;
            while((unit % 10)==0) {
                zero++;
                unit /= 10;
            }
            return zero;
        }
        //lĩtH[}bgBKvȎ̂ݏ_\
        private static string FormatPrice(double value) {
            double r = value - Math.Floor(value);
            if(r<0.001)
                return value.ToString("F0");
            else
                return value.ToString("F2");
        }

        private static Bitmap LargeBitmap(int index) {
            return OrderingPlugin.OrderingIcons.GetBitmap(index);
        }

    }
}
