/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Forms/BellagioToolBar.cs#16 $
 * $DateTime: 2008/05/14 13:05:12 $
 * 
 * c[o[{́B
 * Office2007Ƃ܂˂đ傫ACRɂĂ݂BȂAڂhbv_E{^̓̂߂Poderosaɋ@\ǉĂ
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

using Travis.ORT;

using Poderosa;
using Poderosa.Commands;
using Poderosa.Forms;
using Poderosa.Util;

using Bellagio.Environment;
using Bellagio;

namespace Bellagio.Forms {
    public class BellagioToolBar : IToolBarComponent {

        private IToolBarElement[] _elements;

        public BellagioToolBar() {
        }
        private void CreateElements() {
            //̂ASɃvOCPʂɕ悤ɂȂĂȂ
            //AR}hGeneralCommandɂÂ炢Ȃǖ菭ȂȂ
            DropDownToolBarElement.CommandConstructorDelegate session_open = delegate(ExtensionKitItem item) {
                return ((ViewSchemaBase)item).SessionOpenCommand;
            };

            //ToolBarComponent̃xŕ΂ł͕̕svɂȂ邪AڏubN}[N͈ɂȂĂ
            List<IToolBarElement> e = new List<IToolBarElement>();
            if(BellagioVersionInfo.EDITION==BellagioEditions.HatchukunTX) {
                e.Add(new DropDownToolBarElement(delegate(IList l) { BellagioRoot.SchemaRoot.CollectStaticChartSchema(l); }, session_open, "`[g", 0, false));
                e.Add(new DropDownToolBarElement(delegate(IList l) { BellagioRoot.SchemaRoot.CollectRealTimeChartSchema(l); }, session_open, "A^C", 1, true));
                e.Add(new DropDownToolBarElement(delegate(IList l) { BellagioRoot.SchemaRoot.CollectFigureBoardSchema(l); }, new DropDownToolBarElement.CommandConstructorDelegate(FigureBoard.FigureBoardSession.CreateOpenOrActivateSessionCommand), "EHb`Xg", 5, true));
                e.Add(new DialogToolBarElement("A[g", 6, new PoderosaCommandImpl(
                    new ExecuteDelegate(Alert.AlertPlugin.Instance.OpenAlertList),
                    new CanExecuteDelegate(delegate(ICommandTarget target) { return BellagioRoot.DataSourceHost.IsConnected; }))));
                e.Add(new DialogToolBarElement("ubN}[N", 12, Bookmark.BookmarkPlugin.Instance.OpenBookamrkCommand));
            }
            else {
                e.Add(new DropDownToolBarElement(delegate(IList l) { BellagioRoot.SchemaRoot.CollectStaticChartSchema(l); }, session_open, "`[g", 0, false));
                e.Add(new DialogToolBarElement("XN[jO", 1, Screening.ScreeningPlugin.Instance.OpenScreeningDialogCommand));
                e.Add(new DialogToolBarElement("", 2, Screening.ScreeningPlugin.Instance.OpenAutoTradingDialogCommand));
                e.Add(new DialogToolBarElement("ubN}[N", 3, Bookmark.BookmarkPlugin.Instance.OpenBookamrkCommand));
            }
            _elements = e.ToArray();
        }

        public IToolBarElement[] ToolBarElements {
            get {
                if(_elements==null) CreateElements();
                return _elements;
            }
        }

        public Size BarImageSize {
            get {
                return new Size(24, 24);
            }
        }

        public IAdaptable GetAdapter(Type adapter) {
            return BUtil.DefaultGetAdapter(this, adapter);
        }

        public delegate void CollectorDelegate(IList l);
    }


    public class DropDownToolBarElement : IToolBarDropDownButton {
        public delegate IPoderosaCommand CommandConstructorDelegate(ExtensionKitItem kitItem);
        private BellagioToolBar.CollectorDelegate _collector;
        private CommandConstructorDelegate _commandConstructor;

        private IPoderosaMenuItem[] _menus;
        private bool _loginRequired;
        private string _text;
        private int _iconIndex;

        public DropDownToolBarElement(BellagioToolBar.CollectorDelegate collector, CommandConstructorDelegate commandConstructor, string text, int iconIndex, bool login_required) {
            _collector = collector;
            _commandConstructor = commandConstructor;
            _text = text;
            _iconIndex = iconIndex;
            _loginRequired = login_required;
        }

        public IPoderosaMenuItem[] Items {
            get {
                //gLbg[hɔLbV͂߂
                List<ExtensionKitItem> coll = new List<ExtensionKitItem>();
                _collector(coll);
                _menus = new IPoderosaMenuItem[coll.Count];
                for(int i=0; i<_menus.Length; i++) {
                    ExtensionKitItem k = coll[i];
                    PoderosaMenuItemImpl mi = new PoderosaMenuItemImpl(_commandConstructor(k), FormatLabel(k));

                    _menus[i] = mi;
                }

                return _menus;
            }
        }

        public string Text {
            get {
                return _text;
            }
        }

        public Image Icon {
            get {
                return BellagioRoot.CommonIcons.LargeSessions.GetBitmap(_iconIndex);
            }
        }

        public bool IsEnabled(ICommandTarget target) {
            return _loginRequired? BellagioRoot.DataSourceHost.IsConnected : true;
        }

        public string ToolTipText {
            get {
                return null;
            }
        }

        public IAdaptable GetAdapter(Type adapter) {
            return BUtil.DefaultGetAdapter(this, adapter);
        }

        private string FormatLabel(ExtensionKitItem item) {
            ORText d = item.description;
            if(!d.IsOmitted)
                return d.Value;
            else
                return item.id.Value;
        }
    }



    public class DialogToolBarElement : IToolBarCommandButton {
        private string _text;
        private int _iconIndex;
        private IPoderosaCommand _command;

        public DialogToolBarElement(string text, int iconIndex, IPoderosaCommand command) {
            _text = text;
            _iconIndex = iconIndex;
            _command = command;
        }

        public string Text {
            get {
                return _text;
            }
        }

        public ContentAlignment ImageAlign {
            get {
                return ContentAlignment.MiddleLeft;
            }
        }

        public Image Icon {
            get {
                return BellagioRoot.CommonIcons.LargeSessions.GetBitmap(_iconIndex);
            }
        }

        public bool IsEnabled(ICommandTarget target) {
            return _command.CanExecute(target);
        }

        public string ToolTipText {
            get {
                ICommandManager cm = BellagioPlugin.Instance.CommandManager;
                IGeneralCommand gc = _command as IGeneralCommand;
                if(gc!=null) {
                    Keys sc = cm.CurrentKeyBinds.GetKey(gc);
                    if(sc==Keys.None)
                        return _text;
                    else
                        return String.Format("{0} ({1})", _text, WinFormsUtil.FormatShortcut(sc));
                }
                else
                    return _text;
            }
        }

        public IAdaptable GetAdapter(Type adapter) {
            return BUtil.DefaultGetAdapter(this, adapter);
        }
        public IPoderosaCommand Command {
            get {
                return _command;
            }
        }

    }
}
