﻿/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id$
 * $DateTime$
 * 
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;

using Bellagio.Values;

namespace Bellagio.Evaluators {
    //ひとつのBMethodを実行するコンテキスト
    public class BStackFrame {
        private BMethod _context;
        private BStackFrame _parent;
        private BV[] _values;
        private BV[][] _invokeArguments;
        private bool _using; //再利用に使うフラグ

        public BStackFrame(BMethod method, BStackFrame parent, BV[] args) {
            _context = method;
            _parent = parent;

            Initialize(args, method.Parameters, method.IntermediateValues, method.ExternalContextValues, method.InvokeArgumentSizes);

        }
        public BStackFrame(EvaluatorBuildContext ctx, BV[] args) {
            _context = null;
            _parent = null;

            Initialize(args, ctx.Arguments, ctx.Intermediates, new BMethod.ExternalBoundValueTag[0], ctx.InvokeArgSizes);
        }
        private void Initialize(BV[] args, LocalVariable[] parameters, LocalVariable[] intermediates, BMethod.ExternalBoundValueTag[] externalContextValues, int[] invokeArgumentSizes) {
            LocalVariable[] pa = parameters;
            Debug.Assert(pa.Length==args.Length);
            LocalVariable[] im = intermediates;
            BMethod.ExternalBoundValueTag[] ex = externalContextValues;

            _values = new BV[pa.Length + im.Length + ex.Length];
            int i = 0;
            foreach(LocalVariable v in pa) { _values[i] = args[i]; i++; }
            foreach(LocalVariable v in im) _values[i++] = v.BT.CreateInstance();
            foreach(BMethod.ExternalBoundValueTag v in ex) _values[i++] = v.externalVar.BT.CreateInstance();

            int[] sizes = invokeArgumentSizes;
            _invokeArguments = new BV[sizes.Length][];
            for(i=0; i<sizes.Length; i++)
                _invokeArguments[i] = new BV[sizes[i]];

            _using = true;
        }

        public bool Using {
            get {
                return _using;
            }
            set {
                _using = value;
            }
        }

        public BStackFrame ParentFrame {
            get {
                return _parent;
            }
        }

        public void Reuse(BStackFrame parent, BV[] args) {
            _parent = parent;

            for(int i=0; i<args.Length; i++) { _values[i] = args[i]; }

            _using = true;
        }


        //これに対して破壊的代入をする。Nilは入れない！
        public BV GetAt(int index) {
            return _values[index];
        }

        public BV[] GetInvokeArgumentBuffer(int index) {
            return _invokeArguments[index];
        }
    }
}
