/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Data/DataSourceHost.cs#8 $
 * $DateTime: 2007/09/19 15:00:21 $
 * 
 * ،Ђ̏ԁAʒmȂǂm点BOC܂ށBOf[^\[Xʒm悱
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;

using Bellagio.Forms;
using Bellagio.Values;
using Bellagio.Environment;
using Bellagio.Ordering;

using Poderosa;
using Poderosa.Forms;
using Poderosa.Commands;

using Travis;

namespace Bellagio.Data {

    public interface IDataSourceEnvironment {
        //
        int CurrentDate { get; }
        bool IsStockCacheFileAvailable { get; }

        //ӃIuWFNg
        IDataSourceConnectionInfo ConnectionInfo { get; }

        ITickDataSource TickDataSource { get; }
        IItaDataSource ItaDataSource { get; }
        ILightIntraDayTradeSource IndexDataSource { get; }
        IOrderDataSource OrderDataSource { get; }
        IDataSourceAccountInfo AccountInfo { get; }

        DialogResult ShowLoginDialog(Form parent, string inital_account, string initial_password);
        void Logout();

        void EnterToOfflineMode();

        //Xg[ؒf
        void DisconnectStream();
        //Xg[̂ݐ؂ꂽƂ̕A
        AsyncOpResult ResumeStream(ref string message);

        //HeartBeatM
        void SendStreamHeartBeat();
        void SendWebHeartBeat();
#if DEBUG
        //G[̃V~[V
        void EmulateInterruptingSnapshot(Stock stock, int tickCount, int time, int price, int volume);
        bool EmulateOrderServerError { get; set; }
        bool EmulateOnDemandServerError { get; set; }
        void ItaResubscribe(Stock stock);
#endif
    }

    //ڑ̎ӏ
    public interface IDataSourceConnectionInfo {
        int StreamHeartBeatInterval { get; }
        int WebHeartBeatInterval { get; }
        int OrderStatusRefreshSuppressTime { get; }
    }

    //ڋq̏Ɋւ̂^
    public interface IDataSourceAccountInfo {
        bool TokuteiKouzaAvailable { get; set; }
    }

    public enum OrderStatusEvent {
        Accepted, //ɒʂ
        Changed,  //ύX
        Cancelled, //
        Expired, //
        Failed,  //s
        Ignore,  //Ă悢
    }
    public enum OrderStatusCodeCategory {
        Stock,
        Future,
        Option
    }

    public enum NotifyMessageAction {
        MessageOnly,       //bZ[W\̂
        DisconnectStream,  //Xg[ؒf
        ForceQuit          //AvI
    }

    public interface IDataSourceHost : IAdaptable {
        void BeginLogin(string account, string password);
        void EnterToOfflineMode(); //[J[hւ̈ڍsB͓IɌʂԂȂƂȂ
        void CompleteAsyncLogin(AsyncOpResult result, int timestamp, string message);

        void CompleteResumeStream(AsyncOpResult result, string message);

        void NotifyCurrentTime(int time); //BTimeƓlintn
        void NotifyTrade(string orderCode, OrderStatusCodeCategory category, bool completed, int time, int price, int volume); //ʒm
        void NotifyMessage(string message, NotifyMessageAction action);
        void UpdateOrderStatus(string orderCode, OrderStatusCodeCategory category, OrderStatusEvent eventcode); //ȊO̒ԕω
        
        AbstractStockProfile FindStockProfile(string code);
        DerivativeStockProfile FindDerivativeStockProfile(string code, bool includes_hidden); //،Ƌ̂XR[h̃T[`
    }

    public enum DataSourceStatus {
        Empty,        //ԁBOCĂȂB
        Disconnected, //ߋɃOCAXg[؂ꂽ
        Offline,      //IɃItCԂɂȂ
        Connected     //ڑ
    }
    //NOTE OCȂ@\݂͑ȂBStockIuWFNgč\zɂȂƕA͔ɍł邽߁B


    public class DataSourceHost : IDataSourceHost {
        private IDataSourceEnvironment _dataSource;
        private DataSourceStatus _dataSourceStatus;
        private bool _loginAtLeastOnce; //xłOCǂB}X^[hɊ֌W
        private string _lastAccount;
        private string _lastPassword;

        private BTime _currentTime;

        private class OrderAndPositionRefreshRequest {
            public int reservedTime;
            public int lastExecutionTime;
            public TradeOrderItem orderItem;
            public bool stockPositionRefreshRequired;
            public bool derivativePositionRefreshRequired;
            public bool allOrderRefreshRequired;
            public void Reset(TradeOrderItem item) {
                orderItem = item;
                reservedTime = 0;
                stockPositionRefreshRequired = false;
                derivativePositionRefreshRequired = false;
                allOrderRefreshRequired = item==null;
            }
        }
        private OrderAndPositionRefreshRequest _orderAndPositionRefreshRequest;

        public DataSourceHost() {
            _orderAndPositionRefreshRequest = new OrderAndPositionRefreshRequest();
            _dataSourceStatus = DataSourceStatus.Empty;
            _currentTime = new BTime(0);
        }
        public DataSourceStatus CurrentStatus {
            get {
                return _dataSourceStatus;
            }
        }
        public bool IsConnected {
            get {
                return _dataSourceStatus==DataSourceStatus.Connected;
            }
        }
        public IDataSourceEnvironment ExternalEnvironment {
            get {
                return _dataSource;
            }
        }
        public void Initialize(IDataSourceEnvironment de) {
            _dataSource = de;
        }
        public void NotifyCurrentTime(int time) {
            _currentTime.LetInt(time - BellagioRoot.FixedPreferences.QuoteTimeMargin);
            BellagioRoot.TimeManager.OnExternalMinutelyTick(_currentTime);
        }
        public void NotifyTrade(string orderCode, OrderStatusCodeCategory category, bool completed, int time, int price, int volume) {
            TradeOrderItem item = BellagioRoot.OrderDataProvider.FindOrGetTradeOrderItemByID(orderCode, category);
            if(item==null) {
                Debug.WriteLine(String.Format("L[{0}ɑΉf[^܂", orderCode));
                return;
            }
            TradeOrderItem.Element elem = new TradeOrderItem.Element();
            elem.Time = new BTime(time);
            elem.Price = item.AdjustReversePriceI(price);
            elem.Volume = volume;

            BellagioRoot.MainThreadControl.Invoke(new NotifyTradeDelegate(NotifyTradeMain), item, elem);
        }

        private delegate void NotifyTradeDelegate(TradeOrderItem item, TradeOrderItem.Element elem);
        

        private void NotifyTradeMain(TradeOrderItem item, TradeOrderItem.Element elem) {
            try {
                Debug.Assert(BUtil.IsExecutingInMainThread);

                //ʒm\
                if(BellagioRoot.FixedPreferences.Ordering.ShowTradeNotification)
                    OrderingPlugin.Instance.Commands.OpenTradeNotification(BellagioPlugin.Instance.WindowManager.ActiveWindow, item, elem);

                UpdateOrderListRefreshRequest(item, true, item.Stock.Profile.IsDerivative? OrderStatusCodeCategory.Future : OrderStatusCodeCategory.Stock);
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }
        public void UpdateOrderStatus(string orderCode, OrderStatusCodeCategory category, OrderStatusEvent eventCode) {
            if(eventCode==OrderStatusEvent.Ignore) return;

            BellagioRoot.OrderDataProvider.UpdateOrderStatus(orderCode, eventCode);
            TradeOrderItem item = BellagioRoot.OrderDataProvider.FindTradeOrderItemByID(orderCode);
            //茳Ƀf[^ȂƂ͑SXV𑣂
            UpdateOrderListRefreshRequest(item, eventCode!=OrderStatusEvent.Changed && eventCode!=OrderStatusEvent.Accepted, category); //Accept͒𓊂Ƃɍŝŕsv
        }
        private void UpdateOrderListRefreshRequest(TradeOrderItem item, bool position_refresh_required, OrderStatusCodeCategory category) {
            //Ƀ|WVSƒԂtbV@ԊuߐڂƂ͂̃IuWFNgč쐬̂ŃXLbv
            //Őݒ肵eɊÂĎŝSecondlyTask
            lock(_orderAndPositionRefreshRequest) {
                if(_orderAndPositionRefreshRequest.lastExecutionTime + _dataSource.ConnectionInfo.OrderStatusRefreshSuppressTime <= _currentTime.AsInt()) { //܂͎Ԃo߂ĂƂ
                    _orderAndPositionRefreshRequest.Reset(item);
                    _orderAndPositionRefreshRequest.reservedTime = _currentTime.AsInt();
                }
                else {
                    _orderAndPositionRefreshRequest.reservedTime = _currentTime.AsInt() + _dataSource.ConnectionInfo.OrderStatusRefreshSuppressTime;
                    
                    if(!_orderAndPositionRefreshRequest.allOrderRefreshRequired) {
                        if(item==null || _orderAndPositionRefreshRequest.orderItem.UniqueString!=item.UniqueString) //꒍łȂȂStbV
                            _orderAndPositionRefreshRequest.allOrderRefreshRequired = true;
                    }
                }

                //ύXł̓|WVɂ͕ωȂB
                if(position_refresh_required && BellagioRoot.FixedPreferences.Ordering.PositionRefreshByTrade) {
                    _orderAndPositionRefreshRequest.stockPositionRefreshRequired |= category==OrderStatusCodeCategory.Stock;
                    _orderAndPositionRefreshRequest.derivativePositionRefreshRequired |= category==OrderStatusCodeCategory.Future || category==OrderStatusCodeCategory.Option;
                }
            }
        }

        public void NotifyMessage(string message, NotifyMessageAction action) {
            try {
                if(BellagioPlugin.Instance.PoderosaApplication.IsExitingApplication) return;

                BellagioRoot.UIError.ShowLater(UIError.ErrorType.FatalExit, null, message);
                if(action==NotifyMessageAction.DisconnectStream) {
                    _dataSource.DisconnectStream();
                    _dataSourceStatus = DataSourceStatus.Disconnected;
                    BellagioRoot.MainThreadControl.Invoke(new VoidVoidDelegate(AdjustUI));
                }
                else if(action==NotifyMessageAction.ForceQuit) {
                    BellagioRoot.MainThreadControl.Invoke(new VoidVoidDelegate(LogoutAndQuit));
                }
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }

        public IAdaptable GetAdapter(Type adapter) {
            return BUtil.DefaultGetAdapter(this, adapter);
        }

        public AbstractStockProfile FindStockProfile(string code) {
            return BellagioRoot.GlobalStockCollection.FindExact(code);
        }
        public DerivativeStockProfile FindDerivativeStockProfile(string code, bool includes_hidden) {
            return BellagioRoot.GlobalStockCollection.FindDerivativeStockProfile(code, includes_hidden, EveningSessionAware.Preference);
        }
        public bool CanOpenRealtimeData(Stock stock) {
            if(!this.IsConnected) return false;
            AbstractStockProfile sp = stock.Profile;
            if((sp.Flags & StockProfileFlags.Hidden)!=StockProfileFlags.None) return false;

            if(sp is MarketIndex)
                return false; //w͓nł̂ݑIł
            else if(sp is BasicStockProfile) { //ʏ́Ap~Ȃnł̂ݑIł
                if(sp.Primary==null) return false; //{肦ȂA}X^̃oO
                if((sp.Primary.StockFlags & StockFlags.Obsolete)!=StockFlags.None)
                    return false;
                else
                    return true;
            }
            else {
                Debug.Assert(sp is DerivativeStockProfile);
                DerivativeStockProfile dp = sp as DerivativeStockProfile;
                return dp.ConcatinatedFuture? false : true; //SԘÂ͓݁AȊO͑S\BCujOZbVw肪ʂ̂Hiddenŏ̂OK
            }

        }

        //GMOpłƂ̋Ɩt
        public int GetCurrentOrderingDate() {
            if(_dataSourceStatus==DataSourceStatus.Connected)
                return _dataSource.CurrentDate;
            else
                return BDate.DateTimeToInt(DateTime.Now);
        }

        //bPʂōsׂ^XN
        private int _lastStreamHeartBeatTime;
        private int _lastWebHeartBeatTime;
        public void DoSecondlyTask(BTime time_) {
            int time = time_.AsInt();
            _currentTime.LetInt(time);

            if(_dataSourceStatus==DataSourceStatus.Connected) {
                if(_dataSource.ConnectionInfo.StreamHeartBeatInterval > 0 && time >= _lastStreamHeartBeatTime + _dataSource.ConnectionInfo.StreamHeartBeatInterval - 3) { //RbOɂ͔OƂ
                    _dataSource.SendStreamHeartBeat();
                    Debug.WriteLineIf(BRuntimeOpts.TRACE_HEARTBEAT, "HeartBeat(Stream) " + time);
                    _lastStreamHeartBeatTime = time;
                }
            }
            if(_dataSourceStatus==DataSourceStatus.Connected || _dataSourceStatus==DataSourceStatus.Disconnected) { //WebDisconnectedł
                if(_dataSource.ConnectionInfo.WebHeartBeatInterval > 0 && time >= _lastWebHeartBeatTime + _dataSource.ConnectionInfo.WebHeartBeatInterval - 3) { //RbOɂ͔OƂ
                    _dataSource.SendWebHeartBeat();
                    Debug.WriteLineIf(BRuntimeOpts.TRACE_HEARTBEAT, "HeartBeat(Web) " + time);
                    _lastWebHeartBeatTime = time;
                }
            }

            //Order/PositiontbV
            lock(_orderAndPositionRefreshRequest) {
                if(_orderAndPositionRefreshRequest.reservedTime!=0 && _orderAndPositionRefreshRequest.reservedTime <= time) {
                    //|WV̓tOɉ
                    if(_orderAndPositionRefreshRequest.stockPositionRefreshRequired)
                        BellagioRoot.OrderDataProvider.StockPosition.Refresh();
                    if(_orderAndPositionRefreshRequest.derivativePositionRefreshRequired)
                        BellagioRoot.OrderDataProvider.DerivativePosition.Refresh();

                    //͑SwȂSAłȂΒP
                    if(_orderAndPositionRefreshRequest.allOrderRefreshRequired) {
                        BellagioRoot.OrderDataProvider.StockOrder.Refresh();
                        BellagioRoot.OrderDataProvider.DerivativeOrder.Refresh();
                    }
                    else 
                        BellagioRoot.OrderDataProvider.RefreshOrder(_orderAndPositionRefreshRequest.orderItem);


                    _orderAndPositionRefreshRequest.lastExecutionTime = time;
                    _orderAndPositionRefreshRequest.reservedTime = 0;
                }
            }
        }



        //f[^̕KvȃR}h̎sOɕKĂԂ
        public CommandResult CheckDataSource() {
            if(_dataSourceStatus==DataSourceStatus.Connected || _dataSourceStatus==DataSourceStatus.Offline)
                return CommandResult.Succeeded; //ڑς݂ȂOK
            else
                return LoginOrResume();
        }

        public CommandResult Logout() {
            if(_dataSourceStatus==DataSourceStatus.Connected) {
                try {
                    _dataSource.Logout();
                    return CommandResult.Succeeded;
                }
                catch(Exception ex) {
                    RuntimeUtil.SilentReportException(ex); //OAEgł̓G[͂Ȃ
                    return CommandResult.Failed;
                }
            }
            else
                return CommandResult.Ignored;
        }
        private void LogoutAndQuit() {
            try {
                Logout();
                BellagioRoot.ExitApplication();
            }
            catch(Exception ex) {
                RuntimeUtil.SilentReportException(ex);
            }
        }

        public CommandResult LoginOrResume() {
            if(_dataSourceStatus==DataSourceStatus.Empty || _dataSourceStatus==DataSourceStatus.Offline) {

                //ItĈƂ͂܂SZbV
                if(_dataSourceStatus==DataSourceStatus.Offline) {
                    IPoderosaCommand cmd = BellagioPlugin.Instance.CommandManager.Find("org.poderosa.core.window.closeall");
                    Debug.Assert(cmd!=null);
                    BellagioPlugin.Instance.CommandManager.Execute(cmd, BellagioPlugin.Instance.WindowManager.ActiveWindow);
                }

                Debug.Assert(BUtil.IsExecutingInMainThread);
                FixedPreferences fp = BellagioRoot.FixedPreferences;
                DialogResult dr = _dataSource.ShowLoginDialog(BellagioPlugin.Instance.MainWindow, fp.SavedAccount, fp.AutoPassword? fp.SavedPassword : "");
                return dr==DialogResult.Cancel? CommandResult.Cancelled : CommandResult.Succeeded;
            }
            else if(_dataSourceStatus==DataSourceStatus.Disconnected) {
                return this.ResumeStream();
            }
            else
                return CommandResult.Ignored;
        }

        public CommandResult ResumeStream() {
            try {
                string msg = null;
                AsyncOpResult r = _dataSource.ResumeStream(ref msg);
                if(r==AsyncOpResult.Failed) {
                    BUtil.ShowWarningMessageBox(msg);
                    return CommandResult.Failed;
                }
                else
                    return CommandResult.Succeeded; //Async܂
            }
            catch(Exception ex) { //ł̗O͗ƂĂ܂B`Pbg擾łȂꍇ
                BUtil.ShowWarningMessageBox(ex.Message);
                BellagioRoot.ExitApplication();
                return CommandResult.Failed;
            }
        }

        public CommandResult DisconnectStream() {
            _dataSource.DisconnectStream();
            _dataSourceStatus = DataSourceStatus.Disconnected;
            AdjustUI();
            return CommandResult.Succeeded;
        }


        void IDataSourceHost.BeginLogin(string account, string password) {
            BellagioRoot.GlobalStockCollection.Clear();
            _lastAccount = account;
            _lastPassword = password;

        }
        void IDataSourceHost.EnterToOfflineMode() {
            if(!_loginAtLeastOnce) {
                BellagioRoot.GlobalStockCollection.Clear();
            }

            _dataSourceStatus = DataSourceStatus.Offline;
            AdjustUI();
        }


        //LoginBodyƑ΂ɂȂĂ̑BOC_CAO͗LłȂ
        void IDataSourceHost.CompleteAsyncLogin(AsyncOpResult result, int timestamp, string message) {
            int time_adjust = BellagioRoot.FixedPreferences.QuoteTimeMargin;

            Debug.Assert(result!=AsyncOpResult.Async); //Eŝǂ炩

            //OĈŕۑ
            if(result==AsyncOpResult.Succeeded) {
                BellagioRoot.FixedPreferences.SavedAccount = _lastAccount;
                BellagioRoot.FixedPreferences.SavedPassword = BellagioRoot.FixedPreferences.AutoPassword? _lastPassword : ""; //SavedPasswordɉĂĂ㏑
            }

            if(result==AsyncOpResult.Succeeded) {
                _dataSourceStatus = DataSourceStatus.Connected;

                _currentTime.LetInt(timestamp - time_adjust);
                BellagioRoot.TimeManager.OnExternalMinutelyTick(_currentTime);

                //Xg̏I(̐̂Ƃ̂)
                if(!_loginAtLeastOnce)
                    BellagioRoot.GlobalStockCollection.AfterRegistrationAction();

                _loginAtLeastOnce = true;
            }
            else if(result==AsyncOpResult.Failed) {
                BUtil.ShowWarningMessageBox(message);
                _dataSourceStatus = DataSourceStatus.Disconnected;
            }
            _lastPassword = "";
            _lastAccount = ""; //珜(GC悾)
            BellagioPlugin.Instance.MainWindow.Invoke(new VoidVoidDelegate(AdjustUI));

        }

        void IDataSourceHost.CompleteResumeStream(AsyncOpResult result, string message) {
            if(result==AsyncOpResult.Succeeded) {
                _dataSourceStatus = DataSourceStatus.Connected;

                BellagioPlugin.Instance.MainWindow.BeginInvoke(new VoidVoidDelegate(ResumeMain));
            }
            else if(result==AsyncOpResult.Failed) {
                BUtil.ShowWarningMessageBox(message);
                _dataSourceStatus = DataSourceStatus.Disconnected;
            }
            BellagioPlugin.Instance.MainWindow.Invoke(new VoidVoidDelegate(AdjustUI));
        }
        private void ResumeMain() {
            try {
                Debug.Assert(BUtil.IsExecutingInMainThread);
                ResumeInfo resume = new ResumeInfo();
                resume.Create();

                ResumeProcessDialog dlg = new ResumeProcessDialog(resume);
                DialogResult dr = dlg.ShowDialog(BellagioPlugin.Instance.MainWindow);
                dlg.Dispose();
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }

        //c[o[̏ԍXV
        private void AdjustUI() {
            BellagioPlugin.Instance.WindowManager.RefreshToolBar();
            BellagioPlugin.Instance.RefreshStatusBar();
        }

    }

    //OC̃{^񋟂c[o[
    public class LoginToolBarComponent : IToolBarComponent {
        private IToolBarElement[] _elements;
        private ToolBarCommandButtonImpl _loginOrOfflineModeButton;

        private void CreateToolBar() {
            _elements = new IToolBarElement[1];
            _loginOrOfflineModeButton =  new LoginButton();
            _elements[0] = _loginOrOfflineModeButton;
        }



        IToolBarElement[] IToolBarComponent.ToolBarElements {
            get {
                if(_elements==null) CreateToolBar();
                return _elements;
            }
        }

        Size IToolBarComponent.BarImageSize {
            get {
                return new Size(24, 24);
            }
        }

        IAdaptable IAdaptable.GetAdapter(Type adapter) {
            return BUtil.DefaultGetAdapter(this, adapter);
        }


        private class LoginButton : ToolBarCommandButtonImpl {
            public LoginButton()
                : base(BellagioPlugin.Instance.Commands.LoginCommand, GetIcon(9)) {
                _imageAlign = ContentAlignment.MiddleLeft;
            }
            public override Image Icon {
                get {
                    //bool can_login = BellagioRoot.DataSourceHost.CurrentStatus!=DataSourceStatus.Connected;
                    return GetIcon(9);
                }
            }
            public override string Text {
                get {
                    return "ڑ";
                }
            }
            private static Image GetIcon(int index) {
                return BellagioRoot.CommonIcons.LargeSessions.GetBitmap(index);
            }
        }
    }


    //f[^\[XŒ񋟂IuWFNgŁA񓯊ǂݍ݂̂bvB
    //ƂĂBellagioDocumentBaseɎĂ邪ASessionƂ͖֌Wł_AԕύXʒmDelegate𕡐Ă_Ⴄ
    public abstract class AsyncLoadDataSourceObjectHost {
        protected BellagioDocumentStatus _status;
        protected List<DataThreadToMainThread> _listeners;

        public AsyncLoadDataSourceObjectHost() {
            _listeners = new List<DataThreadToMainThread>();
            _status = BellagioDocumentStatus.Empty;
        }

        public BellagioDocumentStatus DocumentStatus {
            get {
                return _status;
            }
        }
        public void AddListener(DataThreadToMainThread d) {
            lock(this) {
                _listeners.Add(d);
            }
        }
        public void RemoveListener(DataThreadToMainThread d) {
            lock(this) {
                _listeners.Remove(d);
            }
        }

        public void CallEventDelegates() {
            //fQ[gĂяo̍ŒAdd/RemoveListenerƍ̂ŁÃ\bhŜlock킯ɂ͂Ȃ
            DataThreadToMainThread[] ds;
            lock(this) {
                ds = _listeners.ToArray();
            }

            if(ds.Length > 0) {
                bool invoke_req = !BUtil.IsExecutingInMainThread;
                Control target = invoke_req? BellagioPlugin.Instance.MainWindow : null;

                foreach(DataThreadToMainThread d in ds) {
                    if(invoke_req)
                        target.Invoke(d);
                    else
                        d();
                }
            }
        }

    }

    //IuWFg܂ŃZbgɂ
    public class AsyncLoadingDataSourceObjectHostT<T> : AsyncLoadDataSourceObjectHost where T:class {
        private T _value;
        public AsyncLoadingDataSourceObjectHostT() {
            _value = null;
        }

        public T Value {
            get {
                return _value;
            }
        }

        public void InternalSetValueAndStatus(T value, BellagioDocumentStatus status) {
            BellagioDocumentStatus prev = _status;
            _value = value;
            _status = status;
            if(_value!=null || prev!=_status)
                CallEventDelegates();
        }


    }


}
