/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Chart/ChartOptionPanel.cs#4 $
 * $DateTime: 2008/05/14 13:05:12 $
 * 
 * `[gݒ̃IvVpl
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Diagnostics;
using System.Windows.Forms;

using Bellagio.Forms;
using Bellagio.Drawing;
using Bellagio.Environment;
using Bellagio.Data;

using Travis.LocationOperation;
using Poderosa.Usability;
using Poderosa.Preferences;
using Poderosa.UI;

namespace Bellagio.Chart {
    public class ChartOptionPanelExtension : IOptionPanelExtension {
        private ChartOptionPanel _panel;

        public string Caption {
            get {
                return "`[g";
            }
        }

        public System.Drawing.Image Icon {
            get {
                if(BellagioVersionInfo.EDITION==BellagioEditions.HatchukunTX)
                    return BellagioRoot.CommonIcons.OptionDialogButtons.GetBitmap(0);
                else
                    return BellagioRoot.CommonIcons.LargeSessions.GetBitmap(0);
            }
        }

        public string[] PreferenceFolderIDsToEdit {
            get {
                return new string[] { "tactico.chart", "tactico.chartDrawing" };
            }
        }

        public Panel ContentPanel {
            get {
                return _panel;
            }
        }

        public void InitiUI(IPreferenceFolder[] values) {
            if(_panel==null) _panel = new ChartOptionPanel();
            _panel.InitUI(values[0], values[1]);
        }

        public bool Commit(IPreferenceFolder[] values) {
            return _panel.Commit(values[0], values[1]);
        }

        public void Dispose() {
            if(_panel!=null) {
                _panel.Dispose();
                _panel = null;
            }
        }
    }

    //IvVpl̃tHgݒUI@xAtHg\AύX{^̑g
    public class FontConfig {
        private Label _label;
        private Label _valueLabel;
        private Button _changeButton;
        private SmartFont _value;

        public FontConfig(Control container, string label, int x, ref int y) {
            _label = FormUtil.CreateLabel(label);
            _changeButton = new Button();
            _valueLabel = FormUtil.CreateLabel("");
            _changeButton.Text = "ύX...";
            _changeButton.Click += new EventHandler(OnChangeFont);

            _label.Location = new Point(x, y+2);
            _label.Size = new Size(120, 19);
            _valueLabel.Location = new Point(x + _label.Width, y);
            _valueLabel.Size = new Size(100, 24);
            _changeButton.Location = new Point(_valueLabel.Right, y);
            _changeButton.Size = new Size(60, 24);
            y += 24;

            container.Controls.Add(_label);
            container.Controls.Add(_valueLabel);
            container.Controls.Add(_changeButton);
        }
        public SmartFont Value {
            get {
                return _value;
            }
        }
        public void SetFont(DSFont f) {
            SetFont(f.F);
            _value.Set(f.SmartFont);
        }
        private void SetFont(Font f) {
            _valueLabel.Text = String.Format("{0} {1}pt", f.Name, f.Size);
        }
        private void OnChangeFont(object sender, EventArgs args) {
            /*
            BFontDialog fd = new BFontDialog();
            fd.SetFont(false, _value.F);
            if(fd.ShowDialog()==DialogResult.OK) {
                Font result = fd.JapaneseFont;
                _value.Set(result.Name, result.Size, result.Style);
                this.SetFont(result);
            }
            */
            FontDialog fd = new FontDialog();
            fd.AllowVerticalFonts = false;
            fd.FontMustExist = true;
            fd.AllowScriptChange = true;
            fd.ShowEffects = false;
            byte charset = _value.F.GdiCharSet;
            fd.Font = (charset==0 || charset==128)? (Font)_value.F.Clone() : new Font(DSFont.GenericFontName, 8) ;
            if(fd.ShowDialog()==DialogResult.OK) {
                Font result = (Font)fd.Font.Clone();
                if(result.GdiCharSet!=0 && result.GdiCharSet!=128) //{EȊO݂Ƃ߂Ȃ
                    BUtil.ShowWarningMessageBox("̎ނ̃tHg͎wł܂");
                else {
                    _value.Set(result.Name, result.Size, result.Style);
                    this.SetFont(result);
                }
            }


            fd.Dispose();
        }
    }

    //Fݒ
    public class ColorConfig {
        private Label _label;
        private ColorButton _button;

        public ColorConfig(Control container, string label, int x, int y) { //refȂ͒l̍XVȂ
            Init(container, label, x, ref y);
        }
        public ColorConfig(Control container, string label, int x, ref int y) {
            Init(container, label, x, ref y);
        }
        private void Init(Control container, string label, int x, ref int y) {
            _label = FormUtil.CreateLabel(label);
            _button = new ColorButton();
            _button.ColorChanged += new ColorButton.NewColorEventHandler(OnColorChanged);

            _label.Location = new Point(x, y+2);
            _label.Size = new Size(120, 19);
            _button.Location = new Point(_label.Right, y);
            _button.Size = new Size(60, 24);
            y += 24;

            container.Controls.Add(_label);
            container.Controls.Add(_button);
        }


        private void OnColorChanged(object sender, Color newcolor) {
        }

        public Color SelectedColor {
            get {
                return _button.SelectedColor;
            }
            set {
                _button.SelectedColor = value;
            }
        }
    }

    //yݒ ͂PŒ
    public class PenConfig {
        private Label _label;
        private ComboBox _style;
        private ColorButton _button;

        public PenConfig(Control container, string label, int x, ref int y) {
            _label = FormUtil.CreateLabel(label);
            _style = FormUtil.CreateComboBox("", "_");
            _button = new ColorButton();
            _button.ColorChanged += new ColorButton.NewColorEventHandler(OnColorChanged);

            _label.Location = new Point(x, y+2);
            _label.Size = new Size(120, 19);
            _style.Location = new Point(_label.Right, y);
            _style.Size = new Size(48, 24);
            _button.Location = new Point(_style.Right+8, y);
            _button.Size = new Size(60, 24);
            y += 24;

            container.Controls.Add(_label);
            container.Controls.Add(_style);
            container.Controls.Add(_button);
        }

        public void SetPen(BPenStyle p) {
            _button.SelectedColor = p.color;
            _style.SelectedIndex = (int)p.dash;
        }

        private void OnColorChanged(object sender, Color newcolor) {
        }

        public BPenStyle SelectedPen {
            get {
                return new BPenStyle(_button.SelectedColor, (BPenStyle.DashStyle)_style.SelectedIndex, 1);
            }
            set {
                _style.SelectedIndex = (int)value.dash;
                _button.SelectedColor = value.color;
            }
        }
    }


    public class ChartOptionPanel : Panel {
        private GroupBox _chartGroup;
        private FontConfig _mainFont;
        private ColorConfig _candleColor;
        private Label _candleWidthLabel;
        private ComboBox _candleWidthBox;
        private ColorConfig _volumeColor;
        private Label _candleSpacingLabel;
        private ComboBox _candleSpacingBox;
        private PenConfig _pricePen;
        private PenConfig _timePen;
        private PenConfig _mouseTrackingPrice;
        private PenConfig _mouseTrackingTime;
        private ColorConfig _freeLinePen;

        private GroupBox _dataGroup;
        private CheckBox _enableAnimation;
        private Label _eveningSessionAwareLabel;
        private ComboBox _eveningSessionAwareBox;

        public ChartOptionPanel() {
            _chartGroup = new GroupBox();
            _chartGroup.FlatStyle = FlatStyle.System;
            _chartGroup.Text = "tHgƐF̐ݒ";
            _chartGroup.Location = new Point(8, 8);
            _chartGroup.Width = 440;
            _chartGroup.Height = 232;

            int y = 12;

            _mainFont = new FontConfig(_chartGroup, "WtHg(&F)", 8, ref y);
            _candleWidthLabel = FormUtil.CreateLabelVT("E\N(&W)");
            _candleWidthBox = new ComboBox();
            _candleWidthBox.DrawMode = DrawMode.OwnerDrawFixed;
            _candleWidthBox.DropDownStyle = ComboBoxStyle.DropDownList;
            _candleWidthBox.DrawItem += new DrawItemEventHandler(OnCandleWidthBox_DrawItem);
            _candleWidthBox.Items.AddRange(new object[] { 1, 2, 3, 4, 5, 6, 7 });
            _candleWidthBox.BackColor = Color.Black;
            _candleWidthBox.ForeColor = Color.White;
            _candleWidthLabel.Location = new Point(204, y+2);
            _candleWidthLabel.Size = new Size(96, 19);
            _candleWidthBox.Location = new Point(304, y);
            _candleWidthBox.Size = new Size(48, 19);
            _candleColor = new ColorConfig(_chartGroup, "E\NF(&C)", 8, ref y);
            _chartGroup.Controls.Add(_candleWidthLabel);
            _chartGroup.Controls.Add(_candleWidthBox);
            
            
            _candleSpacingLabel = FormUtil.CreateLabelVT("E\NԃXy[X(&S)");
            _candleSpacingLabel.Location = new Point(204, y+2);
            _candleSpacingLabel.Size = new Size(96, 19);
            _candleSpacingBox = FormUtil.CreateComboBox("0", "1", "2", "3", "4", "5");
            _candleSpacingBox.Location = new Point(304, y);
            _candleSpacingBox.Size = new Size(48, y);
            _volumeColor = new ColorConfig(_chartGroup, "oF(&V)", 8, ref y);
            _chartGroup.Controls.Add(_candleSpacingLabel);
            _chartGroup.Controls.Add(_candleSpacingBox);

            _pricePen = new PenConfig(_chartGroup, "i؂(&P)", 8, ref y);
            _timePen = new PenConfig(_chartGroup, "t؂(&D)", 8, ref y);
            _mouseTrackingPrice = new PenConfig(_chartGroup, "}EXAi", 8, ref y);
            _mouseTrackingTime = new PenConfig(_chartGroup, "}EXAt", 8, ref y);
            _freeLinePen = new ColorConfig(_chartGroup, "R", 8, ref y);
            this.Controls.Add(_chartGroup);
            
            //Ɖ
            _dataGroup = BellagioVersionInfo.EDITION==BellagioEditions.HatchukunTX? new GroupBox() : null;
            if(_dataGroup!=null) {
                _dataGroup.FlatStyle = FlatStyle.System;
                _dataGroup.Text = "\̐ݒ";
                _dataGroup.Location = new Point(8, _chartGroup.Bottom + 8);
                _dataGroup.Width = _chartGroup.Width;
                _dataGroup.Height = 108;

                _enableAnimation = new CheckBox();
                _enableAnimation.Text = "`[gŌݒlωAj[VL(&A)";
                _enableAnimation.Location = new Point(8, 12);
                _enableAnimation.Size = new Size(400, 19);
                _eveningSessionAwareLabel = FormUtil.CreateLabel("CujOZbV̐敨f[^(&E)\n(ύX͎NɗL)");
                _eveningSessionAwareLabel.Location = new Point(8, 36);
                _eveningSessionAwareLabel.Size = new Size(200, 32);
                _eveningSessionAwareBox = FormUtil.CreateComboBox("Ɋ܂߂", "");
                _eveningSessionAwareBox.Location = new Point(_eveningSessionAwareLabel.Right + 8, 36);
                _eveningSessionAwareBox.Size = new Size(100, 19);
                _dataGroup.Controls.Add(_enableAnimation);
                _dataGroup.Controls.Add(_eveningSessionAwareLabel);
                _dataGroup.Controls.Add(_eveningSessionAwareBox);
                this.Controls.Add(_dataGroup);
            }

        }

        public void InitUI(IPreferenceFolder chart, IPreferenceFolder chart_dr) {
            ChartPreferences p = BellagioRoot.FixedPreferences.Chart;

            ChartDrawingSettings cd = p.ChartDrawingSettings;
            _mainFont.SetFont(cd.priceLabelFont);
            _candleColor.SelectedColor = DrawingUtil.ParseColor(chart_dr.ChildAt(cd.candleColor.PreferenceItem.Index).AsItem().AsString().Value);
            _volumeColor.SelectedColor = DrawingUtil.ParseColor(chart_dr.ChildAt(cd.volumeGraphColor.PreferenceItem.Index).AsItem().AsString().Value);
            _pricePen.SelectedPen = BPenStyle.Parse(chart_dr.ChildAt(cd.priceLineStyle.PreferenceItem.Index).AsItem().AsString().Value);
            _timePen.SelectedPen = BPenStyle.Parse(chart_dr.ChildAt(cd.timeLineStyle.PreferenceItem.Index).AsItem().AsString().Value);
            _mouseTrackingPrice.SelectedPen = BPenStyle.Parse(chart_dr.ChildAt(cd.mousePriceLineStyle.PreferenceItem.Index).AsItem().AsString().Value);
            _mouseTrackingTime.SelectedPen = BPenStyle.Parse(chart_dr.ChildAt(cd.mouseTimeLineStyle.PreferenceItem.Index).AsItem().AsString().Value);
            _freeLinePen.SelectedColor = DrawingUtil.ParseColor(chart_dr.ChildAt(cd.freeLineColor.PreferenceItem.Index).AsItem().AsString().Value);
            _candleWidthBox.SelectedIndex = Math.Min(cd.candleWidth.V-1, _candleWidthBox.Items.Count-1);
            _candleSpacingBox.SelectedIndex = cd.candleSpacing.V;

            if(_dataGroup!=null) {
                _enableAnimation.Checked = chart.ChildAt(p.EnableChartAnimationItem.Index).AsItem().AsBool().Value;
                _eveningSessionAwareBox.SelectedIndex = chart.ChildAt(p.EveningSessionAwareItem.Index).AsItem().AsString().Value==EveningSessionAware.Default.ToString()? 0 : 1;
            }
        }
        public bool Commit(IPreferenceFolder chart, IPreferenceFolder chart_dr) {
            ChartPreferences p = BellagioRoot.FixedPreferences.Chart;

            ChartDrawingSettings cd = p.ChartDrawingSettings;
            string mainfont = _mainFont.Value.ToString();
            //͘Aē
            chart_dr.ChildAt(cd.priceLabelFont.PreferenceItem.Index).AsItem().AsString().Value = mainfont;
            chart_dr.ChildAt(cd.oscillatorScaleFont.PreferenceItem.Index).AsItem().AsString().Value = mainfont;
            chart_dr.ChildAt(cd.stockInfoFont.PreferenceItem.Index).AsItem().AsString().Value = mainfont;
            chart_dr.ChildAt(cd.timeLabelFont.PreferenceItem.Index).AsItem().AsString().Value = mainfont;
            chart_dr.ChildAt(cd.volumeLabelFont.PreferenceItem.Index).AsItem().AsString().Value = mainfont;

            chart_dr.ChildAt(cd.candleColor.PreferenceItem.Index).AsItem().AsString().Value = DrawingUtil.ColorToString(_candleColor.SelectedColor);
            chart_dr.ChildAt(cd.volumeGraphColor.PreferenceItem.Index).AsItem().AsString().Value = DrawingUtil.ColorToString(_volumeColor.SelectedColor);
            chart_dr.ChildAt(cd.priceLineStyle.PreferenceItem.Index).AsItem().AsString().Value = _pricePen.SelectedPen.ToString();
            chart_dr.ChildAt(cd.timeLineStyle.PreferenceItem.Index).AsItem().AsString().Value = _timePen.SelectedPen.ToString();
            chart_dr.ChildAt(cd.mousePriceLineStyle.PreferenceItem.Index).AsItem().AsString().Value = _mouseTrackingPrice.SelectedPen.ToString();
            chart_dr.ChildAt(cd.mouseTimeLineStyle.PreferenceItem.Index).AsItem().AsString().Value = _mouseTrackingTime.SelectedPen.ToString();
            chart_dr.ChildAt(cd.candleWidth.UnderlyingItem.Index).AsItem().AsInt().Value = _candleWidthBox.SelectedIndex+1;
            chart_dr.ChildAt(cd.candleSpacing.UnderlyingItem.Index).AsItem().AsInt().Value = _candleSpacingBox.SelectedIndex;

            //RQژA
            chart_dr.ChildAt(cd.freeLineColor.PreferenceItem.Index).AsItem().AsString().Value = DrawingUtil.ColorToString(_freeLinePen.SelectedColor);
            chart_dr.ChildAt(cd.hoveredFreeLineColor.PreferenceItem.Index).AsItem().AsString().Value = DrawingUtil.ColorToString(_freeLinePen.SelectedColor);


            if(_dataGroup!=null) {
                //TODO EnumPreferenceƉ
                chart.ChildAt(p.EnableChartAnimationItem.Index).AsItem().AsBool().Value = _enableAnimation.Checked;
                chart.ChildAt(p.EveningSessionAwareItem.Index).AsItem().AsString().Value = _eveningSessionAwareBox.SelectedIndex==0?
                EveningSessionAware.Default.ToString() : EveningSessionAware.Daytime.ToString();
            }

            return true;
        }

        private void OnCandleWidthBox_DrawItem(object sender, DrawItemEventArgs args) {
            Graphics g = args.Graphics;

            CandleDrawing dr = new CandleDrawing(args.ForeColor, args.BackColor, args.Index+1);
            Rectangle rc = args.Bounds;
            dr.DrawYosen(args.Graphics, rc.X+13, rc.Y+4, rc.Bottom-4, rc.Y+1, rc.Bottom-2);
            dr.Dispose();
        }
    }
}
