using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.IO;
using System.Drawing;
using System.Windows.Forms;

using Poderosa;
using Poderosa.Commands;
using Poderosa.Forms;
using Poderosa.Plugins;

namespace Bellagio.Personal {
    internal static class DataManagementCommands {
        private static GeneralCommandImpl _initDataCommand;
        private static GeneralCommandImpl _downloadDailyDataCommand;

        public static void Init() {

            _downloadDailyDataCommand = new GeneralCommandImpl("tactico.personal.downloadDailyData", "f[^_E[h", null, new ExecuteDelegate(DownloadDailyData));
            _downloadDailyDataCommand.SetDefaultShortcutKey(Keys.Control|Keys.O);
            _initDataCommand = new GeneralCommandImpl("tactico.personal.initData", "f[^̏", null, new ExecuteDelegate(InitData));

            IExtensionPoint filemenu = PersonalPlugin.Instance.PoderosaWorld.PluginManager.FindExtensionPoint("org.poderosa.menu.file");
            filemenu.RegisterExtension(new PoderosaMenuGroupImpl(new IPoderosaMenu[] {
                new PoderosaMenuItemImpl(_downloadDailyDataCommand, "f[^̃_E[h(&O)..."),
                new PoderosaMenuItemImpl(_initDataCommand, "f[^̏(&I)...") }));

            //c[o[邪AACR̓XN[jÕvOCĂ
            PersonalPlugin.Instance.PoderosaWorld.PluginManager.FindExtensionPoint(WindowManagerConstants.TOOLBARCOMPONENT_ID).RegisterExtension(new DataDownloadToolBar());
        }
        private class DataDownloadToolBar : IToolBarComponent {

            public IToolBarElement[] ToolBarElements {
                get {
                    return new IToolBarElement[] {
                        new DialogToolBarElement("f[^XV", Screening.ScreeningPluginAccessor.GetToolbarBitmap(5), _downloadDailyDataCommand)
                    };
                }
            }

            public Size BarImageSize {
                get {
                    return new Size(24, 24);
                }
            }


            public IAdaptable GetAdapter(Type adapter) {
                return PUtil.DefaultGetAdapter(this, adapter);
            }
        }
        internal class DialogToolBarElement : IToolBarCommandButton {
            private string _text;
            private Image _icon;
            private IPoderosaCommand _command;

            public DialogToolBarElement(string text, Image icon, IPoderosaCommand command) {
                _text = text;
                _icon = icon;
                _command = command;
            }

            public string Text {
                get {
                    return _text;
                }
            }

            public ContentAlignment ImageAlign {
                get {
                    return ContentAlignment.MiddleLeft;
                }
            }

            public Image Icon {
                get {
                    return _icon;
                }
            }

            public bool IsEnabled(ICommandTarget target) {
                return _command.CanExecute(target);
            }

            public string ToolTipText {
                get {
                    return _text;
                }
            }

            public IAdaptable GetAdapter(Type adapter) {
                return PUtil.DefaultGetAdapter(this, adapter);
            }
            public IPoderosaCommand Command {
                get {
                    return _command;
                }
            }

        }


        public static IGeneralCommand InitDataCommand {
            get {
                return _initDataCommand;
            }
        }
        public static IGeneralCommand DownloadDailyDataCommand {
            get {
                return _downloadDailyDataCommand;
            }
        }

        private static CommandResult InitData(ICommandTarget target) {
            IPoderosaForm f = (IPoderosaForm)target.GetAdapter(typeof(IPoderosaForm));
            InitDataDialog dlg = new InitDataDialog();
            dlg.ShowDialog(f.AsForm());
            dlg.Dispose();
            return CommandResult.Succeeded;
        }
        private static CommandResult DownloadDailyData(ICommandTarget target) {
            IPoderosaForm f = (IPoderosaForm)target.GetAdapter(typeof(IPoderosaForm));
            DailyDataUpdateDialog dlg = new DailyDataUpdateDialog();
            dlg.ShowDialog(f.AsForm());
            dlg.Dispose();
            return CommandResult.Succeeded;
        }
    }

    internal class InitialDataChecker : IMainWindowEventHandler {

        public void OnFirstMainWindowLoaded(IPoderosaMainWindow window) {
            string data_dir = PersonalPlugin.Instance.BellagioEnvironment.DataHomeDir;
            if(!File.Exists(data_dir + "daily\\0201")) //t@C̔z邱Ƃłt@C̐`FbNłȂB͒ʏ펞d̂ŁATOPIX̃t@C邩ǂŔ肳
                PersonalPlugin.Instance.CoreServices.CommandManager.Execute(DataManagementCommands.InitDataCommand, window);
        }

        public void OnMainWindowLoaded(IPoderosaMainWindow window) {
        }

        public void OnMainWindowUnloaded(IPoderosaMainWindow window) {
        }

        public void OnLastMainWindowUnloaded(IPoderosaMainWindow window) {
        }

        public bool AskCancelClosingLastWindow(IPoderosaMainWindow window) {
            return false;
        }

        public Poderosa.IAdaptable GetAdapter(Type adapter) {
            return this;
        }

    }
}
