/*
 * Copyright 2004,2006 The Poderosa Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * $Id: SelectionEx.cs,v 1.8 2006/08/23 05:58:43 dan-iwasaki Exp $
 */
using System;
using System.Collections.Generic;
using System.Text;

using Poderosa.Sessions;
using Poderosa.Commands;

namespace Poderosa.View {

    //IT[rX
    // ɕSelectionƂł邪iFireFoxȂǂȂĂjAANeBuȂ͓̂ɂ͈B

    /// <summary>
    /// <ja>
    /// IuWFNg̑IɊւ@\񋟂C^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface that offers function concerning selection of object
    /// </en>
    /// </summary>
    public interface ISelectionService {
        /// <summary>
        /// <ja>
        /// ݂̑I󋵂܂ISelectionłB
        /// </ja>
        /// <en>
        /// ISelection including present selection situation
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// ݃ANeBuȃr[<see cref="IPoderosaView.CurrentSelection">CurrentSelectionvpeB</see>QƂ̂ƓłB
        /// </ja>
        /// <en>
        /// It is the same as the reference to the <see cref="IPoderosaView.CurrentSelection">CurrentSelection property</see> of an active view at present. 
        /// </en>
        /// </remarks>
        ISelection ActiveSelection { get; } //ActiveViewSelectionƓ`
        /// <summary>
        /// <ja>
        /// ftHg̃Rs[\tɊւR}hւ̃C^[tFCXłB
        /// </ja>
        /// <en>
        /// Interface to command concerning copy and putting default.
        /// </en>
        /// </summary>
        IPoderosaCommand DefaultCopyCommand { get; }
    }

    /// <summary>
    /// <ja>
    /// IԂωƂ̒ʒm󂯎郊XiłB
    /// </ja>
    /// <en>
    /// Listener that receives notification when selection changes.
    /// </en>
    /// </summary>
    public interface ISelectionListener {
        /// <summary>
        /// <ja>
        /// IJnꂽƂɌĂяo܂B
        /// </ja>
        /// <en>
        /// When the selection is begun, it is called. 
        /// </en>
        /// </summary>
        void OnSelectionStarted();
        /// <summary>
        /// <ja>
        /// Im肵ƂɌĂяo܂B
        /// </ja>
        /// <en>
        /// When the selection is fixed, it is called. 
        /// </en>
        /// </summary>
        void OnSelectionFixed();
    }

    //IĂIuWFNg ͊eIPoderosaViewǗ邾낤
    /// <summary>
    /// <ja>
    /// IĂIuWFNg𑀍삷C^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface that operates object that has been selected
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// ^[~iG~[^łr[̏ꍇAGetAdapter\bhgƂ
    /// <seealso cref="ITextSelection">ITextSelecton</seealso>ւƕϊł܂B
    /// </ja>
    /// <en>
    /// It is possible to convert it into <seealso cref="ITextSelection">ITextSelecton</seealso> by using the GetAdapter 
    /// method for the view that is the terminal emulator. 
    /// </en>
    /// </remarks>
    public interface ISelection : ICommandTarget {
        /// <summary>
        /// <ja>
        /// Lr[܂B
        /// </ja>
        /// <en>
        /// The owned view is shown. 
        /// </en>
        /// </summary>
        IPoderosaView OwnerView { get; }

        /// <summary>
        /// <ja>
        /// I͈͂ωƂ̃Xio^܂B
        /// </ja>
        /// <en>
        /// The listener when the range of the selection changes is registered. 
        /// </en>
        /// </summary>
        /// <param name="listener"><ja>o^郊Xi</ja><en>The listener to regist.</en></param>
        void AddSelectionListener(ISelectionListener listener);
        /// <summary>
        /// <ja>
        /// I͈͂ωƂ̃Xi܂B
        /// </ja>
        /// <en>
        /// The listener when the range of the selection changes is released. 
        /// </en>
        /// </summary>
        /// <param name="listener">
        /// <ja>郊Xi</ja>
        /// <en>The listener to remove.</en>
        /// </param>
        void RemoveSelectionListener(ISelectionListener listener);
    }

    /* T^IȃViI
     * @IJnEIUIViewŕB̒Selection̓ԂXVB
     * @View̕`ɂẮAgSelection΂Ƃɕ`悷B
     * @Rs[Ȃǂ̔ėpR}h́ASelectionɑ΂TranslateCommandĂŁASelectioñ^CvɂŗLR}hԂB
     * @ReLXgj[́ASelectionCommandTargetƂ郁j[c[r[pӂĕ\
     */

    //eLXg̑Ip
    /// <summary>
    /// <ja>
    /// eLXgIƂ̏w肵܂B
    /// </ja>
    /// <en>
    /// The format when the text is selected is specified. 
    /// </en>
    /// </summary>
    public enum TextFormatOption {
        /// <summary>
        /// <ja>
        /// WIȃeLXgƂĕԂ܂B
        /// </ja>
        /// <en>
        /// Returns as a standard text. 
        /// </en>
        /// </summary>
        Default,
        /// <summary>
        /// <ja>
        /// ܂܂̏ԂŕԂ܂BȂ킿r[̉E[Ő܂Ԃꂽӏ\r\nt܂B
        /// </ja>
        /// <en>
        /// It returns it while seen. That is, \r\n adheres to the part turned on a right edge of the view. 
        /// </en>
        /// </summary>
        AsLook
    }

    /// <summary>
    /// <ja>
    /// IĂeLXg𑀍삷C^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface that operates text that has been selected.
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// ^[~iG~[^r[̏ꍇAISelectiońAITextSelectionւƕϊł܂B
    /// </ja>
    /// <en>
    /// ISelection can be converted into this ITextSelection for the view that shows the terminal emulator. 
    /// </en>
    /// </remarks>
    /// <example>
    /// <ja>
    /// ANeBuȃr[őIĂeLXg擾܂B
    /// <code>
    /// // <value>target</value>ANeBuȃr[𓾂܂
    /// IPoderosaView view = CommandTargetUtil.AsViewOrLastActivatedView(target);
    /// // ITextSelection𓾂܂B
    /// ITextSelection select = (ITextSelection)view.CurrentSelection.GetAdapter(
    ///   typeof(ITextSelection));
    /// // IĂeLXg𓾂܂
    /// if ((select != null) &amp;&amp; (!select.IsEmpty))
    /// {
    ///   MessageBox.Show(select.GetSelectedText(TextFormatOption.Default));
    /// }
    /// </code>
    /// </ja>
    /// <en>
    /// The text has been selected by an active view is got.
    /// <code>
    /// // Get the active view from <value>target</value>.
    /// IPoderosaView view = CommandTargetUtil.AsViewOrLastActivatedView(target);
    /// // Get ITextSelection
    /// ITextSelection select = (ITextSelection)view.CurrentSelection.GetAdapter(
    ///   typeof(ITextSelection));
    /// // Get the selected text.
    /// if ((select != null) &amp;&amp; (!select.IsEmpty))
    /// {
    ///   MessageBox.Show(select.GetSelectedText(TextFormatOption.Default));
    /// }
    /// </code>
    /// </en>
    /// </example>
    public interface ITextSelection : ISelection {
        /// <summary>
        /// <ja>
        /// IĂeLXg𓾂܂B
        /// </ja>
        /// <en>
        /// The text that has been selected is obtained. 
        /// </en>
        /// </summary>
        /// <param name="opt"><ja>擾tH[}bgw肵܂B</ja><en>Specifies the acquired format.</en></param>
        /// <returns><ja>IĂeLXgłB</ja><en>Selected text</en></returns>
        string GetSelectedText(TextFormatOption opt);
        /// <summary>
        /// <ja>
        /// IĂeLXg݂邩ǂ܂BIĂȂƂɂtrueAIĂƂɂfalsełB
        /// </ja>
        /// <en>
        /// It is shown whether the text that has been selected exists. When true and selected, it is false when nothing has been selected. 
        /// </en>
        /// </summary>
        bool IsEmpty { get; }
        /// <summary>
        /// <ja>
        /// ׂđIԂɂ܂B
        /// </ja>
        /// <en>
        /// It all puts it into the state of the selection. 
        /// </en>
        /// </summary>
        void SelectAll();
        /// <summary>
        /// <ja>
        /// IĂȂԂɂ܂B
        /// </ja>
        /// <en>
        /// It puts it into the state that nothing has been selected. 
        /// </en>
        /// </summary>
        void Clear();
    }

}
