/*
 * Copyright 2004,2006 The Poderosa Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * $Id: PreferencesEx.cs,v 1.9 2006/08/23 05:58:02 dan-iwasaki Exp $
 */
using System;
using System.IO;
using System.Collections;

/**
 * StructuredText̏ɁA^AgUNVȂǂ̋@\ڂPreferenceƂĎg悤ɂ
	
**/

namespace Poderosa.Preferences {

	// Exported Part
    /// <summary>
    /// <ja>
    /// [U[ݒľ،ʂC^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface that shows verification result of user setting value.
    /// </en>
    /// </summary>
	public interface IPreferenceValidationResult {
        /// <summary>
        /// <ja>
        /// ؂ۂ܂B
        /// </ja>
        /// <en>
        /// It is shown whether the verification succeeded. 
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// truêƂAfalsêƂsӖ܂B
        /// </ja>
        /// <en>
        /// It succeeds at true, and the failure is meant at false. 
        /// </en>
        /// </remarks>
		bool Validated { get; }
        /// <summary>
        /// <ja>
        /// ؎̃G[bZ[W܂B
        /// </ja>
        /// <en>
        /// The error message when verifying it is shown. 
        /// </en>
        /// </summary>
		string ErrorMessage { get; set; }
	}

    /// <summary>
    /// <ja>
    /// ؂sƂ̗ONXłB
    /// </ja>
    /// <en>
    /// Class that shows exception when verification fails
    /// </en>
    /// </summary>
	public class ValidationException : Exception {
		private IPreferenceItemBase _sourceItem;
		private IPreferenceValidationResult _result;

        /// <summary>
        /// <ja>
        /// ؂sƂ̗O𐶐܂B
        /// </ja>
        /// <en>
        /// The exception when the verification fails is generated. 
        /// </en>
        /// </summary>
        /// <param name="source"><ja>ǑƂȂ\[XłB</ja><en>Source that causes exception</en></param>
        /// <param name="result"><ja>،ʂłB</ja><en>Verification result</en></param>
		public ValidationException(IPreferenceItemBase source, IPreferenceValidationResult result) : base(result.ErrorMessage) {
			_sourceItem = source;
			_result = result;
		}

        /// <summary>
        /// <ja>
        /// ǑƂȂ\[X܂B
        /// </ja>
        /// <en>
        /// The source that causes the exception is shown. 
        /// </en>
        /// </summary>
		public IPreferenceItemBase SourceItem {
			get {
				return _sourceItem;
			}
		}

        /// <summary>
        /// <ja>
        /// ،ʂ܂B
        /// </ja>
        /// <en>
        /// The verification result is shown. 
        /// </en>
        /// </summary>
		public IPreferenceValidationResult Result {
			get {
				return _result;
			}
		}
	}

    //Preference Plugin
    /// <summary>
    /// <ja>
    /// PreferencePluginvOC񋟂C^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface that PreferencePlugin plug-in offers.
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// ̃C^[tFCX́A<seealso cref="Poderosa.Plugins.ICoreServices">ICoreServices</seealso><see cref="Poderosa.Plugins.ICoreServices.Preferences">PreferencesvpeB</see>
    /// 擾ł܂B
    /// </ja>
    /// <en>
    /// This interface can be get from the <see cref="Poderosa.Plugins.ICoreServices.Preferences">Preferences property</see> of <seealso cref="Poderosa.Plugins.ICoreServices">ICoreServices</seealso>. 
    /// </en>
    /// </remarks>
    /// <example>
    /// <ja>
    /// IPreferences𓾂܂B
    /// <code>
    /// ICoreServices cs = PoderosaWorld.GetAdapter(typeof(ICoreServices));
    /// // IPreferences擾܂
    /// IPreferences pref = cs.Preferences;
    /// </code>
    /// </ja>
    /// <en>
    /// Get IPreferences.
    /// <code>
    /// ICoreServices cs = PoderosaWorld.GetAdapter(typeof(ICoreServices));
    /// // Get IPreferences.
    /// IPreferences pref = cs.Preferences;
    /// </code>
    /// </en>
    /// </example>
    public interface IPreferences {
        /// <summary>
        /// <ja>
        /// tH_܂B
        /// </ja>
        /// <en>
        /// Retrieve the folder.
        /// </en>
        /// </summary>
        /// <param name="id"><ja>tH_</ja><en>Retrieved folder name</en></param>
        /// <returns><ja>tH_IPreferenceFolderBȂƂɂnull</ja><en>IPreferenceFolder that shows found folder. When not found, null returns.</en></returns>
        IPreferenceFolder FindPreferenceFolder(string id);
        /// <summary>
        /// <ja>ׂẴtH_zƂē܂B</ja>
        /// <en>All folders are obtained as an array.</en>
        /// </summary>
        /// <returns><ja>ێĂ邷ׂẴtH_</ja><en>All held folders</en></returns>
        IPreferenceFolder[] GetAllFolders(bool includes_hidden);

        //t@C֏o
        void Flush();
    }


	//ݒ荀ڂ`鑤
    /// <summary>
    /// <ja>
    /// [U[ݒ荀ڂ`vOCׂC^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface that plug-in that defines user setting item should implement.
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// <para>
    /// [U[ݒ荀ڂǂݏvOĆÃC^[tFCXIuWFNgpӂA
    /// PreferencePluginvOC񋟂uorg.poderosa.core.preferencesvƂg|Cgւ
    /// o^܂B
    /// </para>
    /// <para>
    /// uorg.poderosa.core.preferencesvg|CǵA<seealso cref="Poderosa.Plugins.ICoreServices">ICoreServices</seealso>
    /// <see cref="Poderosa.Plugins.ICoreServices.PreferenceExtensionPoint">PreferenceExtensionPointvpeB</see>擾ł܂B
    /// </para>
    /// <code>
    /// ICoreServices cs = PoderosaWorld.GetAdapter(typeof(ICoreServices));
    /// // PreferencesPluginvOC̊g|Cg擾܂
    /// IExtensionPoint prefext =cs.PreferenceExtensionPoint;
    /// 
    /// // go^܂B
    /// prefext.RegisterExtension(this);
    /// </code>
    /// <para>
    /// ̓IȎgɂẮA<see href="/chap04_05.html">[U[ݒl̑</see>QƂĂB
    /// </para>
    /// </ja>
    /// <en>
    /// <para>
    /// The object that implements this interface is prepared, and the plug-in to read and 
    /// write the user setting item is registered to the extension point of "org.poderosa.core.preferences" 
    /// that the PreferencePlugin plug-in offers. 
    /// </para>
    /// <para>
    /// "org.poderosa.core.preferences" The extension point can be got from the 
    /// <see cref="Poderosa.Plugins.ICoreServices.PreferenceExtensionPoint">PreferenceExtensionPoint property</see> 
    /// of <seealso cref="Poderosa.Plugins.ICoreServices">ICoreServices</seealso>. 
    /// </para>
    /// <code>
    /// ICoreServices cs = PoderosaWorld.GetAdapter(typeof(ICoreServices));
    /// // Get the extension point of PreferencesPlugin plug-in.
    /// IExtensionPoint prefext =cs.PreferenceExtensionPoint;
    /// 
    /// // Regist this.
    /// prefext.RegisterExtension(this);
    /// </code>
    /// <para>
    /// Please refer to <see href="/chap04_05.html">Operation of user setting value</see> for a concrete usage. 
    /// </para>
    /// </en>
    /// </remarks>
	public interface IPreferenceSupplier : IAdaptable {
        /// <summary>
        /// <ja>
        /// ݒlvOCƂɎʂ鍀ږłB
        /// </ja>
        /// <en>
        /// Item name that identifies set value of each plug-in.
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// <para>
        /// ̒ĺAoptions.confɏ܂Ƃ̃[g̖OƂč̗p܂B̃vOCƏdȂ悤ɂ邽߁A
        /// vOCIDƓ̂ݒ肷邱Ƃ܂iđ̃vOC̐ݒlǂݏꍇɂ́Ǎł͂܂jB
        /// </para>
        /// </ja>
        /// <en>
        /// <para>
        /// This value is adopted as a name right under the route when written in options.conf. 
        /// To make it not overlap with other plug-ins, the same one as plug-in ID is recommended to be set 
        /// (It is not this to dare to read and write a set value of other plug-ins). 
        /// </para>
        /// </en>
        /// </remarks>
        string PreferenceID { get; } 
        /// <summary>
        /// <ja>
        /// PreferencesPluginvOCĂяo郁\bhłB
        /// </ja>
        /// <en>
        /// Method that calls from PreferencesPlugin plug-in when initializing it
        /// </en>
        /// </summary>
        /// <param name="builder"><ja>ݒ荀ڂo^邽߂̃C^[tFCXłB</ja><en>Interface to register set item</en></param>
        /// <param name="folder"><ja>eƂȂtH_łB</ja><en>Folder that becomes parents</en></param>
        /// <remarks>
        /// <ja>
        /// J҂́Ã\bh<paramref name="bulder"/>̊e\bhĂяoāA
        /// ݒlo^܂B
        /// </ja>
        /// <en>
        /// The developer calls each method of <paramref name="bulder"/> in this method, and registers a set value. 
        /// </en>
        /// </remarks>
		void InitializePreference(IPreferenceBuilder builder, IPreferenceFolder folder);
        /// <summary>
        /// <ja>
        /// [U[ݒlL̃C^[tFCXւƕϊƂɗp܂B
        /// </ja>
        /// <en>
        /// It uses it to convert the user setting value into a peculiar interface. 
        /// </en>
        /// </summary>
        /// <param name="folder"><ja>eƂȂtH_łB</ja><en>Folder that becomes parents</en></param>
        /// <param name="type"><ja>ϊ悤Ƃ^łB</ja><en>Type that tries to be converted</en></param>
        /// <returns><ja>ϊ̌^Ԃ܂B</ja><en>The type after it converts it is returned. </en></returns>
        /// <remarks>
        /// <ja>
        /// ^̕ϊ@\KvƂȂƂɂ́APnullԂ悤ɎĂB
        /// </ja>
        /// <en>
        /// Please implement to return null simply when the conversion function of the type is not needed. 
        /// </en>
        /// </remarks>
        object QueryAdapter(IPreferenceFolder folder, Type type);

        /// <summary>
        /// <ja>
        /// tH_Ɋ܂܂镡̃[U[ݒlƂɗp܂B
        /// </ja>
        /// <en>
        /// It uses it to inspect two or more user setting values included in the same folder. 
        /// </en>
        /// </summary>
        /// <param name="folder"><ja>؂̑ΏۂƂȂtH_n܂B</ja><en>Target folder for verification</en></param>
        /// <param name="output"><ja>،ʂݒ肵܂B</ja><en>The verification result is set. </en></param>
        /// <remarks>
        /// <ja>
        /// ̃[U[ݒl@\KvƂȂƂɂ́Ȁ͋ł܂܂B
        /// </ja>
        /// <en>
        /// This processing is not cared about in the sky when the function to inspect two or more user setting values is not needed. 
        /// </en>
        /// </remarks>
		void ValidateFolder(IPreferenceFolder folder, IPreferenceValidationResult output);
	}

    //Added for Bellagio
    public interface IPreferenceSupplier2 : IAdaptable {
        bool Hidden { get; }
    }

	//ύXʒm
    /// <summary>
    /// <ja>
    /// tH_̃[U[ݒlωƂɒʒm󂯎C^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface that receives notification when user setting value in folder changes.
    /// </en>
    /// </summary>
	public interface IPreferenceChangeListener {
        /// <summary>
        /// <ja>
        /// [U[ݒlωƂɌĂяo郁\bhłB
        /// </ja>
        /// <en>
        /// Method of call when user setting value changes.
        /// </en>
        /// </summary>
        /// <param name="oldvalues"><ja>ݒǑÂlłB</ja><en>Old value before it sets it</en></param>
        /// <param name="newvalues"><ja>ݒ̐VlłB</ja><en>New value after it sets it</en></param>
		void OnPreferenceImport(IPreferenceFolder oldvalues, IPreferenceFolder newvalues);

        //Add for Bellagio
        //R~bgIɌĂ΂
        void OnPreferenceImportFinish();
	}

	//̂ݗL
    /// <summary>
    /// <ja>
    /// [U[ݒliPreferencejƂčڂo^@\񋟂܂B
    /// </ja>
    /// <en>
    /// The function to register the item as user setting value (Preference) is offered. 
    /// </en>
    /// </summary>
	public interface IPreferenceBuilder {
        /// <summary>
        /// <ja>
        /// KwtH_`܂B
        /// </ja>
        /// <en>
        /// The hierarchized folder is defined. 
        /// </en>
        /// </summary>
        /// <param name="parent"><ja>eƂȂtH_</ja><en>Folder that becomes parents</en></param>
        /// <param name="supplier"></param>
        /// <param name="id"></param>
        /// <returns></returns>
        /// <remarks>
        /// <ja>
        /// <paramref name="parent"/>ɂ́A<seealso cref="IPreferenceSupplier">IPreferenceSupplier</seealso>
        /// <see href="IPreferenceSupplier.InitializePreference">InitializePreference</see>̑2ɓnꂽ
        /// l̂܂܈n̂ʗłB
        /// </ja>
        /// <en>
        /// In <paramref name="parent"/>, it is usual to pass the value passed to the second argument of 
        /// <see href="IPreferenceSupplier.InitializePreference">InitializePreference</see> of 
        /// <seealso cref="IPreferenceSupplier">IPreferenceSupplier</seealso> in off as it is. 
        /// </en>
        /// </remarks>
        /// <exclude/>
		IPreferenceFolder DefineFolder(IPreferenceFolder parent, IPreferenceSupplier supplier, string id); //qSuppliernull
        /// <exclude/>
        IPreferenceFolder DefineFolderArray(IPreferenceFolder parent, IPreferenceSupplier supplier, string id); //ArrayԂ킯ł͂ȂƂɒ
        /// <exclude/>
        IPreferenceLooseNode DefineLooseNode(IPreferenceFolder parent, IPreferenceLooseNodeContent content, string id);

		//validatorsvȂƂnull
        /// <summary>
        /// <ja>
        /// bool^̃[U[ݒl`܂B
        /// </ja>
        /// <en>
        /// The user setting value of the bool type is defined. 
        /// </en>
        /// </summary>
        /// <param name="parent"><ja>eƂȂtH_</ja><en>Folder that becomes parents</en></param>
        /// <param name="id"><ja>l̃L[ƂȂݒ薼</ja><en>Set name that becomes key to value.</en></param>
        /// <param name="initial_value"><ja>l</ja><en>Initial value</en></param>
        /// <param name="validator"><ja>l؂ۂ̃of[^</ja><en>Validator when value is verified</en></param>
        /// <returns><ja>lǂݏ邽߂<seealso cref="IBoolPreferenceItem">IBoolPreferenceItem</seealso></ja><en><seealso cref="IBoolPreferenceItem">IBoolPreferenceItem</seealso> to read and write value.</en></returns>
        /// <remarks>
        /// <ja>
        /// <para>
        /// <paramref name="parent"/>ɂ́A<seealso cref="IPreferenceSupplier">IPreferenceSupplier</seealso>
        /// <see href="IPreferenceSupplier.InitializePreference">InitializePreference</see>̑2ɓnꂽ
        /// l̂܂܈n̂ʗłB
        /// </para>
        /// <para>
        /// <paramref name="id"/>́A[U[ݒlʂ邽߂̔Cӂ̖OłB<paramref name="parent"/>
        /// ŊKw邽߁Aق̃vOCƂ̖ȌdlKv͂܂B
        /// </para>
        /// <para>
        /// <paramref name="initial_value"/>́AY郆[U[ݒl܂݂Ȃꍇ̏lłB
        /// łɂ̃[U[ݒl݂ꍇɂ͖A̒lǂݍ܂܂B
        /// </para>
        /// <para>
        /// ؋@\KvƂȂƂɂ́A<paramref name="validator"/>nullɂ邱Ƃł܂B
        /// </para>
        /// </ja>
        /// <en>
        /// <para>
        /// In <paramref name="parent"/>, it is usual to pass the value passed to the second argument of 
        /// <see href="IPreferenceSupplier.InitializePreference">InitializePreference</see> of 
        /// <seealso cref="IPreferenceSupplier">IPreferenceSupplier</seealso> in off as it is. 
        /// </para>
        /// <para>
        /// <paramref name="id"/> is an arbitrary name to identify the user setting value. 
        /// It is not necessary to think about the repetition of the name with other plug-ins 
        /// because it is hierarchized by <paramref name="parent"/>. 
        /// </para>
        /// <para>
        /// <paramref name="initial_value"/> is a value in the early the case where the corresponding user 
        /// setting value has not existed yet. It is disregarded when this user setting value already exists, 
        /// and an existing value is read. 
        /// </para>
        /// <para>
        /// When the verification function is not needed, <paramref name="validator"/> can be made null. 
        /// </para>
        /// </en>
        /// </remarks>
		IBoolPreferenceItem   DefineBoolValue(IPreferenceFolder parent, string id, bool initial_value, PreferenceItemValidator<bool> validator);
        /// <summary>
        /// <ja>
        /// int^̃[U[ݒl`܂B
        /// </ja>
        /// <en>
        /// The user setting value of the int type is defined. 
        /// </en>
        /// </summary>
        /// <param name="parent"><ja>eƂȂtH_</ja><en>Folder that becomes parents</en></param>
        /// <param name="id"><ja>l̃L[ƂȂݒ薼</ja><en>Set name that becomes key to value.</en></param>
        /// <param name="initial_value"><ja>l</ja><en>Initial value</en></param>
        /// <param name="validator"><ja>l؂ۂ̃of[^</ja><en>Validator when value is verified</en></param>
        /// <returns><ja>lǂݏ邽߂<seealso cref="IIntPreferenceItem">IIntPreferenceItem</seealso></ja><en><seealso cref="IIntPreferenceItem">IIntPreferenceItem</seealso> to read and write value.</en></returns>
        /// <remarks>
        /// <ja>
        /// <para>
        /// <paramref name="parent"/>ɂ́A<seealso cref="IPreferenceSupplier">IPreferenceSupplier</seealso>
        /// <see href="IPreferenceSupplier.InitializePreference">InitializePreference</see>̑2ɓnꂽ
        /// l̂܂܈n̂ʗłB
        /// </para>
        /// <para>
        /// <paramref name="id"/>́A[U[ݒlʂ邽߂̔Cӂ̖OłB<paramref name="parent"/>
        /// ŊKw邽߁Aق̃vOCƂ̖ȌdlKv͂܂B
        /// </para>
        /// <para>
        /// <paramref name="initial_value"/>́AY郆[U[ݒl܂݂Ȃꍇ̏lłB
        /// łɂ̃[U[ݒl݂ꍇɂ͖A̒lǂݍ܂܂B
        /// </para>
        /// <para>
        /// ؋@\KvƂȂƂɂ́A<paramref name="validator"/>nullɂ邱Ƃł܂B
        /// </para>
        /// </ja>
        /// <en>
        /// <para>
        /// In <paramref name="parent"/>, it is usual to pass the value passed to the second argument of 
        /// <see href="IPreferenceSupplier.InitializePreference">InitializePreference</see> of 
        /// <seealso cref="IPreferenceSupplier">IPreferenceSupplier</seealso> in off as it is. 
        /// </para>
        /// <para>
        /// <paramref name="id"/> is an arbitrary name to identify the user setting value. 
        /// It is not necessary to think about the repetition of the name with other plug-ins 
        /// because it is hierarchized by <paramref name="parent"/>. 
        /// </para>
        /// <para>
        /// <paramref name="initial_value"/> is a value in the early the case where the corresponding user 
        /// setting value has not existed yet. It is disregarded when this user setting value already exists, 
        /// and an existing value is read. 
        /// </para>
        /// <para>
        /// When the verification function is not needed, <paramref name="validator"/> can be made null. 
        /// </para>
        /// </en>
        /// </remarks>
        IIntPreferenceItem    DefineIntValue(IPreferenceFolder parent, string id, int initial_value, PreferenceItemValidator<int> validator);

        /// <summary>
        /// <ja>
        /// string^̃[U[ݒl`܂B
        /// </ja>
        /// <en>
        /// The user setting value of the string type is defined. 
        /// </en>
        /// </summary>
        /// <param name="parent"><ja>eƂȂtH_</ja><en>Folder that becomes parents</en></param>
        /// <param name="id"><ja>l̃L[ƂȂݒ薼</ja><en>Set name that becomes key to value.</en></param>
        /// <param name="initial_value"><ja>l</ja><en>Initial value</en></param>
        /// <param name="validator"><ja>l؂ۂ̃of[^</ja><en>Validator when value is verified</en></param>
        /// <returns><ja>lǂݏ邽߂<seealso cref="IIntPreferenceItem">IIntPreferenceItem</seealso></ja><en><seealso cref="IIntPreferenceItem">IIntPreferenceItem</seealso> to read and write value.</en></returns>
        /// <remarks>
        /// <ja>
        /// <para>
        /// <paramref name="parent"/>ɂ́A<seealso cref="IPreferenceSupplier">IPreferenceSupplier</seealso>
        /// <see href="IPreferenceSupplier.InitializePreference">InitializePreference</see>̑2ɓnꂽ
        /// l̂܂܈n̂ʗłB
        /// </para>
        /// <para>
        /// <paramref name="id"/>́A[U[ݒlʂ邽߂̔Cӂ̖OłB<paramref name="parent"/>
        /// ŊKw邽߁Aق̃vOCƂ̖ȌdlKv͂܂B
        /// </para>
        /// <para>
        /// <paramref name="initial_value"/>́AY郆[U[ݒl܂݂Ȃꍇ̏lłB
        /// łɂ̃[U[ݒl݂ꍇɂ͖A̒lǂݍ܂܂B
        /// </para>
        /// <para>
        /// ؋@\KvƂȂƂɂ́A<paramref name="validator"/>nullɂ邱Ƃł܂B
        /// </para>
        /// </ja>
        /// <en>
        /// <para>
        /// In <paramref name="parent"/>, it is usual to pass the value passed to the second argument of 
        /// <see href="IPreferenceSupplier.InitializePreference">InitializePreference</see> of 
        /// <seealso cref="IPreferenceSupplier">IPreferenceSupplier</seealso> in off as it is. 
        /// </para>
        /// <para>
        /// <paramref name="id"/> is an arbitrary name to identify the user setting value. 
        /// It is not necessary to think about the repetition of the name with other plug-ins 
        /// because it is hierarchized by <paramref name="parent"/>. 
        /// </para>
        /// <para>
        /// <paramref name="initial_value"/> is a value in the early the case where the corresponding user 
        /// setting value has not existed yet. It is disregarded when this user setting value already exists, 
        /// and an existing value is read. 
        /// </para>
        /// <para>
        /// When the verification function is not needed, <paramref name="validator"/> can be made null. 
        /// </para>
        /// </en>
        /// </remarks>
        IStringPreferenceItem DefineStringValue(IPreferenceFolder parent, string id, string initial_value, PreferenceItemValidator<string> validator);
	}


    /// <summary>
    /// <ja>
    /// [U[ݒliPreferencej̍ڂtH_̊ƂȂC^[tFCXłB
    /// </ja>
    /// <en>
    /// It is an interface that becomes the item of user setting value (Preference) and basic of the folder. 
    /// </en>
    /// </summary>
	public interface IPreferenceItemBase {
        /// <summary>
        /// <ja>
        /// ݒ薼łB
        /// </ja>
        /// <en>
        /// Name of setting
        /// </en>
        /// </summary>
		string Id { get; }
        /// <summary>
        /// <ja>
        /// tH_܂߂SȐݒ薼łB
        /// </ja>
        /// <en>
        /// Complete set name including folder name
        /// </en>
        /// </summary>
		string FullQualifiedId { get; }
        /// <summary>
        /// <ja>
        /// ẽCfbNXʒułB
        /// </ja>
        /// <en>
        /// It is an index position from parents. 
        /// </en>
        /// </summary>
		int Index { get; }
		//cast: NOTE:p~\
        /// <exclude/>
		IPreferenceItem AsItem();
        /// <exclude/>
        IPreferenceFolder AsFolder();
        /// <exclude/>
        IPreferenceFolderArray AsFolderArray();
		//ׂď
        /// <summary>
        /// <ja>
        /// lׂď܂B
        /// </ja>
        /// <en>
        /// All the values are initialized. 
        /// </en>
        /// </summary>
		void ResetValue();
	}

    /// <summary>
    /// <ja>
    /// [U[ݒliPreferencejKwtH_𑀍삷C^[tFCXłB
    /// </ja>
    /// <en>
    /// It is an interface that operates the folder that hierarchizes user setting value (Preference). 
    /// </en>
    /// </summary>
	public interface IPreferenceFolder : IPreferenceItemBase {
        /// <summary>
        /// <ja>
        /// 쐬܂B
        /// </ja>
        /// <en>
        /// Create a copy.
        /// </en>
        /// </summary>
        /// <returns><ja>IPreferenceFolder</ja><en>Duplicated IPreferenceFolder</en></returns>
		IPreferenceFolder Clone();
        /// <summary>
        /// <ja>
        /// ʂ̃tH_C|[g܂B
        /// </ja>
        /// <en>
        /// Import from another folder.
        /// </en>
        /// </summary>
        /// <param name="newvalues"><ja>C|[gl܂ރtH_</ja><en>Folder including value in which import.</en></param>
		void Import(IPreferenceFolder newvalues, bool with_child_folders);

		//TODO O̖Ifolder validation

        /// <summary>
        /// <ja>
        /// q̃tH_܂B
        /// </ja>
        /// <en>
        /// Child's folder is retrieved. 
        /// </en>
        /// </summary>
        /// <param name="id"><ja>q̃tH_ID</ja><en>ID of child's folder.</en></param>
        /// <returns><ja>tH_IPreferenceFolderBȂƂɂnull</ja><en>IPreferenceFolder that shows found folder. When not found, null returns.</en></returns>
		IPreferenceFolder FindChildFolder(string id);
        /// <summary>
        /// <ja>
        /// q̃tH_̔z܂B
        /// </ja>
        /// <en>
        /// Array of child's folder is retrieved. 
        /// </en>
        /// </summary>
        /// <param name="id">
        /// <ja>q̃tH_ID</ja>
        /// <en>ID of child's folder.</en>
        /// </param>
        /// <returns><ja>tH_IPreferenceFolderBȂƂɂnull</ja><en>IPreferenceFolder that shows found folder. When not found, null returns.</en></returns>
		IPreferenceFolderArray FindChildFolderArray(string id);
        /// <summary>
        /// <ja>
        /// ̃tH_̐ݒl܂B
        /// </ja>
        /// <en>
        /// A set value in this folder is retrieved. 
        /// </en>
        /// </summary>
        /// <param name="id"><ja>ݒ薼</ja><en>Retrieved set name</en></param>
        /// <returns><ja>tH_IPreferenceFolderBȂƂɂnull</ja><en>IPreferenceFolder that shows found folder. When not found, null returns.</en></returns>
		IPreferenceItem FindItem(string id);
        /// <summary>
        /// <ja>
        /// q̐܂B
        /// </ja>
        /// <en>
        /// Number of children
        /// </en>
        /// </summary>
		int ChildCount { get; }
        /// <summary>
        /// <ja>
        /// w肵CfbNXʒuɂݒ荀ڂԂ܂B
        /// </ja>
        /// <en>
        /// A set item at the specified index position is returned. 
        /// </en>
        /// </summary>
        /// <param name="index"><ja>CfbNXʒu</ja><en>Position of index.</en></param>
        /// <returns><ja>̃CfbNXʒuɂݒ荀ڂIPreferenceItemBaseBȂƂɂnull</ja><en>IPreferenceItemBase that shows set item at the index position. When not found, returns null.</en></returns>
		IPreferenceItemBase ChildAt(int index);

        //UserFriendly interfaceւ̃LXgp
        /// <summary>
        /// <ja>
        /// ꂼ̃vOCɓLPreferenceւƕϊ܂B
        /// </ja>
        /// <en>
        /// It converts it into peculiar Preference to each plug-in. 
        /// </en>
        /// </summary>
        /// <param name="type"><ja>ϊC^[tFCX̌^</ja><en>Type in converted interface</en></param>
        /// <returns><ja>ϊ̃C^[tFCXBϊłȂƂɂnull</ja><en>Interface after it converts it. When it is not possible to convert it, returns null. </en></returns>
        object QueryAdapter(Type type);

		//cւ`d
        /// <summary>
        /// <ja>
        /// ̃tH_̐ݒlωƂɒʒmIuWFNgo^܂B
        /// </ja>
        /// <en>
        /// The object notified when a set value in this folder changes is registered. 
        /// </en>
        /// </summary>
        /// <param name="listener"><ja>ʒm̃IuWFNg</ja><en>Object at notification destination</en></param>
		void AddChangeListener(IPreferenceChangeListener listener);
        /// <summary>
        /// <ja>
        /// <seealso cref="AddChangeListener">AddChangeListener</seealso>œo^IuWFNg܂B
        /// </ja>
        /// <en>
        /// The object registered with AddChangeListener is released. 
        /// </en>
        /// </summary>
        /// <param name="listener"><ja>IuWFNg</ja><en>Object to release.</en></param>
		void RemoveChangeListener(IPreferenceChangeListener listener);
	}

    /// <summary>
    /// <ja>
    /// [U[ݒliPreferencej̃tH_܂Ƃ߂Ĉ߂̃C^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface to handle the folder of the user setting value collectively. 
    /// </en>
    /// </summary>
    public interface IPreferenceFolderArray : IPreferenceItemBase {
        /// <summary>
        /// <ja>
        /// 쐬܂B
        /// </ja>
        /// <en>
        /// Create a copy.
        /// </en>
        /// </summary>
        /// <returns><ja>IPreferenceFolderArray</ja><en>Duplicated IPreferenceFolderArray</en></returns>
		IPreferenceFolderArray Clone();
        /// <summary>
        /// <ja>
        /// ʂ̃tH_C|[g܂B
        /// </ja>
        /// <en>
        /// Import from another folder.
        /// </en>
        /// </summary>
        /// <param name="newvalues"><ja>C|[gl܂ރtH_</ja><en>Folder including value in which import is done</en></param>
		void Import(IPreferenceFolderArray newvalues);

        /// <summary>
        /// <ja>
        /// ێĂeIPreferenceFolder̔zƂē܂B
        /// </ja>
        /// <en>
        /// The held content is obtained as an array of IPreferenceFolder. 
        /// </en>
        /// </summary>
		IPreferenceFolder[] Folders { get; }

        /// <summary>
        /// <ja>
        /// ێĂeNA܂B
        /// </ja>
        /// <en>
        /// Clear the held content.
        /// </en>
        /// </summary>
        void Clear();

        /// <summary>
        /// <ja>
        /// VtH_쐬܂B
        /// </ja>
        /// <en>
        /// Create a new folder.
        /// </en>
        /// </summary>
        /// <returns><ja>ꂽVtH_IPreferenceFolder</ja>
        /// <en>IPreferenceFolder that shows made new folder</en>
        /// </returns>
		IPreferenceFolder CreateNewFolder();

        /// <summary>
        /// <ja>
        /// ev[gpāAq̃tH_ACeւƕϊ܂B
        /// </ja>
        /// <en>
        /// Child's folder is converted into the item with a template. 
        /// </en>
        /// </summary>
        /// <param name="child_folder"><ja>ϊqtH_</ja><en>Converted child folder</en></param>
        /// <param name="item_in_template"><ja>pev[g</ja><en>Used template.</en></param>
        /// <returns><ja>ev[gɂĕϊꂽڂIPreferenceItem</ja><en>IPreferenceItem that shows item converted with template</en></returns>
		IPreferenceItem ConvertItem(IPreferenceFolder child_folder, IPreferenceItem item_in_template);
	}

    /// <summary>
    /// <ja>
    /// [U[ݒl؂邽߂̃fQ[głB
    /// </ja>
    /// <en>
    /// It is delegate to verify the user setting value. 
    /// </en>
    /// </summary>
    /// <typeparam name="T"><ja>[U[ݒľ^łB</ja><en>It is type information on the user setting value. </en></typeparam>
    /// <param name="value"><ja>؂ׂlłB</ja><en>It is a value that should be verified. </en></param>
    /// <param name="result"><ja>،ʂi[܂B</ja><en>The verification result is stored. </en></param>
    /// <remarks>
    /// <ja>
    /// [U[ݒl؂@\񋟂vOCł́A<paramref name="value"/>̒l̑Ó؂A
    /// ̌ʂ<paramref name="result"/>ɐݒ肵ĂB
    /// </ja>
    /// <en>Please verify the validity of the value of <paramref name="value"/>, and set the result to <paramref name="result"/> in the plug-in that offers the function to verify the user setting value. </en>
    /// </remarks>
    public delegate void PreferenceItemValidator<T>(T value, IPreferenceValidationResult result);

    /// <summary>
    /// <ja>
    /// [U[ݒliPreferencej̍ڂC^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface that shows item of user setting value (Preference).
    /// </en>
    /// </summary>
	public interface IPreferenceItem : IPreferenceItemBase {
        /// <summary>
        /// <ja>
        /// bool^ƂĒl𓾂邽߂̃C^[tFCX擾܂B
        /// </ja>
        /// <en>
        /// The interface to obtain the value as bool type is got. 
        /// </en>
        /// </summary>
        /// <returns><ja>boollƂăANZX邽߂IBoolPreferenceItem</ja><en>IBoolPreferenceItem to access it as bool value</en></returns>
       	IBoolPreferenceItem AsBool();
        /// <summary>
        /// <ja>
        /// int^ƂĒl𓾂邽߂̃C^[tFCX擾܂B
        /// </ja>
        /// <en>
        /// The interface to obtain the value as int type is got. 
        /// </en>
        /// </summary>
        /// <returns><ja>intlƂăANZX邽߂IIntPreferenceItem</ja><en>IIntPreferenceItem to access it as int value</en></returns>
		IIntPreferenceItem AsInt();
        /// <summary>
        /// <ja>
        /// string^ƂĒl𓾂邽߂̃C^[tFCX擾܂B
        /// </ja>
        /// <en>
        /// The interface to obtain the value as string type is got. 
        /// </en>
        /// </summary>
        /// <returns><ja>stringlƂăANZX邽߂IStringPreferenceItem</ja><en>IStringPreferenceItem to access it as string value</en></returns>
		IStringPreferenceItem AsString();
       
	}

    /// <summary>
    /// <ja>
    /// IPoderosaItem^tC^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface that puts the type as for IPoderosaItem. 
    /// </en>
    /// </summary>
    /// <typeparam name="T"></typeparam>
    public interface ITypedPreferenceItem<T> : IPreferenceItem {
        /// <summary>
        /// <ja>
        /// [U[ݒlǂݏ܂B
        /// </ja>
        /// <en>
        /// Read and write the user setting value.
        /// </en>
        /// </summary>
        T Value {
            get;
            set;
        }

        /// <summary>
        /// <ja>
        /// [U[ݒl̏l܂B
        /// </ja>
        /// <en>
        /// Show the initial value of the user setting value.
        /// </en>
        /// </summary>
        T InitialValue {
            get;
        }

        /// <summary>
        /// <ja>
        /// [U[ݒl؂邽߂PreferenceItemValidator擾^ݒ肵܂B
        /// </ja>
        /// <en>
        /// Get / set the PreferenceItemValidator to verify the user setting value.
        /// </en>
        /// </summary>
        PreferenceItemValidator<T> Validator {
            get;
            set;
        }
    }

    //Generic ParametervO}ɖw肳̂炵AIPreferenceItem̃LXgp\bhCyɎĝ
    /// <summary>
    /// <ja>
    /// bool^̃[U[ݒlǂݏ@\񋟂܂B
    /// </ja>
    /// <en>
    /// Offered the function to read and write the user setting value of the bool type.
    /// </en>
    /// </summary>
	public interface IBoolPreferenceItem : ITypedPreferenceItem<bool> {
	}

    /// <summary>
    /// <ja>
    /// int^̃[U[ݒlǂݏ@\񋟂܂B
    /// </ja>
    /// <en>
    /// Offered the function to read and write the user setting value of the int type.
    /// </en>
    /// </summary>
	public interface IIntPreferenceItem : ITypedPreferenceItem<int> {
	}

    /// <summary>
    /// <ja>
    /// string^̃[U[ݒlǂݏ@\񋟂܂B
    /// </ja>
    /// <en>
    /// Offered the function to read and write the user setting value of the string type.
    /// </en>
    /// </summary>
	public interface IStringPreferenceItem : ITypedPreferenceItem<string> {
	}

    //Loose Node

    /// <summary>
    /// </summary>
    /// <exclude/>
    public interface IPreferenceLooseNode : IPreferenceItemBase {
        IPreferenceLooseNodeContent Content { get; }
    }

    //TODO Folder̓N[ł̂Content͂łȂ͕̂ςBΏƓIłȂ
    /// <summary>
    /// 
    /// </summary>
    /// <exclude/>
    public interface IPreferenceLooseNodeContent {
        IPreferenceLooseNodeContent Clone();
        void Reset();
        void LoadFrom(StructuredText node);
        void SaveTo(StructuredText node);
    }

	//End Exported Part
}
