/*
 * Copyright 2004,2006 The Poderosa Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * $Id: ListenerList.cs,v 1.3 2006/07/16 03:21:52 osawa Exp $
 */
using System;
using System.Collections;
using System.Collections.Generic;

namespace Poderosa.Util
{
    /// <summary>
    /// 
    /// </summary>
    /// <typeparam name="T"></typeparam>
    /// <exclude/>
	public class ListenerList<T> : IEnumerable<T> {
        private LinkedList<T> _list;

		public ListenerList() {
		}
		public void Add(T listener) {
            Precheck();
            _list.AddLast(listener);
		}
        public void Remove(T listener) {
            Precheck();
            _list.Remove(listener);
        }

		IEnumerator IEnumerable.GetEnumerator() {
            Precheck();
            return _list.GetEnumerator();
		}
		IEnumerator<T> IEnumerable<T>.GetEnumerator() {
            Precheck();
            return _list.GetEnumerator();
		}

        public bool IsEmpty {
            get {
                return _list!=null && _list.Count==0;
            }
        }

        public void Clear() {
            if(_list!=null) _list.Clear();
        }

        //͈Listenero^ȂBx쐬
        private void Precheck() {
            if (_list == null) _list = new LinkedList<T>();
        }

	}

    //Xi̓o^E폜C^tF[X
    /// <summary>
    /// 
    /// </summary>
    /// <typeparam name="T"></typeparam>
    /// <exclude/>
    public interface IListenerRegistration<T> {
        void AddListener(T listener);
        void RemoveListener(T listener);
    }
}
