/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Values/TradingObjects.cs#11 $
 * $DateTime: 2008/04/17 18:17:59 $
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using Bellagio.Data;

#if UNITTEST
using NUnit.Framework;
using Bellagio.Script;
using Bellagio.Evaluators;
#endif

//TODO eXgP[X̕z

namespace Bellagio.Values {
    //g[fBOɊւ{NXiATimeAndSalesAȂ)̒`

    //ʏƎ

#if UNITTEST
    [TestFixture]
    public class TradingObjectTests  {
        private LocalVariable[] _argVariables;
        private BV[] _argValues;
   
        [TestFixtureSetUp]
        public void Init() {
            BellagioEnvironmentParam p = new BellagioEnvironmentParam();
            p.SetupForUnitTest();
            p.RUN_DATA_SUBSCRIBER_ENGINE = true;
            BellagioRoot.Init(p);
            BellagioRoot.IntraDayTradeProvider.SetTickDataSource(new UnitTestSimpleDataSource());

            FunctionLibrary lib = BellagioRoot.Functions.User;
            List<LocalVariable> argVariables = new List<LocalVariable>();
            List<BV> argValues = new List<BV>();

            TimeAndSales ts1 = new TimeAndSales();
            ts1.Add(BTime.ParseToInt("9:00"), 100, 1, TickItaRelation.Unknown);
            ts1.Add(BTime.ParseToInt("9:01"), 101, 2, TickItaRelation.Unknown);
            ts1.Add(BTime.ParseToInt("9:02"), 102, 3, TickItaRelation.Unknown);
            argVariables.Add(new LocalVariable("ts1", TimeAndSalesType.instance, 0));
            argValues.Add(ts1);

            ConcreteQuote pr1 = new ConcreteQuote(Quote.QuoteUnit.Minutely);
            pr1.Add(BTime.ParseToInt("9:00"), 100, 102, 99, 101, 1000, 0, 0);
            pr1.Add(BTime.ParseToInt("9:01"), 101, 104, 100, 102, 2000, 0, 0);
            pr1.Add(BTime.ParseToInt("9:02"), 102, 106, 101, 103, 3000, 0, 0);
            argVariables.Add(new LocalVariable("pr1", QuoteType.instance, 1));
            argValues.Add(new SubseqQuote(pr1, 0, pr1.Count));

            //ċA֐̃eXgpɒ߂̂
            ConcreteQuote pr2 = new ConcreteQuote(Quote.QuoteUnit.Minutely);
            for(int i=0; i<10; i++)
                pr2.Add(BTime.ParseToInt("9:00")+i*60, 100+i, 100+i, 100+i, 100+i, 1000, 0, 0);
            argVariables.Add(new LocalVariable("pr2", QuoteType.instance, 2));
            argValues.Add(new SubseqQuote(pr2, 0, pr2.Count));
            ParameterListDefinition pl = Expression.ParseParameterListDefinition("Quote q, int l");
            BellagioRoot.Functions.BuiltIn.DefineUserFunction("", "price_rec_test", pl, Expression.ParseTypeDesc("double"),
                Expression.ParseExpression("q.length()==l? q.close() : price_rec_test(q.shift(1), l)"), null).Compile();

            string message = null;
            StockRef st1 = new StockRef();
            st1.Stock = new BasicStockProfile("test", "1", StockProfileFlags.None,1).CreatePrimary(StockExchange.B, StockExchangeSubType.None, StockFlags.None);
            argVariables.Add(new LocalVariable("st1", StockType.instance, 3));
            argValues.Add(st1);

            IntraDayTrade rs = null;
            BellagioRoot.IntraDayTradeProvider.Open(st1.Stock, ref rs, ref message); ;
            rs.ReplaceQuotes(pr1);
            rs.ReplaceTimeAndSales(ts1);

            _argValues = argValues.ToArray();
            _argVariables = argVariables.ToArray();
        }
        [TestFixtureTearDown]
        public void TearDown() {
            BellagioRoot.Terminate();
        }

        private StandAloneEvaluator CreateEvaluator(string expression) {
            Expression expr = Expression.ParseExpression(expression);
            EvaluatorBuildContext ctx = new EvaluatorBuildContext(null);
            ctx.Initialize(null, _argVariables);
            EvaluatorBuilder bld = new EvaluatorBuilder(ctx);
            IEvaluator e = bld.Build(expr);
            return new StandAloneEvaluator(e, ctx, _argValues);
        }
        private EvalContext EvalContext() {
            EvalContext c = new EvalContext();
            return c;
        }

        

        [Test]
        public void TSBasic() {
            StandAloneEvaluator first1 = CreateEvaluator("ts1.first().time()");
            StandAloneEvaluator first2 = CreateEvaluator("ts1.first(1).time()");
            StandAloneEvaluator last1 = CreateEvaluator("ts1.last().time()");
            StandAloneEvaluator last2 = CreateEvaluator("ts1.last(1).time()");

            Assert.AreEqual(BTime.ParseToInt("9:00"), ((BTime)first1.Eval(EvalContext())).AsInt());
            Assert.AreEqual(BTime.ParseToInt("9:01"), ((BTime)first2.Eval(EvalContext())).AsInt());
            Assert.AreEqual(BTime.ParseToInt("9:02"), ((BTime)last1.Eval(EvalContext())).AsInt());
            Assert.AreEqual(BTime.ParseToInt("9:01"), ((BTime)last2.Eval(EvalContext())).AsInt());
        }

        [Test]
        public void TSTailHead() {
            StandAloneEvaluator t1 = CreateEvaluator("ts1.head(2).last().time()");
            StandAloneEvaluator t2 = CreateEvaluator("ts1.tail(2).last().time()");
            Assert.AreEqual(BTime.ParseToInt("9:01"), ((BTime)t1.Eval(EvalContext())).AsInt());
            Assert.AreEqual(BTime.ParseToInt("9:02"), ((BTime)t2.Eval(EvalContext())).AsInt());
        }

        [Test]
        public void TickData() {
            StandAloneEvaluator t = CreateEvaluator("ts1.last().time()");
            StandAloneEvaluator p = CreateEvaluator("ts1.last().price()");
            StandAloneEvaluator v = CreateEvaluator("ts1.last().volume()");
            Assert.AreEqual(BTime.ParseToInt("9:02"), ((BTime)t.Eval(EvalContext())).AsInt());
            Assert.AreEqual(102, ((BInt)p.Eval(EvalContext())).Value);
            Assert.AreEqual(3, ((BInt)v.Eval(EvalContext())).Value);
        }

        [Test]
        public void TSCount() {
            //NOTE@ŏɎIuWFNgTime&SalesȂ̂CountȂǂ̃eXgɂ邪A{ׂ͕
            StandAloneEvaluator t = CreateEvaluator("ts1.count(price() > 100)");
            Assert.AreEqual(2, ((BInt)t.Eval(EvalContext())).Value);
        }
        [Test]
        public void TSAll() {
            StandAloneEvaluator t1 = CreateEvaluator("ts1.all(price() > 100)");
            Assert.IsFalse(((BBoolean)t1.Eval(EvalContext())).Value);
            StandAloneEvaluator t2 = CreateEvaluator("ts1.all(price() > 90)");
            Assert.IsTrue(((BBoolean)t2.Eval(EvalContext())).Value);
        }
        [Test]
        public void TSAny() {
            StandAloneEvaluator t1 = CreateEvaluator("ts1.any(price() > 100)");
            Assert.IsTrue(((BBoolean)t1.Eval(EvalContext())).Value);
            StandAloneEvaluator t2 = CreateEvaluator("ts1.any(price() > 102)");
            Assert.IsFalse(((BBoolean)t2.Eval(EvalContext())).Value);
        }
        [Test]
        public void TSMap() {
            StandAloneEvaluator t1 = CreateEvaluator("ts1.map(volume()>2? volume() : 0)");
            Assert.AreEqual(BT.Int.ArrayType().Name, t1.BT.Name);
            Assert.AreEqual("{0, 0, 3}", BV.DefaultFormat(t1.Eval(EvalContext())));
        }

        [Test]
        public void Quote1() {
            StandAloneEvaluator o1 = CreateEvaluator("pr1.open()");
            Assert.AreEqual(102, ((BDouble)o1.Eval(EvalContext())).Value);

            StandAloneEvaluator o2 = CreateEvaluator("pr1.open(2)");
            Assert.AreEqual("{101, 102}", BV.DefaultFormat(o2.Eval(EvalContext())));

            StandAloneEvaluator o3 = CreateEvaluator("pr1.open(3, 2)");
            Assert.AreEqual("{100, 101}", BV.DefaultFormat(o3.Eval(EvalContext())));

            StandAloneEvaluator o4 = CreateEvaluator("pr1.open(4)");
            Assert.IsTrue(o4.Eval(EvalContext()).IsNil);
        }
        [Test]
        public void Quote2() {
            //͍Ō̎l{l
            StandAloneEvaluator o = CreateEvaluator("pr1.open()");
            Assert.AreEqual(102, ((BDouble)o.Eval(EvalContext())).Value);
            StandAloneEvaluator h = CreateEvaluator("pr1.high()");
            Assert.AreEqual(106, ((BDouble)h.Eval(EvalContext())).Value);
            StandAloneEvaluator l = CreateEvaluator("pr1.low()");
            Assert.AreEqual(101, ((BDouble)l.Eval(EvalContext())).Value);
            StandAloneEvaluator c = CreateEvaluator("pr1.close()");
            Assert.AreEqual(103, ((BDouble)c.Eval(EvalContext())).Value);
            StandAloneEvaluator v = CreateEvaluator("pr1.volume()");
            Assert.AreEqual(3000, ((BDouble)v.Eval(EvalContext())).Value);

            //BVJEgsσ`FbN
            int t = BV.instanceCount;
            v.Eval(EvalContext());
            Assert.AreEqual(t, BV.instanceCount);
        }
        [Test]
        public void QuoteMA() {
            StandAloneEvaluator ma = CreateEvaluator("pr1.ma(2)");
            Assert.AreEqual(102.5, ((BDouble)ma.Eval(EvalContext())).Value);
        }
        [Test]
        public void QuoteEach() {
            StandAloneEvaluator a1 = CreateEvaluator("pr1.each(2, lambda((Quote q) q.close()))");
            BV r = a1.Eval(EvalContext());
            Assert.IsTrue(r.AsArray()!=null);
            BArray arr = (BArray)r;
            Assert.AreEqual(2, arr.Count);
            Assert.AreEqual(102, ((BDouble)arr[0]).Value);
            Assert.AreEqual(103, ((BDouble)arr[1]).Value);

            StandAloneEvaluator a2 = CreateEvaluator("pr1.each(2, lambda((Quote q) q.ma(2)))");
            r = a2.Eval(EvalContext());
            arr = (BArray)r;
            Assert.AreEqual(2, arr.Count);
            Assert.AreEqual(101.5, ((BDouble)arr[0]).Value);
            Assert.AreEqual(102.5, ((BDouble)arr[1]).Value);

            StandAloneEvaluator a3 = CreateEvaluator("pr1.each(5, lambda((Quote q) q.ma(2)))");
            r = a3.Eval(EvalContext());
            Assert.IsTrue(r.IsNil);
        }

        /*
            pr1.Add(BTime.ParseToInt("9:00"), 100, 102, 99, 101, 1000, 0, 0);
            pr1.Add(BTime.ParseToInt("9:01"), 101, 104, 100, 102, 2000, 0, 0);
            pr1.Add(BTime.ParseToInt("9:02"), 102, 106, 101, 103, 3000, 0, 0);
        */
        [Test]
        public void QuoteArraySpecial() {
            StandAloneEvaluator a = CreateEvaluator("pr1.all(volume()>0)");
            Assert.IsTrue(((BBoolean)a.Eval(EvalContext())).Value);

            StandAloneEvaluator b = CreateEvaluator("pr1.count(low()>=100)");
            Assert.AreEqual(2, ((BInt)b.Eval(EvalContext())).Value);
        }
        [Test]
        public void QuoteSublist() {
            /*
            StandAloneEvaluator a = CreateEvaluator("pr1.sublist(2)");
            BArray aa = (BArray)a.Eval(EvalContext());
            Assert.AreEqual(QuoteType.instance, aa.BT);
            Assert.AreEqual(2, aa.Count);
            */
            StandAloneEvaluator b = CreateEvaluator("pr1.sublist(2).low()");
            Assert.AreEqual(101, ((BDouble)b.Eval(EvalContext())).Value);
            StandAloneEvaluator c = CreateEvaluator("pr1.sublist(2).volume()");
            Assert.AreEqual(3000, ((BDouble)c.Eval(EvalContext())).Value);
        }
        [Test]
        public void QuoteRecursive() {
            StandAloneEvaluator a = CreateEvaluator("price_rec_test(pr2, 1)");
            Assert.AreEqual(100, ((BDouble)a.Eval(EvalContext())).Value);
            StandAloneEvaluator b = CreateEvaluator("price_rec_test(pr2, 2)");
            Assert.AreEqual(101, ((BDouble)b.Eval(EvalContext())).Value);
            StandAloneEvaluator c = CreateEvaluator("price_rec_test(pr2, 2) - price_rec_test(pr2, 1)");
            //StandAloneEvaluator c = CreateEvaluator("avg(pr2.close(2)) - avg(pr2.close(3))");
            Assert.AreEqual(1, ((BDouble)c.Eval(EvalContext())).Value);
        }
        [Test]
        public void QuoteShift() {
            StandAloneEvaluator a = CreateEvaluator("pr1.shift(1).close()");
            Assert.AreEqual(102, ((BDouble)a.Eval(EvalContext())).Value);
            StandAloneEvaluator b = CreateEvaluator("pr1.shift(1).shift(-1).close()"); //̃VtgP[X
            Assert.AreEqual(103, ((BDouble)b.Eval(EvalContext())).Value);
            StandAloneEvaluator c = CreateEvaluator("pr1.shift(-1).close()"); //̃VtgȂP[X
            Assert.IsTrue(c.Eval(EvalContext()).IsNil);
        }
        [Test]
        public void QuoteAndSeries() {
            StandAloneEvaluator a = CreateEvaluator("series(2).map( lambda( (int i) pr1.shift(i).open() ) )");
            BRegularArray r = (BRegularArray)a.Eval(EvalContext());
            Assert.AreEqual(2, r.Count);
            Assert.AreEqual(102, ((BDouble)r[0]).Value);
            Assert.AreEqual(101, ((BDouble)r[1]).Value);
        }
        [Test]
        public void QuoteAndCandle() {
            StandAloneEvaluator a = CreateEvaluator("pr1.candleAt(2).open()");
            Assert.AreEqual(100, ((BInt)a.Eval(EvalContext())).Value);
        }
        [Test]
        public void CandleShift() {
            /*
            pr1.Add(BTime.ParseToInt("9:00"), 100, 102, 99, 101, 1000, 0, 0);
            pr1.Add(BTime.ParseToInt("9:01"), 101, 104, 100, 102, 2000, 0, 0);
            pr1.Add(BTime.ParseToInt("9:02"), 102, 106, 101, 103, 3000, 0, 0);
            */
            StandAloneEvaluator a = CreateEvaluator("pr1.lastCandle().shift(2).volume()");
            Assert.AreEqual(1000, ((BInt)a.Eval(EvalContext())).Value);

            StandAloneEvaluator b = CreateEvaluator("pr1.lastCandle().distanceTo(pr1.lastCandle().shift(1))");
            Assert.AreEqual(1, ((BInt)b.Eval(EvalContext())).Value);
        }

        [Test]
        public void StockBasic() {
            StandAloneEvaluator a = CreateEvaluator("st1.code()");
            Assert.AreEqual("1", ((BString)a.Eval(EvalContext())).Value);
            a = CreateEvaluator("st1.name()");
            Assert.AreEqual("test", ((BString)a.Eval(EvalContext())).Value);
        }


        /*
        [Test]
        public void StockLatestPrice() {
            //Quote̒g͂
            /*
            pr1.Add(9:00, 100, 102, 99, 101, 1000);
            pr1.Add(9:01, 101, 104, 100, 102, 2000);
            pr1.Add(9:02, 102, 106, 101, 103, 3000);
            StandAloneEvaluator a = CreateEvaluator("pr1.price()");
            Assert.AreEqual(102, ((BDouble)a.Eval(EvalContext())).Value); //Ӂ@eXgf[^̕sTime&SalesQuotesΉĂȂBCurrentTime==nullłT&ŜłŐ
            a = CreateEvaluator("pr1.minquotes().length()");
            Assert.AreEqual(3, ((BInt)a.Eval(EvalContext())).Value);
        }
        [Test]
        public void StockTimeShift() {
            StandAloneEvaluator a = CreateEvaluator("pr1.price()");
            _evalContext.CurrentTime = BTime.Parse("9:01");
            Assert.AreEqual(101, ((BDouble)a.Eval(_evalContext)).Value);
            _evalContext.CurrentTime = BTime.Parse("9:02");
            Assert.AreEqual(102, ((BDouble)a.Eval(_evalContext)).Value);

            a = CreateEvaluator("pr1.minquotes().length()");
            _evalContext.CurrentTime = BTime.Parse("9:01");
            Assert.AreEqual(2, ((BInt)a.Eval(_evalContext)).Value);
        }
             */
    }
#endif

}
