/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id$
 * $DateTime$
 * 
 * Ï؂̓́@ۗ̔ł͈Ï؂̂ݕKvł
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;
using System.Drawing;

using Bellagio.Forms;

namespace Bellagio.Ordering {
    public class PinCodeDialog : Form {
        private TextBox _pinCodeBox;
        private Button _okButton;
        private Button _cancelButton;

        private string _result;

        public PinCodeDialog() {
            this.Text = "Ï؂̓";
            this.FormBorderStyle = FormBorderStyle.FixedToolWindow;

            _pinCodeBox = new TextBox();
            _pinCodeBox.PasswordChar = '*';

            _okButton = FormUtil.CreateOKButton();
            _cancelButton = FormUtil.CreateCancelButton();

            _pinCodeBox.Location = new Point(8, 4);
            _pinCodeBox.Size = new Size(80, 19);
            _pinCodeBox.MaxLength = BRuntimeOpts.MAX_PASSWORD_LENGTH;
            _okButton.Location = new Point(92, 3);
            _okButton.Size = new Size(62, 22);
            _okButton.Click += new EventHandler(OnOK);
            _cancelButton.Location = new Point(156, 3);
            _cancelButton.Size = new Size(62, 22);
            this.ClientSize = new Size(224, 28);

            this.Controls.AddRange(new Control[] { _pinCodeBox, _okButton, _cancelButton });

            this.AcceptButton = _okButton;
            this.CancelButton = _cancelButton;

            FormUtil.AdjustStyleForModalDialog(this);
        }

        public string Result {
            get {
                return _result;
            }
        }

        private void OnOK(object sender, EventArgs args) {
            _result = _pinCodeBox.Text;
        }
    }
}
