/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Ordering/OrderAndPositionOptionPanel.cs#3 $
 * $DateTime: 2008/01/28 15:03:31 $
 * 
 * Sʐݒ̃IvVpl
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;
using System.Drawing;

using Bellagio.Forms;
using Travis.LocationOperation;
using Poderosa.Usability;
using Poderosa.Preferences;

namespace Bellagio.Ordering {
    public class OrderingAndPoisitionOptionPanelExtension : IOptionPanelExtension {
        private OrderingAndPoisitionOptionPanel _panel;

        public string Caption {
            get {
                return "Ɖ";
            }
        }

        public System.Drawing.Image Icon {
            get {
                return BellagioRoot.CommonIcons.OptionDialogButtons.GetBitmap(3);
            }
        }

        public string[] PreferenceFolderIDsToEdit {
            get {
                return new string[] { "tactico.ordering" };
            }
        }

        public Panel ContentPanel {
            get {
                return _panel;
            }
        }

        public void InitiUI(IPreferenceFolder[] values) {
            if(_panel==null) _panel = new OrderingAndPoisitionOptionPanel();
            _panel.InitUI(values[0]);
        }

        public bool Commit(IPreferenceFolder[] values) {
            return _panel.Commit(values[0]);
        }

        public void Dispose() {
            if(_panel!=null) _panel.Dispose();
        }

    }

    public class OrderingAndPoisitionOptionPanel : Panel {
        private Label _partialTradeDisplayLabel;
        private ComboBox _partialTradeDisplayBox;
        private CheckBox _positionRefreshByTradeBox;
        private CheckBox _halfTransparentBox;
        //private CheckBox _showMultipleCreditCloseWarning;

        public OrderingAndPoisitionOptionPanel() {
            _partialTradeDisplayLabel = FormUtil.CreateLabel("莞̐ʕ\(&P)");
            _partialTradeDisplayLabel.Location = new Point(8, 8);
            _partialTradeDisplayLabel.Size = new Size(244, 24);
            _partialTradeDisplayBox = FormUtil.CreateComboBox("ς݂\", "c\");
            _partialTradeDisplayBox.Location = new Point(_partialTradeDisplayLabel.Right, 8);
            
            _positionRefreshByTradeBox = new CheckBox();
            _positionRefreshByTradeBox.Text = "Ƀ|WVXV";
            _positionRefreshByTradeBox.Size = new Size(300, 19);
            _positionRefreshByTradeBox.Location = new Point(8, 32);

            _halfTransparentBox = new CheckBox();
            _halfTransparentBox.Text = "Ɖʂ𔼓ɂ\n(w̃`[gBȂƂɎgp)";
            _halfTransparentBox.Size = new Size(300, 32);
            _halfTransparentBox.Location = new Point(8, 56);


            this.Controls.Add(_partialTradeDisplayLabel);
            this.Controls.Add(_partialTradeDisplayBox);
            this.Controls.Add(_positionRefreshByTradeBox);
            this.Controls.Add(_halfTransparentBox);

        }

        public void InitUI(IPreferenceFolder f) {
            OrderingPreferences op = BellagioRoot.FixedPreferences.Ordering;

            _partialTradeDisplayBox.SelectedIndex = (int)Enum.Parse(typeof(PartialTradeDisplay), f.ChildAt(op.PartialTradeDisplayItem.PreferenceItem.Index).AsItem().AsString().Value);
            //_showMultipleCreditCloseWarning.Checked = f.ChildAt(op.ShowMultipleCreditCloseWarningItem.Index).AsItem().AsBool().Value;
            _positionRefreshByTradeBox.Checked = f.ChildAt(op.PositionRefreshByTradeItem.Index).AsItem().AsBool().Value;
            _halfTransparentBox.Checked = f.ChildAt(op.HalfTransparentViewItem.Index).AsItem().AsBool().Value;
        }

        public bool Commit(IPreferenceFolder f) {
            OrderingPreferences op = BellagioRoot.FixedPreferences.Ordering;
            f.ChildAt(op.PartialTradeDisplayItem.PreferenceItem.Index).AsItem().AsString().Value = ((PartialTradeDisplay)_partialTradeDisplayBox.SelectedIndex).ToString();
            //f.ChildAt(op.ShowMultipleCreditCloseWarningItem.Index).AsItem().AsBool().Value = _showMultipleCreditCloseWarning.Checked;
            f.ChildAt(op.PositionRefreshByTradeItem.Index).AsItem().AsBool().Value = _positionRefreshByTradeBox.Checked;
            f.ChildAt(op.HalfTransparentViewItem.Index).AsItem().AsBool().Value = _halfTransparentBox.Checked;

            return true;
        }
    }

}
