/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Environment/FixedPreferences.cs#12 $
 * $DateTime: 2008/05/14 13:05:12 $
 * 
 * [Uݒ\ȍڂ̂A\BellagioAvŌ߂
 * gLbg\̂ExtensiblePreference
 */

using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Drawing;
using System.Diagnostics;

using Poderosa;
using Poderosa.Plugins;
using Poderosa.Preferences;

using Bellagio.Chart;
using Bellagio.Ordering;
using Travis;

using Microsoft.Win32;

namespace Bellagio.Environment {
    //PreferenceSupplier{
    public abstract class PreferenceSupplierImpl : IPreferenceSupplier {
        private string _prefID;
        public PreferenceSupplierImpl(string prefID) {
            _prefID = prefID;
        }

        public string PreferenceID {
            get { return _prefID; }
        }

        public abstract void InitializePreference(IPreferenceBuilder builder, IPreferenceFolder folder);

        public virtual object QueryAdapter(IPreferenceFolder folder, Type type) {
            return null;
        }

        public virtual void ValidateFolder(IPreferenceFolder folder, IPreferenceValidationResult output) {
        }
        public IAdaptable GetAdapter(Type adapter) {
            return BUtil.DefaultGetAdapter(this, adapter);
        }
    }



    //PoderosaPreferencegpĕۑ鍀ڏW
    //Ŝ\PreferenceChangeListenerB
    public class FixedPreferences : PreferenceSupplierImpl {
        private ChartPreferences _chart;
        private OrderingPreferences _ordering;
       
        private string _homeDir; //΂Ύg
        //private IStringPreferenceItem _dailyDataDir;
        //private IBoolPreferenceItem _autoPassword;
        private IBoolPreferenceItem _autoPinCode;
        private IIntPreferenceItem _quoteTimeMargin; //MinuteŒʒmꂽԂǂꂾIntraDayTradei߂邩
        private IBoolPreferenceItem _askQuit; //IɕĂq˂
        private IBoolPreferenceItem _openBookmarkWithNewTab; //ubN}[NJƂV^uǂBfalseȂ^Og

        //pincodéAɂ̂ݕۑ悤ɂȂ
        private string _pinCodeOnMemory;
        private bool _pinCodeVerified; //xƊmFłtrue

        public FixedPreferences()
            : base("tactico.common") {
            _chart = new ChartPreferences();
            if(BellagioVersionInfo.EDITION==BellagioEditions.HatchukunTX) {
                _ordering = new OrderingPreferences();
                _pinCodeOnMemory = "";
            }
        }
        public void RegisterExtension(IExtensionPoint pt) {
            _homeDir = AppDomain.CurrentDomain.BaseDirectory;

            pt.RegisterExtension(this);
            _chart.RegisterExtension(pt);
            if(_ordering!=null)
                _ordering.RegisterExtension(pt);
        }

        public override void InitializePreference(IPreferenceBuilder builder, IPreferenceFolder folder) {
            //_autoPassword = builder.DefineBoolValue(folder, "autoPassword", false, null);
            _autoPinCode = builder.DefineBoolValue(folder, "autoPinCode", false, null);
            _quoteTimeMargin = builder.DefineIntValue(folder, "quoteTimeMargin", 120, null);
            _askQuit = builder.DefineBoolValue(folder, "askQuit", true, null);
            _openBookmarkWithNewTab = builder.DefineBoolValue(folder, "openBookmarkWithNewTab", false, null);
        }


        public ChartPreferences Chart {
            get {
                return _chart;
            }
        }
        public OrderingPreferences Ordering {
            get {
                return _ordering;
            }
        }


        //͍͎擾̂݁Aݒ͎蓮
        public string DailyDataDir {
            get {
                return "";
            }
        }
        public string SoundDir {
            get {
                return _homeDir + "sound\\";
            }
        }
        public Color DefaultBackColor {
            get {
                return Color.Black; //ꉞPreferenceɒuBłPrefItem
            }
        }

        public int QuoteTimeMargin {
            get {
                return _quoteTimeMargin.Value;
            }
            set {
                _quoteTimeMargin.Value = value;
            }
        }
        public bool AskQuit {
            get {
                return _askQuit.Value;
            }
            set {
                _askQuit.Value = value;
            }
        }
        public IBoolPreferenceItem AskQuitItem {
            get {
                return _askQuit;
            }
        }
        public bool OpenBookMarkWithNewTab {
            get {
                return _openBookmarkWithNewTab.Value;
            }
        }
        public IBoolPreferenceItem OpenBookMarkWithNewTabItem {
            get {
                return _openBookmarkWithNewTab;
            }
        }

        public bool AutoPassword {
            get {
                return BRuntimeOpts.SAVE_PASSWORD;
            }
        }
        public string SavedAccount {
            get {
                return GetRegKeyElement("account");
            }
            set {
                SetRegKeyElement("account", value);
            }
        }
        //pX[h́i.conft@C݂炢ł́j킩Ȃ悤ɂ
        public string SavedPassword {
            get {
                string v = GetRegKeyElement("password");
                if(v.Length==0) return v;

                try {
                    return Encoding.ASCII.GetString(SimpleXor(Base64.Decode(v), 0x6A)); //0x6A͈ÍɑBŒl
                }
                catch(Exception ex) {
                    Debug.WriteLine(String.Format("Password Decode Error:{0}", ex.Message));
                    return "";
                }
            }
            set {
                if(value.Length > 0) {
                    try {
                        value = Encoding.ASCII.GetString(Base64.Encode(SimpleXor(Encoding.ASCII.GetBytes(value), 0x6A)));
                    }
                    catch(Exception ex) {
                        Debug.WriteLine(String.Format("Password Decode Error:{0}", ex.Message));
                        value = "";
                    }
                }
                SetRegKeyElement("password", value);
            }
        }
        public bool AutoPinCode {
            get {
                return _autoPinCode.Value;
            }
            set {
                _autoPinCode.Value = value;
            }
        }

        public bool PinCodeVerified {
            get {
                return _pinCodeVerified;
            }
        }

        public string SavedPinCode {
            get {
                if(BRuntimeOpts.SAVE_PASSWORD) {
                    string v = GetRegKeyElement("pinCode");
                    if(v.Length==0) return v;

                    try {
                        return Encoding.ASCII.GetString(SimpleXor(Base64.Decode(v), 0x4D));
                    }
                    catch(Exception ex) {
                        Debug.WriteLine(String.Format("Password Decode Error:{0}", ex.Message));
                        return "";
                    }
                }
                else
                    return _pinCodeOnMemory;
            }
            set {
                if(BRuntimeOpts.SAVE_PASSWORD) {
                    if(value.Length > 0) {
                        try {
                            value = Encoding.ASCII.GetString(Base64.Encode(SimpleXor(Encoding.ASCII.GetBytes(value), 0x4D)));
                        }
                        catch(Exception ex) {
                            Debug.WriteLine(String.Format("Password Decode Error:{0}", ex.Message));
                            value = "";
                        }
                    }
                    SetRegKeyElement("pinCode", value);
                }
                else
                    _pinCodeOnMemory = value;

                _pinCodeVerified = true;
            }
        }

        //ۑȂ擾
        public bool GetLastValidPassword(out string pw) {
            if(BRuntimeOpts.SAVE_PASSWORD) {
                pw = this.SavedPassword;
                return true;
            }
            else {
                pw = null;
                return false;
            }
        }
        /*
        public bool GetLastValidPinCode(out string pw) {
            if(BRuntimeOpts.SAVE_PASSWORD && _pinCodeVerified) {
                pw = this.SavedPinCode;
                return true;
            }
            else {
                pw = null;
                return false;
            }
        }
        */

        //lłQXOR猳ɖ߂邵
        private static byte[] SimpleXor(byte[] v, byte m) {
            for(int i=0; i<v.Length; i++) {
                v[i] ^= m;
            }
            return v;
        }

        private static RegistryKey GetRegKey() {
            try {
                return Registry.CurrentUser.CreateSubKey(BellagioVersionInfo.REGISTRY_PATH);
            }
            catch(Exception ex) {
                Debug.WriteLine(ex.Message);
                return null;
            }
        }
        private static string GetRegKeyElement(string tag) {
            try {
                RegistryKey k = GetRegKey();
                if(k==null)
                    return "";
                else
                    return (string)k.GetValue(tag, "");
            }
            catch(Exception ex) {
                Debug.WriteLine(ex.Message);
                return "";
            }
        }
        private static void SetRegKeyElement(string tag, string value) {
            try {
                RegistryKey k = GetRegKey();
                if(k==null)
                    return;
                else
                    k.SetValue(tag, value, RegistryValueKind.String);
            }
            catch(Exception ex) {
                Debug.WriteLine(ex.Message);
                return;
            }
        }


    }


}
