/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Drawing/WaitingMark.cs#4 $
 * $DateTime: 2007/12/28 19:23:38 $
 * 
 */
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Diagnostics;
using System.Drawing.Imaging;

namespace Bellagio.Drawing {
    //hLg̃[h҂őҋ@Ԃł邱Ƃ}[N̕`BFireFoxYouTubeł悭݂
    public class WaitingMark {
        private int _radius;
        private int _markRadius;
        private int _markCount;
        private int _flatPeriod;
        private int _progressPeriod;
        private Color _flatColor;
        private Color _topColor;

        public WaitingMark() {
            _radius = 10;
            _markRadius = 3;
            _markCount = 8;
            _flatPeriod = 10;
            _progressPeriod = 15;
            _flatColor = Color.Gray;
            _topColor = Color.White;
        }

        public int Radius {
            get {
                return _radius;
            }
            set {
                _radius = value;
            }
        }
        public int MarkRadius {
            get {
                return _markRadius;
            }
            set {
                _markRadius = value;
            }
        }
        public int FlatPeriod {
            get {
                return _flatPeriod;
            }
            set {
                _flatPeriod = value;
            }
        }
        public int ProgressPeriod {
            get {
                return _progressPeriod;
            }
            set {
                _progressPeriod = value;
            }
        }
        public Color FlatColor {
            get {
                return _flatColor;
            }
            set {
                _flatColor = value;
            }
        }
        public Color TopColor {
            get {
                return _topColor;
            }
            set {
                _topColor = value;
            }
        }

        public void Draw(Graphics g, Point pt, int progress) {
            Draw(g, pt.X, pt.Y, progress);
        }
        public void Draw(Graphics g, int x, int y, int progress) {
            float fsz = 2.0F * _markRadius;
            for(int i=0; i<_markCount; i++) {
                int p = (progress + i * (_flatPeriod + _progressPeriod) / _markCount) % (_flatPeriod + _progressPeriod);
                Color c = p <= _flatPeriod? _flatColor : DrawingUtil.ProportionalColor(_flatColor, _topColor, (p-_flatPeriod) / (double)_progressPeriod);
                double r = Math.PI * 2.0 * i / _markCount;
                using(Brush br = new SolidBrush(c)) {
                    g.FillEllipse(br, (float)(x + Math.Cos(r) * _radius - _markRadius), (float)(y + Math.Sin(r) * _radius - _markRadius), fsz, fsz);
                }
            }
        }
    }
}
