/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Drawing/PageSwitchingBoard.cs#8 $
 * $DateTime: 2007/12/28 19:23:38 $
 * 
 * y[W؂ւ\Rei FigureBoard̃ReiƂĊJ
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Windows.Forms;
using System.Diagnostics;

using Sansa.Runtime;
using Travis.LocationOperation;

namespace Bellagio.Drawing {
    //͓ɂ͂Py[Ŵ݂ANeBuAƂ݂̂l
    public class PageSwitchingBoard {
        public interface IPage {
            void Paint(Graphics g, Point point, Rectangle clip);
        }
        public delegate void PagePositionDelegate(double progression, out Point active_page_pos, out Point next_page_pos);

        private class PageInfo {
            public IPage _content;

            public PageInfo(IPage page) {
                _content = page;
            }
        }

        private List<PageInfo> _pages;
        private IPlatformBridge _platform;
        private Control _container;

        private DoubleTimer _moveTimer; //y[W؂ւƂɃANeBuɂȂ^C}[
        private IntTimer _stableTimer; //݃y[WŒ~ƂɃANeBuɂȂ^C}[
        private Point _defaultPageLocation; //Î~Ԃł̃y[Ẅʒu
        private BRect _bound; //̃Reïʒu
        private PagePositionDelegate _pagePositionDelegate;

        private double _stableTime;
        private double _animationTime;
        private int _activeIndex; //ANeBuȃy[WB_timerI_ŃANeBuȂ؂ւ
        
        public PageSwitchingBoard(Control container, IPlatformBridge platform) {
            _container = container;
            _platform = platform;
            _bound = new BRect();
            _moveTimer = new DoubleTimer(platform, new DTimerHandler(delegate() { _moveTimer.reset(0, 1, platform.getRootTimer().secondToTick(_animationTime)); }, new DTimerHandler.D(OnAnimationTick)).SetEnd(new DTimerHandler.D(OnEndMoving)));
            _stableTimer = new IntTimer(platform, new StableTimerHandler(this));
            _pages = new List<PageInfo>();
        }

        public double AnimationTime {
            get {
                return _animationTime;
            }
            set {
                _animationTime = value;
            }
        }
        public double StableTime {
            get {
                return _stableTime;
            }
            set {
                _stableTime = value;
            }
        }

        public BRect Bound {
            get {
                return _bound;
            }
        }
        public Point DefaultPageLocation {
            get {
                return _defaultPageLocation;
            }
            set {
                _defaultPageLocation = value;
            }
        }
        public PagePositionDelegate PagePositionAnimation {
            get {
                return _pagePositionDelegate;
            }
            set {
                _pagePositionDelegate = value;
            }
        }

        public void AddPage(IPage page) {
            _pages.Add(new PageInfo(page));
        }

        //JnƏI
        public void StartSwitching() {
            Debug.Assert(_pagePositionDelegate!=null); //͕K{
            Debug.Assert(_animationTime!=0);
            Debug.Assert(_stableTime!=0);
            Debug.Assert(_pages.Count!=0);
            _moveTimer.Initialize();
        }
        public void StopSwitching() {
            if(_moveTimer.IsActive()) _moveTimer.Abort();
            if(_stableTimer.IsActive()) _stableTimer.Abort();
        }

        private int NextActiveIndex() {
            return _activeIndex==_pages.Count-1? 0 : _activeIndex+1;
        }

        private void OnAnimationTick() {
            if(!_bound.IsEmpty)
                _container.Invalidate(_bound.Value);
        }

        private void StartMovingToNextPage() {

            _moveTimer.Initialize();
        }
        private void OnEndMoving() {
            _activeIndex = NextActiveIndex();
            _stableTimer.Initialize();
            if(!_bound.IsEmpty)
                _container.Invalidate(_bound.Value);
        }

        private class StableTimerHandler : ITimerDownstream {
            private PageSwitchingBoard _parent;
            public StableTimerHandler(PageSwitchingBoard parent) {
                _parent = parent;
            }
            public void oninitialize() {
                int l = _parent._platform.getRootTimer().secondToTick(_parent._stableTime);
                _parent._stableTimer.reset(0, l, l);
            }
            public void onstart() {
            }
            public void onend() {
                _parent.StartMovingToNextPage();
            }
            public void ontick() {
            }
        }

        //`
        public void Paint(Graphics g, Rectangle clip) {
            if(_bound.IsEmpty) return;

            if(_moveTimer.IsActive() && _pages.Count>1) {
                Point p, q;
                _pagePositionDelegate(_moveTimer.value(), out p, out q);
                p.Offset(_defaultPageLocation);
                q.Offset(_defaultPageLocation);
                _pages[_activeIndex]._content.Paint(g, p, clip);
                _pages[NextActiveIndex()]._content.Paint(g, q, clip);
            }
            else
                _pages[_activeIndex]._content.Paint(g, _defaultPageLocation, clip);
        }


        public enum ScrollDir {
            ToLeft, ToRight, ToTop, ToBottom
        }

        public class ScrollSwitcher {
            private int _pageLength;
            private ScrollDir _dir;
            public ScrollSwitcher(ScrollDir dir, int pageLength) {
                _dir = dir;
                _pageLength = pageLength;
            }
            private void CalcMovingPosition(double progression, out Point active_page_pos, out Point next_page_pos) {
                int v = (int)(_pageLength * progression);
                Point c = new Point();
                Point n = new Point();

                switch(_dir) {
                    case ScrollDir.ToBottom:
                        c.Y = v;
                        n.Y = v - _pageLength;
                        break;
                    case ScrollDir.ToTop:
                        c.Y = -v;
                        n.Y = -v + _pageLength;
                        break;
                    case ScrollDir.ToRight:
                        c.X = v;
                        n.X = v + _pageLength;
                        break;
                    case ScrollDir.ToLeft:
                        c.X = -v;
                        n.X = -v + _pageLength;
                        break;
                }

                active_page_pos = c;
                next_page_pos = n;
            }

            public static PagePositionDelegate CreateDelegate(ScrollDir dir, int pageLength) {
                return new PagePositionDelegate(new ScrollSwitcher(dir, pageLength).CalcMovingPosition);
            }
        }
    }

}
