/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Drawing/DrawingUtil.cs#11 $
 * $DateTime: 2007/12/28 19:23:38 $
 * 
 * `ɂĂ̔ėputil
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Drawing.Imaging;
using System.Drawing.Drawing2D;
using System.Diagnostics;

//TODO ̃t@C̓eTraviss

namespace Bellagio.Drawing {
    //Fݒ̎^ Loop͂̃NCAgłƂC邪
    public class LoopColorTable {
        private Color[] _colors;
        public void Init(params Color[] c) {
            _colors = c;
        }
        public Color ColorAt(int index) {
            return _colors[index % _colors.Length];
        }

        //eLXgƂ̕ῗ

    }


    public class DrawingUtil {
        //Rectangle
        public static Point RectCenterPoint(Rectangle rect) {
            return new Point(rect.Left + rect.Width/2, rect.Top + rect.Height/2);
        }
        public static Rectangle CenterPointToRect(Point point, int width, int height) {
            return new Rectangle(point.X - width/2, point.Y - height/2, width, height);
        }
        //OɊg債rectԂ
        public static Rectangle InflateRect(Rectangle rect, int size) {
            return new Rectangle(rect.Left - size, rect.Top-size, rect.Width + size*2, rect.Height + size*2);
        }

        // 'p/q'̈ʒuɔzFԂBp==0Ȃt, p==qȂsɈv
        public static Color ProportionalColor(Color t, Color s, int p, int q) {
            int r = (t.R * (q-p) + s.R * p) / q;
            int g = (t.G * (q-p) + s.G * p) / q;
            int b = (t.B * (q-p) + s.B * p) / q;
            return Color.FromArgb(r, g, b);
        }
        // 0.01.0̊Ԃ̒l
        public static Color ProportionalColor(Color t, Color s, double v) {
            //V[gJbg
            if(v==0)
                return t;
            else if(v==1)
                return s;

            int r = (int)(t.R * (1-v) + s.R * v);
            int g = (int)(t.G * (1-v) + s.G * v);
            int b = (int)(t.B * (1-v) + s.B * v);
            return Color.FromArgb(r, g, b);
        }
        public static int ProportionalInt(int t, int s, double v) {
            //V[gJbg
            if(v==0)
                return t;
            else if(v==1)
                return s;

            return (int)(t*(1-v) + s*v);
        }

        //px̒ -PIPIɂȂ悤
        public static double AdjustAngle(double value) {
            if(Math.Abs(value) <= Math.PI)
                return value; //̏ꍇ͂
            else {
                if(value > Math.PI) {
                    while(value > Math.PI) value -= Math.PI*2;
                }
                else {
                    while(value < -Math.PI) value += Math.PI*2;
                }
                return value;
            }
        }
        //t
        public static double InverseAngle(double value) {
            return AdjustAngle(value + Math.PI);
        }

        //Fw肵ēhrbg}bvBRXgN^ゾƑSFȂ͕̂s
        public static Bitmap CreateBitmap(int width, int height, Color col) {
            Bitmap b = new Bitmap(width, height, PixelFormat.Format32bppArgb);
            Graphics g = Graphics.FromImage(b);
            SolidBrush br = new SolidBrush(col);
            g.FillRectangle(br, 0, 0, width, height);
            g.Dispose();
            br.Dispose();
            return b;
        }

        //pointrectangle̕ӂ d ǂBSɊOłꍇ܂ށBʊOɕ\Ȃ̂߂̋@\
        public static bool PointIsAboutEdge(Point pt, Rectangle rect, int d) {
            return
                (pt.X < rect.Left  + d) ||
                (pt.X > rect.Right - d) ||
                (pt.Y < rect.Top + d) ||
                (pt.Y > rect.Bottom - d);
        }

        //COLORREFɑΉԂ
        public static uint ToCOLORREF(Color c) {
            uint t = (uint)c.ToArgb();
            //COLORREF0x00BBGGRRAToArgb0x00RRGGBB
            uint r = (t & 0x00FF0000) >> 16;
            uint b = (t & 0x000000FF) << 16;
            t &= 0x0000FF00;
            return t | r | b;
        }

        //eLXgColor
        public static bool TryParseColor(string text, out Color result) {
            if(text.Length>0) {
                if(text[0]=='#' && (text.Length==7 || text.Length==9)) //rrggbb or aarrggbb
                    return TryParseHexColor(text, 1, out result);
                else if(text.Length==6) {
                    if(TryParseHexColor(text, 0, out result)) return true; //#Ŏn܂ȂƂ͎sɖOł̉ɃgC
                }
            }

            result = Color.FromName(text); //FromNamegƁA`ς݂̂ƂKnownColorɂȂĂ
            if(result.IsKnownColor)
                return true;
            else if(text=="none") { //none͋
                result = Color.Empty;
                return true;
            }
            return false;
        }
        public static Color ParseColor(string text) {
            Color r;
            if(TryParseColor(text, out r))
                return r;
            else
                return Color.Empty;
        }

        public static bool TryParseHexColor(string text, int start, out Color result) {
            result = Color.Empty;
            int a = 255;
            if(start + 8 == text.Length) {
                a = TryParseColorElement(text, start); 
                start += 2;
            }

            int r = TryParseColorElement(text, start);
            if(r==-1) return false;
            int g = TryParseColorElement(text, start+2);
            if(g==-1) return false;
            int b = TryParseColorElement(text, start+4);
            if(b==-1) return false;

            result = Color.FromArgb(a, r, g, b);
            return true;
        }
        private static int TryParseColorElement(string text, int start) {
            int a = HexToValue(text[start]);
            if(a==-1) return -1;
            int b = HexToValue(text[start+1]);
            if(b==-1) return -1;
            return a*16 + b;
        }

        private static int HexToValue(char ch) {
            if('0'<=ch && ch<='9')
                return ch - '0';
            else if('a'<=ch && ch<='f')
                return ch - 'a' + 10;
            else if('A'<=ch && ch<='F')
                return ch - 'A' + 10;
            else
                return -1;
        }

        public static string ColorToString(Color c) {
            if(c.IsEmpty)
                return "none";
            else if(c.IsKnownColor)
                return c.Name;
            else {
                string n = c.Name;
                //'A'̒lƂffĂȂ炻͏ȗ
                if(n.Length==8 && n.StartsWith("ff"))
                    return "#" + n.Substring(2);
                else
                    return "#" + n;
            }
        }

    }

    //Dispose܂HighQuality`
    public class HighQualityDrawingSupport : IDisposable {
        private Graphics _g;
        private SmoothingMode _mode;
        public HighQualityDrawingSupport(Graphics g) {
            _g = g;
            _mode = _g.SmoothingMode;
            _g.SmoothingMode = SmoothingMode.HighQuality;
        }
        public Graphics Graphics {
            get {
                return _g;
            }
        }


        public void Dispose() {
            _g.SmoothingMode = _mode;
        }

    }
}
