/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Drawing/Candle.cs#8 $
 * $DateTime: 2007/12/28 19:23:38 $
 * 
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;

namespace Bellagio.Drawing {
    //낤̕`
    //TESTINFO GraphicViewer
    public class CandleDrawing : IDisposable {
        private Color _color;
        private Pen _pen;       //gƂЂpy
        private Pen _lightPen;
        private Pen _darkPen;
        private Brush _brush; //낤uV
        private Brush _backBrush;
        private int _hcw; //낤̔̕

        public CandleDrawing() {
        }

        public CandleDrawing(Color candle, Color back, int hcw) {
            Reset(candle, back, hcw);
        }
        public void Reset(Color candle, Color back, int hcw) {
            if(_color==candle && hcw==_hcw) return; //ωȂ΂ȂɂȂ
            this.Dispose();

            _color = candle;
            _pen = new Pen(candle);
            _lightPen = new Pen(DrawingUtil.ProportionalColor(candle, back, 1, 4));
            _darkPen = new Pen(DrawingUtil.ProportionalColor(candle, back, 1, 2));
            _brush = new SolidBrush(candle);
            _backBrush = new SolidBrush(back);
            _hcw = hcw;
        }

        public void DrawYosen(Graphics g, int x, int top, int bottom, int top_hige, int bottom_hige) {
            //K̘g[x-HALF_CW, x+HALF_CW+1)
            g.DrawRectangle(_pen, x-_hcw, top, _hcw*2, bottom-top);
            //ƍ
            g.DrawLine(_darkPen, x-_hcw-1, top-1, x+_hcw, top-1);
            g.DrawLine(_darkPen, x-_hcw-1, top-1, x-_hcw-1, bottom);
            //ƉE
            g.DrawLine(_darkPen, x+_hcw-1, top+1, x+_hcw-1, bottom-1);
            g.DrawLine(_darkPen, x-_hcw+1, bottom-1, x+_hcw-1, bottom-1);

            DrawHige(g, x, top, bottom, top_hige, bottom_hige);
        }
        public void DrawInsen(Graphics g, int x, int top, int bottom, int top_hige, int bottom_hige) {
            //K̘g[x-HALF_CW, x+HALF_CW+1)
            g.FillRectangle(_brush, x-_hcw+1, top+1, _hcw*2-1, bottom-top-1);
            //ƍ
            g.DrawLine(_lightPen, x-_hcw, top, x+_hcw, top);
            g.DrawLine(_lightPen, x-_hcw, top, x-_hcw, bottom);
            //ƉE
            g.DrawLine(_darkPen, x+_hcw, top+1, x+_hcw, bottom);
            g.DrawLine(_darkPen, x-_hcw+1, bottom, x+_hcw, bottom);

            DrawHige(g, x, top, bottom, top_hige, bottom_hige);
        }

        //\(top==bottom) 
        public void DrawCross(Graphics g, int x, int top, int bottom, int top_hige, int bottom_hige) {
            g.DrawLine(_pen, x-_hcw, top, x+_hcw, top);
            DrawHige(g, x, top, bottom, top_hige, bottom_hige);
        }

        //`BႦΏo_͏Ă
        public void DrawUpBar(Graphics g, int x, int top, int bottom) {
            //K̘g[x-HALF_CW, x+HALF_CW+1)
            g.FillRectangle(_brush, x-_hcw+1, top+1, _hcw*2-1, bottom-top);
            //ƍ
            g.DrawLine(_lightPen, x-_hcw, top, x+_hcw, top);
            g.DrawLine(_lightPen, x-_hcw, top, x-_hcw, bottom);
            //E
            g.DrawLine(_darkPen, x+_hcw, top+1, x+_hcw, bottom);
        }

        private void DrawHige(Graphics g, int x, int top, int bottom, int top_hige, int bottom_hige) {
            //Ђ
            if(top_hige < top)
                g.DrawLine(_pen, x, top_hige, x, top);
            if(bottom_hige > bottom)
                g.DrawLine(_pen, x, bottom, x, bottom_hige);
        }

        public void Dispose() {
            if(_pen==null) return;

            _pen.Dispose();
            _lightPen.Dispose();
            _darkPen.Dispose();
            _brush.Dispose();
            _backBrush.Dispose();
        }
    }
}
